/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Vector;

public abstract class SnmpRackMibHandler
extends RackEnclosureTopologyHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(SnmpRackMibHandler.class);
    private String rackName = null;
    private String rUid = null;
    private MxNode rackNode;
    private String bladeSerialNumber = null;
    private String bladeUUID = null;
    private int bladeSlot = -1;
    private int bladeHeight = -1;
    private int bladeWidth = -1;
    private int bladeDepth = -1;
    private int maxNumBlades = 0;
    private int maxNumBladesXDir = 0;
    private int maxNumBladesYDir = 1;
    private int bladeSlotsUsed = 1;
    private int bladeSlotsUsedXDir = 1;
    private int bladeSlotsUsedYDir = 1;
    private int switchesPresent = 0;
    private boolean leftSwitchPresent = false;
    private boolean rightSwitchPresent = false;
    private int switchSlot = -1;
    private String leftSwitchSerialNumber = null;
    private String rightSwitchSerialNumber = null;
    private String enclosureSerialNum = null;
    private String switchSerialNum = null;
    private Vector<Vector> topology = new Vector();
    private int serverEnclosureIndex = -1;

    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
    }

    public void cleanUpAssociationData(MxNode d) {
    }

    public abstract NodeAssociations loadAssociationDataFromDb(MxNode var1);

    public void setAssociationType(String associationType) {
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public abstract NodeAssociations buildContainerTree(NodeAssociations var1, MxNode var2, MxNode var3);

    public SnmpRackMibHandler(MxNode d) {
        super(d);
    }

    public void getRackAttributesFromTheMib() {
        boolean endOfTable = false;
        String rackNameOID = null;
        String rUidOID = null;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.2.1.1.2[0],1.3.6.1.4.1.232.22.2.2.1.1.3[1]");
        while (!endOfTable) {
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(0);
            if (vb == null || vb.isError()) break;
            rackNameOID = vb.getOid();
            LOGGER.fine("The RACK Name OID : " + rackNameOID);
            SnmpResponseVarBind vb2 = curResp.findById(1);
            if (vb2 == null || vb2.isError()) break;
            rUidOID = vb2.getOid();
            LOGGER.fine(" The RUID OID : " + rUidOID);
            if (!rackNameOID.startsWith("1.3.6.1.4.1.232.22.2.2.1.1.2.")) break;
            this.rackName = vb.getValue();
            if (this.rackName.trim().equalsIgnoreCase("unknown")) {
                this.rackName = "";
            }
            LOGGER.fine("Rack Name for device " + this.device.getNameString() + " is " + this.rackName);
            this.rUid = vb2.getValue();
            if (this.rUid.trim().equalsIgnoreCase("unknown")) {
                this.rUid = "";
            }
            LOGGER.fine("RUID for device " + this.device.getNameString() + " is " + this.rUid);
            this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(rackNameOID, "0");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(rUidOID, "1");
        }
    }

    public void getCommonEnclosureAttributesAndTopologyFromTheMib() {
        LOGGER.enter("SnmpRackMibHandler.getCommonEnclosureAttributesAndTopologyFromTheMib()");
        boolean endOfTable = false;
        String enclSerNoOID = null;
        String enclNameOID = null;
        String leftNgbrNameOID = null;
        String rgtNgbrNameOID = null;
        String hasSrvrBladesOID = null;
        String hasPwrBladesOID = null;
        String leftNgbrSerNoOID = null;
        String rgtNgbrSerNoOID = null;
        String enclUidOID = null;
        String leftNgbrUidOID = null;
        String rgtNgbrUidOID = null;
        String productIDOID = null;
        String productIDOIDPrev = null;
        String productIDOIDNext = null;
        String productID = null;
        String productIDleft = null;
        String productIDrgt = null;
        int counter = 0;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.3.1.1.1.7[0],1.3.6.1.4.1.232.22.2.3.1.1.1.9[1],1.3.6.1.4.1.232.22.2.3.1.1.1.10[2],1.3.6.1.4.1.232.22.2.3.1.1.1.11[3],1.3.6.1.4.1.232.22.2.3.1.1.1.17[4],1.3.6.1.4.1.232.22.2.3.1.1.1.18[5],1.3.6.1.4.1.232.22.2.3.1.1.1.24[6],1.3.6.1.4.1.232.22.2.3.1.1.1.25[7],1.3.6.1.4.1.232.22.2.3.1.1.1.30[8],1.3.6.1.4.1.232.22.2.3.1.1.1.31[9],1.3.6.1.4.1.232.22.2.3.1.1.1.32[10],1.3.6.1.4.1.232.22.2.3.1.1.1.27[11],1.3.6.1.4.1.232.22.2.3.1.1.1.28[12],1.3.6.1.4.1.232.22.2.3.1.1.1.29[13]");
        while (!endOfTable) {
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb0 = curResp.findById(0);
            if (vb0 == null || vb0.isError()) break;
            enclSerNoOID = vb0.getOid();
            LOGGER.fine("The Enclosure Serial NO. OID : " + enclSerNoOID);
            SnmpResponseVarBind vb1 = curResp.findById(1);
            if (vb1 == null || vb1.isError()) break;
            enclNameOID = vb1.getOid();
            LOGGER.fine(" The Enclosure Name OID : " + enclNameOID);
            SnmpResponseVarBind vb2 = curResp.findById(2);
            if (vb2 == null || vb2.isError()) break;
            leftNgbrNameOID = vb2.getOid();
            LOGGER.fine(" The Left Neighbor Name OID : " + leftNgbrNameOID);
            SnmpResponseVarBind vb3 = curResp.findById(3);
            if (vb3 == null || vb3.isError()) break;
            rgtNgbrNameOID = vb3.getOid();
            LOGGER.fine(" The Right Neighbor Name OID : " + rgtNgbrNameOID);
            SnmpResponseVarBind vb4 = curResp.findById(4);
            if (vb4 == null || vb4.isError()) break;
            hasSrvrBladesOID = vb4.getOid();
            LOGGER.fine("The HasServerBlades OID : " + hasSrvrBladesOID);
            SnmpResponseVarBind vb5 = curResp.findById(5);
            if (vb5 == null || vb5.isError()) break;
            hasPwrBladesOID = vb5.getOid();
            LOGGER.fine(" The HasPowerSupplyBlades OID : " + hasPwrBladesOID);
            SnmpResponseVarBind vb6 = curResp.findById(6);
            if (vb6 == null || vb6.isError()) break;
            leftNgbrSerNoOID = vb6.getOid();
            LOGGER.fine(" The Left Neighbor Serial Number OID : " + leftNgbrSerNoOID);
            SnmpResponseVarBind vb7 = curResp.findById(7);
            if (vb7 == null || vb7.isError()) break;
            rgtNgbrSerNoOID = vb7.getOid();
            LOGGER.fine(" The Right Neighbor Serial Number OID : " + rgtNgbrSerNoOID);
            SnmpResponseVarBind vb8 = curResp.findById(8);
            if (vb8 == null || vb8.isError()) break;
            enclUidOID = vb8.getOid();
            LOGGER.fine(" The Enclosure UUID OID : " + enclUidOID);
            SnmpResponseVarBind vb9 = curResp.findById(9);
            if (vb9 == null || vb9.isError()) break;
            leftNgbrUidOID = vb9.getOid();
            LOGGER.fine(" The Left Neighbor UUID OID : " + leftNgbrUidOID);
            SnmpResponseVarBind vb10 = curResp.findById(10);
            if (vb10 == null || vb10.isError()) break;
            rgtNgbrUidOID = vb10.getOid();
            LOGGER.fine(" The Right Neighbor UUID OID : " + rgtNgbrUidOID);
            SnmpResponseVarBind prodID = curResp.findById(11);
            if (prodID == null || prodID.isError()) break;
            productIDOID = prodID.getOid();
            LOGGER.fine("SnmpRackMibHandler. The product OID : " + productIDOID);
            SnmpResponseVarBind prodIDPrev = curResp.findById(12);
            if (prodIDPrev == null || prodIDPrev.isError()) break;
            productIDOIDPrev = prodIDPrev.getOid();
            LOGGER.fine("SnmpRackMibHandler.  The left product OID : : " + productIDOIDPrev);
            SnmpResponseVarBind prodIDNext = curResp.findById(13);
            if (prodIDNext == null || prodIDNext.isError()) break;
            productIDOIDNext = prodIDNext.getOid();
            LOGGER.fine("SnmpRackMibHandler.  The Right product OID : : " + productIDOIDPrev);
            if (enclSerNoOID.startsWith("1.3.6.1.4.1.232.22.2.3.1.1.1.7.")) {
                Vector<String> tplgy = new Vector<String>();
                String enclosureUuid = vb8.getValue();
                if (enclosureUuid != null && enclosureUuid.trim().length() > 0 && enclosureUuid.trim().length() >= 10 && !enclosureUuid.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclosureUuid);
                } else {
                    tplgy.add("");
                }
                LOGGER.fine("Enclosure Serial NUmber/Uuid for device " + this.device.getNameString() + " is " + (String)tplgy.elementAt(0));
                String enclosureName = vb1.getValue();
                if (enclosureName != null && !enclosureName.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(vb1.getValue());
                } else {
                    tplgy.add("");
                }
                LOGGER.fine("Enclosure Name for device " + this.device.getNameString() + " is " + (String)tplgy.elementAt(1));
                tplgy.add(vb2.getValue());
                LOGGER.fine("Left Neighbor Name for device " + this.device.getNameString() + " is " + (String)tplgy.elementAt(2));
                tplgy.add(vb3.getValue());
                LOGGER.fine("Right Neighbor Name for device " + this.device.getNameString() + " is " + (String)tplgy.elementAt(3));
                int val = vb4.getIntValue();
                if (val == 1) {
                    tplgy.add("false");
                } else {
                    tplgy.add("true");
                    this.serverEnclosureIndex = counter;
                    LOGGER.fine("SERVER ENCLOSURE INDEX :  " + this.serverEnclosureIndex);
                }
                LOGGER.fine("Has Server Blades value  for device " + this.device.getNameString() + " is " + (String)tplgy.elementAt(4));
                val = vb5.getIntValue();
                if (val == 2) {
                    tplgy.add("true");
                } else {
                    tplgy.add("false");
                }
                LOGGER.fine("Has Power Supply blades value for device " + this.device.getNameString() + " is " + (String)tplgy.elementAt(5));
                String enclLeftUuid = vb9.getValue();
                if (enclLeftUuid != null && enclLeftUuid.trim().length() > 0 && enclLeftUuid.trim().length() >= 10) {
                    tplgy.add(enclLeftUuid);
                } else {
                    tplgy.add("");
                }
                LOGGER.fine("Left Neighbor UUID for device " + this.device.getNameString() + " is " + (String)tplgy.elementAt(6));
                String enclRgtUuid = vb10.getValue();
                if (enclRgtUuid != null && enclRgtUuid.trim().length() > 0 && enclRgtUuid.trim().length() >= 10) {
                    tplgy.add(enclRgtUuid);
                } else {
                    tplgy.add("");
                }
                LOGGER.fine("Right Neighbor UUID for device " + this.device.getNameString() + " is " + (String)tplgy.elementAt(7));
                String enclSerNo = vb0.getValue();
                String leftSerNo = vb6.getValue();
                String rgtSerNo = vb7.getValue();
                productID = prodID.getValue();
                productIDleft = prodIDPrev.getValue();
                productIDrgt = prodIDNext.getValue();
                if (enclSerNo != null && !enclSerNo.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclSerNo);
                    if (Integer.parseInt(productID) != 0) {
                        this.prodIdList.put(enclSerNo, productID);
                    }
                } else {
                    tplgy.add("");
                }
                if (leftSerNo != null) {
                    tplgy.add(leftSerNo);
                    if (Integer.parseInt(productIDleft) != 0) {
                        this.prodIdList.put(leftSerNo, productIDleft);
                    }
                } else {
                    tplgy.add("");
                }
                if (rgtSerNo != null) {
                    tplgy.add(rgtSerNo);
                    if (Integer.parseInt(productIDrgt) != 0) {
                        this.prodIdList.put(rgtSerNo, productIDrgt);
                    }
                } else {
                    tplgy.add("");
                }
                this.topology.add(tplgy);
                ++counter;
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclSerNoOID, "0");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclNameOID, "1");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(leftNgbrNameOID, "2");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(rgtNgbrNameOID, "3");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(hasSrvrBladesOID, "4");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(hasPwrBladesOID, "5");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(leftNgbrSerNoOID, "6");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(rgtNgbrSerNoOID, "7");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclUidOID, "8");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(leftNgbrUidOID, "9");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(rgtNgbrUidOID, "10");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(productIDOID, "11");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(productIDOIDPrev, "12");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(productIDOIDNext, "13");
                continue;
            }
            containerDeviceDebug.warning("enclosure serial number oid was not correct" + enclSerNoOID);
            break;
        }
        LOGGER.exit("SnmpRackMibHandler.getCommonEnclosureAttributesAndTopologyFromTheMib()");
    }

    public void getCommonEnclosureAttributesAndTopologyFromTheSANMib() {
        LOGGER.enter("SnmpRackMibHandler.getCommonEnclosureAttributesAndTopologyFromTheSANMib()");
        boolean endOfTable = false;
        String enclosureSerialNumberOID = null;
        String enclosureNameOID = null;
        int counter = 0;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.3.1.1.1.7[0],1.3.6.1.4.1.232.22.2.3.1.1.1.9[1]");
        while (!endOfTable) {
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse snmpResponse = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind cpqRackCommonEnclosureSerialNumVB = snmpResponse.findById(0);
            LOGGER.fine("SnmpRackMibHandler.cpqRackCommonEnclosureSerialNumVB " + cpqRackCommonEnclosureSerialNumVB);
            LOGGER.fine("SnmpRackMibHandler.cpqRackCommonEnclosureSerialNumVB.isError() " + cpqRackCommonEnclosureSerialNumVB.isError());
            if (cpqRackCommonEnclosureSerialNumVB == null || cpqRackCommonEnclosureSerialNumVB.isError()) break;
            enclosureSerialNumberOID = cpqRackCommonEnclosureSerialNumVB.getOid();
            LOGGER.fine("SnmpRackMibHandler.enclosureSerialNumberOID " + enclosureSerialNumberOID);
            SnmpResponseVarBind cpqRackCommonEnclosureNameVB = snmpResponse.findById(1);
            LOGGER.fine("SnmpRackMibHandler.cpqRackCommonEnclosureNameVB " + cpqRackCommonEnclosureNameVB);
            LOGGER.fine("SnmpRackMibHandler.cpqRackCommonEnclosureNameVB.isError() " + cpqRackCommonEnclosureNameVB.isError());
            if (cpqRackCommonEnclosureNameVB == null || cpqRackCommonEnclosureNameVB.isError()) break;
            enclosureNameOID = cpqRackCommonEnclosureNameVB.getOid();
            LOGGER.fine("SnmpRackMibHandler.enclosureNameOID " + enclosureNameOID);
            if (enclosureSerialNumberOID.startsWith("1.3.6.1.4.1.232.22.2.3.1.1.1.7.")) {
                Vector<String> tplgy = new Vector<String>();
                tplgy.add("");
                String enclosureName = cpqRackCommonEnclosureNameVB.getValue();
                LOGGER.fine("SnmpRackMibHandler.enclosureName " + enclosureName);
                if (enclosureName != null && !enclosureName.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclosureName);
                } else {
                    tplgy.add("");
                }
                tplgy.add("");
                tplgy.add("");
                tplgy.add("true");
                tplgy.add("false");
                tplgy.add("");
                tplgy.add("");
                String enclosureSerialNumber = cpqRackCommonEnclosureSerialNumVB.getValue();
                LOGGER.fine("SnmpRackMibHandler.enclosureSerialNumber " + enclosureSerialNumber);
                if (enclosureSerialNumber != null && !enclosureSerialNumber.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclosureSerialNumber);
                } else {
                    tplgy.add("");
                }
                tplgy.add("");
                tplgy.add("");
                this.topology.add(tplgy);
                ++counter;
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclosureSerialNumberOID, "0");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclosureNameOID, "1");
                continue;
            }
            LOGGER.fine("SnmpRackMibHandler.enclosure serial number oid was not correct " + enclosureSerialNumberOID);
            break;
        }
        LOGGER.exit("SnmpRackMibHandler.getCommonEnclosureAttributesAndTopologyFromTheSANMib()");
    }

    public void getServerEnclosureAttributesFromTheMib() {
        LOGGER.enter(" SNMPRACKHAndler :getServerEnclosureAttributesFromTheMib");
        boolean endOfTable = false;
        String maxNumBladesOID = null;
        String maxNumBladesInXDirOID = null;
        String maxNumBladesInYDirOID = null;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.3.2.1.1.4[0],1.3.6.1.4.1.232.22.2.3.2.1.1.5[1],1.3.6.1.4.1.232.22.2.3.2.1.1.6[2]");
        while (!endOfTable) {
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb1 = curResp.findById(0);
            if (vb1 == null || vb1.isError()) break;
            maxNumBladesOID = vb1.getOid();
            LOGGER.fine("The Enclosure Max NUM Blades OID : " + maxNumBladesOID);
            SnmpResponseVarBind vb2 = curResp.findById(1);
            if (vb2 == null || vb2.isError()) break;
            maxNumBladesInXDirOID = vb2.getOid();
            LOGGER.fine("The Enclosure Max NUM Blades in the X Direction OID : " + maxNumBladesInXDirOID);
            SnmpResponseVarBind vb3 = curResp.findById(2);
            if (vb3 == null || vb3.isError()) break;
            maxNumBladesInYDirOID = vb3.getOid();
            LOGGER.fine("The Enclosure Max NUM Blades in the Y Direction OID : " + maxNumBladesInYDirOID);
            if (!maxNumBladesOID.startsWith("1.3.6.1.4.1.232.22.2.3.2.1.1.4.")) break;
            this.maxNumBlades = vb1.getIntValue();
            LOGGER.fine("Enclosure Maximum Number of Blades for device " + this.device.getNameString() + " is " + this.maxNumBlades);
            if (maxNumBladesInXDirOID.startsWith("1.3.6.1.4.1.232.22.2.3.2.1.1.5.")) {
                this.maxNumBladesXDir = vb2.getIntValue();
                LOGGER.fine("Enclosure Maximum Number of Blades in X DIR for device " + this.device.getNameString() + " is " + this.maxNumBladesXDir);
            } else {
                this.maxNumBladesXDir = 0;
            }
            if (maxNumBladesInYDirOID.startsWith("1.3.6.1.4.1.232.22.2.3.2.1.1.6.")) {
                this.maxNumBladesYDir = vb3.getIntValue();
                LOGGER.fine("Enclosure Maximum Number of Blades in Y DIR for device " + this.device.getNameString() + " is " + this.maxNumBladesYDir);
            } else {
                this.maxNumBladesYDir = 1;
            }
            this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(maxNumBladesOID, "0");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(maxNumBladesInXDirOID, "1");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(maxNumBladesInYDirOID, "2");
        }
        LOGGER.exit(" SNMPRACKHAndler :getServerEnclosureAttributesFromTheMib");
    }

    public void getServerBladeAttributesFromTheMib(boolean getSerialNumber, String theSerialNumber) {
        LOGGER.enter("getServerBladeAttributesFromTheMib");
        boolean endOfTable = false;
        String bladeSerialNumberOID = null;
        String bladeSlotOID = null;
        String bladeWidthOID = null;
        String bladeDepthOID = null;
        String bladeHeightOID = null;
        String bladeSlotsUsedOID = null;
        String bladeUUIDOID = null;
        String bladeSlotsUsedXDirOID = null;
        String bladeSlotsUsedYDirOID = null;
        SnmpResponseVarBind vb6 = null;
        SnmpResponseVarBind vb9 = null;
        StringBuffer sb = new StringBuffer();
        if (!getSerialNumber) {
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.8[0],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.9[1],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.10[2],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.11[3],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.15[4],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.19[5],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.20[6]");
        } else {
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.8[0],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.9[1],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.10[2],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.11[3],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.15[4],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.19[5],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.20[6],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.16[7],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.18[8]");
        }
        this.snmpPdh.getSnmpRequest().setAsn1Numbers(sb.toString());
        while (!endOfTable) {
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(0);
            if (vb == null || vb.isError()) break;
            bladeSlotOID = vb.getOid();
            LOGGER.fine("The Blade Slot OID : " + bladeSlotOID);
            SnmpResponseVarBind vb2 = curResp.findById(1);
            if (vb2 == null || vb2.isError()) break;
            bladeHeightOID = vb2.getOid();
            LOGGER.fine(" The Blade Height OID : " + bladeHeightOID);
            SnmpResponseVarBind vb3 = curResp.findById(2);
            if (vb3 == null || vb3.isError()) break;
            bladeWidthOID = vb3.getOid();
            LOGGER.fine(" The Blade Width OID : " + bladeWidthOID);
            SnmpResponseVarBind vb4 = curResp.findById(3);
            if (vb4 == null || vb4.isError()) break;
            bladeDepthOID = vb4.getOid();
            LOGGER.fine(" The Blade Depth OID : " + bladeDepthOID);
            SnmpResponseVarBind vb5 = curResp.findById(4);
            if (vb5 == null || vb5.isError()) break;
            bladeSlotsUsedOID = vb5.getOid();
            LOGGER.fine(" Number of Blade Slots Used OID : " + bladeSlotsUsedOID);
            SnmpResponseVarBind vb7 = curResp.findById(5);
            if (vb7 == null || vb7.isError()) break;
            bladeSlotsUsedXDirOID = vb7.getOid();
            LOGGER.fine(" Number of Blade Slots Used in the X Direction OID : " + bladeSlotsUsedXDirOID);
            SnmpResponseVarBind vb8 = curResp.findById(6);
            if (vb8 == null || vb8.isError()) break;
            bladeSlotsUsedYDirOID = vb8.getOid();
            LOGGER.fine(" Number of Blade Slots Used in the Y Direction OID : " + bladeSlotsUsedYDirOID);
            if (getSerialNumber) {
                vb6 = curResp.findById(7);
                if (vb6 == null || vb6.isError()) break;
                bladeSerialNumberOID = vb6.getOid();
                LOGGER.fine("The Blade SerialNumber OID : " + bladeSerialNumberOID);
                vb9 = curResp.findById(8);
                if (vb9 == null || vb9.isError()) break;
                bladeUUIDOID = vb9.getOid();
                LOGGER.fine("The Blade UUID OID : " + bladeUUIDOID);
            }
            if (!bladeSlotOID.startsWith("1.3.6.1.4.1.232.22.2.4.1.1.1.8.")) break;
            if (getSerialNumber) {
                this.bladeUUID = vb9.getValue();
                LOGGER.fine("\n\nBLADE UUID from MIB " + this.device.getNameString() + "  is '" + this.bladeUUID.trim() + "'");
                LOGGER.fine("UUID for actual blade server " + this.device.getNameString() + " is '" + this.device.getAgentUUID() + "'");
                this.bladeSerialNumber = vb6.getValue();
                LOGGER.fine("\n\nBLADE Ser NUm for device " + this.device.getNameString() + "  is '" + this.bladeSerialNumber.trim() + "'");
                LOGGER.fine("Server Ser NUm for device " + this.device.getNameString() + " is '" + theSerialNumber.trim() + "'");
                boolean isHaloBlade = this.bladeSerialNumber.trim().equalsIgnoreCase(theSerialNumber.trim());
                if (this.bladeUUID != null && this.bladeUUID.trim().length() > 0 && this.device.getAgentUUID().trim().length() > 0) {
                    isHaloBlade = this.bladeUUID.trim().equalsIgnoreCase(this.device.getAgentUUID().trim());
                }
                if (isHaloBlade) {
                    int tempVal;
                    this.bladeSlot = vb.getIntValue();
                    LOGGER.fine("bladeSlot:" + this.bladeSlot);
                    LOGGER.fine("BLADE Slot for device " + this.device.getNameString() + " is " + this.bladeSlot);
                    this.bladeHeight = vb2.getIntValue();
                    LOGGER.fine("Blade Height for device " + this.device.getNameString() + " is " + this.bladeHeight);
                    this.bladeWidth = vb3.getIntValue();
                    LOGGER.fine("Blade Width for device " + this.device.getNameString() + " is " + this.bladeWidth);
                    this.bladeDepth = vb4.getIntValue();
                    LOGGER.fine("Blade Depth for device " + this.device.getNameString() + " is " + this.bladeDepth);
                    this.bladeSlotsUsed = vb5.getIntValue();
                    LOGGER.fine("Blade Slots Used for device " + this.device.getNameString() + " is " + this.bladeSlotsUsed);
                    if (bladeSlotsUsedXDirOID.startsWith("1.3.6.1.4.1.232.22.2.4.1.1.1.19")) {
                        tempVal = vb7.getIntValue();
                        if (tempVal != -1 || tempVal != 0) {
                            this.bladeSlotsUsedXDir = tempVal;
                        }
                        LOGGER.fine("Blade Slots Used X DIR for device " + this.device.getNameString() + " is " + this.bladeSlotsUsedXDir);
                        LOGGER.fine("Blade Slots Used X DIR for device " + this.device.getNameString() + " is " + this.bladeSlotsUsedXDir);
                    } else {
                        this.bladeSlotsUsedXDir = 1;
                    }
                    if (bladeSlotsUsedYDirOID.startsWith("1.3.6.1.4.1.232.22.2.4.1.1.1.20")) {
                        tempVal = vb8.getIntValue();
                        if (tempVal != -1 || tempVal != 0) {
                            this.bladeSlotsUsedYDir = tempVal;
                        }
                        LOGGER.fine("Blade Slots Used Y Dir for device " + this.device.getNameString() + " is " + this.bladeSlotsUsedYDir);
                        LOGGER.fine("Blade Slots Used Y Dir for device " + this.device.getNameString() + " is " + this.bladeSlotsUsedYDir);
                    } else {
                        this.bladeSlotsUsedYDir = 1;
                    }
                    endOfTable = true;
                    continue;
                }
            } else {
                int tempVal;
                this.bladeSlot = vb.getIntValue();
                LOGGER.fine("BLADE Slot for device " + this.device.getNameString() + " is " + this.bladeSlot);
                this.bladeHeight = vb2.getIntValue();
                LOGGER.fine("Blade Height for device " + this.device.getNameString() + " is " + this.bladeHeight);
                this.bladeWidth = vb3.getIntValue();
                LOGGER.fine("Blade Width for device " + this.device.getNameString() + " is " + this.bladeWidth);
                this.bladeDepth = vb4.getIntValue();
                LOGGER.fine("Blade Depth for device " + this.device.getNameString() + " is " + this.bladeDepth);
                this.bladeSlotsUsed = vb5.getIntValue();
                LOGGER.fine("Blade Slots Used for device " + this.device.getNameString() + " is " + this.bladeSlotsUsed);
                if (bladeSlotsUsedXDirOID.startsWith("1.3.6.1.4.1.232.22.2.4.1.1.1.19")) {
                    tempVal = vb7.getIntValue();
                    if (tempVal != -1 || tempVal != 0) {
                        this.bladeSlotsUsedXDir = tempVal;
                    }
                    LOGGER.fine("Blade Slots Used X DIR for device " + this.device.getNameString() + " is " + this.bladeSlotsUsedXDir);
                    LOGGER.fine("Blade Slots Used X DIR for device " + this.device.getNameString() + " is " + this.bladeSlotsUsedXDir);
                }
                if (bladeSlotsUsedYDirOID.startsWith("1.3.6.1.4.1.232.22.2.4.1.1.1.20")) {
                    tempVal = vb8.getIntValue();
                    if (tempVal != -1 || tempVal != 0) {
                        this.bladeSlotsUsedYDir = tempVal;
                    }
                    LOGGER.fine("Blade Slots Used Y Dir for device " + this.device.getNameString() + " is " + this.bladeSlotsUsedYDir);
                    LOGGER.fine("Blade Slots Used Y Dir for device " + this.device.getNameString() + " is " + this.bladeSlotsUsedYDir);
                }
                endOfTable = true;
                continue;
            }
            this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeSlotOID, "0");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeHeightOID, "1");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeWidthOID, "2");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeDepthOID, "3");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeSlotsUsedOID, "4");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeSlotsUsedXDirOID, "5");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeSlotsUsedYDirOID, "6");
            if (!getSerialNumber) continue;
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeSerialNumberOID, "7");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeUUIDOID, "8");
        }
        LOGGER.exit("SnmpRackMibHandler.getServerBladeAttributesFromTheMib");
    }

    public void getSwitchAttributesFromTheMib() {
        LOGGER.enter("SnmpRackMibHandler.getSwitchAttributesFromTheMib()");
        boolean endOfTable = false;
        String switchesPresentOID = null;
        String switchesLocationOID = null;
        String swserialNumberOID = null;
        String cpqRacknetConnectorIndexOID = null;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.6.1.1.1.12[0],1.3.6.1.4.1.232.22.2.6.1.1.1.13[1],1.3.6.1.4.1.232.22.2.6.1.1.1.3[2],1.3.6.1.4.1.232.22.2.6.1.1.1.7[3]");
        while (!endOfTable) {
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(0);
            if (vb == null || vb.isError()) break;
            switchesLocationOID = vb.getOid();
            LOGGER.fine("The Enclosure - Switches Location OID : " + switchesLocationOID);
            SnmpResponseVarBind vb1 = curResp.findById(1);
            if (vb1 == null || vb1.isError()) break;
            switchesPresentOID = vb1.getOid();
            LOGGER.fine("The Enclosure - Switches Present OID : " + switchesPresentOID);
            SnmpResponseVarBind vb3 = curResp.findById(3);
            if (vb3 == null || vb3.isError()) break;
            swserialNumberOID = vb3.getOid();
            if (!switchesLocationOID.startsWith("1.3.6.1.4.1.232.22.2.6.1.1.1.12.")) break;
            String temp = vb.getValue().trim();
            if (temp.equalsIgnoreCase("A") || temp.equalsIgnoreCase("Left Side") || temp.equalsIgnoreCase("Network Side A")) {
                if (vb1.getIntValue() == 3) {
                    this.leftSwitchSerialNumber = vb3.getValue();
                    this.leftSwitchPresent = true;
                    this.switchSlot = 0;
                }
            } else if ((temp.equalsIgnoreCase("B") || temp.equalsIgnoreCase("Right Side") || temp.equalsIgnoreCase("Network Side B")) && vb1.getIntValue() == 3) {
                this.rightSwitchSerialNumber = vb3.getValue();
                this.rightSwitchPresent = true;
                this.switchSlot = 9999;
            }
            LOGGER.fine("Switches Present for device " + this.device.getNameString() + " is left " + this.leftSwitchPresent + " and right " + this.rightSwitchPresent);
            LOGGER.fine("SnmpRackMibHandler.temp " + temp);
            if (temp.equalsIgnoreCase("Upper Cube")) {
                SnmpResponseVarBind cpqRacknetConnectorIndexVB = curResp.findById(2);
                if (cpqRacknetConnectorIndexVB == null || cpqRacknetConnectorIndexVB.isError()) break;
                cpqRacknetConnectorIndexOID = cpqRacknetConnectorIndexVB.getOid();
                LOGGER.fine("SnmpRackMibHandler.cpqRacknetConnectorIndexOID " + cpqRacknetConnectorIndexOID);
                int DUKES_LOCATION = cpqRacknetConnectorIndexVB.getIntValue();
                LOGGER.fine("SnmpRackMibHandler.DUKES_LOCATION " + DUKES_LOCATION);
                LOGGER.fine("SnmpRackMibHandler.vb1.getIntValue() " + vb1.getIntValue());
                if (vb1.getIntValue() == 3) {
                    if (DUKES_LOCATION == 1) {
                        this.rightSwitchSerialNumber = vb3.getValue();
                        LOGGER.fine("Dukes.rightSwitchSerialNumber " + this.rightSwitchSerialNumber);
                        this.switchSlot = 9999;
                    } else if (DUKES_LOCATION == 2) {
                        this.leftSwitchSerialNumber = vb3.getValue();
                        LOGGER.fine("Dukes.leftSwitchSerialNumber " + this.leftSwitchSerialNumber);
                        this.switchSlot = 0;
                    }
                }
            }
            LOGGER.fine("SnmpRackMibHandler.switchSlot " + this.switchSlot);
            this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(switchesPresentOID, "1");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(switchesLocationOID, "0");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(swserialNumberOID, "3");
        }
        LOGGER.fine("Left Switch  : " + this.leftSwitchPresent);
        LOGGER.fine("Right Switch  : " + this.rightSwitchPresent);
        LOGGER.exit("SnmpRackMibHandler.getSwitchAttributesFromTheMib()");
    }

    public String getEnclosureSerialNum() {
        return this.enclosureSerialNum;
    }

    public String getSwitchSerialNum() {
        return this.switchSerialNum;
    }

    public String getRackName() {
        return this.rackName;
    }

    public String getRuid() {
        return this.rUid;
    }

    public MxNode getRack() {
        return this.rackNode;
    }

    public int getMaxNumBlades() {
        return this.maxNumBlades;
    }

    public int getMaxNumBladesXDir() {
        return this.maxNumBladesXDir;
    }

    public int getMaxNumBladesYDir() {
        return this.maxNumBladesYDir;
    }

    public Vector getContainerEnclosureInformation() {
        if (this.topology != null && this.topology.size() != 0) {
            return this.topology.get(0);
        }
        return null;
    }

    public int getSwitchesPresent() {
        return this.switchesPresent;
    }

    public boolean getLeftSwitchPresent() {
        return this.leftSwitchPresent;
    }

    public boolean getRightSwitchPresent() {
        return this.rightSwitchPresent;
    }

    public int getSwitchSlot() {
        return this.switchSlot;
    }

    public String getLeftSwitchSerialNumber() {
        return this.leftSwitchSerialNumber;
    }

    public String getRightSwitchSerialNumber() {
        return this.rightSwitchSerialNumber;
    }

    public int getBladeSlot() {
        return this.bladeSlot;
    }

    public int getBladeHeight() {
        return this.bladeHeight;
    }

    public int getBladeWidth() {
        return this.bladeWidth;
    }

    public int getBladeDepth() {
        return this.bladeDepth;
    }

    public int getBladeSlotsUsed() {
        return this.bladeSlotsUsed;
    }

    public int getBladeSlotsUsedXDir() {
        return this.bladeSlotsUsedXDir;
    }

    public int getBladeSlotsUsedYDir() {
        return this.bladeSlotsUsedYDir;
    }

    public int getServerEnclosureIndex() {
        return this.serverEnclosureIndex;
    }

    public Vector getTopology() {
        return this.topology;
    }
}

