/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.querymanager.TableModelHandler;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLBlade;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class OverlordServerHandler
extends SnmpRackMibHandler {
    private static final DebugSubsystem m_logger = new DebugSubsystem(OverlordServerHandler.class);

    public OverlordServerHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode serverNode, DeviceIdentificationData idInfo) {
        m_logger.enter("In OverlordServerHandler.getAssocaitionData(" + serverNode + "," + idInfo + ")");
        if (serverNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            try {
                this.doEnclosureDeviceProcessing(serverNode);
                this.buildMPToServerAssociation(serverNode);
            }
            catch (Exception e) {
                m_logger.exception("Overlors server handler :Exception:" + e);
                containerDeviceDebug.exception((Throwable)e);
            }
            finally {
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
            }
        }
    }

    private void doEnclosureDeviceProcessing(MxNode servNode) {
        m_logger.enter("OverlordServerHandler.doEnclosureDeviceProcessing(" + servNode + ")");
        try {
            String enclName;
            String[] uniqueIds;
            OAHelper myOAHelper = OAHelper.getOAHelper();
            MxNode enclORDevice = null;
            for (String propertyValue : uniqueIds = new String[]{servNode.getUniqueIdentifier(), servNode.getAgentUUID(), servNode.getSerialNumber()}) {
                try {
                    enclORDevice = myOAHelper.getDeviceNodeHavingProperty(propertyValue);
                }
                catch (OAException e) {
                    m_logger.fine("Could not find OLDevice using " + propertyValue);
                }
                if (enclORDevice != null) break;
            }
            OLBlade myOLBlade = null;
            if (enclORDevice != null && !enclORDevice.getDeviceType().equals("Enclosure") && (enclName = servNode.getEnclosureName()) != null && enclName.length() > 0) {
                try {
                    MxNode enclMxNode;
                    enclORDevice = enclMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByNodeOrHostName(enclName, false);
                }
                catch (MxException e) {
                    m_logger.fine("Logical Node not created, enclORDevice is encl node & data available on enclosure node");
                }
            }
            myOLBlade = (OLBlade)myOAHelper.getOLDevice(servNode, enclORDevice);
            if (enclORDevice != null && enclORDevice.getDeviceType().equals("Enclosure")) {
                m_logger.fine("Logical Node not created, enclORDevice is encl node & data available on enclosure node");
                m_logger.fine("enclosure device key:" + enclORDevice.getDeviceKey());
                this.makeServerToEnclAssociation(servNode, enclORDevice.getDeviceKey());
                if (this.myNodeRelationships.getSlotNumber() <= 0) {
                    this.myNodeRelationships.setSlotNumber(myOLBlade.getDeviceSlot());
                    this.myNodeRelationships.setNumBladeSlotsUsedXDir(myOLBlade.getDeviceSlotsInXDirection());
                    this.myNodeRelationships.setNumBladeSlotsUsedYDir(myOLBlade.getDeviceSlotsInYDirection());
                    this.myNodeRelationships.setMmHeight(myOLBlade.getDeviceHeight());
                    this.myNodeRelationships.setMmWidth(myOLBlade.getDeviceWidth());
                    this.myNodeRelationships.setMmDepth(myOLBlade.getDeviceDepth());
                    this.myNodeRelationships.setInContainer(true);
                }
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclORDevice, false);
            } else if (enclORDevice != null && enclORDevice.getDeviceType().equals("Server")) {
                m_logger.fine("Logical Node present, enclORDevice is logical node;hence take data from Logical node");
                if (enclORDevice.getDeviceKey() != servNode.getDeviceKey()) {
                    MxNode enclosureNode = this.getAssociatedNode(enclORDevice, "ServerToEnclosure");
                    NodeAssociations thelogicalServerAssociations = null;
                    thelogicalServerAssociations = this.myNodeRelationshipManager.getNodeAssociations(enclORDevice.getDeviceKey());
                    this.myNodeRelationships.setSlotNumber(thelogicalServerAssociations.getSlotNumber());
                    this.myNodeRelationships.setNumBladeSlotsUsedXDir(thelogicalServerAssociations.getNumBladeSlotsUsedXDir());
                    this.myNodeRelationships.setNumBladeSlotsUsedYDir(thelogicalServerAssociations.getNumBladeSlotsUsedYDir());
                    this.myNodeRelationships.setMmHeight(thelogicalServerAssociations.getMmHeight());
                    this.myNodeRelationships.setMmWidth(thelogicalServerAssociations.getMmWidth());
                    this.myNodeRelationships.setMmDepth(thelogicalServerAssociations.getMmDepth());
                    this.makeServerToEnclAssociation(servNode, enclosureNode.getDeviceKey());
                    this.myNodeRelationships.setInContainer(true);
                    NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(enclosureNode.getDeviceKey());
                    DefaultMutableTreeNode topologyTree = na.getContainerDeviceTree();
                    this.removeBladeFromTopology(enclORDevice.getDeviceKey(), topologyTree);
                    this.myNodeRelationshipManager.update(na);
                    thelogicalServerAssociations.removeTheAssociation(enclORDevice.getDeviceKey(), "ServerToEnclosure");
                    this.myNodeRelationshipManager.update(thelogicalServerAssociations);
                    this.cleanUpAssociationData(enclORDevice, "ServerToEnclosure");
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclosureNode, false);
                } else {
                    m_logger.fine("Logical Node & Physical Nodes are merged");
                }
            } else {
                this.checkNodeInDB(servNode);
            }
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
        }
        catch (Exception e) {
            m_logger.exception("OverlordServerHandler.doEnclosureDeviceProcessing: Exception :" + e);
        }
    }

    private MxNode getAssociatedNode(MxNode deviceNode, String asscType) {
        m_logger.enter("overlordserverHandler:getAssociatedNode for: " + deviceNode.getNameString() + "and" + asscType);
        int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(deviceNode.getDeviceKey(), asscType);
        m_logger.fine("associatedDeviceKey:" + associatedDeviceKey);
        MxNode associatedDevice = null;
        try {
            associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
        }
        catch (MxUndefinedNodeException ex) {
            m_logger.exception("Node not found");
        }
        return associatedDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeServerToEnclAssociation(MxNode serverNode, int theEnclDeviceKey) {
        m_logger.enter("OverlordServerHandler.makeAssociation(" + serverNode + "," + theEnclDeviceKey + ")");
        m_logger.fine("server Device Key:" + serverNode.getDeviceKey());
        m_logger.fine("enclosure Device Key:" + theEnclDeviceKey);
        MxNode syncObject = serverNode;
        try {
            MxNode enclosureNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
            NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(enclosureNode.getDeviceKey());
            if (na != null) {
                syncObject = na;
            }
            MxNode mxNode = syncObject;
            synchronized (mxNode) {
                if (na != null) {
                    int myDeviceKey = serverNode.getDeviceKey();
                    this.myNodeRelationships.setTheAssociation(myDeviceKey, enclosureNode.getDeviceKey(), "ServerToEnclosure", false);
                    this.addDeviceToTopologyTree(na, myDeviceKey);
                    this.myNodeRelationshipManager.update(na);
                    MxNode theRackDevice = this.getAssociatedNode(enclosureNode, "EnclosureToRack");
                    this.getRackInformation(theRackDevice.getNameString(), theRackDevice.getAgentUUID(), enclosureNode.getDeviceKey());
                    this.myNodeRelationshipManager.update(na);
                    NodeAssociationsManager.getDefaultManager().reLoadDeviceAssociations(theRackDevice.getDeviceKey());
                    this.updateDevContainerAndRoleNames(theRackDevice);
                    serverNode.setEnclosureName(enclosureNode.getNameString());
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), serverNode, false);
                }
            }
        }
        catch (Exception e) {
            m_logger.exception("OverlordServerHandler.makeAssociation: Exception :" + e);
        }
    }

    private void checkNodeInDB(MxNode d) {
        NodeAssociations dTmpNodeAssociations;
        m_logger.enter("OverlordServerHandler.checkNodeInDB(" + d + ")");
        MxNode dTmp = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure");
        if (dTmp != null && (dTmpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(dTmp.getDeviceKey())) != null) {
            DefaultMutableTreeNode topologyTree = dTmpNodeAssociations.getContainerDeviceTree();
            topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
            dTmpNodeAssociations.setContainerDeviceTree(topologyTree);
            this.myNodeRelationshipManager.update(dTmpNodeAssociations);
        }
    }

    private void buildMPToServerAssociation(MxNode serverMxNode) {
        String propertyValue;
        String mpToServerATN = "MgmtProcToServer_Ilo";
        if (serverMxNode.getDeviceSubTypes().contains("HPIntegrity")) {
            mpToServerATN = "MgmtProcToServer_IPF";
        }
        String[] uniqueIds = new String[]{serverMxNode.getUniqueIdentifier(), serverMxNode.getAgentUUID(), serverMxNode.getSerialNumber()};
        boolean isAssociationSuccess = false;
        String[] arr$ = uniqueIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(isAssociationSuccess = this.buildMPToServerAssociationILOXML(serverMxNode, propertyValue = arr$[i$], mpToServerATN)); ++i$) {
        }
        if (!isAssociationSuccess) {
            this.buildMPToServerSNMPAssociation(serverMxNode, mpToServerATN);
        }
    }

    private boolean buildMPToServerAssociationILOXML(MxNode serverMxNode, String propertyValue, String ATN) {
        m_logger.enter("OverlordServerHandler.buildMPToServerAssociationILOXML(" + serverMxNode + ")");
        boolean isAssocSuccessful = false;
        if (propertyValue != null) {
            List allDevicesWithThisProperty = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), propertyValue);
            m_logger.fine("MP devices list size:" + allDevicesWithThisProperty.size());
            if (allDevicesWithThisProperty.size() == 1) {
                for (Integer assocDeviceKey : allDevicesWithThisProperty) {
                    m_logger.fine("MP device key:" + assocDeviceKey);
                    m_logger.fine("Server device key:" + serverMxNode.getDeviceKey());
                    try {
                        MxNode mpMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(assocDeviceKey.intValue());
                        if (mpMxNode.getDeviceType().equals("MgmtProc")) {
                            this.setTwoWayAssociation(serverMxNode.getDeviceKey(), mpMxNode.getDeviceKey(), ATN);
                            AssociationHandlerConstants.setILOAsscociatedAttributes(serverMxNode, mpMxNode);
                        }
                        isAssocSuccessful = true;
                    }
                    catch (MxUndefinedNodeException exec) {
                        m_logger.error("Either MP is not discovered yet,Unable to obtain MxNode of MP ,Association btwserver and MP failed. via SNMP");
                        m_logger.exception("Exception:" + (Object)((Object)exec));
                        isAssocSuccessful = false;
                    }
                }
            } else {
                m_logger.error("There are multiple MP's with the UUID/Unique identifier of serverin the DB,This is incorrect,Associtaion btw server and MP failed");
            }
        }
        m_logger.exit("OverlordServerHandler.buildMPToServerAssociationILOXML(" + serverMxNode + ")");
        return isAssocSuccessful;
    }

    private void addMpToServerInTree(int serverDeviceKey, int mpDeviceKey) {
        NodeAssociations mpNodeAssociations;
        NodeAssociations myServerNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(serverDeviceKey);
        if (myServerNodeAssociations == null) {
            myServerNodeAssociations = new NodeAssociations(serverDeviceKey);
        }
        if ((mpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(mpDeviceKey)) == null) {
            mpNodeAssociations = new NodeAssociations(mpDeviceKey);
        }
        this.myNodeRelationshipManager.update(myServerNodeAssociations);
        this.myNodeRelationshipManager.update(mpNodeAssociations);
    }

    void buildMPToServerSNMPAssociation(MxNode serverMxNode, String ATN) {
        int isThisIloRilo;
        m_logger.enter("OverlordServerHandler.buildMPToServerSNMPAssociation(" + serverMxNode + "," + ATN + ")");
        boolean isSNMPSupported = MonteroSNMPUtils.checkSNMP(serverMxNode);
        if (!isSNMPSupported) {
            m_logger.exit("OverlordServerHandler.buildMPToServerSNMPAssociation(" + serverMxNode + "," + ATN + ")");
            return;
        }
        String theRibSerialNo = null;
        theRibSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.9.2.2.15.0[1]", true);
        m_logger.fine("OverlordServerHandler.buildMPToServerSNMPAssociation : ILO Serial Number:" + theRibSerialNo);
        int associatedDeviceKey = 0;
        if (theRibSerialNo != null && theRibSerialNo.trim().length() > 0 && (associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(theRibSerialNo)) > 0 && (isThisIloRilo = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.21.0[1]", true)) == 7) {
            try {
                MxNode mpMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
                if (mpMxNode.getDeviceType().equals("MgmtProc")) {
                    this.setTwoWayAssociation(serverMxNode.getDeviceKey(), mpMxNode.getDeviceKey(), ATN);
                    AssociationHandlerConstants.setILOAsscociatedAttributes(serverMxNode, mpMxNode);
                }
            }
            catch (MxUndefinedNodeException exec) {
                m_logger.error("Either MP is not discovered yet,Unable to obtain MxNode of MP ,Association btwserver and MP failed. via SNMP");
                m_logger.exception("Exception:" + (Object)((Object)exec));
            }
        }
        m_logger.exit("OverlordServerHandler.buildMPToServerSNMPAssociation(" + serverMxNode + "," + ATN + ")");
    }

    private void setTwoWayAssociation(int deviceKey1, int deviceKey2, String ATN) {
        m_logger.enter("OverlordServerHandler.setTwoWayAssociation(" + deviceKey1 + "," + deviceKey2 + "," + ATN + ")");
        NodeAssociations device1Associations = this.myNodeRelationshipManager.getNodeAssociations(deviceKey1);
        if (device1Associations == null) {
            device1Associations = new NodeAssociations(deviceKey1);
        }
        this.myNodeRelationships.setTheAssociation(deviceKey1, deviceKey2, ATN, true);
        NodeAssociations device2Associations = this.myNodeRelationshipManager.getNodeAssociations(deviceKey2);
        if (device2Associations == null) {
            device2Associations = new NodeAssociations(deviceKey2);
        }
        device2Associations.setParent(deviceKey1);
        device2Associations.setInContainer(true);
        device2Associations.setTheAssociation(deviceKey2, deviceKey1, ATN, true);
        this.myNodeRelationshipManager.update(device1Associations);
        this.myNodeRelationshipManager.update(device2Associations);
        m_logger.fine("Association successful ATN:" + ATN);
        m_logger.exit("OverlordServerHandler.setTwoWayAssociation(" + deviceKey1 + "," + deviceKey2 + "," + ATN + ")");
    }

    public NodeAssociations loadAssociationDataFromDb(MxNode node) {
        m_logger.enter("OverlordServerHandler.loadAssociationDataFromDb(" + node + ")");
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(node.getDeviceKey(), true);
        boolean isloadRequired = false;
        if (node.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            isloadRequired = true;
        }
        if (isloadRequired) {
            na = AssociationHandlerUtil.loadAssocFrmDB(node.getDeviceKey(), this.myNodeRelationshipManager);
        }
        m_logger.exit("OverlordServerHandler.loadAssociationDataFromDb(" + node + ")");
        return na;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        m_logger.enter("OverlordServerHandler.buildContainerTree(" + myAssoc + "," + node1 + "," + node2 + ")");
        m_logger.fine("node1.name:" + node1.getNameString());
        m_logger.fine("node1.getDeviceType:" + node1.getDeviceType());
        m_logger.fine("node2.name:" + node2.getNameString());
        m_logger.fine("node2.getDeviceType:" + node2.getDeviceType());
        if (node1.getDeviceType().equals("Server") && node2.getDeviceType().equals("Enclosure")) {
            this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
            myAssoc.setInContainer(true);
            myAssoc.setParent(node2.getDeviceKey());
        }
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        m_logger.enter("OverlordServerHandler.cleanUpAssociationData(" + d + ")");
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ilo");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_IPF");
            int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.resetDeviceAssociations(associatedDeviceKey);
            TableModelHandler.notifyViewTopoHasChanged();
        }
        catch (NodeAssociationsPersistenceException nodeAssociationsPersistenceException) {
            // empty catch block
        }
    }

    private void cleanUpAssociationData(MxNode node, String strAssociationType) {
        m_logger.enter("OverlordServerHandler.cleanUpAssociationData(" + node + "," + strAssociationType + ")");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(node.getDeviceKey(), strAssociationType);
    }
}

