/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.DiscoveryController;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.objectmodel.MxObjectPersistenceException;
import com.hp.mx.core.protocol.dns.InetXe;
import com.hp.mx.core.tools.datacollection.http.ICMB;
import com.hp.mx.core.tools.datacollection.http.oa.OADataManager;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.core.tools.datacollection.http.oa.OLEnclosure;
import com.hp.mx.core.tools.datacollection.http.oa.OnboardAdministrator;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.HandlerException;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.core.utilities.UniqueIdentifierUtility;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAAssociationHandler
extends RackEnclosureTopologyHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(OAAssociationHandler.class);
    private static final Object syncObject = new Object();

    public OAAssociationHandler(MxNode oaMxNode) {
        super(oaMxNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAssociationData(MxNode oaMxNode, DeviceIdentificationData deviceIdentificationData) {
        LOGGER.enter("OAAssociationHandler.getAssociationData(" + oaMxNode + "," + deviceIdentificationData + ")");
        LOGGER.fine("OAAssociationHandler.getAssociationData.WORKING_ADDRESS " + oaMxNode.getWorkingAddress());
        LOGGER.fine("oaMxNode.getModel() " + oaMxNode.getModel());
        LOGGER.fine("oaMxNode.getDeviceType() " + oaMxNode.getDeviceType());
        LOGGER.fine("oaMxNode has OA subtype " + oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()));
        LOGGER.fine("oaMxNode has cClass subtype " + oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString()));
        if (!oaMxNode.getDeviceType().equals("MgmtProc")) {
            LOGGER.fine("**********IT IS NOT A MANAGEMENT PROCESSOR CLEANUPASSOCIATION**********" + oaMxNode.getWorkingAddress());
            this.cleanUpAssociationData(oaMxNode);
            LOGGER.exit("OAAssociationHandler.getAssociationData(" + oaMxNode + "," + deviceIdentificationData + ")");
            return;
        }
        try {
            while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                Thread.sleep(100L);
            }
            LOGGER.fine("**********IT IS A MANAGEMENT PROCESSOR**********" + oaMxNode.getWorkingAddress());
            if (oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()) && oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
                LOGGER.fine("**********GETTING NEW ASSOCIATIONS FOR OA " + oaMxNode.getWorkingAddress() + "**********");
                OADataManager oaDataManager = new OADataManager(oaMxNode);
                LOGGER.fine("**********SUCCESSFULLY PARSED OAXML. NOW PERFORMING ASSOCIATIONS FOR OA " + oaMxNode.getWorkingAddress() + "**********");
                this.performAssociations(oaDataManager, oaMxNode);
                LOGGER.fine("**********SUCCESSFULLY PERFORMED ASSOCIATIONS FOR OA " + oaMxNode.getWorkingAddress() + "**********");
            }
        }
        catch (HandlerException e) {
            LOGGER.error("****************UNABLE TO ASSOCIATE OA " + oaMxNode.getWorkingAddress() + " WITH ITS ENCLOSURE. PLEASE ENSURE OA XML HAS GOT ENCLOSURE UUID, RACK UUID AND RACK TOPOLOGY IN IT****************");
            LOGGER.error("HandlerException in OAAssociationHandler.getAssociationData: " + e);
            LOGGER.exception((Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error("****************UNABLE TO GET RELATIONSHIP LOCK FOR OA " + oaMxNode.getWorkingAddress() + " PLEASE DISCOVER THIS OA AFTER SOMETIME****************");
            LOGGER.error("InterruptedException in OAAssociationHandler.getAssociationData: " + e);
            LOGGER.exception((Throwable)e);
        }
        catch (OAException e) {
            LOGGER.error("********ERROR IN PARSING OA XML. PLEASE ENSURE OA " + oaMxNode.getWorkingAddress() + " IS UP AND HAS GOT LATEST FIRMWARE INSTALLED IN IT*********");
            LOGGER.error("OAException in OAAssociationHandler.getAssociationData: " + e);
            LOGGER.exception((Throwable)e);
        }
        finally {
            NodeAssociationsManager.releaseWriteLock();
        }
        LOGGER.exit("OAAssociationHandler.getAssociationData(" + oaMxNode + "," + deviceIdentificationData + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAssociations(OADataManager oaDataManager, MxNode oaMxNode) throws HandlerException {
        LOGGER.enter("OAAssociationHandler.performAssociations(" + oaDataManager + "," + oaMxNode + ")");
        NodeAssociations myEnclosureNodeAssociations = null;
        OLEnclosure olEnclosure = oaDataManager.getEnclosureDevice();
        Vector<Vector<String>> topology = null;
        Object object = syncObject;
        synchronized (object) {
            topology = this.getTopology(olEnclosure);
            String rackName = olEnclosure.getRackName();
            String rackUUID = olEnclosure.getRackTopology().getRackUUID();
            LOGGER.fine("OAAssociationHandler.performAssociations Creating Enclosure Now");
            myEnclosureNodeAssociations = this.getEnclosureInformation(this.getCurrentTopology(olEnclosure, topology), rackName, rackUUID);
            LOGGER.fine("OAAssociationHandler.performAssociations Creating Rack Now");
            this.getRackInformation(rackName, rackUUID, myEnclosureNodeAssociations.getDeviceKey());
            if (rackUUID != null) {
                this.storeTopologyInformation(topology, rackUUID);
            }
            if (this.getTheRackDevice() != null) {
                LOGGER.fine("OAAssociationHandler.performAssociations Adding Subtype to Rack");
                this.addNodeTypeSubType(this.getTheRackDevice(), NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
                this.getTheRackDevice().setModel("Rack");
            }
        }
        try {
            OLDevice olDevice = olEnclosure.resolveCurrentOADevice(oaMxNode.getWorkingAddress());
            this.buildOAAssociation(olEnclosure, oaMxNode, olDevice, myEnclosureNodeAssociations, this.myNodeRelationships);
        }
        catch (OAException e) {
            LOGGER.error("OAAssociationHandler.performAssociations : buildOAAssociation failed " + e);
            LOGGER.exception((Throwable)e);
        }
        String DISCOVERY_ASSOCIATED_DEVICE_CHECK = GlobalSettings.getProperty((String)"obaDisc_enabled_state", (String)"checked");
        LOGGER.fine("OAAssociationHandler.performAssociations : DISCOVERY_ASSOCIATED_DEVICE_CHECK " + DISCOVERY_ASSOCIATED_DEVICE_CHECK);
        List<OLDevice> bladeList = olEnclosure.getBladeList();
        List<OLDevice> switchList = olEnclosure.getSwitchList();
        NodeAssociations nodeAssociations = myEnclosureNodeAssociations;
        synchronized (nodeAssociations) {
            this.createAndBuildOtherOAAssociations(olEnclosure, oaMxNode, DISCOVERY_ASSOCIATED_DEVICE_CHECK, myEnclosureNodeAssociations);
            this.updateEnclosureNode(olEnclosure, myEnclosureNodeAssociations);
            this.buildDeviceAssociations(olEnclosure, bladeList, myEnclosureNodeAssociations, "ServerToEnclosure", DISCOVERY_ASSOCIATED_DEVICE_CHECK);
            this.buildDeviceAssociations(olEnclosure, switchList, myEnclosureNodeAssociations, "SwitchToEnclosure", DISCOVERY_ASSOCIATED_DEVICE_CHECK);
            if (DISCOVERY_ASSOCIATED_DEVICE_CHECK.equalsIgnoreCase("checked")) {
                for (int i = 0; i < bladeList.size(); ++i) {
                    try {
                        this.checkMPExistsAndBuildMPAssociation(bladeList.get(i));
                        continue;
                    }
                    catch (HandlerException e) {
                        LOGGER.finer("OAAssociationHandler.performAssociations Blade ILO IP : " + bladeList.get(i).getDeviceMgmtProcIp());
                        if (!this.isValidDevIP(bladeList.get(i).getDeviceMgmtProcIp())) continue;
                        this.triggerAutomaticDiscovery(bladeList.get(i).getDeviceMgmtProcIp());
                    }
                }
            }
        }
        if (this.getTheRackDevice() != null) {
            nodeAssociations = this.getTheRackDevice();
            synchronized (nodeAssociations) {
                LOGGER.fine("OAAssociationHandler.performAssociations Storing the topology now");
                this.storeTopologyInformation(topology, this.getTheRackDevice());
            }
        }
        LOGGER.exit("OAAssociationHandler.performAssociations(" + oaDataManager + "," + oaMxNode + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndBuildOtherOAAssociations(OLEnclosure olEnclosure, MxNode discoveredOaMxNode, String DISCOVERY_ASSOCIATED_DEVICE_CHECK, NodeAssociations myEnclosureNodeAssociations) {
        List<OLDevice> oaList = olEnclosure.getOAList();
        for (OnboardAdministrator onboardAdministrator : oaList) {
            List discoveredOAIPList = discoveredOaMxNode.getIPAddressList();
            if (discoveredOAIPList.contains(onboardAdministrator.getDeviceMgmtProcIp())) continue;
            if (!onboardAdministrator.isUniqueIdentifierExists()) {
                LOGGER.fine("OAAssociationHandler.createAndBuildOtherOAAssociations : No UUID/Serial number. Skipping Node Creation");
                continue;
            }
            MxNode otherOAMxNode = onboardAdministrator.getDeviceMxNode();
            LOGGER.fine("OAAssociationHandler.createAndBuildOtherOAAssociations : otherOAMxNode " + otherOAMxNode);
            if (otherOAMxNode == null && DISCOVERY_ASSOCIATED_DEVICE_CHECK.equalsIgnoreCase("checked")) {
                otherOAMxNode = this.createBareMetalDevice(onboardAdministrator, olEnclosure);
            }
            LOGGER.fine("OAAssociationHandler.createAndBuildOtherOAAssociations : deviceMxNode " + otherOAMxNode);
            if (otherOAMxNode == null) continue;
            MxNode mxNode = otherOAMxNode;
            synchronized (mxNode) {
                this.setDeviceName(otherOAMxNode, this.getLogicalDeviceNameBySlotNumber(onboardAdministrator, olEnclosure), this.getLogicalDeviceNameBySerialNumber(onboardAdministrator, olEnclosure));
                try {
                    NodeAssociations otherOANodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(otherOAMxNode.getDeviceKey(), true);
                    this.buildOAAssociation(olEnclosure, otherOAMxNode, onboardAdministrator, myEnclosureNodeAssociations, otherOANodeAssociations);
                }
                catch (OAException oaExcep) {
                    LOGGER.error("Unable to associate OA and its enclosure, OA:" + otherOAMxNode.getNameString() + " Exception:" + oaExcep);
                }
            }
        }
    }

    private void checkMPExistsAndBuildMPAssociation(OLDevice blade) throws HandlerException {
        LOGGER.enter("checkMPExistsAndBuildMPAssociation(" + blade + ")");
        String MP_IP_ADDRESS = blade.getDeviceMgmtProcIp();
        LOGGER.fine("MP IP of the blade from OA XML:" + MP_IP_ADDRESS);
        try {
            MxNodeController nodeController = MxNodeController.getDefaultController();
            MxNode mpMxNode = nodeController.getNodeByIPAddress(MP_IP_ADDRESS);
            String ATN = "MgmtProcToServer_Ilo";
            MxNode serverMxNode = blade.getDeviceMxNode();
            if (serverMxNode != null && serverMxNode.getDeviceSubTypes().contains("HPIntegrity")) {
                ATN = "MgmtProcToServer_IPF";
            }
            if (serverMxNode != null && mpMxNode != null) {
                this.buildMPAssociation(mpMxNode, serverMxNode, ATN);
            }
        }
        catch (MxUndefinedNodeException undefExec) {
            throw new HandlerException("Unable to get the MP Node from the IP Address,Assuming MP does not exists!");
        }
        catch (MxObjectPersistenceException e) {
            throw new HandlerException("Unable to get the NodeController object,Assuming MP does not exists!");
        }
    }

    private Vector<Vector<String>> getTopology(OLEnclosure olEnclosure) {
        LOGGER.enter("OAAssociationHandler.buildTopology(" + olEnclosure + ")");
        Vector<Vector<String>> topology = new Vector<Vector<String>>(1, 2);
        Vector<String> tplgy = null;
        List<ICMB> icmbList = olEnclosure.getRackTopology().getICMBList();
        ICMB icmb = null;
        for (int i = 0; i < icmbList.size(); ++i) {
            icmb = icmbList.get(i);
            tplgy = new Vector<String>(11, 2);
            tplgy.addElement(icmb.getUUID());
            LOGGER.finer("icmb.getUUID() " + icmb.getUUID());
            LOGGER.finer("olEnclosure.getEnclosureUUID() " + olEnclosure.getEnclosureUUID());
            if (icmb.getUUID().equalsIgnoreCase(olEnclosure.getEnclosureUUID())) {
                tplgy.addElement(olEnclosure.getEnclosureName());
            } else {
                tplgy.addElement("");
            }
            tplgy.addElement("");
            tplgy.addElement("");
            tplgy.addElement("true");
            tplgy.addElement("false");
            tplgy.addElement(icmb.getLeftUUID());
            tplgy.addElement(icmb.getRightUUID());
            tplgy.addElement(icmb.getSerialNumber());
            tplgy.addElement(icmb.getLeftSerialNumber());
            tplgy.addElement(icmb.getRightSerialNumber());
            topology.addElement(tplgy);
        }
        LOGGER.exit("OAAssociationHandler.buildTopology(" + olEnclosure + ")");
        return topology;
    }

    private Vector<String> getCurrentTopologyByUUID(OLEnclosure olEnclosure, Vector<Vector<String>> topology) throws HandlerException {
        LOGGER.enter("IloAssociationDataHandler.getCurrentTopologyByUUID(" + olEnclosure + "," + topology + ")");
        Vector<String> tplgy = null;
        String uuid = null;
        for (int i = 0; i < topology.size(); ++i) {
            tplgy = topology.get(i);
            uuid = tplgy.get(0);
            LOGGER.fine("OAAssociationHandler.getCurrentTopologyByUUID.uuid " + uuid);
            LOGGER.fine("OAAssociationHandler.getCurrentTopologyByUUID.bladeEnclosure.getUUID() " + olEnclosure.getEnclosureUUID());
            if (!uuid.equalsIgnoreCase(olEnclosure.getEnclosureUUID())) continue;
            LOGGER.fine("OAAssociationHandler.getCurrentTopologyByUUID.Yeah there is a matching topology");
            LOGGER.exit("OAAssociationHandler.getCurrentTopologyByUUID(" + olEnclosure + "," + topology + ")");
            return tplgy;
        }
        LOGGER.fine("Could not get the current topology from UUID.");
        throw new HandlerException("OAAssociationHandler.getCurrentTopologyByUUID Unable to get current topology information from UUID");
    }

    private Vector<String> getCurrentTopologyBySerialNum(OLEnclosure olEnclosure, Vector<Vector<String>> topology) throws HandlerException {
        LOGGER.enter("OAAssociationHandler.getCurrentTopologyBySerialNum(" + olEnclosure + "," + topology + ")");
        Vector<String> tplgy = null;
        String serialNumber = null;
        for (int i = 0; i < topology.size(); ++i) {
            tplgy = topology.get(i);
            serialNumber = tplgy.get(8);
            LOGGER.fine("OAAssociationHandler.getCurrentTopologyBySerialNum.serialnmber " + serialNumber);
            LOGGER.fine("OAAssociationHandler.getCurrentTopologyBySerialNum.bladeEnclosure.BySerialNum() " + olEnclosure.getEnclosureSerialNumber());
            if (!serialNumber.equalsIgnoreCase(olEnclosure.getEnclosureSerialNumber())) continue;
            LOGGER.fine("OAAssociationHandler.getCurrentTopologyBySerialNum.Yeah there is a matching topology");
            LOGGER.exit("OAAssociationHandler.getCurrentTopologyBySerialNum(" + olEnclosure + "," + topology + ")");
            return tplgy;
        }
        LOGGER.fine("Could not get the current topology from serial number as well.");
        throw new HandlerException("OAAssociationHandler.getCurrentTopologyByUUID Unable to get current topology information from serial number");
    }

    private Vector<String> getCurrentTopology(OLEnclosure olEnclosure, Vector<Vector<String>> topology) throws HandlerException {
        LOGGER.enter("OAAssociationHandler.getCurrentTopology(" + olEnclosure + "," + topology + ")");
        Vector<String> tplgy = null;
        try {
            tplgy = this.getCurrentTopologyByUUID(olEnclosure, topology);
        }
        catch (HandlerException e) {
            tplgy = this.getCurrentTopologyBySerialNum(olEnclosure, topology);
        }
        if (tplgy != null) {
            return tplgy;
        }
        LOGGER.exit("OAAssociationHandler.getCurrentTopology(" + olEnclosure + "," + topology + ")");
        throw new HandlerException("Unable to get current topology information");
    }

    private void buildOAAssociation(OLEnclosure olEnclosure, MxNode oaMxNode, OLDevice oaDevice, NodeAssociations myEnclosureNodeAssociations, NodeAssociations oaNodeAssociations) throws OAException {
        LOGGER.enter("OAAssociationHandler.buildOAAssociation(" + olEnclosure + "," + oaMxNode + "," + myEnclosureNodeAssociations + ")");
        int enclosureDeviceKey = myEnclosureNodeAssociations.getDeviceKey();
        int oaDeviceKey = oaMxNode.getDeviceKey();
        LOGGER.fine("OAAssociationHandler.buildOAAssociation : enclosureDeviceKey " + enclosureDeviceKey);
        LOGGER.fine("OAAssociationHandler.buildOAAssociation : oaDeviceKey " + oaDeviceKey);
        LOGGER.fine("OAAssociationHandler.buildOAAssociation : olDevice.getDeviceMgmtProcIp() " + oaDevice.getDeviceMgmtProcIp());
        LOGGER.fine("OAAssociationHandler.buildOAAssociation : olDevice.getDeviceUUID() " + oaDevice.getDeviceUUID());
        oaNodeAssociations.setInContainer(true);
        oaNodeAssociations.setParent(enclosureDeviceKey);
        oaNodeAssociations.setSource("OA");
        oaNodeAssociations.setSlotNumber(oaDevice.getDeviceSlot());
        oaNodeAssociations.setMmHeight(oaDevice.getDeviceHeight());
        oaNodeAssociations.setMmWidth(oaDevice.getDeviceWidth());
        oaNodeAssociations.setMmDepth(oaDevice.getDeviceDepth());
        int slotsUsedInXDirection = oaDevice.getDeviceSlotsInXDirection();
        int slotsUsedInYDirection = oaDevice.getDeviceSlotsInYDirection();
        LOGGER.fine("OAAssociationHandler.buildOAAssociation : olDevice.getDeviceSlot() " + oaDevice.getDeviceSlot());
        LOGGER.fine("OAAssociationHandler.buildOAAssociation : slotsUsedInXDirection " + slotsUsedInXDirection);
        LOGGER.fine("OAAssociationHandler.buildOAAssociation : slotsUsedInYDirection " + slotsUsedInYDirection);
        oaNodeAssociations.setNumBladeSlotsUsedYDir(1);
        if (slotsUsedInXDirection > 0 && slotsUsedInYDirection > 0) {
            oaNodeAssociations.setNumBladeSlotsUsedXDir(slotsUsedInXDirection);
            oaNodeAssociations.setNumBladeSlotsUsedYDir(slotsUsedInYDirection);
            oaNodeAssociations.setNumBladeSlotsUsed(slotsUsedInXDirection * slotsUsedInYDirection);
        }
        if (oaNodeAssociations.getSlotNumber() != -1) {
            this.removeOldDeviceFromThisSlot(oaNodeAssociations, myEnclosureNodeAssociations, "MgmtProc", "MgmtProcToEnclosure");
            oaNodeAssociations.setTheAssociation(oaDeviceKey, enclosureDeviceKey, "MgmtProcToEnclosure", false);
        }
        if (oaMxNode.getAgentUUID() == null || oaMxNode.getAgentUUID().trim().length() == 0) {
            oaMxNode.setAgentUUID(oaDevice.getDeviceUUID());
        }
        if (oaMxNode.getSerialNumber() == null || oaMxNode.getSerialNumber().length() == 0) {
            oaMxNode.setSerialNumber(oaDevice.getDeviceSerialNumber());
        }
        oaMxNode.setEnclosureName(this.getServerEnclosureName(olEnclosure));
        MxNode enclosureMxNode = olEnclosure.getDeviceMxNode();
        LOGGER.fine("OAAssociationHandler.buildOAAssociation : enclosureMxNode " + enclosureMxNode);
        oaDevice.update(oaMxNode, enclosureMxNode);
        this.myNodeRelationshipManager.update(oaNodeAssociations);
        this.addDeviceToTopologyTree(myEnclosureNodeAssociations, oaDeviceKey);
        LOGGER.exit("OAAssociationHandler.buildOAAssociation(" + olEnclosure + "," + oaMxNode + "," + myEnclosureNodeAssociations + ")");
    }

    private void updateEnclosureNode(OLEnclosure olEnclosure, NodeAssociations myEnclosureNodeAssociations) {
        LOGGER.enter("OAAssociationHandler.updateEnclosureNode(" + olEnclosure + "," + myEnclosureNodeAssociations + ")");
        String shortyModelName = "c3000";
        myEnclosureNodeAssociations.setMaxNumItemsXDir(8);
        myEnclosureNodeAssociations.setMaxNumItemsYDir(2);
        if (olEnclosure.getEnclosureProductName().contains("c3000")) {
            myEnclosureNodeAssociations.setMaxNumItems(8);
        } else {
            myEnclosureNodeAssociations.setMaxNumItems(16);
        }
        myEnclosureNodeAssociations.setSource("OA");
        myEnclosureNodeAssociations.setMmHeight(olEnclosure.getEnclosureHeight());
        myEnclosureNodeAssociations.setMmWidth(olEnclosure.getEnclosureWidth());
        myEnclosureNodeAssociations.setMmDepth(olEnclosure.getEnclosureDepth());
        this.myNodeRelationshipManager.update(myEnclosureNodeAssociations);
        try {
            MxNode enclosureMxNode = olEnclosure.getDeviceMxNode();
            enclosureMxNode.setModel("Server Enclosure");
            enclosureMxNode.setAssetNumber(olEnclosure.getEnclosureAsset());
            List currentSubTypes = enclosureMxNode.getDeviceSubTypes();
            List newSubTypes = olEnclosure.getSubTypeList();
            for (int i = 0; i < newSubTypes.size(); ++i) {
                currentSubTypes.add(newSubTypes.get(i));
            }
            enclosureMxNode.setDeviceSubTypes(currentSubTypes);
            olEnclosure.update(enclosureMxNode);
        }
        catch (OAException e) {
            LOGGER.error("OAAssociationHandler.updateEnclosureNode Failed " + e);
            LOGGER.exception((Throwable)e);
        }
        LOGGER.exit("OAAssociationHandler.updateEnclosureNode(" + olEnclosure + "," + myEnclosureNodeAssociations + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDeviceAssociations(OLEnclosure olEnclosure, List<OLDevice> deviceList, NodeAssociations myEnclosureNodeAssociations, String ASSOCIATION_TYPE, String DISCOVERY_ASSOCIATED_DEVICE_CHECK) {
        LOGGER.enter("OAAssociationHandler.buildDeviceAssociations(" + olEnclosure + "," + deviceList + "," + myEnclosureNodeAssociations + "," + ASSOCIATION_TYPE + "," + DISCOVERY_ASSOCIATED_DEVICE_CHECK + ")");
        OLDevice olDevice = null;
        for (int i = 0; i < deviceList.size(); ++i) {
            olDevice = deviceList.get(i);
            LOGGER.fine("OAAssociationHandler.buildDeviceAssociations : olDevice " + olDevice);
            LOGGER.fine("OAAssociationHandler.buildDeviceAssociations : olDevice.isUniqueIdentifierExists() " + olDevice.isUniqueIdentifierExists());
            if (!olDevice.isUniqueIdentifierExists()) {
                LOGGER.fine("OAAssociationHandler.buildDeviceAssociations : No UUID/Serial number. Skipping Node Creation");
                continue;
            }
            MxNode deviceMxNode = olDevice.getDeviceMxNode();
            LOGGER.fine("OAAssociationHandler.buildDeviceAssociations : deviceMxNode " + deviceMxNode);
            if (deviceMxNode == null && DISCOVERY_ASSOCIATED_DEVICE_CHECK.equalsIgnoreCase("checked")) {
                deviceMxNode = this.createBareMetalDevice(olDevice, olEnclosure);
            }
            LOGGER.fine("OAAssociationHandler.buildDeviceAssociations : deviceMxNode " + deviceMxNode);
            if (deviceMxNode != null) {
                MxNode mxNode = deviceMxNode;
                synchronized (mxNode) {
                    this.performDeviceAssociation(olDevice, deviceMxNode, myEnclosureNodeAssociations, ASSOCIATION_TYPE, olEnclosure);
                }
            }
            MxNode enclosureMxNode = null;
            try {
                enclosureMxNode = olEnclosure.getDeviceMxNode();
            }
            catch (OAException e) {
                LOGGER.error("OAAssociationHandler.buildDeviceAssociations : Unable to get Enclosure MxNode " + e);
                LOGGER.exception((Throwable)e);
            }
            this.makeDevicePollable(deviceMxNode);
            olDevice.update(deviceMxNode, enclosureMxNode);
        }
        LOGGER.exit("OAAssociationHandler.buildDeviceAssociations(" + olEnclosure + "," + deviceList + "," + myEnclosureNodeAssociations + "," + ASSOCIATION_TYPE + "," + DISCOVERY_ASSOCIATED_DEVICE_CHECK + ")");
    }

    private void makeDevicePollable(MxNode deviceMxNode) {
        if (deviceMxNode != null && deviceMxNode.getDeviceType().equalsIgnoreCase("Storage")) {
            deviceMxNode.setSnoozeTime(-2);
        }
    }

    private void performDeviceAssociation(OLDevice olDevice, MxNode deviceMxNode, NodeAssociations myEnclosureNodeAssociations, String ASSOCIATION_TYPE, OLEnclosure olEnclosure) {
        LOGGER.enter("OAAssociationHandler.performDeviceAssociation(" + olDevice + "," + deviceMxNode + "," + myEnclosureNodeAssociations + "," + ASSOCIATION_TYPE + "," + olEnclosure + ")");
        int deviceKey = deviceMxNode.getDeviceKey();
        LOGGER.fine("OAAssociationHandler.performDeviceAssociation : deviceKey " + deviceKey);
        int enclosureDeviceKey = myEnclosureNodeAssociations.getDeviceKey();
        LOGGER.fine("OAAssociationHandler.performDeviceAssociation : enclosureDeviceKey " + enclosureDeviceKey);
        NodeAssociations myDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(deviceKey);
        LOGGER.fine("OAAssociationHandler.performDeviceAssociation : myDeviceNodeAssociations " + myDeviceNodeAssociations);
        if (myDeviceNodeAssociations == null) {
            LOGGER.fine("OAAssociationHandler.performDeviceAssociation : Creating new myDeviceNodeAssociations");
            myDeviceNodeAssociations = new NodeAssociations(deviceKey);
            LOGGER.fine("OAAssociationHandler.performDeviceAssociation : myDeviceNodeAssociations " + myDeviceNodeAssociations);
        }
        int DEVICE_OLD_SLOT = myDeviceNodeAssociations.getSlotNumber();
        LOGGER.fine("OAAssociationHandler.performDeviceAssociation : DEVICE_OLD_SLOT " + DEVICE_OLD_SLOT);
        LOGGER.fine("OAAssociationHandler.performDeviceAssociation : Creating new association for " + olDevice.getDeviceUUID());
        deviceMxNode.setEnclosureName(this.getServerEnclosureName(olEnclosure));
        int slotsUsedInXDirection = olDevice.getDeviceSlotsInXDirection();
        int slotsUsedInYDirection = olDevice.getDeviceSlotsInYDirection();
        myDeviceNodeAssociations.setNumBladeSlotsUsedYDir(1);
        if (slotsUsedInXDirection > 0 && slotsUsedInYDirection > 0) {
            myDeviceNodeAssociations.setNumBladeSlotsUsedXDir(slotsUsedInXDirection);
            myDeviceNodeAssociations.setNumBladeSlotsUsedYDir(slotsUsedInYDirection);
            myDeviceNodeAssociations.setNumBladeSlotsUsed(slotsUsedInXDirection * slotsUsedInYDirection);
        }
        myDeviceNodeAssociations.setInContainer(true);
        myDeviceNodeAssociations.setParent(enclosureDeviceKey);
        myDeviceNodeAssociations.setSource("OA");
        myDeviceNodeAssociations.setSlotNumber(olDevice.getDeviceSlot());
        myDeviceNodeAssociations.setMmHeight(olDevice.getDeviceHeight());
        myDeviceNodeAssociations.setMmWidth(olDevice.getDeviceWidth());
        myDeviceNodeAssociations.setMmDepth(olDevice.getDeviceDepth());
        if (myDeviceNodeAssociations.getSlotNumber() != -1) {
            this.removeOldDeviceFromThisSlot(myDeviceNodeAssociations, myEnclosureNodeAssociations, olDevice.getDeviceType(), ASSOCIATION_TYPE);
            myDeviceNodeAssociations.setTheAssociation(deviceKey, enclosureDeviceKey, ASSOCIATION_TYPE, false);
        }
        this.myNodeRelationshipManager.update(myDeviceNodeAssociations);
        this.addDeviceToTopologyTree(myEnclosureNodeAssociations, deviceKey);
        try {
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), deviceMxNode, false);
        }
        catch (MxException e) {
            LOGGER.error("OAAssociationHandler.performDeviceAssociation : Failed. Device Serial Number is " + deviceMxNode.getSerialNumber() + " MxException " + (Object)((Object)e));
            LOGGER.exception((Throwable)e);
        }
        this.setDeviceName(deviceMxNode, this.getLogicalDeviceNameBySlotNumber(olDevice, olEnclosure), this.getLogicalDeviceNameBySerialNumber(olDevice, olEnclosure));
        LOGGER.exit("OAAssociationHandler.performDeviceAssociation(" + olDevice + "," + deviceMxNode + "," + myEnclosureNodeAssociations + "," + ASSOCIATION_TYPE + "," + olEnclosure + ")");
    }

    private MxNode createBareMetalDevice(OLDevice olDevice, OLEnclosure olEnclosure) {
        LOGGER.enter("OAAssociationHandler.createBareMetalDevice(" + olDevice + "," + olEnclosure + ")");
        MxNode deviceMxNode = new MxNode();
        String srvAgentUUID = olDevice.getDeviceUUID();
        String serverPN = olDevice.getDeviceProductName();
        String srvSerialNum = olDevice.getDeviceSerialNumber();
        String srvUniqueIdent = null;
        if (srvAgentUUID != null && srvAgentUUID.length() > 0) {
            String spnToLower = serverPN.toLowerCase();
            srvUniqueIdent = serverPN != null && spnToLower.indexOf("bl860c") != -1 ? UniqueIdentifierUtility.normalizeUniqueID((String)srvAgentUUID, (boolean)false, (boolean)true) : UniqueIdentifierUtility.normalizeUniqueID((String)srvAgentUUID, (boolean)true, (boolean)true);
            deviceMxNode.setUniqueIdentifier(srvUniqueIdent);
            LOGGER.fine(" --->>> UniqueIdentifier sets to uuid =" + srvAgentUUID);
            deviceMxNode.setAgentUUID(srvAgentUUID);
            LOGGER.fine(" --->>> agentUUID sets to uuid =" + srvAgentUUID);
        } else if (srvSerialNum != null && srvSerialNum.length() > 0) {
            deviceMxNode.setAgentUUID(srvSerialNum);
            LOGGER.fine(" --->>> agentUUID sets to serial number =" + srvSerialNum);
        } else {
            LOGGER.panic("  ????>>> there's no serial numbe and UUID tag specified in XML for ");
        }
        if (srvSerialNum != null && srvSerialNum.length() > 0) {
            deviceMxNode.setSerialNumber(srvSerialNum);
        }
        deviceMxNode.setDeviceType(olDevice.getDeviceType());
        deviceMxNode.setSnoozeTime(-3);
        deviceMxNode.setSnmpTimeOut(new Integer(GlobalSettings.getProperty((String)"NetworkTimeout", (String)"5")).intValue());
        deviceMxNode.setSnmpRetry(new Integer(GlobalSettings.getProperty((String)"NetworkRetries", (String)"2")).intValue());
        deviceMxNode.setIcmpTimeOut(new Integer(GlobalSettings.getProperty((String)"IcmpTimeout", (String)"5")).intValue());
        deviceMxNode.setIcmpRetry(new Integer(GlobalSettings.getProperty((String)"IcmpRetries", (String)"2")).intValue());
        int defaultsMask = 255;
        deviceMxNode.setDefaultsMask(true, defaultsMask);
        deviceMxNode.setModel(olDevice.getDeviceProductName());
        deviceMxNode.setDeviceSubTypes(olDevice.getSubTypeList());
        try {
            MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), deviceMxNode);
            LOGGER.exit("OAAssociationHandler.createBareMetalDevice(" + olDevice + "," + olEnclosure + ")");
            return deviceMxNode;
        }
        catch (MxException e) {
            LOGGER.error("OAAssociationHandler.createBareMetalDevice : Failed. Device Serial Number is " + olDevice.getDeviceUUID() + " MxException " + (Object)((Object)e));
            LOGGER.exception((Throwable)e);
            LOGGER.exit("OAAssociationHandler.createBareMetalDevice(" + olDevice + "," + olEnclosure + ")");
            return null;
        }
    }

    private void setDeviceName(MxNode deviceMxNode, String NEW_NAME, String NEW_ALTERNATIVE_NAME) {
        LOGGER.enter("OAAssociationHandler.setDeviceName(" + deviceMxNode + "," + NEW_NAME + "," + NEW_ALTERNATIVE_NAME + ")");
        if (deviceMxNode.getIPAddressCount() != 0) {
            LOGGER.fine("  ----> OA handler not setting device name because device alreay has ip address for new name=" + deviceMxNode.getWorkingAddress() + ", with new name=" + NEW_NAME);
            return;
        }
        String CURRENT_NAME = deviceMxNode.getNameString();
        String DsIdVal = deviceMxNode.getClientAttribute("DsId");
        if (DsIdVal != null) {
            LOGGER.fine(" =====> OAAssocationHandler.setDeviceName, don't need to change dobby created node, current name=" + CURRENT_NAME);
            return;
        }
        LOGGER.fine("OAAssociationHandler.setDeviceName CURRENT_NAME " + CURRENT_NAME);
        if (NEW_NAME.equalsIgnoreCase(CURRENT_NAME)) {
            return;
        }
        try {
            LOGGER.fine("OAAssociationHandler.setDeviceName setting NEW NAME " + NEW_NAME + ", for dev=" + CURRENT_NAME);
            deviceMxNode.setDeviceName(NEW_NAME);
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), deviceMxNode, false);
        }
        catch (MxException me) {
            LOGGER.fine("OAAssociationHandler.setDeviceName setting NEW NAME failed " + NEW_NAME);
            if (NEW_ALTERNATIVE_NAME.equalsIgnoreCase(CURRENT_NAME)) {
                return;
            }
            try {
                LOGGER.fine("OAAssociationHandler.setDeviceName setting NEW ALETERNATIVE NAME " + NEW_ALTERNATIVE_NAME + ", for dev=" + CURRENT_NAME);
                deviceMxNode.setDeviceName(NEW_ALTERNATIVE_NAME);
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), deviceMxNode, false);
            }
            catch (MxException me1) {
                LOGGER.error("OAAssociationHandler.setDeviceName setting NEW ALETERNATIVE NAME failed " + NEW_ALTERNATIVE_NAME);
                LOGGER.exception((Throwable)me1);
            }
        }
        LOGGER.exit("OAAssociationHandler.setDeviceName(" + deviceMxNode + "," + NEW_NAME + "," + NEW_ALTERNATIVE_NAME + ")");
    }

    private String getLogicalDeviceNameBySlotNumber(OLDevice olDevice, OLEnclosure olEnclosure) {
        LOGGER.enter("OAAssociationHandler.getLogicalDeviceNameBySlotNumber(" + olDevice + "," + olEnclosure + ")");
        StringBuffer logicalDeviceNameBuffer = new StringBuffer();
        logicalDeviceNameBuffer.append(this.getServerEnclosureName(olEnclosure));
        logicalDeviceNameBuffer.append("_");
        logicalDeviceNameBuffer.append(olDevice.getDeviceSlot());
        if (olDevice.getDeviceType().equalsIgnoreCase("MgmtProc")) {
            logicalDeviceNameBuffer.append("_");
            logicalDeviceNameBuffer.append("OA");
        }
        logicalDeviceNameBuffer.append("-");
        logicalDeviceNameBuffer.append(olDevice.getDeviceSide());
        String logicalDevName = logicalDeviceNameBuffer.toString();
        LOGGER.fine("  >>>> logical device name =" + logicalDevName + ", for olDev=" + olDevice + ", for enclosure=" + olEnclosure);
        LOGGER.exit("OAAssociationHandler.getLogicalDeviceNameBySlotNumber(" + olDevice + "," + olEnclosure + ")");
        return logicalDevName;
    }

    private String getRackName(OLEnclosure olEnclosure) {
        LOGGER.enter("ILOAssociationHandler.getRackName(" + olEnclosure + ")");
        String rackName = "";
        MxNode rackNode = this.getTheRackDevice();
        if (rackNode != null) {
            rackName = rackNode.getNameString();
        } else {
            LOGGER.error("Unable to find the rack MxNode, Device namewill be set using the rack name from ILO XML.");
        }
        if (rackName == null || rackName.trim().length() <= 0) {
            rackName = olEnclosure.getRackName();
        }
        LOGGER.fine("Rack Name:" + rackName);
        LOGGER.exit("ILOAssociationHandler.getRackName(" + olEnclosure + ")");
        return rackName;
    }

    private String getServerEnclosureName(OLEnclosure olEnclosure) {
        LOGGER.enter("ILOAssociationHandler.getEnclosureName(" + olEnclosure + ")");
        String enclName = "";
        try {
            MxNode enclosureMxNode = olEnclosure.getDeviceMxNode();
            enclName = enclosureMxNode.getNameString();
        }
        catch (OAException oaexcep) {
            LOGGER.error("Unable to find the enclosure MxNode, Device namewill be set using the enclosure name from ILO XML.");
        }
        if (enclName == null || enclName.trim().length() <= 0) {
            enclName = olEnclosure.getEnclosureName();
        }
        LOGGER.fine("Enclosure Name:" + enclName);
        LOGGER.exit("ILOAssociationHandler.getEnclosureName(" + olEnclosure + ")");
        return enclName;
    }

    private String getLogicalDeviceNameBySerialNumber(OLDevice olDevice, OLEnclosure olEnclosure) {
        LOGGER.enter("OAAssociationHandler.getLogicalDeviceNameBySerialNumber(" + olDevice + "," + olEnclosure + ")");
        StringBuffer logicalDeviceNameBuffer = new StringBuffer();
        logicalDeviceNameBuffer.append(this.getServerEnclosureName(olEnclosure));
        logicalDeviceNameBuffer.append("_");
        logicalDeviceNameBuffer.append(olDevice.getDeviceSerialNumber());
        LOGGER.exit("OAAssociationHandler.getLogicalDeviceNameBySerialNumber(" + olDevice + "," + olEnclosure + ")");
        return logicalDeviceNameBuffer.toString();
    }

    private boolean isValidDevIP(String DEVICE_IP_ADDRESS) {
        boolean isValidIP = false;
        if (InetXe.isValidIp((String)DEVICE_IP_ADDRESS) && !DEVICE_IP_ADDRESS.equalsIgnoreCase("0.0.0.0")) {
            isValidIP = true;
        }
        return isValidIP;
    }

    private void triggerAutomaticDiscovery(String DEVICE_IP_ADDRESS) {
        LOGGER.enter("triggerAutomaticDiscovery(" + DEVICE_IP_ADDRESS + ")");
        try {
            MxNode deviceMxNode = new MxNode();
            deviceMxNode.addIPAddress(DEVICE_IP_ADDRESS);
            DiscoveryController.getDefaultController().discoverASystem((MxTransaction)new MxCoreTransaction(), deviceMxNode, true, "ID", false);
        }
        catch (MxException e) {
            LOGGER.error("OAAssociationHandler.triggerAutomaticDiscovery : Failed. DEVICE_IP_ADDRESS " + DEVICE_IP_ADDRESS + " MxException " + (Object)((Object)e));
            LOGGER.exception((Throwable)e);
        }
        LOGGER.exit("triggerAutomaticDiscovery(" + DEVICE_IP_ADDRESS + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeAssociations loadAssociationDataFromDb(MxNode oaMxNode) {
        LOGGER.enter("OAAssociationHandler.loadAssociationDataFromDb(" + oaMxNode + ")");
        LOGGER.fine("OAAssociationHandler.loadAssociationDataFromDb.WORKING_ADDRESS " + oaMxNode.getWorkingAddress());
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        int oaDeviceKey = oaMxNode.getDeviceKey();
        NodeAssociations myNodeRelationships = this.myNodeRelationshipManager.getNodeAssociations(oaDeviceKey, true);
        try {
            LOGGER.fine("OAAssociationHandler.loadAssociationDataFromDb.In Loading Device Associations for " + oaDeviceKey);
            if (oaMxNode != null && oaMxNode.getDeviceType().equals("MgmtProc") && oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()) && oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
                LOGGER.fine("OAAssociationHandler.loadAssociationDataFromDb.Started loading Device Associations for " + oaDeviceKey);
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + oaDeviceKey);
                int deviceKey1 = -1;
                int deviceKey2 = -1;
                String associationTypeNumber = null;
                while (myResultSet.next()) {
                    LOGGER.fine("OAAssociationHandler.loadAssociationDataFromDb.Loading Associations now");
                    deviceKey1 = myResultSet.getInt(1);
                    deviceKey2 = myResultSet.getInt(2);
                    associationTypeNumber = myResultSet.getString(3).trim();
                    LOGGER.fine("OAAssociationHandler.loadAssociationDataFromDb.Loading Associations now deviceKey1 " + deviceKey1);
                    LOGGER.fine("OAAssociationHandler.loadAssociationDataFromDb.Loading Associations now deviceKey2 " + deviceKey2);
                    LOGGER.fine("OAAssociationHandler.loadAssociationDataFromDb.Loading Associations now associationTypeNumber " + associationTypeNumber);
                    myNodeRelationships.setInContainer(true);
                    myNodeRelationships.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                    myNodeRelationships.setParent(deviceKey2);
                }
                LOGGER.fine("OAAssociationHandler.loadAssociationDataFromDb.Loading Dimension Info now");
                myNodeRelationships = this.myNodeRelationshipManager.loadDeviceDimensionInfo(oaDeviceKey, myNodeRelationships);
                this.myNodeRelationshipManager.update(myNodeRelationships);
                LOGGER.fine("loaded, In container flag is now " + myNodeRelationships.inContainer() + " parent " + myNodeRelationships.getParent());
            }
        }
        catch (SQLException sqlException) {
            LOGGER.error("OAAssociationHandler.loadAssociationDataFromDb : SQLException " + sqlException);
            LOGGER.exception((Throwable)sqlException);
        }
        catch (Exception exception) {
            LOGGER.error("OAAssociationHandler.loadAssociationDataFromDb : Exception " + exception);
            LOGGER.exception((Throwable)exception);
        }
        finally {
            try {
                if (myResultSet != null) {
                    myResultSet.close();
                }
                if (myStatement != null) {
                    myStatement.close();
                }
            }
            catch (SQLException sqle) {
            }
            catch (Exception e) {}
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        LOGGER.exit("OAAssociationHandler.loadAssociationDataFromDb(" + oaMxNode + ")");
        return myNodeRelationships;
    }

    @Override
    public NodeAssociations buildContainerTree(NodeAssociations tempMyNodeRelationships, MxNode oaMxNode, MxNode enclosureMxNode) {
        LOGGER.enter("OAAssociationHandler.buildContainerTree(" + tempMyNodeRelationships + "," + oaMxNode + "," + enclosureMxNode + ")");
        LOGGER.fine("OAAssociationHandler.buildContainerTree.WORKING_ADDRESS " + oaMxNode.getWorkingAddress());
        this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(enclosureMxNode.getDeviceKey()), oaMxNode.getDeviceKey());
        tempMyNodeRelationships.setInContainer(true);
        tempMyNodeRelationships.setParent(enclosureMxNode.getDeviceKey());
        LOGGER.exit("OAAssociationHandler.buildContainerTree(" + tempMyNodeRelationships + "," + oaMxNode + "," + enclosureMxNode + ")");
        return tempMyNodeRelationships;
    }

    @Override
    public void cleanUpAssociationData(MxNode oaMxNode) {
        LOGGER.enter("OAAssociationHandler.cleanUpAssociationData(" + oaMxNode + ")");
        LOGGER.fine("OAAssociationHandler.cleanUpAssociationData.WORKING_ADDRESS " + oaMxNode.getWorkingAddress());
        try {
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(oaMxNode.getDeviceKey(), "MgmtProcToEnclosure");
            this.myNodeRelationshipManager.resetDeviceAssociations(oaMxNode.getDeviceKey());
        }
        catch (Exception e) {
            LOGGER.error("OAAssociationHandler.cleanUpAssociationData failed : Exception " + e);
            LOGGER.exception((Throwable)e);
        }
        LOGGER.exit("OAAssociationHandler.cleanUpAssociationData(" + oaMxNode + ")");
    }

    private OADataManager getOADataManagerUT(MxNode oaMxNode) throws OAException {
        LOGGER.enter("OAAssociationHandler.getOADataManagerUT(" + oaMxNode + ")");
        OAHelper oaHelper = OAHelper.getOAHelper();
        OADataManager oaDataManager = new OADataManager(oaHelper.getOAXML(oaMxNode));
        LOGGER.exit("OAAssociationHandler.getOADataManagerUT(" + oaMxNode + ")");
        return oaDataManager;
    }

    private void buildMPAssociation(MxNode iLOMxNode, MxNode serverMxNode, String ASSOCIATION_TYPE) {
        LOGGER.enter("OAAssociationHandler.buildMPAssociation(" + iLOMxNode + "," + serverMxNode + "," + ASSOCIATION_TYPE + ")");
        NodeAssociations myMPNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(iLOMxNode.getDeviceKey());
        if (myMPNodeAssociations == null) {
            myMPNodeAssociations = new NodeAssociations(iLOMxNode.getDeviceKey());
        }
        myMPNodeAssociations.setTheAssociation(iLOMxNode.getDeviceKey(), serverMxNode.getDeviceKey(), ASSOCIATION_TYPE, true);
        myMPNodeAssociations.setInContainer(true);
        myMPNodeAssociations.setSource("");
        NodeAssociations myServerNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(serverMxNode.getDeviceKey());
        if (myServerNodeAssociations == null) {
            myServerNodeAssociations = new NodeAssociations(serverMxNode.getDeviceKey());
        }
        myServerNodeAssociations.setTheAssociation(serverMxNode.getDeviceKey(), iLOMxNode.getDeviceKey(), ASSOCIATION_TYPE, true);
        this.myNodeRelationshipManager.update(myMPNodeAssociations);
        this.myNodeRelationshipManager.update(myServerNodeAssociations);
        AssociationHandlerConstants.setILOAsscociatedAttributes(serverMxNode, iLOMxNode);
        LOGGER.exit("OAAssociationHandler.buildMPAssociation(" + iLOMxNode + "," + serverMxNode + "," + ASSOCIATION_TYPE + ")");
    }
}

