/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.event.MxEventListener;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.datacollection.http.DCException;
import com.hp.mx.core.tools.datacollection.http.DCUtil;
import com.hp.mx.core.tools.datacollection.http.ICMB;
import com.hp.mx.core.tools.datacollection.http.iLO.Blade;
import com.hp.mx.core.tools.datacollection.http.iLO.BladeEnclosure;
import com.hp.mx.core.tools.datacollection.http.iLO.ILO;
import com.hp.mx.core.tools.datacollection.http.iLO.ILODataManager;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOException;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOHelper;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.HandlerException;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.core.utilities.UniqueIdentifierUtility;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.nodedelete.handlers.ILONodeDeleteHandler;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IloAssociationDataHandler
extends RackEnclosureTopologyHandler {
    private static final DebugSubsystem LOGGER;
    private static final Object syncObject;

    public IloAssociationDataHandler(MxNode iLOMxNode) {
        super(iLOMxNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAssociationData(MxNode iLOMxNode, DeviceIdentificationData deviceIdentificationData) {
        LOGGER.enter("IloAssociationDataHandler.getAssociationData(" + iLOMxNode + "," + deviceIdentificationData + ")");
        LOGGER.fine("IloAssociationDataHandler.getAssociationData.WORKING_ADDRESS " + iLOMxNode.getWorkingAddress());
        LOGGER.fine("iLOMxNode.getModel() " + iLOMxNode.getModel());
        LOGGER.fine("iLOMxNode.getDeviceType() " + iLOMxNode.getDeviceType());
        if (!iLOMxNode.getDeviceType().equals("MgmtProc") || iLOMxNode.getModel().toLowerCase().indexOf("integrated lights-out") == -1 && iLOMxNode.getModel().toLowerCase().indexOf("remote insight lights-out edition ii") == -1 && !iLOMxNode.getModel().toLowerCase().equalsIgnoreCase("Lights-Out 100 Remote Management") || iLOMxNode.getModel().toLowerCase().equalsIgnoreCase("integrated lights-out (ilo) for integrity and hp9000") || iLOMxNode.getModel().toLowerCase().equalsIgnoreCase("hp single partition server, management processor") || iLOMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.BS_BMP_SUBTYPE.toString())) {
            LOGGER.fine("IloAssociationDataHandler.getAssociationData Cleaning up the associations");
            this.cleanUpAssociationData(iLOMxNode);
            LOGGER.exit("IloAssociationDataHandler.getAssociationData(" + iLOMxNode + "," + deviceIdentificationData + ")");
            return;
        }
        String isHttpEnabledOnGlobalScale = GlobalSettings.getProperty((String)"http_check_state", (String)"checked");
        if (!isHttpEnabledOnGlobalScale.equals("checked")) {
            LOGGER.fine("Http/Https protocols are disabled on global scale, Go to Options->Configure Global Protocol settings from the SIM Menu and enable the check.");
            this.cleanUpAssociationData(iLOMxNode);
            LOGGER.exit("IloAssociationDataHandler.getAssociationData(" + iLOMxNode + "," + deviceIdentificationData + ")");
            return;
        }
        try {
            while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                Thread.sleep(100L);
            }
            ILODataManager iLODataManager = new ILODataManager(iLOMxNode);
            LOGGER.fine("**********SUCCESSFULLY PARSED ILOXML. NOW PERFORMING ASSOCIATIONS FOR ILO " + iLOMxNode.getWorkingAddress() + "**********");
            if (!iLODataManager.getBladeSubType().equalsIgnoreCase(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
                if (iLODataManager.isBladeServer()) {
                    this.performBladeILOAssociations(iLODataManager, iLOMxNode, "MgmtProcToServer_Ilo");
                    this.updateBladeILOData(iLOMxNode, iLODataManager.getBladeEnclosure().getBlade().getILO());
                } else {
                    this.performNonBladeILOAssociations(iLODataManager, iLOMxNode, "MgmtProcToServer_Ilo");
                    this.updateBladeILOData(iLOMxNode, iLODataManager.getBlade().getILO());
                }
            } else {
                this.performCCLASSBladeILOAssociations(iLODataManager, iLOMxNode, "MgmtProcToServer_Ilo");
            }
            LOGGER.fine("**********SUCCESSFULLY PERFORMED ASSOCIATIONS FOR ILO " + iLOMxNode.getWorkingAddress() + "**********");
        }
        catch (HandlerException e) {
            LOGGER.error("****************UNABLE TO ASSOCIATE ILO " + iLOMxNode.getWorkingAddress() + " WITH ITS ENCLOSURE. PLEASE ENSURE ILO XML HAS GOT ENCLOSURE UUID, RACK UUID AND RACK TOPOLOGY IN IT****************");
            LOGGER.error("HandlerException in IloAssociationDataHandler.getAssociationData: " + e);
            LOGGER.exception((Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.error("****************UNABLE TO GET RELATIONSHIP LOCK FOR ILO " + iLOMxNode.getWorkingAddress() + " PLEASE DISCOVER THIS ILO AFTER SOMETIME****************");
            LOGGER.error("InterruptedException in IloAssociationDataHandler.getAssociationData: " + e);
            LOGGER.exception((Throwable)e);
        }
        catch (ILOException e) {
            LOGGER.error("********ERROR IN PARSING ILO XML. PLEASE ENSURE ILO " + iLOMxNode.getWorkingAddress() + " IS UP AND HAS GOT LATEST FIRMWARE INSTALLED IN IT*********");
            LOGGER.error("ILOException in IloAssociationDataHandler.getAssociationData: " + e);
            LOGGER.exception((Throwable)e);
        }
        finally {
            NodeAssociationsManager.releaseWriteLock();
        }
        LOGGER.exit("IloAssociationDataHandler.getAssociationData(" + iLOMxNode + "," + deviceIdentificationData + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeAssociations performBladeILOAssociations(ILODataManager iLODataManager, MxNode iLOMxNode, String ASSOCIATION_TYPE) throws HandlerException {
        LOGGER.enter("IloAssociationDataHandler.performBladeILOAssociations(" + iLODataManager + "," + iLOMxNode + "," + ASSOCIATION_TYPE + ")");
        NodeAssociations myEnclosureNodeAssociations = null;
        BladeEnclosure bladeEnclosure = iLODataManager.getBladeEnclosure();
        Vector<Vector<String>> topology = null;
        String rackUUID = null;
        Object object = syncObject;
        synchronized (object) {
            topology = this.getTopology(bladeEnclosure);
            String rackName = bladeEnclosure.getRackName();
            rackUUID = bladeEnclosure.getRackTopology().getRackUUID();
            LOGGER.fine("IloAssociationDataHandler.performBladeILOAssociations Creating Enclosure Now");
            myEnclosureNodeAssociations = this.getEnclosureInformation(this.getCurrentTopology(bladeEnclosure, topology), rackName, rackUUID);
            if (myEnclosureNodeAssociations != null) {
                LOGGER.fine("IloAssociationDataHandler.performBladeILOAssociations Creating Rack Now");
                this.storeTopologyInformation(topology, rackUUID);
            }
            LOGGER.fine("IloAssociationDataHandler.performBladeILOAssociations getTheRackDevice() " + this.getTheRackDevice());
            if (this.getTheRackDevice() != null) {
                LOGGER.fine("IloAssociationDataHandler.performBladeILOAssociations Adding Subtype to Rack " + bladeEnclosure.getBlade().getSubType());
                this.addNodeTypeSubType(this.getTheRackDevice(), bladeEnclosure.getBlade().getSubType());
            }
        }
        object = myEnclosureNodeAssociations;
        synchronized (object) {
            this.updateEnclosureData(myEnclosureNodeAssociations, bladeEnclosure);
        }
        String DISCOVERY_ASSOCIATED_DEVICE_CHECK = GlobalSettings.getProperty((String)"iloDisc_enabled_state", (String)"checked");
        LOGGER.fine("IloAssociationDataHandler.performBladeILOAssociations : DISCOVERY_ASSOCIATED_DEVICE_CHECK " + DISCOVERY_ASSOCIATED_DEVICE_CHECK);
        Object object2 = myEnclosureNodeAssociations;
        synchronized (object2) {
            this.buildBladeILOAssociation(bladeEnclosure, iLOMxNode, myEnclosureNodeAssociations, DISCOVERY_ASSOCIATED_DEVICE_CHECK, ASSOCIATION_TYPE);
        }
        if (rackUUID != null) {
            object2 = syncObject;
            synchronized (object2) {
                this.storeTopologyInformation(topology, rackUUID);
            }
        }
        LOGGER.exit("IloAssociationDataHandler.performBladeILOAssociations(" + iLODataManager + "," + iLOMxNode + ")");
        return myEnclosureNodeAssociations;
    }

    private Vector<Vector<String>> getTopology(BladeEnclosure bladeEnclosure) {
        LOGGER.enter("IloAssociationDataHandler.getTopology(" + bladeEnclosure + ")");
        Vector<Vector<String>> topology = new Vector<Vector<String>>(1, 2);
        Vector<String> tplgy = null;
        List<ICMB> icmbList = bladeEnclosure.getRackTopology().getICMBList();
        ICMB icmb = null;
        for (int i = 0; i < icmbList.size(); ++i) {
            icmb = icmbList.get(i);
            tplgy = new Vector<String>(11, 2);
            tplgy.addElement(icmb.getUUID());
            if (icmb.getUUID().equalsIgnoreCase(bladeEnclosure.getUUID())) {
                tplgy.addElement(bladeEnclosure.getName());
            } else {
                tplgy.addElement("");
            }
            tplgy.addElement("");
            tplgy.addElement("");
            if (icmb.isServerEnclosure()) {
                tplgy.addElement("true");
                tplgy.addElement("false");
            } else {
                tplgy.addElement("false");
                tplgy.addElement("true");
            }
            tplgy.addElement(icmb.getRightUUID());
            tplgy.addElement(icmb.getLeftUUID());
            tplgy.addElement(icmb.getSerialNumber());
            tplgy.addElement(icmb.getRightSerialNumber());
            tplgy.addElement(icmb.getLeftSerialNumber());
            topology.addElement(tplgy);
            this.prodIdList.put(icmb.getSerialNumber(), icmb.getProductId());
        }
        LOGGER.exit("IloAssociationDataHandler.getTopology(" + bladeEnclosure + ")");
        return topology;
    }

    private Vector<String> getCurrentTopologyByUUID(BladeEnclosure bladeEnclosure, Vector<Vector<String>> topology) throws HandlerException {
        LOGGER.enter("IloAssociationDataHandler.getCurrentTopologyByUUID(" + bladeEnclosure + "," + topology + ")");
        Vector<String> tplgy = null;
        String uuid = null;
        for (int i = 0; i < topology.size(); ++i) {
            tplgy = topology.get(i);
            uuid = tplgy.get(0);
            LOGGER.fine("IloAssociationDataHandler.getCurrentTopologyByUUID.uuid " + uuid);
            LOGGER.fine("IloAssociationDataHandler.getCurrentTopologyByUUID.bladeEnclosure.getUUID() " + bladeEnclosure.getUUID());
            if (!uuid.equalsIgnoreCase(bladeEnclosure.getUUID())) continue;
            LOGGER.fine("IloAssociationDataHandler.getCurrentTopologyByUUID.Yeah there is a matching topology");
            LOGGER.exit("IloAssociationDataHandler.getCurrentTopologyByUUID(" + bladeEnclosure + "," + topology + ")");
            return tplgy;
        }
        LOGGER.fine("Could not get the current topology from UUID.");
        throw new HandlerException("IloAssociationDataHandler.getCurrentTopologyByUUID Unable to get current topology information from UUID");
    }

    private Vector<String> getCurrentTopologyBySerialNum(BladeEnclosure bladeEnclosure, Vector<Vector<String>> topology) throws HandlerException {
        LOGGER.enter("IloAssociationDataHandler.getCurrentTopologyBySerialNum(" + bladeEnclosure + "," + topology + ")");
        Vector<String> tplgy = null;
        String serialNumber = null;
        for (int i = 0; i < topology.size(); ++i) {
            tplgy = topology.get(i);
            serialNumber = tplgy.get(8);
            LOGGER.fine("IloAssociationDataHandler.getCurrentTopologyBySerialNum.serialnmber " + serialNumber);
            LOGGER.fine("IloAssociationDataHandler.getCurrentTopologyBySerialNum.bladeEnclosure.BySerialNum() " + bladeEnclosure.getSerialNumber());
            if (!serialNumber.equalsIgnoreCase(bladeEnclosure.getSerialNumber())) continue;
            LOGGER.fine("IloAssociationDataHandler.getCurrentTopologyBySerialNum.Yeah there is a matching topology");
            LOGGER.exit("IloAssociationDataHandler.getCurrentTopologyBySerialNum(" + bladeEnclosure + "," + topology + ")");
            return tplgy;
        }
        LOGGER.fine("Could not get the current topology from serial number as well.");
        throw new HandlerException("IloAssociationDataHandler.getCurrentTopologyByUUID Unable to get current topology information from serial number");
    }

    private Vector<String> getCurrentTopology(BladeEnclosure bladeEnclosure, Vector<Vector<String>> topology) throws HandlerException {
        LOGGER.enter("IloAssociationDataHandler.getCurrentTopology(" + bladeEnclosure + "," + topology + ")");
        Vector<String> tplgy = null;
        try {
            tplgy = this.getCurrentTopologyByUUID(bladeEnclosure, topology);
        }
        catch (HandlerException e) {
            tplgy = this.getCurrentTopologyBySerialNum(bladeEnclosure, topology);
        }
        if (tplgy != null) {
            return tplgy;
        }
        throw new HandlerException("IloAssociationDataHandler.getCurrentTopology Unable to get current topology information");
    }

    private void updateILOData(MxNode iLOMxNode, ILO iLO) {
        if ((iLOMxNode.getModel() == null || iLOMxNode.getModel().trim().length() == 0) && iLO.getPN().length() != 0) {
            LOGGER.fine("Setting " + iLO.getPN() + " as model" + "name on ILOMxNode: " + iLOMxNode.getNameString());
            iLOMxNode.setModel(iLO.getPN());
        }
        if ((iLOMxNode.getSerialNumber() == null || iLOMxNode.getSerialNumber().trim().length() == 0) && iLO.getSN().length() != 0) {
            try {
                DCUtil.getNodeBySerialNumber(iLO.getSN());
            }
            catch (DCException dcExcep) {
                LOGGER.fine("Setting " + iLO.getSN() + " as serial " + "number on ILOMxNode: " + iLOMxNode.getNameString());
                iLOMxNode.setSerialNumber(iLO.getSN());
            }
        }
        try {
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), iLOMxNode, false);
        }
        catch (MxException me) {
            LOGGER.error("IloAssociationDataHandler.updateBladeILOData MxException: " + (Object)((Object)me));
            LOGGER.exception((Throwable)me);
        }
    }

    private void updateBladeILOData(MxNode iLOMxNode, ILO iLO) {
        LOGGER.enter("IloAssociationDataHandler.updateBladeILOData(" + iLOMxNode + "," + iLO + ")");
        this.updateILOData(iLOMxNode, iLO);
        iLO.updateAllQueryData(iLOMxNode);
        LOGGER.exit("IloAssociationDataHandler.updateBladeILOData(" + iLOMxNode + "," + iLO + ")");
    }

    private void updateEnclosureData(NodeAssociations myEnclosureNodeAssociations, BladeEnclosure bladeEnclosure) {
        LOGGER.enter("IloAssociationDataHandler.updateEnclosureData(" + myEnclosureNodeAssociations + "," + bladeEnclosure + ")");
        int maxSlotInXDirection = bladeEnclosure.getMaxSlotInXDirection();
        int maxSlotInYDirection = bladeEnclosure.getMaxSlotInYDirection();
        if (maxSlotInXDirection > 0 && maxSlotInYDirection > 0) {
            myEnclosureNodeAssociations.setMaxNumItemsXDir(maxSlotInXDirection);
            myEnclosureNodeAssociations.setMaxNumItemsYDir(maxSlotInYDirection);
            myEnclosureNodeAssociations.setMaxNumItems(maxSlotInXDirection * maxSlotInYDirection);
        } else {
            myEnclosureNodeAssociations.setMaxNumItems(0);
        }
        myEnclosureNodeAssociations.setSource("");
        this.myNodeRelationshipManager.update(myEnclosureNodeAssociations);
        LOGGER.exit("IloAssociationDataHandler.updateEnclosureData(" + myEnclosureNodeAssociations + "," + bladeEnclosure + ")");
    }

    private void buildBladeILOAssociation(BladeEnclosure bladeEnclosure, MxNode iLOMxNode, NodeAssociations myEnclosureNodeAssociations, String DISCOVERY_ASSOCIATED_DEVICE_CHECK, String ASSOCIATION_TYPE) {
        LOGGER.enter("IloAssociationDataHandler.buildBladeILOAssociation(" + bladeEnclosure + "," + iLOMxNode + "," + myEnclosureNodeAssociations + "," + DISCOVERY_ASSOCIATED_DEVICE_CHECK + "," + ASSOCIATION_TYPE + ")");
        MxNode serverMxNode = this.getServerMxNode(bladeEnclosure.getBlade(), DISCOVERY_ASSOCIATED_DEVICE_CHECK);
        LOGGER.fine("IloAssociationDataHandler.buildBladeILOAssociation serverMxNode " + serverMxNode);
        if (serverMxNode != null) {
            this.setServerName(serverMxNode, this.getBladeServerDeviceNameBySlotNumber(bladeEnclosure), this.getBladeServerDeviceNameBySerialNumber(bladeEnclosure));
            this.buildMPAssociation(iLOMxNode, serverMxNode, ASSOCIATION_TYPE);
            this.buildBladeServerAssociation(serverMxNode, bladeEnclosure, myEnclosureNodeAssociations);
        } else {
            int enclosureDeviceKey = myEnclosureNodeAssociations.getDeviceKey();
            try {
                MxNode enclosureMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(enclosureDeviceKey);
                String enclosureSubType = bladeEnclosure.getBlade().getSubType();
                enclosureMxNode.addDeviceSubType(enclosureSubType);
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclosureMxNode, false);
                LOGGER.fine("subType set on enclosure when ILO is discovered without server creation check, subType:" + enclosureSubType + " Enclosure Name:" + enclosureMxNode.getNameString());
            }
            catch (MxException e) {
                LOGGER.fine("Unable to set subType on enclosure when ILO is discovered without server creation check, Exception:" + (Object)((Object)e));
            }
        }
        this.storeAttributes(iLOMxNode, bladeEnclosure.getBlade());
        LOGGER.exit("IloAssociationDataHandler.buildBladeILOAssociation(" + bladeEnclosure + "," + iLOMxNode + "," + myEnclosureNodeAssociations + "," + DISCOVERY_ASSOCIATED_DEVICE_CHECK + ")");
    }

    private MxNode getServerMxNode(Blade blade, String DISCOVERY_ASSOCIATED_DEVICE_CHECK) {
        LOGGER.enter("IloAssociationDataHandler.getServerMxNode(" + blade + "," + DISCOVERY_ASSOCIATED_DEVICE_CHECK + ")");
        MxNode serverMxNode = this.getMxNodeByAgentUUID(blade);
        if (serverMxNode == null) {
            serverMxNode = this.getMxNodeByUniqueIdentifier(blade);
        }
        if (serverMxNode == null) {
            serverMxNode = this.getMxNodeBySerialNumber(blade);
        }
        if (serverMxNode == null && (blade.getUUID().length() > 0 || blade.getBSN().length() > 0) && DISCOVERY_ASSOCIATED_DEVICE_CHECK.equalsIgnoreCase("checked") && !blade.getSubType().equals(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            serverMxNode = this.createBareMetalDevice(blade);
        }
        LOGGER.fine("IloAssociationDataHandler.getServerMxNode serverMxNode " + serverMxNode);
        LOGGER.exit("IloAssociationDataHandler.getServerMxNode(" + blade + "," + DISCOVERY_ASSOCIATED_DEVICE_CHECK + ")");
        return serverMxNode;
    }

    private MxNode getMxNodeByAgentUUID(Blade blade) {
        LOGGER.enter("IloAssociationDataHandler.getMxNodeByAgentUUID(" + blade + ")");
        String serverAgentUUID = blade.getUUID();
        MxNode deviceMxNode = null;
        if (serverAgentUUID != null && serverAgentUUID.length() > 0) {
            try {
                deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(serverAgentUUID);
            }
            catch (MxUndefinedNodeException ex) {
                LOGGER.fine("IloAssociationDataHandler.getMxNodeByAgentUUID MxUndefinedNodeException: " + (Object)((Object)ex));
                LOGGER.fine("IloAssociationDataHandler.getMxNodeByAgentUUID Unable to get server node by Agent UUID: " + serverAgentUUID);
            }
        }
        LOGGER.fine("MxNode:" + deviceMxNode);
        LOGGER.exit("IloAssociationDataHandler.getMxNodeByAgentUUID(" + blade + ")");
        return deviceMxNode;
    }

    private MxNode getMxNodeBySerialNumber(Blade blade) {
        LOGGER.enter("IloAssociationDataHandler.getMxNodeBySerialNumber(" + blade + ")");
        String serialNumber = blade.getBSN();
        MxNode deviceMxNode = null;
        if (serialNumber != null) {
            deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(new Integer(this.myNodeRelationshipManager.getAssociatedDeviceKey(serialNumber)));
        }
        LOGGER.fine("MxNode:" + deviceMxNode);
        LOGGER.exit("IloAssociationDataHandler.getMxNodeBySerialNumber(" + blade + ")");
        return deviceMxNode;
    }

    MxNode getMxNodeByUniqueIdentifier(Blade blade) {
        LOGGER.enter("IloAssociationDataHandler.getMxNodeByUniqueIdentifier(" + blade + ")");
        LOGGER.enter("IloAssociationDataHandler.getMxNodeByUniqueIdentifier(" + blade + ")");
        String serverAgentUUID = blade.getUUID();
        String srvUniqueIdent = null;
        MxNode deviceMxNode = null;
        if (serverAgentUUID != null && serverAgentUUID.length() > 0) {
            srvUniqueIdent = UniqueIdentifierUtility.normalizeUniqueID((String)serverAgentUUID, (boolean)true, (boolean)true);
            try {
                deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByNormUniqueIDENT(srvUniqueIdent);
            }
            catch (MxUndefinedNodeException ex) {
                LOGGER.fine("IloAssociationDataHandler.getMxNodeByUniqueIdentifier MxUndefinedNodeException: " + (Object)((Object)ex));
                LOGGER.fine("IloAssociationDataHandler.getMxNodeByUniqueIdentifier Unable to get server node by Unique Identifier: " + srvUniqueIdent);
            }
        }
        return deviceMxNode;
    }

    private void setServerName(MxNode serverMxNode, String NEW_NAME, String NEW_ALTERNATIVE_NAME) {
        LOGGER.enter("IloAssociationDataHandler.setServerName(" + serverMxNode + "," + NEW_NAME + "," + NEW_ALTERNATIVE_NAME + ")");
        LOGGER.fine("IloAssociationDataHandler.setServerName serverMxNode.getIPAddressCount() " + serverMxNode.getIPAddressCount());
        if (serverMxNode.getIPAddressCount() != 0) {
            LOGGER.fine("  ----> ILO handler not setting device name because device alreay has ip address for new name=" + serverMxNode.getWorkingAddress() + ", with new name=" + NEW_NAME);
            return;
        }
        String CURRENT_NAME = serverMxNode.getNameString();
        String DsIdVal = serverMxNode.getClientAttribute("DsId");
        if (DsIdVal != null) {
            LOGGER.fine(" =====> IloAssociationDataHandler.setServerName, don't need to change dobby created node, current name=" + CURRENT_NAME);
            return;
        }
        LOGGER.fine("IloAssociationDataHandler.setServerName CURRENT_NAME " + CURRENT_NAME);
        if (NEW_NAME.equalsIgnoreCase(CURRENT_NAME)) {
            return;
        }
        try {
            LOGGER.fine("IloAssociationDataHandler.setServerName Setting New Name " + NEW_NAME + ", from the current name=" + CURRENT_NAME);
            serverMxNode.setDeviceName(NEW_NAME);
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), serverMxNode, false);
        }
        catch (MxException me) {
            LOGGER.fine("IloAssociationDataHandler.setServerName Setting New Name Failed" + NEW_NAME);
            if (NEW_ALTERNATIVE_NAME.equalsIgnoreCase(CURRENT_NAME)) {
                return;
            }
            try {
                LOGGER.fine("IloAssociationDataHandler.setServerName Setting New Alternative Name " + NEW_ALTERNATIVE_NAME + ", from current name=" + CURRENT_NAME);
                serverMxNode.setDeviceName(NEW_ALTERNATIVE_NAME);
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), serverMxNode, false);
            }
            catch (MxException me1) {
                LOGGER.error("IloAssociationDataHandler.setServerName Setting New Alternative Name Failed" + NEW_ALTERNATIVE_NAME);
                LOGGER.exception((Throwable)me1);
            }
        }
        LOGGER.exit("IloAssociationDataHandler.setServerName(" + serverMxNode + "," + NEW_NAME + "," + NEW_ALTERNATIVE_NAME + ")");
    }

    void storeAttributes(MxNode iLOMxNode, Blade blade) {
        LOGGER.enter("IloAssociationDataHandler.storeAttributes(" + iLOMxNode + "," + blade + ")");
        String serverUUID = blade.getUUID();
        String serverSerialNumber = blade.getBSN();
        try {
            if (serverUUID.length() > 0) {
                LOGGER.fine("IloAssociationDataHandler.storeAttributes Storing UUID " + serverUUID);
                iLOMxNode.setSWAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), serverUUID);
            } else if (serverSerialNumber.length() > 0) {
                LOGGER.fine("IloAssociationDataHandler.storeAttributes Storing Serial Number " + serverSerialNumber);
                iLOMxNode.setSWAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), serverSerialNumber);
            }
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), iLOMxNode, false);
        }
        catch (MxException me) {
            LOGGER.error("IloAssociationDataHandler.storeAttributes Failed");
            LOGGER.exception((Throwable)me);
        }
        LOGGER.exit("IloAssociationDataHandler.storeAttributes(" + iLOMxNode + "," + blade + ")");
    }

    void buildMPAssociation(MxNode iLOMxNode, MxNode serverMxNode, String ASSOCIATION_TYPE) {
        LOGGER.enter("IloAssociationDataHandler.buildMPAssociation(" + iLOMxNode + "," + serverMxNode + "," + ASSOCIATION_TYPE + ")");
        this.myNodeRelationships.setTheAssociation(iLOMxNode.getDeviceKey(), serverMxNode.getDeviceKey(), ASSOCIATION_TYPE, true);
        this.myNodeRelationships.setInContainer(true);
        this.myNodeRelationships.setParent(serverMxNode.getDeviceKey());
        this.myNodeRelationships.setSource("");
        NodeAssociations myServerNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(serverMxNode.getDeviceKey());
        if (myServerNodeAssociations == null) {
            myServerNodeAssociations = new NodeAssociations(serverMxNode.getDeviceKey());
        }
        myServerNodeAssociations.setTheAssociation(serverMxNode.getDeviceKey(), iLOMxNode.getDeviceKey(), ASSOCIATION_TYPE, true);
        this.myNodeRelationshipManager.update(this.myNodeRelationships);
        this.myNodeRelationshipManager.update(myServerNodeAssociations);
        AssociationHandlerConstants.setILOAsscociatedAttributes(serverMxNode, iLOMxNode);
        LOGGER.exit("IloAssociationDataHandler.buildMPAssociation(" + iLOMxNode + "," + serverMxNode + ")");
    }

    void buildBladeServerAssociation(MxNode serverMxNode, BladeEnclosure bladeEnclosure, NodeAssociations myEnclosureNodeAssociations) {
        LOGGER.enter("IloAssociationDataHandler.buildBladeServerAssociation(" + serverMxNode + "," + bladeEnclosure + "," + myEnclosureNodeAssociations + ")");
        Blade blade = bladeEnclosure.getBlade();
        serverMxNode.setEnclosureName(this.getServerEnclosureName(bladeEnclosure));
        try {
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), serverMxNode, false);
        }
        catch (MxException me) {
            // empty catch block
        }
        NodeAssociations myServerNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(serverMxNode.getDeviceKey());
        if (myServerNodeAssociations == null) {
            myServerNodeAssociations = new NodeAssociations(serverMxNode.getDeviceKey());
        }
        if (blade.getSLOT() != -1) {
            myServerNodeAssociations.setSlotNumber(blade.getSLOT());
            myServerNodeAssociations.setMmHeight(blade.getDeviceHeight());
            myServerNodeAssociations.setMmWidth(blade.getDeviceWidth());
            myServerNodeAssociations.setMmDepth(blade.getDeviceDepth());
            int deviceSlotsInXDirection = blade.getDeviceSlotsInXDirection();
            int deviceSlotsInYDirection = blade.getDeviceSlotsInYDirection();
            LOGGER.fine("IloAssociationDataHandler.buildBladeServerAssociation deviceSlotsInXDirection " + deviceSlotsInXDirection);
            LOGGER.fine("IloAssociationDataHandler.buildBladeServerAssociation deviceSlotsInYDirection " + deviceSlotsInYDirection);
            if (deviceSlotsInXDirection > 0 && deviceSlotsInYDirection > 0) {
                myServerNodeAssociations.setNumBladeSlotsUsedXDir(deviceSlotsInXDirection);
                myServerNodeAssociations.setNumBladeSlotsUsedYDir(deviceSlotsInYDirection);
                myServerNodeAssociations.setNumBladeSlotsUsed(deviceSlotsInXDirection * deviceSlotsInYDirection);
            } else {
                myServerNodeAssociations.setNumBladeSlotsUsedYDir(1);
            }
            this.myNodeRelationshipManager.update(myServerNodeAssociations);
            this.removeOldDeviceFromThisSlot(myServerNodeAssociations, myEnclosureNodeAssociations, blade.getDeviceType(), "ServerToEnclosure");
            myServerNodeAssociations.setTheAssociation(myServerNodeAssociations.getDeviceKey(), myEnclosureNodeAssociations.getDeviceKey(), "ServerToEnclosure", false);
            this.myNodeRelationshipManager.update(myServerNodeAssociations);
        }
        LOGGER.fine("IloAssociationDataHandler.buildBladeServerAssociation blade.getSLOT() " + blade.getSLOT());
        myServerNodeAssociations.setSource("");
        myServerNodeAssociations.setInContainer(true);
        myServerNodeAssociations.setParent(myEnclosureNodeAssociations.getDeviceKey());
        this.addDeviceToTopologyTree(myEnclosureNodeAssociations, myServerNodeAssociations.getDeviceKey());
        this.myNodeRelationshipManager.update(myServerNodeAssociations);
        LOGGER.exit("IloAssociationDataHandler.buildBladeServerAssociation(" + serverMxNode + "," + bladeEnclosure + "," + myEnclosureNodeAssociations + ")");
    }

    String getNormalisedUUID(String srvAgentUUID) {
        return UniqueIdentifierUtility.normalizeUniqueID((String)srvAgentUUID, (boolean)true, (boolean)true);
    }

    private MxNode createBareMetalDevice(Blade blade) {
        LOGGER.enter("IloAssociationDataHandler.createBareMetalDevice(" + blade + ")");
        MxNode serverMxNode = new MxNode();
        String srvAgentUUID = blade.getUUID();
        String srvSerialNum = blade.getBSN();
        String srvUniqueIdent = null;
        if (srvAgentUUID != null && srvAgentUUID.length() > 0) {
            srvUniqueIdent = this.getNormalisedUUID(srvAgentUUID);
            serverMxNode.setUniqueIdentifier(srvUniqueIdent);
            LOGGER.fine(" --->>> Uniqueidentifier sets to uuid =" + srvUniqueIdent);
            serverMxNode.setAgentUUID(srvAgentUUID);
            LOGGER.fine(" --->>> agentUUID sets to uuid =" + srvAgentUUID);
        } else if (srvSerialNum != null && srvSerialNum.length() > 0) {
            serverMxNode.setAgentUUID(srvSerialNum);
            LOGGER.fine(" --->>> agentUUID sets to serial number =" + srvSerialNum);
        } else {
            LOGGER.panic("  ????>>> there's no serial numbe and UUID tag specified in XML for ");
        }
        serverMxNode.setSerialNumber(srvSerialNum);
        serverMxNode.setModel(blade.getSPN());
        serverMxNode.setDeviceType(blade.getDeviceType());
        serverMxNode.setDeviceSubTypes(blade.getDeviceSubTypeList());
        serverMxNode.setSnoozeTime(-3);
        serverMxNode.setSnmpTimeOut(new Integer(GlobalSettings.getProperty((String)"NetworkTimeout", (String)"5")).intValue());
        serverMxNode.setSnmpRetry(new Integer(GlobalSettings.getProperty((String)"NetworkRetries", (String)"2")).intValue());
        serverMxNode.setIcmpTimeOut(new Integer(GlobalSettings.getProperty((String)"IcmpTimeout", (String)"5")).intValue());
        serverMxNode.setIcmpRetry(new Integer(GlobalSettings.getProperty((String)"IcmpRetries", (String)"2")).intValue());
        int defaultsMask = 255;
        serverMxNode.setDefaultsMask(true, defaultsMask);
        try {
            MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), serverMxNode);
            LOGGER.exit("IloAssociationDataHandler.createBareMetalDevice(" + blade + ")");
            return serverMxNode;
        }
        catch (MxException me) {
            LOGGER.error("IloAssociationDataHandler.createBareMetalDevice Failed");
            LOGGER.exception((Throwable)me);
            LOGGER.exit("IloAssociationDataHandler.createBareMetalDevice(" + blade + ")");
            return null;
        }
    }

    private String getBladeServerDeviceNameBySlotNumber(BladeEnclosure bladeEnclosure) {
        LOGGER.enter("IloAssociationDataHandler.getBladeServerDeviceNameBySlotNumber(" + bladeEnclosure + ")");
        StringBuffer serverDeviceName = new StringBuffer(this.getServerEnclosureName(bladeEnclosure));
        serverDeviceName.append("_");
        serverDeviceName.append(bladeEnclosure.getBlade().getSLOT());
        serverDeviceName.append("-");
        serverDeviceName.append("FRONT");
        LOGGER.exit("IloAssociationDataHandler.getBladeServerDeviceNameBySlotNumber(" + bladeEnclosure + ")");
        return serverDeviceName.toString();
    }

    private String getBladeServerDeviceNameBySerialNumber(BladeEnclosure bladeEnclosure) {
        LOGGER.enter("IloAssociationDataHandler.getBladeServerDeviceNameBySerialNumber(" + bladeEnclosure + ")");
        StringBuffer serverDeviceName = new StringBuffer(this.getServerEnclosureName(bladeEnclosure));
        serverDeviceName.append("_");
        serverDeviceName.append(bladeEnclosure.getBlade().getBSN());
        serverDeviceName.append("-");
        serverDeviceName.append("FRONT");
        LOGGER.exit("IloAssociationDataHandler.getBladeServerDeviceNameBySerialNumber(" + bladeEnclosure + ")");
        return serverDeviceName.toString();
    }

    private String getRackName(BladeEnclosure bladeEnclosure) {
        LOGGER.enter("ILOAssociationHandler.getRackName(" + bladeEnclosure + ")");
        String rackName = "";
        MxNode rackNode = this.getTheRackDevice();
        if (rackNode != null) {
            rackName = rackNode.getNameString();
        } else {
            LOGGER.error("Unable to find the rack MxNode, Device namewill be set using the rack name from ILO XML.");
        }
        if (rackName == null || rackName.trim().length() <= 0) {
            rackName = bladeEnclosure.getRackName();
        }
        LOGGER.fine("Rack Name:" + rackName);
        LOGGER.exit("ILOAssociationHandler.getRackName(" + bladeEnclosure + ")");
        return rackName;
    }

    private String getServerEnclosureName(BladeEnclosure bladeEnclosure) {
        LOGGER.enter("ILOAssociationHandler.getEnclosureName(" + bladeEnclosure + ")");
        String enclName = "";
        try {
            MxNode enclosureMxNode = bladeEnclosure.getDeviceMxNode();
            enclName = enclosureMxNode.getNameString();
        }
        catch (ILOException oaexcep) {
            LOGGER.error("Unable to find the enclosure MxNode, Device namewill be set using the enclosure name from ILO XML.");
        }
        if (enclName == null || enclName.trim().length() <= 0) {
            enclName = bladeEnclosure.getName();
        }
        LOGGER.fine("Enclosure Name:" + enclName);
        LOGGER.exit("ILOAssociationHandler.getEnclosureName(" + bladeEnclosure + ")");
        return enclName;
    }

    private void performNonBladeILOAssociations(ILODataManager iLODataManager, MxNode iLOMxNode, String ASSOCIATION_TYPE) {
        LOGGER.enter("IloAssociationDataHandler.performNonBladeILOAssociations(" + iLODataManager + "," + iLOMxNode + "," + ASSOCIATION_TYPE + ")");
        Blade blade = iLODataManager.getBlade();
        this.updateNonBladeILOData(iLOMxNode, blade.getILO());
        String DISCOVERY_ASSOCIATED_DEVICE_CHECK = GlobalSettings.getProperty((String)"iloDisc_enabled_state", (String)"checked");
        LOGGER.fine("IloAssociationDataHandler.performNonBladeILOAssociations : DISCOVERY_ASSOCIATED_DEVICE_CHECK " + DISCOVERY_ASSOCIATED_DEVICE_CHECK);
        this.buildNonBladeILOAssociation(blade, iLOMxNode, DISCOVERY_ASSOCIATED_DEVICE_CHECK, ASSOCIATION_TYPE);
        LOGGER.exit("IloAssociationDataHandler.performNonBladeILOAssociations(" + iLODataManager + "," + iLOMxNode + ")");
    }

    private void updateNonBladeILOData(MxNode iLOMxNode, ILO iLO) {
        LOGGER.enter("IloAssociationDataHandler.updateNonBladeILOData(" + iLOMxNode + "," + iLO + ")");
        this.updateILOData(iLOMxNode, iLO);
        LOGGER.exit("IloAssociationDataHandler.updateNonBladeILOData(" + iLOMxNode + "," + iLO + ")");
    }

    private void buildNonBladeILOAssociation(Blade blade, MxNode iLOMxNode, String DISCOVERY_ASSOCIATED_DEVICE_CHECK, String ASSOCIATION_TYPE) {
        LOGGER.enter("IloAssociationDataHandler.buildNonBladeILOAssociation(" + blade + "," + iLOMxNode + "," + DISCOVERY_ASSOCIATED_DEVICE_CHECK + "," + ASSOCIATION_TYPE + ")");
        MxNode serverMxNode = this.getServerMxNode(blade, DISCOVERY_ASSOCIATED_DEVICE_CHECK);
        LOGGER.fine("IloAssociationDataHandler.buildNonBladeILOAssociation serverMxNode " + serverMxNode);
        if (serverMxNode != null) {
            this.setServerName(serverMxNode, this.getNonBladeServerDeviceName(blade), this.getNonBladeServerDeviceName(blade));
            this.buildMPAssociation(iLOMxNode, serverMxNode, ASSOCIATION_TYPE);
        }
        this.storeAttributes(iLOMxNode, blade);
        LOGGER.exit("IloAssociationDataHandler.buildNonBladeILOAssociation(" + blade + "," + iLOMxNode + "," + DISCOVERY_ASSOCIATED_DEVICE_CHECK + ")");
    }

    private String getNonBladeServerDeviceName(Blade blade) {
        LOGGER.enter("IloAssociationDataHandler.getNonBladeServerDeviceName(" + blade + ")");
        StringBuffer serverDeviceName = new StringBuffer("Serv_");
        if (blade.getBSN() != null && blade.getBSN().length() > 0) {
            serverDeviceName.append(blade.getBSN());
        } else if (blade.getUUID() != null && blade.getUUID().length() > 0) {
            serverDeviceName.append(blade.getUUID());
        } else {
            LOGGER.panic("Unable to set the name of the logical server, UUID and Serial numberfrom ILO XML are either null or empty string,Node name will be not be created");
        }
        LOGGER.exit("IloAssociationDataHandler.getNonBladeServerDeviceName(" + blade + ")");
        return serverDeviceName.toString();
    }

    void performCCLASSBladeILOAssociations(ILODataManager iLODataManager, MxNode iLOMxNode, String ASSOCIATION_TYPE) throws HandlerException {
        LOGGER.enter("IloAssociationDataHandler.performCCLASSBladeILOAssociations(" + iLODataManager + "," + iLOMxNode + "," + ASSOCIATION_TYPE + ")");
        Blade blade = iLODataManager.getBlade();
        this.updateCCLASSBladeILOData(iLOMxNode, blade.getILO());
        String DISCOVERY_ASSOCIATED_DEVICE_CHECK = GlobalSettings.getProperty((String)"iloDisc_enabled_state", (String)"checked");
        LOGGER.fine("IloAssociationDataHandler.performCCLASSBladeILOAssociations : DISCOVERY_ASSOCIATED_DEVICE_CHECK " + DISCOVERY_ASSOCIATED_DEVICE_CHECK);
        this.buildCCLASSBladeILOAssociation(blade, iLOMxNode, DISCOVERY_ASSOCIATED_DEVICE_CHECK, ASSOCIATION_TYPE);
        LOGGER.exit("IloAssociationDataHandler.performCCLASSBladeILOAssociations(" + iLODataManager + "," + iLOMxNode + ")");
    }

    void updateCCLASSBladeILOData(MxNode iLOMxNode, ILO iLO) {
        LOGGER.enter("IloAssociationDataHandler.updateCCLASSBladeILOData(" + iLOMxNode + "," + iLO + ")");
        this.updateILOData(iLOMxNode, iLO);
        LOGGER.exit("IloAssociationDataHandler.updateCCLASSBladeILOData(" + iLOMxNode + "," + iLO + ")");
    }

    private void buildCCLASSBladeILOAssociation(Blade blade, MxNode iLOMxNode, String DISCOVERY_ASSOCIATED_DEVICE_CHECK, String ASSOCIATION_TYPE) {
        LOGGER.enter("IloAssociationDataHandler.buildCCLASSBladeILOAssociation(" + blade + "," + iLOMxNode + "," + DISCOVERY_ASSOCIATED_DEVICE_CHECK + "," + ASSOCIATION_TYPE + ")");
        MxNode serverMxNode = this.getServerMxNode(blade, DISCOVERY_ASSOCIATED_DEVICE_CHECK);
        LOGGER.fine("IloAssociationDataHandler.buildCCLASSBladeILOAssociation serverMxNode " + serverMxNode);
        if (serverMxNode != null) {
            this.buildMPAssociation(iLOMxNode, serverMxNode, ASSOCIATION_TYPE);
        }
        this.storeAttributes(iLOMxNode, blade);
        LOGGER.exit("IloAssociationDataHandler.buildCCLASSBladeILOAssociation(" + blade + "," + iLOMxNode + "," + DISCOVERY_ASSOCIATED_DEVICE_CHECK + ")");
    }

    @Override
    public NodeAssociations loadAssociationDataFromDb(MxNode iLOMxNode) {
        LOGGER.enter("IloAssociationDataHandler.loadAssociationDataFromDb(" + iLOMxNode + ")");
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(iLOMxNode.getDeviceKey(), true);
        if (iLOMxNode != null && iLOMxNode.getDeviceType().equals("MgmtProc")) {
            na = AssociationHandlerUtil.loadAssocFrmDB(iLOMxNode.getDeviceKey(), this.myNodeRelationshipManager);
        }
        LOGGER.exit("IloAssociationDataHandler.loadAssociationDataFromDb(" + iLOMxNode + ")");
        return na;
    }

    @Override
    public String getUIStringToDisplayInList(String associationType, String language) {
        LOGGER.enter("IloAssociationDataHandler.getUIStringToDisplayInList(" + associationType + "," + language + ")");
        LOGGER.exit("IloAssociationDataHandler.getUIStringToDisplayInList(" + associationType + "," + language + ")");
        return "";
    }

    @Override
    public boolean shouldBeInList(String associationType) {
        LOGGER.enter("IloAssociationDataHandler.shouldBeInList(" + associationType + ")");
        LOGGER.exit("IloAssociationDataHandler.shouldBeInList(" + associationType + ")");
        return true;
    }

    @Override
    public NodeAssociations buildContainerTree(NodeAssociations tempMyNodeRelationships, MxNode childMxNode, MxNode parentMxNode) {
        LOGGER.enter("IloAssociationDataHandler.buildContainerTree(" + tempMyNodeRelationships + "," + childMxNode + "," + parentMxNode + ")");
        LOGGER.fine("Child DeviceKey:" + childMxNode.getDeviceKey());
        LOGGER.fine("Parent DeviceKey:" + parentMxNode.getDeviceKey());
        LOGGER.fine("Child DeviceType:" + childMxNode.getDeviceType());
        LOGGER.fine("Parent DeviceType:" + parentMxNode.getDeviceType());
        if (childMxNode.getDeviceType().equals("Server") && parentMxNode.getDeviceType().equals("Enclosure")) {
            LOGGER.fine("Adding server to enclosure in tree");
            this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(parentMxNode.getDeviceKey()), childMxNode.getDeviceKey());
        }
        if (!parentMxNode.getDeviceType().equalsIgnoreCase("MgmtProc")) {
            tempMyNodeRelationships.setInContainer(true);
            tempMyNodeRelationships.setParent(parentMxNode.getDeviceKey());
        }
        LOGGER.exit("IloAssociationDataHandler.buildContainerTree(" + tempMyNodeRelationships + "," + childMxNode + "," + parentMxNode + ")");
        return tempMyNodeRelationships;
    }

    @Override
    public void cleanUpAssociationData(MxNode iLOMxNode) {
        LOGGER.enter("IloAssociationDataHandler.cleanUpAssociationData(" + iLOMxNode + ")");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(iLOMxNode.getDeviceKey(), "MgmtProcToServer_Ilo");
        this.myNodeRelationshipManager.resetDeviceAssociations(iLOMxNode.getDeviceKey());
        LOGGER.exit("IloAssociationDataHandler.cleanUpAssociationData(" + iLOMxNode + ")");
    }

    private ILODataManager getILODataManagerUT(MxNode iLOMxNode) throws ILOException {
        LOGGER.enter("IloAssociationDataHandler.getILODataManagerUT(" + iLOMxNode + ")");
        ILOHelper iLOHelper = ILOHelper.getILOHelper();
        ILODataManager iLODataManager = new ILODataManager(iLOHelper.getILOXML(iLOMxNode));
        LOGGER.exit("IloAssociationDataHandler.getILODataManagerUT(" + iLOMxNode + ")");
        return iLODataManager;
    }

    static {
        MxNodeController.getDefaultControllerNoEx().addListener((MxEventListener)new ILONodeDeleteHandler());
        LOGGER = new DebugSubsystem(IloAssociationDataHandler.class);
        syncObject = new Object();
    }
}

