/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.querymanager.TableModelHandler;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.List;

public class EClassSwitchHandler
extends RackEnclosureTopologyHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(EClassSwitchHandler.class);

    public EClassSwitchHandler(MxNode switchNode) {
        super(switchNode);
    }

    public void getAssociationData(MxNode switchNode, DeviceIdentificationData idInfo) {
        LOGGER.enter("EClassSwitchHandler.getAssociationData(" + switchNode + "," + idInfo + ")");
        LOGGER.fine("Node name:" + switchNode.getNameString());
        boolean isSNMPSupported = MonteroSNMPUtils.checkSNMP(switchNode);
        if (!isSNMPSupported) {
            LOGGER.exit("EClassSwitchHandler.getAssociationData(" + switchNode + "," + idInfo + ")");
            return;
        }
        if (!switchNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            LOGGER.fine("Node is not an E-Class Switch.");
            LOGGER.exit("EClassSwitchHandler.getAssociationData(" + switchNode + "," + idInfo + ")");
            return;
        }
        while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interExcep) {
                LOGGER.fine("Waiting for the lock to be released on cache,interrupted due to unexpected reasons hence exiting." + interExcep);
                LOGGER.exit("EClassSwitchHandler.getAssociationData(" + switchNode + "," + idInfo + ")");
                return;
            }
        }
        String switchSerNum = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.89.53.14.1.5.1[1]", true);
        if (switchSerNum == null || switchSerNum.trim().length() == 0) {
            LOGGER.fine("Unable to obtain the switch serial#");
            LOGGER.exit("EClassSwitchHandler.getAssociationData(" + switchNode + "," + idInfo + ")");
            return;
        }
        switchNode.setSerialNumber(switchSerNum);
        ArrayList<String> ipAddressList = AssociationHandlerUtil.getMIBData("1.3.6.1.2.1.4.20.1.1[0]", this.snmpPdh);
        for (String data : ipAddressList) {
            if (data == null || data == "") continue;
            switchNode.addIPAddress(data);
        }
        this.doSwitchToEnclAssociation(switchNode);
        NodeAssociationsManager.releaseWriteLock();
        LOGGER.exit("EClassSwitchHandler.getAssociationData(" + switchNode + "," + idInfo + ")");
    }

    private void doSwitchToEnclAssociation(MxNode switchNode) {
        LOGGER.enter("EClassSwitchhandler.doSwitchToEnclAssociation: (" + switchNode + ")");
        LOGGER.fine("Node Name:" + switchNode.getNameString());
        List switchList = AssociationHandlerUtil.getListOfNodeBySerialNumber(switchNode.getSerialNumber());
        LOGGER.fine("Switch node with same serail number :list size" + switchList.size());
        MxNode enclosureNode = null;
        for (int j = 0; j < switchList.size(); ++j) {
            MxNode switchTempNode = (MxNode)switchList.get(j);
            LOGGER.fine("switchTempNode deviceKey" + switchTempNode.getDeviceKey());
            try {
                enclosureNode = this.getAssociatedNode(switchTempNode, "SwitchToEnclosure");
            }
            catch (Exception e) {
                LOGGER.fine("Enclosure node assc with switch not found");
            }
            if (enclosureNode != null) break;
        }
        if (enclosureNode == null) {
            List enclSerLst = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty("Switch_SerNum", switchNode.getSerialNumber());
            LOGGER.fine("if the list size below is > 1 then there is something fishy !!! and if 0 then the switch is discovered before IA so no association will happen.");
            LOGGER.fine("allEnclWithSwitchSerNum.size():" + enclSerLst.size());
            for (int i = 0; i < enclSerLst.size(); ++i) {
                int enclDevKey = (Integer)enclSerLst.get(i);
                MxNode enclNode = null;
                try {
                    enclNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDevKey);
                }
                catch (MxUndefinedNodeException e) {
                    LOGGER.fine("Unable to obtain the MxNode of enclosure,following failed");
                    LOGGER.fine("1. Assocaition btw switch and enclousre.");
                    LOGGER.fine("2. The enclosure name is not set on the switch.");
                    LOGGER.fine("Will now look @ the next enclousre in the list.");
                    continue;
                }
                NodeAssociations theEnclNodeAssociations = null;
                theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(enclNode.getDeviceKey());
                if (theEnclNodeAssociations == null) {
                    LOGGER.fine("Unable to obtain the NodeAssocitions object of enclosure,following failed");
                    LOGGER.fine("1. Assocaition btw switch and enclousre.");
                    LOGGER.fine("2. The enclosure name is not set on the switch.");
                    LOGGER.fine("Will now look @ the next enclousre in the list.");
                    continue;
                }
                int switchDevKey = switchNode.getDeviceKey();
                int enclDeviceKey = theEnclNodeAssociations.getDeviceKey();
                this.myNodeRelationships.setTheAssociation(switchDevKey, enclDeviceKey, "SwitchToEnclosure", false);
                LOGGER.fine("Association done between :" + enclDeviceKey + " and " + switchDevKey + "As switchToEnclosure");
                this.myNodeRelationships.setSource("SwitchToEnclosure");
                this.addDeviceToTopologyTree(theEnclNodeAssociations, switchDevKey);
                this.myNodeRelationships.setInContainer(true);
                this.myNodeRelationships.setParent(enclDeviceKey);
                theEnclNodeAssociations.setSource("Enclosure");
                this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
                String enclName = enclNode.getNameString();
                LOGGER.fine("Enclosure name:" + enclName);
                switchNode.setEnclosureName(enclName);
                try {
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), switchNode, false);
                    continue;
                }
                catch (MxException e) {
                    LOGGER.fine("Unable to set the enclosure name on the switch." + (Object)((Object)e));
                }
            }
        }
        LOGGER.exit("EClassSwitchhandler.doSwitchToEnclAssociation: (" + switchNode + ")");
    }

    private MxNode getAssociatedNode(MxNode deviceNode, String asscType) {
        LOGGER.fine("EClassswicth:getAssociatedNode for: " + deviceNode.getNameString() + "and" + asscType);
        int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(deviceNode.getDeviceKey(), asscType);
        LOGGER.fine("associatedDeviceKey:" + associatedDeviceKey);
        MxNode associatedDevice = null;
        try {
            associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
        }
        catch (MxUndefinedNodeException ex) {
            LOGGER.fine("Asscoaited Node not found");
        }
        return associatedDevice;
    }

    public NodeAssociations loadAssociationDataFromDb(MxNode node) {
        LOGGER.enter("EClassSwitchHandler:loadAssociationDataFromDb(" + node + ")");
        LOGGER.fine("Node name:" + node.getNameString());
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(node.getDeviceKey(), true);
        if (!node.getDeviceType().equalsIgnoreCase("Switch") || !node.getDeviceSubTypes().contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            LOGGER.fine("Node is not an e-Class switch.");
            LOGGER.exit("EClassSwitchHandler.loadAssociationDataFromDb(" + node + ")");
            return na;
        }
        na = AssociationHandlerUtil.loadAssocFrmDB(node.getDeviceKey(), this.myNodeRelationshipManager);
        LOGGER.exit("EClassSwitchHandler.loadAssociationDataFromDb(" + node + ")");
        return na;
    }

    public void cleanUpAssociationData(MxNode node) {
        LOGGER.enter("EClassSwitchHandler.cleanUpAssociationData(" + node + ")");
        if (!node.getDeviceType().equalsIgnoreCase("Switch") || !node.getDeviceSubTypes().contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            LOGGER.fine("Node is not an e-Class switch.");
            LOGGER.exit("EClassSwitchHandler.cleanUpAssociationData(" + node + ")");
            return;
        }
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
        }
        catch (NodeAssociationsPersistenceException e) {
            LOGGER.fine("Failed attempt to access the repository." + (Object)((Object)e));
            LOGGER.exit("EClassSwitchHandler.cleanUpAssociationData(" + node + ")");
            return;
        }
        LOGGER.fine("Performing cleaup.");
        int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(node.getDeviceKey(), "SwitchToEnclosure");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(node.getDeviceKey(), "SwitchToEnclosure");
        this.myNodeRelationshipManager.deleteDimensionInformation(node.getDeviceKey(), "SwitchToEnclosure");
        this.myNodeRelationshipManager.resetDeviceAssociations(associatedDeviceKey);
        TableModelHandler.notifyViewTopoHasChanged();
        LOGGER.exit("EClassSwitchHandler.cleanUpAssociationData(" + node + ")");
    }
}

