/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.querymanager.TableModelHandler;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.PbleClassAssociationDataHandler;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.tree.DefaultMutableTreeNode;

public class EClassServerHandler
extends SnmpRackMibHandler {
    private static final DebugSubsystem m_logger = new DebugSubsystem(EClassServerHandler.class);

    public EClassServerHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        block11: {
            m_logger.enter("EClassServerHandler.... for device " + d.getNameString() + " And product type " + d.getDeviceType());
            m_logger.fine("device subtype is:" + d.getDeviceSubTypes());
            if (!d.getDeviceSubTypes().contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
                m_logger.fine("End:EClassServerHandler:getAssociatedData(" + d + ")");
                return;
            }
            boolean isSNMPSupported = MonteroSNMPUtils.checkSNMP(d);
            if (!isSNMPSupported) {
                m_logger.fine("End:EClassServerHandler.getAssociationData(" + d + ")");
                return;
            }
            m_logger.fine("IN The EClassServerHandler.... - Getting the new associations");
            try {
                while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                    Thread.sleep(100L);
                }
                String iASerialNumber = this.getIASerialNumberFromServerMib();
                m_logger.fine("IA Serial Number From Server MIB:" + iASerialNumber);
                if (iASerialNumber == null || iASerialNumber.trim().length() <= 0) break block11;
                int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(iASerialNumber, 12);
                if (associatedDeviceKey > 0) {
                    m_logger.fine("associatedDeviceKey (IA device)for a given serial number:" + associatedDeviceKey);
                    this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), associatedDeviceKey, "MgmtProcToServer_Ia", false);
                    MxNode associatedDevice = null;
                    try {
                        associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
                        PbleClassAssociationDataHandler pecadh = new PbleClassAssociationDataHandler(associatedDevice);
                        pecadh.snmpPdh.resetSnmpRequestSettings();
                        pecadh.getServerBladeAttributesFromTheMib(true, d.getSerialNumber());
                        this.doRackEnclosureDeviceProcessing(pecadh, d, associatedDevice);
                        this.snmpPdh.resetSnmpRequestSettings();
                    }
                    catch (MxUndefinedNodeException ex) {
                        m_logger.exception("Associated IA node not found:" + (Object)((Object)ex));
                    }
                }
                d.setSWAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), iASerialNumber);
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
            }
            catch (Exception e) {
                m_logger.exception("exception in EClassServerHandler :getAssociationData" + e);
            }
            finally {
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
                NodeAssociationsManager.releaseWriteLock();
            }
        }
        m_logger.exit("EClassServerHandler.... for device " + d.getNameString() + " And product type " + d.getDeviceType());
    }

    private String getIASerialNumberFromServerMib() {
        String theCpqSiSysSerialNo;
        block2: {
            m_logger.enter("EClassServerHandler:getIASerialNumberFromServerMib");
            theCpqSiSysSerialNo = null;
            this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.2.2.13.1.1.6[0]");
            String serialNoResponseOID = null;
            while (true) {
                this.snmpPdh.getSnmpRequest().SnmpGetNext();
                SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
                SnmpResponseVarBind vb = curResp.findById(0);
                if (vb == null || vb.isError()) break block2;
                serialNoResponseOID = vb.getOid();
                m_logger.fine("serialNoResponseOID:" + serialNoResponseOID);
                if (!serialNoResponseOID.startsWith("1.3.6.1.4.1.232.2.2.13.1.1.6.")) break;
                if (vb.getValue() != null && vb.getValue().trim().length() > 0) {
                    theCpqSiSysSerialNo = vb.getValue();
                    m_logger.fine("theCpqSiSysSerialNo:" + theCpqSiSysSerialNo);
                }
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(serialNoResponseOID, "0");
            }
            m_logger.fine("IA Serial Number OID was not correct");
        }
        m_logger.exit("EClassServerHandler:getIASerialNumberFromServerMib");
        return theCpqSiSysSerialNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        m_logger.enter("EClassServerHandler:loadAssociationDataFromDb for :" + device.getNameString());
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        int deviceDbKey = device.getDeviceKey();
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
        try {
            m_logger.fine("In Loading Device Associations for " + deviceDbKey);
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey);
            int deviceKey1 = -1;
            int deviceKey2 = -1;
            String associationTypeNumber = null;
            while (myResultSet.next()) {
                deviceKey1 = myResultSet.getInt(1);
                deviceKey2 = myResultSet.getInt(2);
                associationTypeNumber = myResultSet.getString(3).trim();
                if (device == null || !device.getDeviceType().equals("Server")) continue;
                if (associationTypeNumber.equalsIgnoreCase("ServerToEnclosure")) {
                    na.setInContainer(true);
                    na.setParent(deviceKey2);
                    na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                    continue;
                }
                if (!associationTypeNumber.equalsIgnoreCase("MgmtProcToServer_Ia")) continue;
                na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
            }
            m_logger.fine("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent());
        }
        catch (SQLException myException) {
            m_logger.exception("Failed to get the vector of devices that have associations " + myException);
        }
        finally {
            try {
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
            }
            catch (SQLException sqle) {
                m_logger.exception("failed to close sql connection:" + sqle);
            }
            catch (Exception e) {
                m_logger.exception("exception:" + e);
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        m_logger.exit("EClassServerHandler:loadAssociationDataFromDb ");
        return na;
    }

    private void doRackEnclosureDeviceProcessing(PbleClassAssociationDataHandler pecadh, MxNode serverNode, MxNode iaNode) {
        m_logger.enter("EClassServerHandler:doRackEnclosureDeviceProcessing for :" + serverNode.getNameString() + "and" + iaNode.getNameString());
        int enclDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(iaNode.getDeviceKey(), "MgmtProcToEnclosure");
        m_logger.fine("enclosure DeviceKey: " + enclDeviceKey);
        if (enclDeviceKey > 0) {
            MxNode enclosureDevice = null;
            try {
                enclosureDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDeviceKey);
            }
            catch (Exception ex) {
                m_logger.exception("EClassServerHandler:doRackEnclosureDeviceProcessing associated enclosure Node not found" + ex);
            }
            if (enclosureDevice != null) {
                this.myNodeRelationships.setSlotNumber(pecadh.getBladeSlot());
                this.myNodeRelationships.setMmHeight(pecadh.getBladeHeight());
                this.myNodeRelationships.setMmWidth(pecadh.getBladeWidth());
                this.myNodeRelationships.setMmDepth(pecadh.getBladeDepth());
                this.myNodeRelationships.setNumBladeSlotsUsed(pecadh.getBladeSlotsUsed());
                this.myNodeRelationships.setNumBladeSlotsUsedXDir(pecadh.getBladeSlotsUsedXDir());
                this.myNodeRelationships.setNumBladeSlotsUsedYDir(pecadh.getBladeSlotsUsedYDir());
                this.myNodeRelationships.setSource("ServerToEnclosure");
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
                this.makeServerToEnclosureAssociation(serverNode, enclosureDevice);
            }
        } else {
            this.checkNodeInDB(serverNode);
        }
        m_logger.exit("EClassServerHandler:doRackEnclosureDeviceProcessing");
    }

    private void makeServerToEnclosureAssociation(MxNode serverNode, MxNode enclosureNode) {
        m_logger.enter("EClassServerHandler : makeServerToEnclosureAssociation for :" + serverNode.getNameString() + "and" + enclosureNode.getNameString());
        NodeAssociations theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(enclosureNode.getDeviceKey());
        if (theEnclNodeAssociations == null) {
            theEnclNodeAssociations = new NodeAssociations(enclosureNode.getDeviceKey());
        }
        if (theEnclNodeAssociations != null) {
            int serverDeviceKey = serverNode.getDeviceKey();
            if (this.myNodeRelationships.getSlotNumber() != -1) {
                this.removeOldAssociationsFromThisSlot(serverDeviceKey, enclosureNode.getDeviceKey());
                this.myNodeRelationships.setTheAssociation(serverDeviceKey, enclosureNode.getDeviceKey(), "ServerToEnclosure", false);
                this.addDeviceToTopologyTree(theEnclNodeAssociations, serverDeviceKey);
                this.myNodeRelationships.setInContainer(true);
                this.myNodeRelationships.setParent(enclosureNode.getDeviceKey());
                this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
                serverNode.setEnclosureName(enclosureNode.getNameString());
                try {
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), serverNode, false);
                }
                catch (Exception e) {
                    m_logger.exception("EClass server:makeServerToEnclosureAssociation error in updating server:" + e);
                }
            }
        }
        m_logger.exit("EClassServerHandler : makeServerToEnclosureAssociation");
    }

    private void checkNodeInDB(MxNode d) {
        NodeAssociations dTmpNodeAssociations;
        m_logger.enter("EClassServerHandler.checkNodeInDB(" + d + ")");
        MxNode dTmp = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure");
        if (dTmp != null && (dTmpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(dTmp.getDeviceKey())) != null) {
            DefaultMutableTreeNode topologyTree = dTmpNodeAssociations.getContainerDeviceTree();
            topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
            dTmpNodeAssociations.setContainerDeviceTree(topologyTree);
            this.myNodeRelationshipManager.update(dTmpNodeAssociations);
        }
        m_logger.exit("EClassServerHandler.checkNodeInDB");
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        m_logger.enter("EClassServerHandler : buildContainerTree");
        m_logger.fine("node1.name:" + node1.getNameString());
        m_logger.fine("node1.getDeviceType:" + node1.getDeviceType());
        m_logger.fine("node2.name:" + node2.getNameString());
        m_logger.fine("node2.getDeviceType:" + node2.getDeviceType());
        if (node1.getDeviceType().equals("Server") && node2.getDeviceType().equals("Enclosure")) {
            this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
            myAssoc.setInContainer(true);
            myAssoc.setParent(node2.getDeviceKey());
        }
        m_logger.exit("EClassServerHandler.buildContainerTree()");
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        m_logger.enter("EClassServerHandler: cleanUpAssociationData");
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ia");
            int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.resetDeviceAssociations(associatedDeviceKey);
            TableModelHandler.notifyViewTopoHasChanged();
        }
        catch (NodeAssociationsPersistenceException nape) {
            m_logger.exception("EClassServerHandler:cleanUpAssociationData:" + (Object)((Object)nape));
        }
    }
}

