/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;

public class AssociationHandlerConstants {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(AssociationHandlerConstants.class);
    public static final String DUKES_M_MODEL_NAME = "McDATA 4Gb SAN Switch for HP p-Class BladeSystem";
    public static final String DUKES_B_MODEL_NAME = "Brocade 4Gb SAN Switch for HP p-Class BladeSystem";
    public static final String DUKES_ATTRIBUTE_KEY = "LOCATION";
    public static final String DUKES_ATTRIBUTE_VALUE = "RearUpperCube";
    public static final String DUKES_LOCATION = "Upper Cube";
    public static final String MGMTPROC_ENCLOSURE_ASSOCIATION_TYPE = "MgmtProcToEnclosure";
    public static final String SERVER_ENCLOSURE_ASSOCIATION_TYPE = "ServerToEnclosure";
    public static final String SWITCH_ENCLOSURE_ASSOCIATION_TYPE = "SwitchToEnclosure";
    public static final String ENCLOSURE_RACK_ASSOCIATION_TYPE = "EnclosureToRack";
    public static final String MGMTPROC_SERVER_ASSOCIATION_TYPE = "MgmtProcToServer_Ilo";
    public static final String MGMTPROC_SERVER_IA_ASSOCIATION_TYPE = "MgmtProcToServer_Ia";
    public static final String MGMTPROC_DESKTOP_IA_ASSOCIATION_TYPE = "MgmtProcToDesktop_Ia";
    public static final String MGMTPROC_SERVER_RIB_ASSOCIATION_TYPE = "MgmtProcToServer_Rib";
    public static final String MGMTPROC_SERVER_RCC_ASSOCIATION_TYPE = "MgmtProcToServer_Rcc";
    public static final String DESKTOP_ENCLOSURE_ASSOCIATION_TYPE = "DesktopToEnclosure";
    public static final String MGMTPROC_SERVER_IPF_ATN = "MgmtProcToServer_IPF";
    public static final String IPF_BLADE_SUBTYPE = "HPIntegrity";
    public static final String HYPEN = "-";
    public static final String EMPTY_STRING = "";
    public static final String TRUE_STRING = "true";
    public static final String FALSE_STRING = "false";
    public static final String UNDERSCORE = "_";
    public static final String OA_AUTOMATIC_DISCOVERY_OPTION = "obaDisc_enabled_state";
    public static final String AUTOMATIC_DISCOVERY_OPTION_CHECKED = "checked";
    public static final String AUTOMATIC_DISCOVERY_OPTION_NOT_CHECKED = "NOT";
    public static final String ILO_BARE_METAL_BLADE_NAME_START_STRING = "Serv_";
    public static final String CCI14_LEFT_POWERSUPPLY = "leftPowerSupply";
    public static final String CCI14_RIGHT_POWERSUPPLY = "rightPowerSupply";
    private static boolean m_isHPSystem = false;
    public static final String SWITCH_SERIAL_NUM_AS_CLIENT = "Switch_SerNum";
    public static final int ENCL_UUID_LENGTH_MIN = 10;
    public static final String PRODID_SERVENCL_COOL = "0x0007";
    public static final String PRODID_SERVENCL_ICE = "0x0002";
    public static final String PRODID_PWRENCL_ONEU = "0x0005";
    public static final String PRODID_PWRENCL_THREEU = "0x0003";
    public static final String SERVERENCL = "Server Enclosure";
    public static final String POWERENCL = "Power Enclosure";
    public static final String PRODID_SERVENCL = "7";
    public static final String RACK = "Rack";
    public static final String LEFT_SERNO_ATTR = "compaq.devices.LeftSWSerialNo";
    public static final String RIGHT_SERNO_ATTR = "compaq.devices.RightSWSerialNo";
    public static final String SWITCH_HP_SERNO_ATTR = "compaq.devices.SwitchHPSerialNo";
    public static final String ILO_AUTOMATIC_DISCOVERY_OPTION = "iloDisc_enabled_state";
    public static final String FRONT = "FRONT";
    public static final String OA_SOURCE = "OA";
    public static final String DCRACKUUID = "dCRackUUID";
    public static final String TOP_ENCL_NAME = "topEnclosureName";
    public static final String BOTTOM_ENCL_NAME = "bottomEnclosureName";
    public static final String ORDER = "Order";
    public static final String ILO_IPF_MODNAME_IDEN_HTTP = "integrated lights-out (ilo) for integrity and hp9000";
    public static final String ILO_IPF_MODNAME_IDEN_SNMP = "hp single partition server, management processor";

    static boolean isHPSystem() {
        return false;
    }

    public static void setILOAsscociatedAttributes(MxNode serverMxNode, MxNode iLOMxNode) {
        LOGGER.enter("AssociationHandlerConstants.setILO2AsscociatedAttributes(" + serverMxNode + "," + iLOMxNode + ")");
        if (iLOMxNode == null || serverMxNode == null) {
            LOGGER.fine("Client attributes are not set.");
            LOGGER.exit("AssociationHandlerConstants.setILO2AsscociatedAttributes(" + serverMxNode + "," + iLOMxNode + ")");
            return;
        }
        if (serverMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.BLADE_SUBTYPE.toString())) {
            if (iLOMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ILO2_SUBTYPE.toString())) {
                serverMxNode.setClientAttribute("ILOTypeAssociated", NodeSubTypeMapper.ILO2_SUBTYPE.toString());
            } else if (iLOMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ILO_SUBTYPE.toString())) {
                serverMxNode.setClientAttribute("ILOTypeAssociated", NodeSubTypeMapper.ILO_SUBTYPE.toString());
            }
            serverMxNode.setClientAttribute("iloDeviceKey", String.valueOf(iLOMxNode.getDeviceKey()));
            try {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), serverMxNode, false);
                LOGGER.fine("Client attributes set");
            }
            catch (MxException e) {
                LOGGER.fine("Client attributes are not set, Exception:" + (Object)((Object)e));
            }
        }
        LOGGER.exit("AssociationHandlerConstants.setILO2AsscociatedAttributes(" + serverMxNode + "," + iLOMxNode + ")");
    }

    static {
        String OS_NAME = System.getProperty("os.name").toUpperCase();
        LOGGER.fine("AssociationHandlerConstants.OS_NAME " + OS_NAME);
        if (OS_NAME.startsWith("HP-UX")) {
            m_isHPSystem = true;
        }
        LOGGER.fine("AssociationHandlerConstants.m_isHPSystem " + m_isHPSystem);
    }
}

