/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.soap.oa;

import com.hp.mx.core.tools.datacollection.soap.oa.OACommunicationIntf;
import com.hp.mx.core.tools.datacollection.soap.oa.OAFileHandler;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class SOAPCustomHandler
implements OACommunicationIntf {
    URL url;
    HttpsURLConnection httpConn;
    FileInputStream fin;
    ByteArrayOutputStream bout;
    OutputStream out;
    InputStreamReader isr;
    BufferedReader in;
    String key;
    String soapXmlRequest;
    String respData;
    StringBuffer soapXMLHeader;
    String errorMsg;
    String configScriptURL;
    String guid;
    OAFileHandler fileHandler = new OAFileHandler();
    private static final DebugSubsystem LOGGER = new DebugSubsystem(SOAPCustomHandler.class);

    public SOAPCustomHandler() {
        LOGGER.fine("**********SOAPCustomHandler()***********");
    }

    private void setConnProperties(byte[] soapReq) throws IOException, ProtocolException {
        LOGGER.enter("********SOAPCustomHandler.setConnProperties()**********");
        this.httpConn = (HttpsURLConnection)this.url.openConnection();
        this.httpConn.setRequestMethod("POST");
        this.httpConn.setRequestProperty("Content-Type", "application/soap+xml; charset=UTF-8");
        this.httpConn.setRequestProperty("Accept", "application/soap+xml, application/dime, multipart/related, text/*");
        this.httpConn.setRequestProperty("Cache-Control", "no-cache");
        this.httpConn.setRequestProperty("Pragma", "no-cache");
        this.httpConn.setRequestProperty("Content-Length", String.valueOf(soapReq.length));
        this.httpConn.setRequestProperty("SOAPAction", "\"\"");
        this.httpConn.setRequestProperty("User-Agent", "Axis/1.1");
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        LOGGER.exit("********SOAPCustomHandler.setConnProperties()**********");
    }

    public void setURL(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public void setSessionKey(String key) {
        this.key = key;
    }

    public void setConfigScriptURLForRestore(String configScripturl) {
        this.configScriptURL = configScripturl;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String loginOA(String url, String userName, String pwd) throws MalformedURLException, IOException {
        LOGGER.enter("********SOAPCustomHandler.loginOA(" + url + ", " + userName + " ," + pwd + ")**********");
        if (userName == null || pwd == null) {
            this.errorMsg = "Invalid User Name and/or Password.";
            return "-1";
        }
        this.url = new URL(url);
        String soapLogin = "<?xml version='1.0' encoding='UTF-8'?><soapenv:Envelope xmlns:soapenv='http://www.w3.org/2003/05/soap-envelope' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'> <soapenv:Body>  <userLogIn xmlns='hpoa.xsd'>   <username>" + userName + "</username>   <password>" + pwd + "</password>  </userLogIn> </soapenv:Body></soapenv:Envelope>";
        this.errorMsg = "Sign in failure";
        byte[] b = soapLogin.getBytes();
        this.respData = this.sendSoapRequest(b);
        if (this.respData.indexOf("oaSessionKey") > -1) {
            this.key = this.respData.substring(this.respData.indexOf("oaSessionKey>") + "oaSessionKey>".length(), this.respData.indexOf("</hpoa:oaSessionKey>"));
            return this.key;
        }
        this.in.close();
        this.httpConn.disconnect();
        LOGGER.exit("********SOAPCustomHandler.loginOA(" + url + ", " + userName + " ," + pwd + ")**********");
        return "-1";
    }

    public void restoreConfiguration() throws IOException {
        LOGGER.enter("********SOAPCustomHandler.restoreConfiguration()****************");
        String urlStr = this.configScriptURL + "/bladeime/OAConfig/" + "tmpCfg";
        LOGGER.fine("restore url is " + urlStr);
        StringBuffer xmlConfig = new StringBuffer("<soapenv:Body><downloadConfigScript xmlns=\"hpoa.xsd\"><url>" + urlStr + "</url></downloadConfigScript></soapenv:Body></soapenv:Envelope>");
        this.soapXMLHeader = this.getSoapXMLHeader();
        this.soapXmlRequest = this.soapXMLHeader.append(xmlConfig).toString();
        this.respData = this.sendSoapRequest(this.soapXmlRequest.toString().getBytes());
        LOGGER.exit("********SOAPCustomHandler.restoreConfiguration()****************");
    }

    public void saveConfigurationScript(String fileName) throws IOException {
        LOGGER.enter("********SOAPCustomHandler.saveConfigurationScript(" + fileName + ")****************");
        StringBuffer xmlConfig = new StringBuffer("<soapenv:Body><getConfigScript xmlns=\"hpoa.xsd\"/></soapenv:Body></soapenv:Envelope>");
        this.soapXMLHeader = this.getSoapXMLHeader();
        this.soapXmlRequest = this.soapXMLHeader.append(xmlConfig).toString();
        this.respData = this.sendSoapRequest(this.soapXmlRequest.toString().getBytes());
        this.respData = this.respData.substring(this.respData.indexOf("hpoa:configScript>") + "hpoa:configScript>".length(), this.respData.indexOf("</hpoa:configScript>"));
        this.respData = this.respData.replaceAll("&#xA;", "\r\n");
        this.fileHandler.saveFile(this.guid, fileName, this.respData);
        LOGGER.exit("********SOAPCustomHandler.saveConfigurationScript(" + fileName + ")****************");
    }

    public boolean isCurrentUserOAAdministrator() throws IOException {
        LOGGER.enter("********SOAPCustomHandler.isCurrentUserOAAdministrator()****************");
        StringBuffer xmlConfig = new StringBuffer("<soapenv:Body><getCurrentUserInfo xmlns=\"hpoa.xsd\"/></soapenv:Body></soapenv:Envelope>");
        this.soapXMLHeader = this.getSoapXMLHeader();
        this.soapXmlRequest = this.soapXMLHeader.append(xmlConfig).toString();
        this.respData = this.sendSoapRequest(this.soapXmlRequest.toString().getBytes());
        String userAcl = this.respData.substring(this.respData.indexOf("hpoa:acl>") + "hpoa:acl>".length(), this.respData.indexOf("</hpoa:acl>"));
        String oaBaysAccess = this.respData.substring(this.respData.indexOf("hpoa:oaAccess>") + "hpoa:oaAccess>".length(), this.respData.indexOf("</hpoa:oaAccess>"));
        LOGGER.fine("user ACL is " + userAcl + " and access to OA bays is " + oaBaysAccess);
        if (userAcl.trim().equalsIgnoreCase("ADMINISTRATOR") && oaBaysAccess.trim().equalsIgnoreCase("true")) {
            return true;
        }
        LOGGER.exit("********SOAPCustomHandler.isCurrentUserOAAdministrator()****************");
        return false;
    }

    public StringBuffer getSoapXMLHeader() {
        LOGGER.enter("********SOAPCustomHandler.getSoapXMLHeader()**********");
        StringBuffer soapXml = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Header><wsse:Security soapenv:role=\"http://schemas.xmlsoap.org/soap/actor/next\" soapenv:mustUnderstand=\"true\" xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"><hpoa:HpOaSessionKeyToken ns1:actor=\"http://schemas.xmlsoap.org/soap/actor/next\" ns1:mustUnderstand=\"false\" xmlns:hpoa=\"hpoa.xsd\" xmlns:ns1=\"http://schemas.xmlsoap.org/soap/envelope/\"><hpoa:oaSessionKey ns1:actor=\"http://schemas.xmlsoap.org/soap/actor/next\" ns1:mustUnderstand=\"false\">");
        soapXml.append(this.key);
        soapXml.append("</hpoa:oaSessionKey></hpoa:HpOaSessionKeyToken></wsse:Security></soapenv:Header>");
        LOGGER.exit("********SOAPCustomHandler.getSoapXMLHeader()**********");
        return soapXml;
    }

    public String sendSoapRequest(byte[] soapReq) throws IOException {
        String line;
        LOGGER.enter("********SOAPCustomHandler.sendSoapRequest(" + soapReq.toString() + ")**********");
        this.setConnProperties(soapReq);
        this.out = this.httpConn.getOutputStream();
        this.out.write(soapReq);
        this.out.close();
        this.isr = new InputStreamReader(this.httpConn.getInputStream());
        this.in = new BufferedReader(this.isr);
        StringBuffer respData = new StringBuffer();
        while ((line = this.in.readLine()) != null) {
            respData.append(line);
        }
        LOGGER.fine("Response data from OA is " + respData.toString());
        LOGGER.exit("********SOAPCustomHandler.sendSoapRequest()**********");
        return respData.toString();
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getSessionKey() {
        return this.key;
    }
}

