/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.oa;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.datacollection.http.DCException;
import com.hp.mx.core.tools.datacollection.http.DCUtil;
import com.hp.mx.core.tools.datacollection.http.Invoker;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BAYINFOType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BAYOCCUPANTType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.ENCLMGRType;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.List;

public class OnboardAdministrator
extends OLDevice {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(OnboardAdministrator.class);
    private String role = "";
    private String fwri = "";
    private final String[] OACLIENTATTRIBUTES = new String[]{"OA_ROLE", "OA_FWRI"};

    public OnboardAdministrator(MxNode initFromMxNode, String deviceUniqueIdentifier) {
        super(initFromMxNode, deviceUniqueIdentifier);
        LOGGER.enter("OnboardAdministrator(" + initFromMxNode + "," + this.uniqueIdentifier + ")");
        this.role = initFromMxNode.getClientAttribute(this.OACLIENTATTRIBUTES[0]);
        this.fwri = initFromMxNode.getClientAttribute(this.OACLIENTATTRIBUTES[1]);
        this.print("OnboardAdministrator DB");
        LOGGER.exit("OnboardAdministrator(" + initFromMxNode + "," + this.uniqueIdentifier + ")");
    }

    public OnboardAdministrator(ENCLMGRType enclMgrType, BAYINFOType bayInfoType) {
        LOGGER.enter("OnboardAdministrator(" + enclMgrType + "," + bayInfoType + ")");
        Invoker.init("initializeINFRA2", enclMgrType.getContent(), OnboardAdministrator.class, this);
        this.calculateDirection(2);
        this.height = bayInfoType.getMmHeight().intValue() * this.slotsUsedInYDirection;
        this.width = bayInfoType.getMmWidth().intValue() * this.slotsUsedInXDirection;
        this.depth = bayInfoType.getMmDepth().intValue();
        this.side = DCUtil.trimAttribute(bayInfoType.getSIDE());
        this.initUniqueIdentifier();
        this.print("OnboardAdministrator JAXB");
        LOGGER.exit("OnboardAdministrator(" + enclMgrType + "," + bayInfoType + ")");
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_BAYImpl(Object element) {
        LOGGER.enter("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_BAYImpl(" + element + ")");
        BAYOCCUPANTType bayOCCUPANTType = (BAYOCCUPANTType)element;
        this.connection = DCUtil.getIntValue(bayOCCUPANTType.getCONNECTION());
        this.occupiesList = bayOCCUPANTType.getOCCUPIES();
        LOGGER.exit("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_BAYImpl(" + element + ")");
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_MGMTIPADDRImpl(Object element) {
        LOGGER.enter("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_MGMTIPADDRImpl(" + element + ")");
        this.mgmtIPAddress = DCUtil.trimAttribute(((ENCLMGRType.MGMTIPADDR)element).getValue());
        LOGGER.exit("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_MGMTIPADDRImpl(" + element + ")");
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_SPNImpl(Object element) {
        LOGGER.enter("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_SPNImpl(" + element + ")");
        this.spn = DCUtil.trimAttribute(((ENCLMGRType.SPN)element).getValue());
        LOGGER.exit("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_SPNImpl(" + element + ")");
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_BSNImpl(Object element) {
        LOGGER.enter("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_BSNImpl(" + element + ")");
        this.bsn = DCUtil.trimAttribute(((ENCLMGRType.BSN)element).getValue());
        LOGGER.exit("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_BSNImpl(" + element + ")");
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_STATUSImpl(Object element) {
        LOGGER.enter("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_STATUSImpl(" + element + ")");
        this.status = DCUtil.trimAttribute(((ENCLMGRType.STATUS)element).getValue());
        LOGGER.exit("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_STATUSImpl(" + element + ")");
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_UUIDImpl(Object element) {
        LOGGER.enter("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_UUIDImpl(" + element + ")");
        this.uuid = DCUtil.trimAttribute(((ENCLMGRType.UUID)element).getValue());
        LOGGER.exit("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_UUIDImpl(" + element + ")");
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_ROLEImpl(Object element) {
        LOGGER.enter("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_ROLEImpl(" + element + ")");
        this.role = DCUtil.trimAttribute(((ENCLMGRType.ROLE)element).getValue());
        LOGGER.exit("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_ROLEImpl(" + element + ")");
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_FWRIImpl(Object element) {
        LOGGER.enter("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_FWRIImpl(" + element + ")");
        this.fwri = DCUtil.trimAttribute(((ENCLMGRType.FWRI)element).getValue());
        LOGGER.exit("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_FWRIImpl(" + element + ")");
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_TEMPSImpl(Object element) {
        LOGGER.enter("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_TEMPSImpl(" + element + ")");
        this.deviceTempsType.init(((ENCLMGRType.TEMPSType)element).getContent());
        LOGGER.exit("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_TEMPSImpl(" + element + ")");
    }

    public void initializeINFRA2_ENCLMGRTypeImpl_FANSImpl(Object element) {
        LOGGER.enter("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_FANSImpl(" + element + ")");
        ENCLMGRType.FANSType fansType = (ENCLMGRType.FANSType)element;
        this.deviceFansType.init(fansType.getFAN(), fansType.getREDUNDANCY());
        LOGGER.exit("OnboardAdministrator.initializeINFRA2_ENCLMGRTypeImpl_FANSImpl(" + element + ")");
    }

    protected void updateDataOnDevice(MxNode deviceMxNode) {
        super.updateDataOnDevice(deviceMxNode);
        LOGGER.enter("OnboardAdministrator.updateDataOnDevice(" + deviceMxNode + ")");
        deviceMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[0], this.role);
        deviceMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[1], this.fwri);
        LOGGER.exit("OnboardAdministrator.updateDataOnDevice(" + deviceMxNode + ")");
    }

    public void update(MxNode deviceMxNode, MxNode enclosureMxNode) {
        LOGGER.enter("OnboardAdministrator.update(" + deviceMxNode + "," + enclosureMxNode + ")");
        if (deviceMxNode != null) {
            try {
                LOGGER.fine("OnboardAdministrator.update.Cleaning device data from itself uniqueIdentifier" + this.uniqueIdentifier);
                OAHelper.getOAHelper().getOLDevice(deviceMxNode, deviceMxNode).cleanDataFromDevice(deviceMxNode);
                LOGGER.fine("OnboardAdministrator.update.Cleaning done from OnboardAdministrator uniqueIdentifier " + this.uniqueIdentifier);
            }
            catch (OAException e) {
                LOGGER.error("OnboardAdministrator.update.Unable to find old OLDevice. Cleanup failed uniqueIdentifier " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("OnboardAdministrator.update.Exception " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
            try {
                LOGGER.fine("OnboardAdministrator.update.updating device data on itself " + this.uniqueIdentifier);
                this.updateDataOnDevice(deviceMxNode);
            }
            catch (Exception e) {
                LOGGER.error("OnboardAdministrator.update.Exception " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
            DCUtil.commit(deviceMxNode);
        }
        LOGGER.exit("OnboardAdministrator.update(" + deviceMxNode + "," + enclosureMxNode + ")");
    }

    protected void cleanDataFromDevice(MxNode deviceMxNode) {
        super.cleanDataFromDevice(deviceMxNode);
        for (String propertyName : this.OACLIENTATTRIBUTES) {
            deviceMxNode.removeClientAttribute(propertyName);
        }
        LOGGER.exit("OnboardAdministrator.cleanDataFromDevice(" + deviceMxNode + ")");
    }

    public String getDeviceType() {
        return "MgmtProc";
    }

    public List getSubTypeList() {
        ArrayList<String> subTypeList = new ArrayList<String>();
        subTypeList.add(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString());
        subTypeList.add(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
        subTypeList.add("HPProLiant");
        return subTypeList;
    }

    public boolean getIsPrimary() {
        return this.role != null && this.role.equalsIgnoreCase("ACTIVE");
    }

    public String getRole() {
        return this.role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsPrimary(MxNode deviceMxNode, boolean primary) {
        LOGGER.enter("OnboardAdministrator.setIsPrimary(" + deviceMxNode + "," + primary + ")");
        MxNode mxNode = deviceMxNode;
        synchronized (mxNode) {
            if (primary) {
                deviceMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[0], "ACTIVE");
                this.role = "ACTIVE";
            } else {
                deviceMxNode.setClientAttribute(this.OACLIENTATTRIBUTES[0], "STANDBY");
                this.role = "STANDBY";
            }
            DCUtil.commit(deviceMxNode);
        }
        LOGGER.exit("OnboardAdministrator.setIsPrimary(" + deviceMxNode + "," + primary + ")");
    }

    public String getFWRI() {
        return this.fwri;
    }

    public MxNode getDeviceMxNode() {
        LOGGER.enter("OnboardAdministrator.getDeviceMxNode()");
        MxNode deviceMxNode = null;
        if (this.uuid != null || this.uuid.trim().length() > 0) {
            try {
                deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(this.uuid);
            }
            catch (MxException e) {
                LOGGER.fine("OnboardAdministrator.getDeviceMxNode.Unable to find OA MxNode having uuid " + this.uuid);
            }
        }
        if (deviceMxNode == null) {
            try {
                deviceMxNode = DCUtil.getNodeBySerialNumber(this.bsn);
            }
            catch (DCException de) {
                LOGGER.fine("OnboardAdministrator.getDeviceMxNode.Unable to find OA MxNode having serial number " + this.bsn);
            }
        }
        LOGGER.exit("OnboardAdministrator.getDeviceMxNode()");
        return deviceMxNode;
    }

    protected void print(String SOURCE) {
        super.print(SOURCE);
        LOGGER.enter("*********OnboardAdministrator.print(" + SOURCE + ")**************");
        LOGGER.fine("OnboardAdministrator.role " + this.role);
        LOGGER.fine("OnboardAdministrator.fwri " + this.fwri);
        LOGGER.exit("*********OnboardAdministrator.print(" + SOURCE + ")**************");
    }
}

