/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.oa;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.datacollection.http.DCException;
import com.hp.mx.core.tools.datacollection.http.DCUtil;
import com.hp.mx.core.tools.datacollection.http.Invoker;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.core.tools.datacollection.http.oa.OLSwitchPortMap;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BAYINFOType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BAYOCCUPANTType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.SWITCHPortMap;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.SWITCHType;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.List;

public class OLSwitch
extends OLDevice {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(OLSwitch.class);
    private String mgmtURL = "";
    private String fabricType = "";
    private String fault = "";
    private OLSwitchPortMap olSwitchPortMap = new OLSwitchPortMap();

    public OLSwitch(MxNode initFromMxNode, String deviceUniqueIdentifier) {
        super(initFromMxNode, deviceUniqueIdentifier);
        this.print("OLSwitch DB");
        LOGGER.exit("OLSwitch(" + initFromMxNode + "," + this.uniqueIdentifier + ")");
    }

    public OLSwitch(SWITCHType switchType, BAYINFOType bayInfoType) {
        LOGGER.enter("OLSwitch(" + switchType + "," + bayInfoType + ")");
        Invoker.init("initializeINFRA2", switchType.getContent(), OLSwitch.class, this);
        this.calculateDirection(2);
        this.height = bayInfoType.getMmHeight().intValue() * this.slotsUsedInYDirection;
        this.width = bayInfoType.getMmWidth().intValue() * this.slotsUsedInXDirection;
        this.depth = bayInfoType.getMmDepth().intValue();
        this.side = DCUtil.trimAttribute(bayInfoType.getSIDE());
        this.initUniqueIdentifier();
        this.print("OLSwitch JAXB");
        LOGGER.exit("OLSwitch(" + switchType + "," + bayInfoType + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_BAYImpl(Object element) {
        LOGGER.enter("OLSwitch.initializeINFRA2_SWITCHTypeImpl_BAYImpl(" + element + ")");
        BAYOCCUPANTType bayOCCUPANTType = (BAYOCCUPANTType)element;
        this.connection = DCUtil.getIntValue(bayOCCUPANTType.getCONNECTION());
        this.occupiesList = bayOCCUPANTType.getOCCUPIES();
        LOGGER.exit("OLSwitch.initializeINFRA2_SWITCHTypeImpl_BAYImpl(" + element + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_MGMTIPADDRImpl(Object element) {
        LOGGER.enter("OLSwitch.initializeINFRA2_SWITCHTypeImpl_MGMTIPADDRImpl(" + element + ")");
        this.mgmtIPAddress = DCUtil.trimAttribute(((SWITCHType.MGMTIPADDR)element).getValue());
        LOGGER.exit("OLSwitch.initializeINFRA2_SWITCHTypeImpl_MGMTIPADDRImpl(" + element + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_SPNImpl(Object element) {
        LOGGER.enter("OLSwitch.initializeINFRA2_SWITCHTypeImpl_SPNImpl(" + element + ")");
        this.spn = DCUtil.trimAttribute(((SWITCHType.SPN)element).getValue());
        LOGGER.exit("OLSwitch.initializeINFRA2_SWITCHTypeImpl_SPNImpl(" + element + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_BSNImpl(Object element) {
        LOGGER.enter("OLSwitch.initializeINFRA2_SWITCHTypeImpl_BSNImpl(" + element + ")");
        this.bsn = DCUtil.trimAttribute(((SWITCHType.BSN)element).getValue());
        LOGGER.exit("OLSwitch.initializeINFRA2_SWITCHTypeImpl_BSNImpl(" + element + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_STATUSImpl(Object element) {
        LOGGER.enter("OLSwitch.initializeINFRA2_SWITCHTypeImpl_STATUSImpl(" + element + ")");
        this.status = DCUtil.trimAttribute(((SWITCHType.STATUS)element).getValue());
        LOGGER.exit("OLSwitch.initializeINFRA2_SWITCHTypeImpl_STATUSImpl(" + element + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_UUIDImpl(Object element) {
        LOGGER.enter("OLSwitch.initializeINFRA2_SWITCHTypeImpl_UUIDImpl(" + element + ")");
        this.uuid = DCUtil.trimAttribute(((SWITCHType.UUID)element).getValue());
        LOGGER.exit("OLSwitch.initializeINFRA2_SWITCHTypeImpl_UUIDImpl(" + element + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_MGMTURLImpl(Object element) {
        LOGGER.enter("OLSwitch.initializeINFRA2_SWITCHTypeImpl_MGMTURLImpl(" + element + ")");
        this.mgmtURL = DCUtil.trimAttribute(((SWITCHType.MGMTURL)element).getValue());
        LOGGER.exit("OLSwitch.initializeINFRA2_SWITCHTypeImpl_MGMTURLImpl(" + element + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_FABRICTYPEImpl(Object element) {
        LOGGER.enter("OLSwitch.initializeINFRA2_SWITCHTypeImpl_FABRICTYPEImpl(" + element + ")");
        this.fabricType = DCUtil.trimAttribute(((SWITCHType.FABRICTYPE)element).getValue());
        LOGGER.exit("OLSwitch.initializeINFRA2_SWITCHTypeImpl_FABRICTYPEImpl(" + element + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_FAULTImpl(Object element) {
        LOGGER.enter("OLSwitch.initializeINFRA2_SWITCHTypeImpl_FAULTImpl(" + element + ")");
        this.fault = DCUtil.trimAttribute(((SWITCHType.FAULT)element).getValue());
        LOGGER.exit("OLSwitch.initializeINFRA2_SWITCHTypeImpl_FAULTImpl(" + element + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_TEMPSImpl(Object element) {
        LOGGER.enter("OLSwitch.initializeINFRA2_SWITCHTypeImpl_TEMPSImpl(" + element + ")");
        this.deviceTempsType.init(((SWITCHType.TEMPSType)element).getContent());
        LOGGER.exit("OLSwitch.initializeINFRA2_SWITCHTypeImpl_TEMPSImpl(" + element + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_FANSImpl(Object element) {
        LOGGER.enter("OLSwitch.initializeINFRA2_SWITCHTypeImpl_FANSImpl(" + element + ")");
        SWITCHType.FANSType fansType = (SWITCHType.FANSType)element;
        this.deviceFansType.init(fansType.getFAN(), fansType.getREDUNDANCY());
        LOGGER.exit("OLSwitch.initializeINFRA2_SWITCHTypeImpl_FANSImpl(" + element + ")");
    }

    public void initializeINFRA2_SWITCHTypeImpl_PORTMAPImpl(Object element) {
        LOGGER.enter("OLBlade.initializeINFRA2_SWITCHTypeImpl_PORTMAPImpl(" + element + ")");
        this.olSwitchPortMap.init((SWITCHPortMap)element);
        LOGGER.exit("OLBlade.initializeINFRA2_SWITCHTypeImpl_PORTMAPImpl(" + element + ")");
    }

    public void update(MxNode deviceMxNode, MxNode enclosureMxNode) {
        LOGGER.enter("OLSwitch.update(" + deviceMxNode + "," + enclosureMxNode + ")");
        if (deviceMxNode != null) {
            try {
                LOGGER.fine("OLSwitch.update.Cleaning device data from OLSwitch uniqueIdentifier " + this.uniqueIdentifier);
                OAHelper.getOAHelper().getOLDevice(deviceMxNode, deviceMxNode).cleanDataFromDevice(deviceMxNode);
                LOGGER.fine("OLSwitch.update.Cleaning done from OLSwitch uniqueIdentifier " + this.uniqueIdentifier);
            }
            catch (OAException e) {
                LOGGER.error("OLSwitch.update.Unable to find old OLDevice. Cleanup failed uniqueIdentifier " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("OLSwitch.update.Exception " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
            try {
                LOGGER.fine("OLSwitch.update.updating device data on itself " + this.uniqueIdentifier);
                this.updateDataOnDevice(deviceMxNode);
            }
            catch (Exception e) {
                LOGGER.error("OLSwitch.update.Exception " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
        }
        if (enclosureMxNode != null) {
            try {
                LOGGER.fine("OLSwitch.update.Cleaning device data from enclosure uniqueIdentifier " + this.uniqueIdentifier);
                this.cleanDataFromEnclosure(enclosureMxNode);
            }
            catch (Exception e) {
                LOGGER.error("OLSwitch.update.Exception " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
            try {
                LOGGER.fine("OLSwitch.update.updating device data on enclosure node " + this.uniqueIdentifier);
                this.updateDataOnEnclosure(enclosureMxNode);
            }
            catch (Exception e) {
                LOGGER.error("OLSwitch.update.Exception " + this.uniqueIdentifier);
                LOGGER.exception((Throwable)e);
            }
            DCUtil.commit(enclosureMxNode);
        }
        LOGGER.exit("OLSwitch.update(" + deviceMxNode + "," + enclosureMxNode + ")");
    }

    public List getSubTypeList() {
        ArrayList<String> subTypeList = new ArrayList<String>();
        subTypeList.add(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
        return subTypeList;
    }

    public String getDeviceMgmtURL() {
        return this.mgmtURL;
    }

    public String getDeviceFabricType() {
        return this.fabricType;
    }

    public String getDeviceFault() {
        return this.fault;
    }

    public String getDeviceType() {
        return "Switch";
    }

    public OLSwitchPortMap getOLSwitchPortMap() {
        return this.olSwitchPortMap;
    }

    public MxNode getDeviceMxNode() {
        LOGGER.enter("OLSwitch.getDeviceMxNode()");
        MxNode deviceMxNode = null;
        if (this.uuid != null && this.uuid.trim().length() > 0) {
            try {
                deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(this.uuid);
            }
            catch (MxException e) {
                LOGGER.fine("OLSwitch.getDeviceMxNode.MxException Unable to find Switch MxNode by uuid " + (Object)((Object)e));
            }
        }
        if (deviceMxNode == null) {
            try {
                deviceMxNode = DCUtil.getNodeBySerialNumber(this.bsn);
            }
            catch (DCException de) {
                LOGGER.fine("OLSwitch.getDeviceMxNode.DCException Unable to find Switch MxNode by bsn: " + de);
            }
        }
        LOGGER.exit("OLSwitch.getDeviceMxNode()");
        return deviceMxNode;
    }

    protected void print(String SOURCE) {
        super.print(SOURCE);
        LOGGER.enter("*********OLSwitch.print(" + SOURCE + ")**************");
        LOGGER.fine("OLSwitch.mgmtURL " + this.mgmtURL);
        LOGGER.fine("OLSwitch.fabricType " + this.fabricType);
        LOGGER.fine("OLSwitch.fault " + this.fault);
        LOGGER.exit("*********OLSwitch.print(" + SOURCE + ")**************");
    }
}

