/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.oa;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class DeviceManager {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(DeviceManager.class);
    private Properties m_deviceClasses = null;
    private static DeviceManager deviceManager = null;

    private DeviceManager() {
    }

    public static DeviceManager getDeviceManager() {
        if (deviceManager == null) {
            deviceManager = new DeviceManager();
        }
        return deviceManager;
    }

    public OLDevice getOLDevice(MxNode deviceMxNode, MxNode initFromMxNode) throws OAException {
        LOGGER.enter("DeviceManager.getOLDevice(" + deviceMxNode + "," + initFromMxNode + ")");
        LOGGER.fine("DeviceManager.getOLDevice.m_deviceClasses " + this.m_deviceClasses);
        this.loadProperty();
        OLDevice olDevice = null;
        try {
            olDevice = (OLDevice)this.getDevice(deviceMxNode, initFromMxNode);
        }
        catch (ClassCastException e) {
            LOGGER.error("DeviceManager.getOLDevice Unable to get OL Device object " + e);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getOLDevice(" + deviceMxNode + "," + initFromMxNode + ")");
            throw new OAException(e, "DeviceManager.getOLDevice Unable to get OL Device object " + e);
        }
        LOGGER.exit("DeviceManager.getOLDevice(" + deviceMxNode + "," + initFromMxNode + ")");
        return olDevice;
    }

    private void loadProperty() throws OAException {
        LOGGER.enter("DeviceManager.loadProperty()");
        if (this.m_deviceClasses == null) {
            this.m_deviceClasses = new Properties();
            try {
                this.m_deviceClasses.load(this.getClass().getResourceAsStream("device.properties"));
            }
            catch (IOException e) {
                LOGGER.error("DeviceManager.loadProperty.IOException Unable to load the device.properties file " + e);
                LOGGER.exception((Throwable)e);
                LOGGER.exit("DeviceManager.loadProperty()");
                throw new OAException(e, "DeviceManager.loadProperty.IOException Unable to load the device.properties file " + e);
            }
        }
        LOGGER.exit("DeviceManager.loadProperty()");
    }

    private Object getDevice(MxNode deviceMxNode, MxNode initFromMxNode) throws OAException {
        LOGGER.enter("DeviceManager.getDevice(" + deviceMxNode + "," + initFromMxNode + ")");
        String deviceType = deviceMxNode.getDeviceType();
        LOGGER.fine("DeviceManager.getDevice.deviceType " + deviceType);
        String className = (String)this.m_deviceClasses.get(deviceType);
        LOGGER.fine("DeviceManager.getDevice.className " + className);
        if (className == null) {
            LOGGER.fine("Unable to find class name for device type. DeviceManager.getDevice class name" + className);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + initFromMxNode + ")");
            throw new OAException("Unable to find class name for device type " + deviceType);
        }
        String uniqueIdentifier = this.getUniqueIdentifier(deviceMxNode);
        LOGGER.fine("Data is stored on " + initFromMxNode.getNameString() + "using: uniqueIdentifier:" + uniqueIdentifier);
        Object object = null;
        try {
            Class<?> classObj = Class.forName(className);
            Constructor<?> constructor = classObj.getConstructor(MxNode.class, String.class);
            object = constructor.newInstance(initFromMxNode, uniqueIdentifier);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("DeviceManager.getDevice.ClassNotFoundException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + initFromMxNode + ")");
            throw new OAException(e, "Unable to load class for class name " + className);
        }
        catch (SecurityException e) {
            LOGGER.error("DeviceManager.getDevice.SecurityException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + initFromMxNode + ")");
            throw new OAException(e, "Unable to find constructor for class name" + className);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("DeviceManager.getDevice.NoSuchMethodException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + initFromMxNode + ")");
            throw new OAException(e, "Unable to find constructor for class name " + className);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("DeviceManager.getDevice.IllegalAccessException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + initFromMxNode + ")");
            throw new OAException(e, "Unable to access method for class name " + className);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("DeviceManager.getDevice.IllegalArgumentException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + initFromMxNode + ")");
            throw new OAException(e, "Unable to create device object for class name " + className);
        }
        catch (InstantiationException e) {
            LOGGER.error("DeviceManager.getDevice.InstantiationException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + initFromMxNode + ")");
            throw new OAException(e, "Unable to create device object for class name " + className);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("DeviceManager.getDevice.InvocationTargetException class name" + className);
            LOGGER.exception((Throwable)e);
            LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + initFromMxNode + ")");
            throw new OAException(e, "Unable to create device object for class name " + className);
        }
        LOGGER.exit("DeviceManager.getDevice(" + deviceMxNode + "," + initFromMxNode + ")");
        return object;
    }

    private String getUniqueIdentifier(MxNode deviceMxNode) {
        String[] uniqueIds = new String[]{deviceMxNode.getUniqueIdentifier(), deviceMxNode.getAgentUUID(), deviceMxNode.getSerialNumber()};
        OAHelper myOAHelper = OAHelper.getOAHelper();
        MxNode enclORDevice = null;
        String uniqueIdentifier = "";
        for (String propertyValue : uniqueIds) {
            try {
                enclORDevice = myOAHelper.getDeviceNodeHavingProperty(propertyValue);
            }
            catch (OAException e) {
                LOGGER.fine("Could not find OLDevice using " + propertyValue);
            }
            if (enclORDevice == null) continue;
            uniqueIdentifier = propertyValue;
            break;
        }
        return uniqueIdentifier;
    }
}

