/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.iLO;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.datacollection.http.DCException;
import com.hp.mx.core.tools.datacollection.http.DataManager;
import com.hp.mx.core.tools.datacollection.http.ICMB;
import com.hp.mx.core.tools.datacollection.http.JAXBCustomValidationEventHandler;
import com.hp.mx.core.tools.datacollection.http.iLO.Blade;
import com.hp.mx.core.tools.datacollection.http.iLO.BladeEnclosure;
import com.hp.mx.core.tools.datacollection.http.iLO.EmptyContainerException;
import com.hp.mx.core.tools.datacollection.http.iLO.ILO;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOException;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOHelper;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOUtil;
import com.hp.mx.core.tools.datacollection.http.iLO.PowerEnclosure;
import com.hp.mx.core.tools.datacollection.http.iLO.xsd.icmbXMLJAXB.RIMPType;
import com.hp.mx.core.tools.identification.mgmtproc.MgmtProcessorParser;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class ILODataManager
extends DataManager {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(ILODataManager.class);
    private BladeEnclosure bladeEnclosure;
    private Blade blade;

    public ILODataManager(MxNode iLOMxNode) throws ILOException {
        LOGGER.enter("ILODataManager(" + iLOMxNode + ")");
        LOGGER.fine("ILO used to get the latest data:" + iLOMxNode.getNameString());
        try {
            com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.RIMPType rimpType = super.processXMLData(iLOMxNode);
            if (rimpType.getINFRA() != null) {
                LOGGER.fine("ILODataManager Creating Blade Enclosure object");
                this.bladeEnclosure = new BladeEnclosure(rimpType);
            } else {
                LOGGER.fine("ILODataManager Creating Blade object");
                this.blade = new Blade(rimpType);
            }
        }
        catch (DCException de) {
            LOGGER.error("ILODataManager Unable to create BladeEnclosure/Blade objects DCException " + de);
            LOGGER.exception((Throwable)de);
            LOGGER.exit("ILODataManager(" + iLOMxNode + ")");
            throw new ILOException(de);
        }
        LOGGER.exit("ILODataManager(" + iLOMxNode + ")");
    }

    BladeEnclosure refreshBladeEnclosure(MxNode bladeEnclosureMxNode, MxNode iLOMxNode) {
        LOGGER.enter("ILODataManager.refreshBladeEnclosure(" + bladeEnclosureMxNode + "," + iLOMxNode + ")");
        try {
            this.checkICMBQueryForEnclosure(iLOMxNode);
            this.bladeEnclosure.init(this.processICMBXMLData(this.bladeEnclosure.getICMBAddress(), iLOMxNode));
        }
        catch (ILOException ie) {
            LOGGER.fine("ILODataManager.refreshBladeEnclosure ILOException  Unable to refresh Blade Enclosure " + ie.getMessage());
            LOGGER.exception((Throwable)ie);
        }
        LOGGER.exit("ILODataManager.refreshBladeEnclosure(" + bladeEnclosureMxNode + "," + iLOMxNode + ")");
        return this.bladeEnclosure;
    }

    PowerEnclosure refreshPowerEnclosure(MxNode rackMxNode, MxNode iLOMxNode) {
        LOGGER.enter("ILODataManager.refreshPowerEnclosure(" + rackMxNode + "," + iLOMxNode + ")");
        PowerEnclosure powerEnclosure = new PowerEnclosure();
        try {
            this.checkICMBQueryForEnclosure(iLOMxNode);
            powerEnclosure = this.updatePowerEnclosure(rackMxNode, iLOMxNode);
        }
        catch (ILOException ie) {
            LOGGER.fine("ILODataManager.refreshPowerEnclosure ILOException  Unable to refresh Power Enclosures " + ie.getMessage());
            LOGGER.exception((Throwable)ie);
        }
        LOGGER.exit("ILODataManager.refreshPowerEnclosure(" + rackMxNode + "," + iLOMxNode + ")");
        return powerEnclosure;
    }

    PowerEnclosure refreshPowerEnclosure(MxNode iLOMxNode) {
        LOGGER.enter("ILODataManager.refreshPowerEnclosure(" + iLOMxNode + ")");
        PowerEnclosure powerEnclosure = new PowerEnclosure();
        try {
            this.checkICMBQueryForEnclosure(iLOMxNode);
            powerEnclosure = this.updatePowerEnclosure(iLOMxNode);
        }
        catch (ILOException ie) {
            LOGGER.fine("ILODataManager.refreshPowerEnclosure ILOException  Unable to refresh Power Enclosures " + ie.getMessage());
            LOGGER.exception((Throwable)ie);
        }
        LOGGER.exit("ILODataManager.refreshPowerEnclosure(" + iLOMxNode + ")");
        return powerEnclosure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PowerEnclosure updatePowerEnclosure(MxNode rackMxNode, MxNode iLOMxNode) {
        LOGGER.enter("ILODataManager.updatePowerEnclosure(" + rackMxNode + "," + iLOMxNode + ")");
        PowerEnclosure powerEnclosure = new PowerEnclosure();
        MxNode mxNode = rackMxNode;
        synchronized (mxNode) {
            List<ICMB> icmbList = this.bladeEnclosure.getRackTopology().getICMBList();
            ICMB icmb = null;
            for (int i = 0; i < icmbList.size(); ++i) {
                icmb = icmbList.get(i);
                LOGGER.finer("ILODataManager.updatePowerEnclosure icmb.isServerEnclosure() " + icmb.isServerEnclosure());
                LOGGER.finer("ILODataManager.updatePowerEnclosure icmb.getICMBAddress() " + icmb.getICMBAddress());
                if (icmb.isServerEnclosure()) continue;
                try {
                    powerEnclosure = new PowerEnclosure(this.processICMBXMLData(icmb.getICMBAddress(), iLOMxNode));
                    continue;
                }
                catch (ILOException ie) {
                    LOGGER.error("ILODataManager.updatePowerEnclosure Unable to get ICMB data for Power Enclosure " + ie.getMessage());
                    LOGGER.exception((Throwable)ie);
                }
            }
        }
        LOGGER.exit("ILODataManager.updatePowerEnclosure(" + rackMxNode + "," + iLOMxNode + ")");
        return powerEnclosure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PowerEnclosure updatePowerEnclosure(MxNode iLOMxNode) {
        LOGGER.enter("ILODataManager.updatePowerEnclosure(" + iLOMxNode + ")");
        PowerEnclosure powerEnclosure = new PowerEnclosure();
        MxNode mxNode = iLOMxNode;
        synchronized (mxNode) {
            List<ICMB> icmbList = this.bladeEnclosure.getRackTopology().getICMBList();
            ICMB icmb = null;
            for (int i = 0; i < icmbList.size(); ++i) {
                icmb = icmbList.get(i);
                LOGGER.finer("ILODataManager.updatePowerEnclosure icmb.isServerEnclosure() " + icmb.isServerEnclosure());
                LOGGER.finer("ILODataManager.updatePowerEnclosure icmb.getICMBAddress() " + icmb.getICMBAddress());
                if (icmb.isServerEnclosure()) continue;
                try {
                    powerEnclosure = new PowerEnclosure(this.processICMBXMLData(icmb.getICMBAddress(), iLOMxNode));
                    continue;
                }
                catch (ILOException ie) {
                    LOGGER.error("ILODataManager.updatePowerEnclosure Unable to get ICMB data for Power Enclosure " + ie.getMessage());
                    LOGGER.exception((Throwable)ie);
                }
            }
        }
        LOGGER.exit("ILODataManager.updatePowerEnclosure(" + iLOMxNode + ")");
        return powerEnclosure;
    }

    private void checkICMBQueryForPowerEnclosure(MxNode rackMxNode) throws ILOException {
        LOGGER.enter("ILODataManager.checkICMBQueryForPowerEnclosure(" + rackMxNode + ")");
        MxNode iLOMxNodeHavingMaxFirmwareInRack = ILOUtil.getILOMxNodeHavingMaxFirmwareRevisionInRack(rackMxNode);
        this.checkICMBQueryForEnclosure(iLOMxNodeHavingMaxFirmwareInRack);
        LOGGER.exit("ILODataManager.checkICMBQueryForPowerEnclosure(" + rackMxNode + ")");
    }

    private void checkICMBQueryForEnclosure(MxNode iLOMxNode) throws ILOException {
        LOGGER.enter("ILODataManager.checkICMBQueryForEnclosure(" + iLOMxNode + ")");
        float CURRENT_ILO_FIRMWARE = this.bladeEnclosure.getBlade().getILO().getFWRI();
        ILO iLO = ILOHelper.getILOHelper().getILO(iLOMxNode);
        LOGGER.fine("ILODataManager.checkICMBQueryForEnclosure.CURRENT_ILO_FIRMWARE " + CURRENT_ILO_FIRMWARE);
        LOGGER.fine("ILODataManager.checkICMBQueryForEnclosure.iLO.getFWRI() " + iLO.getFWRI());
        if (CURRENT_ILO_FIRMWARE < iLO.getFWRI()) {
            LOGGER.exit("ILODataManager.checkICMBQueryForEnclosure(" + iLOMxNode + ")");
            throw new ILOException("ILODataManager.checkICMBQueryForEnclosure.Can't fire ICMB query to ILO as it's not having the maximum ILO version");
        }
        if (CURRENT_ILO_FIRMWARE < 1.8f) {
            LOGGER.exit("ILODataManager.checkICMBQueryForEnclosure(" + iLOMxNode + ")");
            throw new ILOException("ILODataManager.checkICMBQueryForEnclosure.Can't fire ICMB query to ILO having less than 1.80");
        }
        LOGGER.exit("ILODataManager.checkICMBQueryForEnclosure(" + iLOMxNode + ")");
    }

    public BladeEnclosure getBladeEnclosure() {
        return this.bladeEnclosure;
    }

    public Blade getBlade() {
        return this.blade;
    }

    public boolean isBladeServer() {
        return this.bladeEnclosure != null;
    }

    public String getBladeSubType() {
        return this.isBladeServer() ? this.bladeEnclosure.getBlade().getSubType() : this.blade.getSubType();
    }

    private RIMPType processICMBXMLData(String ICMB_ADDRESS, MxNode iLOMxNode) throws ILOException {
        LOGGER.enter("ILODataManager.processICMBXMLData(" + ICMB_ADDRESS + "," + iLOMxNode + ")");
        String isHttpEnabledOnGlobalScale = GlobalSettings.getProperty((String)"http_check_state", (String)"checked");
        if (!isHttpEnabledOnGlobalScale.equals("checked")) {
            throw new ILOException("Http/Https protocols are disabled on global scale, Go to Options->Configure Global Protocol settings from the SIM Menu and enable the check.");
        }
        JAXBContext jaxbContext = null;
        Unmarshaller unmarshaller = null;
        try {
            jaxbContext = JAXBContext.newInstance((String)"com.hp.mx.core.tools.datacollection.http.iLO.xsd.icmbXMLJAXB");
            LOGGER.fine("ILODataManager.processICMBXMLData.jaxbContext " + jaxbContext);
            unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new JAXBCustomValidationEventHandler());
            LOGGER.fine("ILODataManager.processICMBXMLData.unmarshaller " + unmarshaller);
        }
        catch (JAXBException je) {
            LOGGER.error("ILODataManager.processICMBXMLData.JAXBException Unable to get jaxbContext/unmarshaller" + (Object)((Object)je));
            LOGGER.exception((Throwable)je);
            LOGGER.exit("ILODataManager.processICMBXMLData(" + ICMB_ADDRESS + "," + iLOMxNode + ")");
            throw new ILOException(je);
        }
        String WORKING_ADDRESS = iLOMxNode.getWorkingAddress();
        LOGGER.fine("ILODataManager.processICMBXMLData.WORKING_ADDRESS " + WORKING_ADDRESS);
        RIMPType rimpType = null;
        try {
            rimpType = this.getRIMPType(unmarshaller, this.getURL(WORKING_ADDRESS, ICMB_ADDRESS, "https://"));
            LOGGER.fine("ILODataManager.processICMBXMLData.rimpType from https:// is success " + rimpType);
        }
        catch (ILOException ie) {
            LOGGER.fine("ILODataManager.processICMBXMLData.rimpType from https:// is failed " + ie);
            try {
                rimpType = this.getRIMPType(unmarshaller, this.getURL(WORKING_ADDRESS, ICMB_ADDRESS, "http://"));
                LOGGER.fine("ILODataManager.processICMBXMLData.rimpType from http:// is success " + rimpType);
            }
            catch (ILOException ie1) {
                LOGGER.error("DataManager.processICMBXMLData.rimpType from http:// is failed " + ie1);
                LOGGER.exception((Throwable)ie1);
                LOGGER.exit("ILODataManager.processICMBXMLData(" + ICMB_ADDRESS + "," + iLOMxNode + ")");
                throw new ILOException(ie1);
            }
        }
        LOGGER.exit("ILODataManager.processICMBXMLData(" + ICMB_ADDRESS + "," + iLOMxNode + ")");
        return rimpType;
    }

    private RIMPType getRIMPType(Unmarshaller unmarshaller, String url) throws ILOException {
        LOGGER.enter("ILODataManager.getRIMPType(" + unmarshaller + "," + url + ")");
        RIMPType rimpType = null;
        MgmtProcessorParser mpp = new MgmtProcessorParser();
        try {
            String xmlResponse = mpp.sendTheRequest(url);
            LOGGER.fine("ILODataManager.getRIMPType xmlResponse " + xmlResponse);
            if (xmlResponse == null) {
                LOGGER.exit("ILODataManager.getRIMPType(" + unmarshaller + "," + url + ")");
                throw new ILOException("XML response is null for url " + url);
            }
            rimpType = (RIMPType)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xmlResponse)));
            LOGGER.fine("ILODataManager.getRIMPType success " + url);
        }
        catch (JAXBException je) {
            LOGGER.error("ILODataManager.getRIMPType failed " + url);
            LOGGER.exception((Throwable)je);
            LOGGER.exit("ILODataManager.getRIMPType(" + unmarshaller + "," + url + ")");
            throw new ILOException(je);
        }
        LOGGER.exit("ILODataManager.getRIMPType(" + unmarshaller + "," + url + ")");
        return rimpType;
    }

    private String getURL(String WORKING_ADDRESS, String ICMB_ADDRESS, String PROTOCOL) {
        LOGGER.enter("ILODataManager.getURL(" + WORKING_ADDRESS + "," + ICMB_ADDRESS + "," + PROTOCOL + ")");
        StringBuffer url = new StringBuffer(PROTOCOL);
        url.append(WORKING_ADDRESS);
        url.append("/xmldata?item=icmb&addr=");
        url.append(ICMB_ADDRESS);
        LOGGER.exit("ILODataManager.getURL(" + WORKING_ADDRESS + "," + ICMB_ADDRESS + "," + PROTOCOL + ")");
        return url.toString();
    }

    public ILODataManager(String xmlString) throws ILOException {
        LOGGER.enter("ILODataManager(" + xmlString + ")");
        try {
            com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.RIMPType rimpType = super.processXMLData(xmlString);
            if (rimpType.getINFRA() != null) {
                LOGGER.fine("ILODataManager Creating Blade Enclosure object");
                this.bladeEnclosure = new BladeEnclosure(rimpType);
            } else {
                LOGGER.fine("ILODataManager Creating Blade object");
                this.blade = new Blade(rimpType);
            }
        }
        catch (DCException de) {
            LOGGER.error("ILODataManager Unable to create BladeEnclosure/Blade objects DCException " + de);
            LOGGER.exception((Throwable)de);
            LOGGER.exit("ILODataManager(" + xmlString + ")");
            throw new ILOException(de);
        }
        LOGGER.exit("ILODataManager(" + xmlString + ")");
    }

    BladeEnclosure refreshBladeEnclosureUT(MxNode bladeEnclosureMxNode, String bladeEnclosureICMBXMLString, MxNode iLOMxNode) {
        LOGGER.enter("ILODataManager.refreshBladeEnclosureUT(" + bladeEnclosureMxNode + "," + bladeEnclosureICMBXMLString + "," + iLOMxNode + ")");
        BladeEnclosure bladeEnclosure = new BladeEnclosure();
        try {
            this.checkICMBQueryForEnclosure(iLOMxNode);
            bladeEnclosure = this.updateBladeEnclosureUT(bladeEnclosureMxNode, bladeEnclosureICMBXMLString);
        }
        catch (ILOException ie) {
            LOGGER.fine("ILODataManager.refreshBladeEnclosureUT ILOException Unable refresh Blade Enclosure " + ie.getMessage());
            LOGGER.exception((Throwable)ie);
        }
        LOGGER.exit("ILODataManager.refreshBladeEnclosureUT(" + bladeEnclosureMxNode + "," + bladeEnclosureICMBXMLString + "," + iLOMxNode + ")");
        return bladeEnclosure;
    }

    private BladeEnclosure updateBladeEnclosureUT(MxNode bladeEnclosureMxNode, String bladeEnclosureICMBXMLString) throws ILOException {
        LOGGER.enter("ILODataManager.updateBladeEnclosureUT(" + bladeEnclosureMxNode + "," + bladeEnclosureICMBXMLString + ")");
        this.bladeEnclosure.init(this.processICMBXMLDataUT(bladeEnclosureICMBXMLString));
        LOGGER.exit("ILODataManager.updateBladeEnclosureUT(" + bladeEnclosureMxNode + "," + bladeEnclosureICMBXMLString + ")");
        return this.bladeEnclosure;
    }

    public void updatePowerEnclosureWithICMBQueryUT(MxNode rackMxNode, Map powerEnclosureICMBXMLStringMap, MxNode iLOMxNode) {
        LOGGER.enter("ILODataManager.updatePowerEnclosureWithICMBQueryUT(" + rackMxNode + "," + powerEnclosureICMBXMLStringMap + "," + iLOMxNode + ")");
        try {
            this.checkICMBQueryForPowerEnclosure(rackMxNode);
            this.updatePowerEnclosureUT(rackMxNode, powerEnclosureICMBXMLStringMap);
        }
        catch (EmptyContainerException ebe) {
            LOGGER.fine("ILODataManager.updatePowerEnclosureWithICMBQueryUT EmptyContainerException " + ebe.getMessage());
            this.refreshPowerEnclosureUT(rackMxNode, powerEnclosureICMBXMLStringMap, iLOMxNode);
        }
        catch (ILOException ie) {
            LOGGER.fine("ILODataManager.updatePowerEnclosureWithICMBQueryUT Unable to update ICMB data for all Power Enclosures " + ie.getMessage());
            LOGGER.exception((Throwable)ie);
        }
        LOGGER.exit("ILODataManager.updatePowerEnclosureWithICMBQueryUT(" + rackMxNode + "," + powerEnclosureICMBXMLStringMap + "," + iLOMxNode + ")");
    }

    PowerEnclosure refreshPowerEnclosureUT(MxNode rackMxNode, Map powerEnclosureICMBXMLStringMap, MxNode iLOMxNode) {
        LOGGER.enter("ILODataManager.refreshPowerEnclosureUT(" + rackMxNode + "," + powerEnclosureICMBXMLStringMap + "," + iLOMxNode + ")");
        PowerEnclosure powerEnclosure = new PowerEnclosure();
        try {
            this.checkICMBQueryForEnclosure(iLOMxNode);
            powerEnclosure = this.updatePowerEnclosureUT(rackMxNode, powerEnclosureICMBXMLStringMap);
        }
        catch (ILOException ie) {
            LOGGER.fine("ILODataManager.refreshPowerEnclosureUT ILOException Unable to refresh Power Enclosure " + ie.getMessage());
            LOGGER.exception((Throwable)ie);
        }
        LOGGER.exit("ILODataManager.refreshPowerEnclosureUT(" + rackMxNode + "," + powerEnclosureICMBXMLStringMap + "," + iLOMxNode + ")");
        return powerEnclosure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PowerEnclosure updatePowerEnclosureUT(MxNode rackMxNode, Map powerEnclosureICMBXMLStringMap) {
        LOGGER.enter("ILODataManager.updatePowerEnclosureUT(" + rackMxNode + "," + powerEnclosureICMBXMLStringMap + ")");
        PowerEnclosure powerEnclosure = new PowerEnclosure();
        MxNode mxNode = rackMxNode;
        synchronized (mxNode) {
            List<ICMB> icmbList = this.bladeEnclosure.getRackTopology().getICMBList();
            ICMB icmb = null;
            String powerEnclosureXMLString = null;
            for (int i = 0; i < icmbList.size(); ++i) {
                icmb = icmbList.get(i);
                powerEnclosureXMLString = (String)powerEnclosureICMBXMLStringMap.get(icmb.getICMBAddress());
                LOGGER.finer("ILODataManager.updatePowerEnclosureUT icmb.getICMBAddress() " + icmb.getICMBAddress());
                LOGGER.finer("ILODataManager.updatePowerEnclosureUT powerEnclosureXMLString " + powerEnclosureXMLString);
                if (powerEnclosureXMLString == null || powerEnclosureXMLString.trim().length() <= 0) continue;
                try {
                    powerEnclosure = new PowerEnclosure(this.processICMBXMLDataUT(powerEnclosureXMLString));
                    continue;
                }
                catch (ILOException ie) {
                    LOGGER.error("ILODataManager.updatePowerEnclosureUT Unable to initialize ICMB data for Power Enclosure " + ie.getMessage());
                    LOGGER.exception((Throwable)ie);
                }
            }
        }
        LOGGER.exit("ILODataManager.updatePowerEnclosureUT(" + rackMxNode + "," + powerEnclosureICMBXMLStringMap + ")");
        return powerEnclosure;
    }

    protected RIMPType processICMBXMLDataUT(String enclosureICMBXMLString) throws ILOException {
        LOGGER.enter("ILODataManager.processICMBXMLDataUT(" + enclosureICMBXMLString + ")");
        RIMPType rimpType = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.hp.mx.core.tools.datacollection.http.iLO.xsd.icmbXMLJAXB");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new JAXBCustomValidationEventHandler());
            rimpType = (RIMPType)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(enclosureICMBXMLString)));
            LOGGER.fine("ILODataManager.processICMBXMLDataUT.rimpType " + rimpType);
        }
        catch (JAXBException je) {
            LOGGER.error("ILODataManager.processICMBXMLDataUT.JAXBException " + (Object)((Object)je));
            LOGGER.exception((Throwable)je);
            LOGGER.exit("ILODataManager.processICMBXMLDataUT(" + enclosureICMBXMLString + ")");
            throw new ILOException(je);
        }
        LOGGER.exit("ILODataManager.processICMBXMLDataUT(" + enclosureICMBXMLString + ")");
        return rimpType;
    }
}

