/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.datacollection.http.iLO;

import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.datacollection.http.DCUtil;
import com.hp.mx.core.tools.datacollection.http.iLO.ILO;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOConstants;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.BLADETypePClass;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.HOSTSYSTEMINFOType;
import com.hp.mx.core.tools.datacollection.http.xsd.MgmtProcXMLJAXB.RIMPType;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.List;

public class Blade {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(Blade.class);
    private ILO iLO;
    private String spn = "";
    private String bsn = "";
    private String uuid = "";
    private int slot = -1;
    private int slotsUsedInXDirection = -1;
    private int slotsUsedInYDirection = -1;
    private int width = -1;
    private int height = -1;
    private int depth = -1;

    public Blade(RIMPType rimpType) {
        LOGGER.enter("Blade(" + rimpType + ")");
        if (rimpType != null && rimpType.getHSI() != null) {
            this.init(rimpType.getHSI());
        }
        this.iLO = new ILO(rimpType);
        LOGGER.exit("Blade(" + rimpType + ")");
    }

    public void init(Object element) {
        LOGGER.enter("Blade.initializeHSI_spn(" + element + ")");
        this.spn = DCUtil.trimAttribute(((HOSTSYSTEMINFOType)element).getSPN());
        this.bsn = DCUtil.trimAttribute(((HOSTSYSTEMINFOType)element).getSBSN());
        this.uuid = DCUtil.trimAttribute(((HOSTSYSTEMINFOType)element).getUUID());
        LOGGER.exit("Blade.initializeHSI_spn(" + element + ")");
    }

    public void initializeINFRA_BLADETypePClassImpl_BSNImpl(Object element) {
        LOGGER.enter("Blade.initializeINFRA_BLADETypePClassImpl_BSNImpl(" + element + ")");
        this.bsn = DCUtil.trimAttribute(((BLADETypePClass.BSN)element).getValue());
        LOGGER.exit("Blade.initializeINFRA_BLADETypePClassImpl_BSNImpl(" + element + ")");
    }

    public void initializeINFRA_BLADETypePClassImpl_UUIDImpl(Object element) {
        LOGGER.enter("Blade.initializeINFRA_BLADETypePClassImpl_UUIDImpl(" + element + ")");
        this.uuid = DCUtil.trimAttribute(((BLADETypePClass.UUID)element).getValue());
        LOGGER.exit("Blade.initializeINFRA_BLADETypePClassImpl_UUIDImpl(" + element + ")");
    }

    public void initializeINFRA_BLADETypePClassImpl_SLOTImpl(Object element) {
        LOGGER.enter("Blade.initializeINFRA_BLADETypePClassImpl_SLOTImpl(" + element + ")");
        this.slot = ((BLADETypePClass.SLOT)element).getValue().intValue();
        LOGGER.exit("Blade.initializeINFRA_BLADETypePClassImpl_SLOTImpl(" + element + ")");
    }

    public void initializeINFRA_BLADETypePClassImpl_NUMSLOTSXImpl(Object element) {
        LOGGER.enter("Blade.initializeINFRA_BLADETypePClassImpl_NUMSLOTSXImpl(" + element + ")");
        this.slotsUsedInXDirection = ((BLADETypePClass.NUMSLOTSX)element).getValue().intValue();
        LOGGER.exit("Blade.initializeINFRA_BLADETypePClassImpl_NUMSLOTSXImpl(" + element + ")");
    }

    public void initializeINFRA_BLADETypePClassImpl_NUMSLOTSYImpl(Object element) {
        LOGGER.enter("Blade.initializeINFRA_BLADETypePClassImpl_NUMSLOTSYImpl(" + element + ")");
        this.slotsUsedInYDirection = ((BLADETypePClass.NUMSLOTSY)element).getValue().intValue();
        LOGGER.exit("Blade.initializeINFRA_BLADETypePClassImpl_NUMSLOTSYImpl(" + element + ")");
    }

    public void initializeINFRA_BLADETypePClassImpl_WMMImpl(Object element) {
        LOGGER.enter("Blade.initializeINFRA_BLADETypePClassImpl_WMMImpl(" + element + ")");
        this.width = ((BLADETypePClass.WMM)element).getValue().intValue();
        LOGGER.exit("Blade.initializeINFRA_BLADETypePClassImpl_WMMImpl(" + element + ")");
    }

    public void initializeINFRA_BLADETypePClassImpl_HMMImpl(Object element) {
        LOGGER.enter("Blade.initializeINFRA_BLADETypePClassImpl_HMMImpl(" + element + ")");
        this.height = ((BLADETypePClass.HMM)element).getValue().intValue();
        LOGGER.exit("Blade.initializeINFRA_BLADETypePClassImpl_HMMImpl(" + element + ")");
    }

    public void initializeINFRA_BLADETypePClassImpl_DMMImpl(Object element) {
        LOGGER.enter("Blade.initializeINFRA_BLADETypePClassImpl_DMMImpl(" + element + ")");
        this.depth = ((BLADETypePClass.DMM)element).getValue().intValue();
        LOGGER.exit("Blade.initializeINFRA_BLADETypePClassImpl_DMMImpl(" + element + ")");
    }

    public String getSPN() {
        return this.spn;
    }

    public String getBSN() {
        return this.bsn;
    }

    public String getUUID() {
        return this.uuid;
    }

    public int getSLOT() {
        return this.slot;
    }

    public int getDeviceSlotsInXDirection() {
        return this.slotsUsedInXDirection;
    }

    public int getDeviceSlotsInYDirection() {
        return this.slotsUsedInYDirection;
    }

    public int getDeviceWidth() {
        return this.width;
    }

    public int getDeviceDepth() {
        return this.height;
    }

    public int getDeviceHeight() {
        return this.depth;
    }

    public String getDeviceType() {
        return this.spn.matches("ProLiant xw[0-9][0-9]p Blade Wor.*") ? "Workstation" : "Server";
    }

    public List getDeviceSubTypeList() {
        String subType;
        ArrayList<String> subTypeList = new ArrayList<String>();
        if (this.isBlade()) {
            subTypeList.add(NodeSubTypeMapper.BLADE_SUBTYPE.toString());
        }
        if ((subType = this.getSubType()).length() > 0) {
            subTypeList.add(subType);
        }
        subTypeList.add(this.getBladeSubType());
        return subTypeList;
    }

    private boolean isBlade() {
        for (String productModel : ILOConstants.PCLASS_BLADE_PRODUCT_MODEL) {
            if (!this.spn.matches(productModel)) continue;
            return true;
        }
        for (String productModel : ILOConstants.CCLASS_BLADE_PRODUCT_MODEL) {
            if (!this.spn.matches(productModel)) continue;
            return true;
        }
        return false;
    }

    public String getSubType() {
        String subType = "";
        for (String productModel : ILOConstants.CCLASS_BLADE_PRODUCT_MODEL) {
            if (!this.spn.matches(productModel)) continue;
            subType = NodeSubTypeMapper.CCLASS_SUBTYPE.toString();
        }
        for (String productModel : ILOConstants.PCLASS_BLADE_PRODUCT_MODEL) {
            if (!this.spn.matches(productModel)) continue;
            subType = NodeSubTypeMapper.PCLASS_SUBTYPE.toString();
        }
        return subType;
    }

    private String getBladeSubType() {
        for (String productModel : ILOConstants.IPF_PRODUCT_MODEL) {
            if (!this.spn.toLowerCase().contains(productModel)) continue;
            return "HPIntegrity";
        }
        return "HPProLiant";
    }

    public ILO getILO() {
        return this.iLO;
    }

    void print(String SOURCE) {
        LOGGER.enter("*********Blade.print(" + SOURCE + ")*************");
        LOGGER.fine("Blade.spn " + this.spn);
        LOGGER.fine("Blade.bsn " + this.bsn);
        LOGGER.fine("Blade.uuid " + this.uuid);
        LOGGER.fine("Blade.slot " + this.slot);
        LOGGER.fine("Blade.slotsUsedInXDirection " + this.slotsUsedInXDirection);
        LOGGER.fine("Blade.slotsUsedInYDirection " + this.slotsUsedInYDirection);
        LOGGER.fine("Blade.width " + this.width);
        LOGGER.fine("Blade.height " + this.height);
        LOGGER.fine("Blade.depth " + this.depth);
        LOGGER.exit("*********Blade.print(" + SOURCE + ")*************");
    }
}

