/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.protocol.snmp.trap.components;

import com.hp.mx.core.alertmanager.AlertSeverity;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.protocol.snmp.trap.TrapInfo;
import com.hp.mx.core.protocol.snmp.trap.components.CommonInfrastructureTrapRuleHandler;
import com.hp.mx.core.protocol.snmp.trap.components.GenericTrapRuleHandler;
import com.hp.mx.core.protocol.snmp.trap.components.TrapForwarding;
import com.hp.mx.core.protocol.snmp.trap.components.TrapProcessor;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OnboardAdministrator;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.HandlerException;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Vector;

public class OARoleTrapHandler
extends GenericTrapRuleHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(OARoleTrapHandler.class);
    String m_sourceDevsrlNum;
    MxNode m_servEncl;

    public int filterTrap(TrapInfo trap, AlertSeverity severity_id, boolean bService, TrapProcessor trapProc, TrapProcessor.TrapDbData dbData, TrapForwarding trapForwarding) {
        LOGGER.enter("OARoleTrapHandler.filterTrap(" + trap + "," + severity_id + "," + bService + "," + trapProc + "," + dbData + "," + trapForwarding);
        int retval = 0;
        this.setSourceAndEnclosureNode(trap);
        MxNode sourceDev = null;
        try {
            sourceDev = AssociationHandlerUtil.getNodeBySerialNumber(this.m_sourceDevsrlNum);
        }
        catch (HandlerException e1) {
            LOGGER.fine("Unable to obtain the source dev node,Trap not handled." + e1);
        }
        if (this.m_servEncl != null && sourceDev != null) {
            int sourceDevKey = sourceDev.getDeviceKey();
            int srvEnclDevKey = this.m_servEncl.getDeviceKey();
            NodeAssociationsManager nodeAssociationsManager = null;
            try {
                nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            }
            catch (NodeAssociationsPersistenceException e) {
                LOGGER.fine("Unable to obtain an instance of NodeAssociationsManager." + (Object)((Object)e));
                LOGGER.exit("OARoleTrapHandler.filterTrap()");
                return 0;
            }
            OAHelper oaHelper = OAHelper.getOAHelper();
            Vector oaDeviceKeyVect = nodeAssociationsManager.getAssociatedDevicesUsingATNs(srvEnclDevKey, "MgmtProcToEnclosure");
            LOGGER.fine("associatedDeviceKeyVect.size:" + oaDeviceKeyVect.size());
            Integer oaDevKeyObj = null;
            int oaDevKey = 0;
            for (int j = 0; j < oaDeviceKeyVect.size(); ++j) {
                oaDevKeyObj = (Integer)oaDeviceKeyVect.elementAt(j);
                oaDevKey = oaDevKeyObj;
                MxNode oaNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(new Integer(oaDevKey));
                OnboardAdministrator oaAdmin = null;
                LOGGER.fine("oaNode:" + oaNode.getNameString());
                try {
                    oaAdmin = (OnboardAdministrator)oaHelper.getOLDevice(oaNode, oaNode);
                }
                catch (OAException e) {
                    LOGGER.fine("Unable to obtain an instance of OnboardAdministrator for the OA." + e);
                    LOGGER.exit("OARoleTrapHandler.filterTrap()");
                    return 0;
                }
                if (oaDevKey == sourceDevKey) {
                    LOGGER.fine("Setting " + oaNode.getNameString() + " active.");
                    oaAdmin.setIsPrimary(oaNode, true);
                    continue;
                }
                LOGGER.fine("Setting " + oaNode.getNameString() + " standby.");
                oaAdmin.setIsPrimary(oaNode, false);
            }
            if (sourceDev == null) {
                sourceDev = this.m_servEncl;
            }
            LOGGER.fine("sourceDev.getNameString():" + sourceDev.getNameString());
            CommonInfrastructureTrapRuleHandler commonHandler = new CommonInfrastructureTrapRuleHandler();
            retval = commonHandler.filterTrap(trap, severity_id, bService, trapProc, dbData, trapForwarding, sourceDev);
            LOGGER.fine("retval:" + retval);
        }
        LOGGER.fine("retVal:" + retval);
        LOGGER.exit("OARoleTrapHandler.filterTrap(" + trap + "," + severity_id + "," + bService + "," + trapProc + "," + dbData + "," + trapForwarding);
        return retval;
    }

    private void setSourceAndEnclosureNode(TrapInfo trap) {
        LOGGER.enter("OARoleTrapHandler.getSourceNode(" + trap + ")");
        LOGGER.fine("Trap IPAddress:" + trap.getTrapAddress());
        String sourceDevSrlNum = null;
        String enclSrlNum = null;
        String varbindName = null;
        String emOID = "1.3.6.1.4.1.232.22.2.3.1.6.1.8";
        String srvEnclOID = "1.3.6.1.4.1.232.22.2.3.1.1.1.7";
        LOGGER.fine("trap.getTrapVarbindCount():" + trap.getTrapVarbindCount());
        for (int i = 0; i < trap.getTrapVarbindCount(); ++i) {
            varbindName = trap.getTrapVarbindName(i);
            if (varbindName.startsWith("1.3.6.1.4.1.232.22.2.3.1.6.1.8")) {
                sourceDevSrlNum = trap.getTrapVarbindValue(i);
            } else if (varbindName.startsWith("1.3.6.1.4.1.232.22.2.3.1.1.1.7")) {
                enclSrlNum = trap.getTrapVarbindValue(i);
            }
            LOGGER.fine("Varbind Name:" + trap.getTrapVarbindName(i));
            LOGGER.fine("Value:" + trap.getTrapVarbindValue(i));
        }
        try {
            this.m_servEncl = AssociationHandlerUtil.getNodeBySerialNumber(enclSrlNum);
        }
        catch (HandlerException hex) {
            LOGGER.fine("Exception in retrieving the MxNode of the server enclosure from the serial number." + hex);
        }
        this.m_sourceDevsrlNum = sourceDevSrlNum;
        LOGGER.fine("Enclosure Manager{OA}Serial Number from the trap:" + sourceDevSrlNum);
        LOGGER.fine("Enclosure Serial Number from the trap:" + enclSrlNum);
        LOGGER.exit("OARoleTrapHandler.getSourceNode(" + trap + ")");
    }
}

