/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.mgmtproc;

import com.hp.mx.core.nodemanager.DeviceUrl;
import com.hp.mx.core.nodemanager.DeviceUrlBuilderRemote;
import com.hp.mx.core.nodemanager.DeviceUrlType;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxOsNames_t;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.nodemanager.NodeUrlManager;
import com.hp.mx.core.nodemanager.NodeUrlPersistenceException;
import com.hp.mx.core.nodemanager.NodeUrlTypeManager;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.HttpPortParserAlgorithm;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.httpclient.MxHttpClientManager;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class MgmtProcessorParser
implements HttpPortParserAlgorithm {
    private String xmlData;
    private ByteArrayInputStream xmlStream;
    private Element rootElement;
    public static DebugSubsystem mgmtProcIdentificationDebug = new DebugSubsystem(MgmtProcessorParser.class, "Management processor parsing ");
    public static DebugSubsystem iLoSimulationDebug = new DebugSubsystem("iLoSimulationOnIIS", "specifically iLo management processor debugs");
    private String valueFWRI = null;
    private String valueHWRI = null;
    private String valueSN = null;
    private String valueSSO = null;
    private int portSSO = -1;
    private String valueCIMOM = null;
    private String valueSBSN = null;
    private String valueMpStatus = null;
    private String valueDUrl = null;
    private DeviceIdentificationData idInfo;
    private String productName = null;

    private String determineSubType(String strXMLData) {
        int nIdx2;
        if (strXMLData == null || strXMLData.length() == 0) {
            return null;
        }
        int nIdx1 = strXMLData.indexOf("<title>");
        String strTitleContent = strXMLData.substring(nIdx1 + 7, nIdx2 = strXMLData.indexOf("</title>")).trim();
        if (strTitleContent.compareToIgnoreCase("Integrated Lights-Out (iLO) for Integrity and HP9000") == 0) {
            return NodeSubTypeMapper.MP_SPS_SUBTYPE.toString();
        }
        if (strTitleContent.compareToIgnoreCase("HP Integrated Lights-Out") == 0 || strTitleContent.compareToIgnoreCase("Compaq Integrated Lights-Out") == 0) {
            return NodeSubTypeMapper.ILO_SUBTYPE.toString();
        }
        if (strTitleContent.indexOf("integrated lights-out 2 ") != -1) {
            return NodeSubTypeMapper.ILO2_SUBTYPE.toString();
        }
        if (strTitleContent.compareToIgnoreCase("HP TopTools Remote Control Card") == 0) {
            return NodeSubTypeMapper.TT_RCC_SUBTYPE.toString();
        }
        if (strTitleContent.compareToIgnoreCase("Remote Insight Lights-Out Edition II") == 0 || strTitleContent.compareToIgnoreCase("HP Remote Insight") == 0 || strTitleContent.compareToIgnoreCase("Remote Insight") == 0) {
            return NodeSubTypeMapper.RILOE2_SUBTYPE.toString();
        }
        if (strTitleContent.compareToIgnoreCase("Remote Insight Lights-Out Edition") == 0) {
            return NodeSubTypeMapper.RILOE_SUBTYPE.toString();
        }
        if (strTitleContent.compareToIgnoreCase("hp Superdome Management Processor") == 0) {
            return NodeSubTypeMapper.MP_MPS_SUBTYPE.toString();
        }
        return null;
    }

    public boolean startParsing(StringBuffer strBuf, String title, MxNode device, DeviceIdentificationData idInfo, String host, int port, String proto) {
        String METHOD_NAME = "startParsing()";
        mgmtProcIdentificationDebug.enter("startParsing()");
        mgmtProcIdentificationDebug.finest("PORT= " + port + "PROTOCOL=  " + proto);
        return this.startParsing2(strBuf, device, idInfo, host, port, proto);
    }

    private boolean isFetchingAllXmlDataOK(MxNode node, String strHost, int nPort, String strProtocolType) {
        String strURLPath = strProtocolType + "://" + strHost + ":" + nPort + "/xmldata?item=All";
        if (iLoSimulationDebug.getEnabled()) {
            strURLPath = strProtocolType + "://" + strHost + ":" + nPort + "/xmldata.asp?item=All";
        }
        mgmtProcIdentificationDebug.fine("XML DATA requested from URL NAME= " + strURLPath);
        this.setXmlData(this.sendTheRequest(strURLPath));
        this.portSSO = nPort;
        if (this.xmlData != null) {
            mgmtProcIdentificationDebug.fine("XML DATA IS NOT NULL");
            this.parseMgmtProcIdentificationDataFromXml(node);
            this.storeTheInformation(node);
            return true;
        }
        mgmtProcIdentificationDebug.fine("XML DATA IS NULL");
        if (iLoSimulationDebug.getEnabled()) {
            strURLPath = "http://" + strHost + ":" + nPort + "/xmldata?item=All";
            this.setXmlData(this.sendTheRequest(strURLPath));
            this.portSSO = nPort;
            if (this.xmlData != null) {
                this.parseMgmtProcIdentificationDataFromXml(node);
                this.storeTheInformation(node);
                return true;
            }
            mgmtProcIdentificationDebug.fine("It is a MGMT PROC but does not support 2nd HTTP identification");
        } else {
            mgmtProcIdentificationDebug.fine("It is a MGMT PROC, but does not support HTTP identification");
        }
        return false;
    }

    private String getManagementProcessorSubType() {
        if (this.productName == null) {
            return null;
        }
        if (this.productName.toLowerCase().contains("onboard administrator")) {
            return NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString();
        }
        if (this.productName.compareToIgnoreCase("hp Superdome MP") == 0) {
            return NodeSubTypeMapper.MP_MPS_SUBTYPE.toString();
        }
        if (this.productName.compareToIgnoreCase("Integrated Lights-Out (iLO) for Integrity and HP9000") == 0) {
            return NodeSubTypeMapper.MP_SPS_SUBTYPE.toString();
        }
        if (this.productName.compareToIgnoreCase("Integrated Lights-Out (iLO)") == 0) {
            return NodeSubTypeMapper.ILO_SUBTYPE.toString();
        }
        if (this.productName.compareToIgnoreCase("Integrated Lights-Out 2 (iLO 2)") == 0) {
            return NodeSubTypeMapper.ILO2_SUBTYPE.toString();
        }
        if (this.productName.compareToIgnoreCase("Remote Insight Lights-Out Edition") == 0) {
            return NodeSubTypeMapper.RILOE_SUBTYPE.toString();
        }
        if (this.productName.compareToIgnoreCase("Remote Insight Lights-Out Edition II") == 0) {
            return NodeSubTypeMapper.RILOE2_SUBTYPE.toString();
        }
        if (this.productName.compareToIgnoreCase("Integrated Lights-Out 2 (iLO 2) for Integrity") == 0) {
            return NodeSubTypeMapper.BS_BMP_SUBTYPE.toString();
        }
        if (this.productName.compareToIgnoreCase("Lights-Out 100 Remote Management") == 0) {
            return NodeSubTypeMapper.LO100_SUBTYPE.toString();
        }
        if (this.productName.compareToIgnoreCase("HP TopTools Remote Control Card") == 0) {
            return NodeSubTypeMapper.TT_RCC_SUBTYPE.toString();
        }
        return null;
    }

    private String isThisNodeManagementProcessor(MxNode node, String strXmlTitleData, String strHost, int nPort, String strProtocolType) {
        int nBeginTitleTagIdx = strXmlTitleData.indexOf("<title>");
        if (nBeginTitleTagIdx == -1) {
            return null;
        }
        int nEndTitleTagIdx = strXmlTitleData.indexOf("</title>");
        if (nEndTitleTagIdx == -1) {
            return null;
        }
        int nTitleTagContentIdx = strXmlTitleData.indexOf("e-class integrated administrator");
        if (nBeginTitleTagIdx < nTitleTagContentIdx && nTitleTagContentIdx < nEndTitleTagIdx) {
            return NodeSubTypeMapper.MP_PBE_IA_SUBTYPE.toString();
        }
        if (nBeginTitleTagIdx >= nEndTitleTagIdx) {
            return null;
        }
        if (!this.isFetchingAllXmlDataOK(node, strHost, nPort, strProtocolType)) {
            return null;
        }
        return this.getManagementProcessorSubType();
    }

    private String getLinkDescription(String strMPSubType) {
        if (strMPSubType.compareToIgnoreCase(NodeSubTypeMapper.MP_PBE_IA_SUBTYPE.toString()) == 0) {
            return new String("HP ProLiant BL e-Class Integrated Administrator");
        }
        if (this.productName == null) {
            return null;
        }
        if (this.productName.toLowerCase().contains("onboard administrator")) {
            return new String("HP Onboard Administrator");
        }
        if (this.productName.compareToIgnoreCase("hp Superdome MP") == 0) {
            return new String("Hp Superdome Management Processor");
        }
        if (this.productName.compareToIgnoreCase("Remote Insight Lights-Out Edition") == 0 || this.productName.compareToIgnoreCase("Remote Insight Lights-Out Edition II") == 0) {
            return new String("HP Remote Insight");
        }
        return new String("HP Integrated Lights-Out");
    }

    private DeviceUrlType registerUrlTypeIfNeeded(int nPort, String strLinkDescription) {
        String strThisUrlTypeLinkDesc;
        String strThisUrlTypeName = "compaq.hmmd.MANAGEMENTPROCESSOR";
        if (nPort != 80) {
            strThisUrlTypeName = strThisUrlTypeName + "." + nPort;
        }
        DeviceUrlType thisDeviceUrlType = NodeUrlTypeManager.getDefaultManager().getUrlTypeByName(strThisUrlTypeName);
        strThisUrlTypeName = "compaq.hmmd.MANAGEMENTPROCESSOR." + nPort;
        int nUniquePortID = 0;
        while (!(thisDeviceUrlType == null || nUniquePortID >= 300 || (strThisUrlTypeLinkDesc = thisDeviceUrlType.getUrlDescription("en")) != null && strThisUrlTypeLinkDesc.trim().equalsIgnoreCase(strLinkDescription))) {
            strThisUrlTypeName = "compaq.hmmd.MANAGEMENTPROCESSOR." + nPort + "." + ++nUniquePortID;
            thisDeviceUrlType = NodeUrlTypeManager.getDefaultManager().getUrlTypeByName(strThisUrlTypeName);
        }
        if (thisDeviceUrlType == null) {
            thisDeviceUrlType = NodeUrlTypeManager.getDefaultManager().registerUrlType(strThisUrlTypeName, 2, null, null, DeviceUrlBuilderRemote.class.getName(), null);
            thisDeviceUrlType.setUrlLinkDisplay("en", strLinkDescription);
        }
        return thisDeviceUrlType;
    }

    private void removeOldUrlFromNode(MxNode node, int nPort) {
        String strUrlTypeNameToRemove = "compaq.hmmd.MANAGEMENTPROCESSOR";
        if (nPort != 80) {
            strUrlTypeNameToRemove = strUrlTypeNameToRemove + "." + nPort;
        }
        List listUrlsFromThisNode = NodeUrlManager.getDefaultManager().getAllUrlsForANode(node.getDeviceKey());
        for (DeviceUrl thisDeviceUrl : listUrlsFromThisNode) {
            String strThisDeviceUrlTypeName = thisDeviceUrl.getUrlType().getUrlName();
            if (!strThisDeviceUrlTypeName.startsWith("compaq.hmmd.MANAGEMENTPROCESSOR") || strThisDeviceUrlTypeName.equals(strUrlTypeNameToRemove)) continue;
            try {
                NodeUrlManager.getDefaultManager().removeDeviceUrl(node.getDeviceKey(), thisDeviceUrl.getUrlType());
            }
            catch (MxException ex) {
                mgmtProcIdentificationDebug.error("Error removing mgmt proc url " + (Object)((Object)ex));
            }
        }
    }

    private void updateNewUrlToNode(MxNode node, DeviceUrlType deviceUrlType, int nPort, String strProtocolType) {
        if (deviceUrlType == null) {
            return;
        }
        DeviceUrl deviceUrl = null;
        deviceUrl = strProtocolType.toLowerCase().startsWith("https") ? new DeviceUrl(node.getDeviceKey(), deviceUrlType, strProtocolType + ":" + nPort + "/") : new DeviceUrl(node.getDeviceKey(), deviceUrlType, ":" + nPort + "/");
        try {
            NodeUrlManager.getDefaultManager().addDeviceUrl(deviceUrl);
        }
        catch (NodeUrlPersistenceException nupe) {
            mgmtProcIdentificationDebug.fine("Error adding the url " + (Object)((Object)nupe));
        }
    }

    private void setManagementProcessorURL(MxNode node, int nPort, String strProtocolType, String strLinkDescription) {
        DeviceUrlType deviceUrlType = this.registerUrlTypeIfNeeded(nPort, strLinkDescription);
        this.removeOldUrlFromNode(node, nPort);
        this.updateNewUrlToNode(node, deviceUrlType, nPort, strProtocolType);
    }

    private boolean startParsing2(StringBuffer strDataBuffer, MxNode node, DeviceIdentificationData idInfo, String strHost, int nPort, String strProtocolType) {
        if (strDataBuffer == null || node == null || idInfo == null || strHost == null || nPort < 1 || strProtocolType == null) {
            return true;
        }
        String strXMLTitleData = strDataBuffer.toString().toLowerCase();
        String strMPSubType = this.isThisNodeManagementProcessor(node, strXMLTitleData, strHost, nPort, strProtocolType);
        if (strMPSubType == null) {
            return true;
        }
        String strLinkDescription = this.getLinkDescription(strMPSubType);
        this.setManagementProcessorURL(node, nPort, strProtocolType, strLinkDescription);
        idInfo.setIsCompaqAndHpDevice(true);
        idInfo.setOSName(MxOsNames_t.HT_OS_NAME_STRING_MGMTPROC.toString());
        idInfo.setOSType(MxOsNames_t.HT_OS_NAME_STRING_MGMTPROC.toString());
        idInfo.setOSDescription("");
        idInfo.setOSVersion("");
        idInfo.setOSVendor("HP");
        int confidenceLevel = 5;
        if (this.productName != null) {
            confidenceLevel = 50;
        }
        idInfo.addIdStateInfo("MgmtProc", strMPSubType, this.productName, confidenceLevel);
        if (strMPSubType.compareToIgnoreCase(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()) == 0) {
            idInfo.addSubType(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
        }
        return false;
    }

    public void storeTheInformation(MxNode device) {
        DeviceUrlType durltype;
        block14: {
            mgmtProcIdentificationDebug.finer("******************************************************************");
            mgmtProcIdentificationDebug.finer("SBSN : " + this.valueSBSN);
            mgmtProcIdentificationDebug.finer("PN : " + this.productName);
            mgmtProcIdentificationDebug.finer("SN : " + this.valueSN);
            mgmtProcIdentificationDebug.finer("FWRI : " + this.valueFWRI);
            mgmtProcIdentificationDebug.finer("HWRI : " + this.valueHWRI);
            mgmtProcIdentificationDebug.finer("SSO [" + this.portSSO + "] : " + this.valueSSO);
            mgmtProcIdentificationDebug.finer("CIMOM : " + this.valueCIMOM);
            mgmtProcIdentificationDebug.finer("DU : " + this.valueDUrl);
            mgmtProcIdentificationDebug.finer("******************************************************************");
            if (this.valueCIMOM != null && this.valueCIMOM.equals("1")) {
                device.setClientAttribute("compaq.cimom.supported", "true");
            } else if (this.valueCIMOM != null && this.valueCIMOM.equals("0")) {
                device.removeSWAttribute("compaq.cimom.supported");
            }
            if (this.valueSSO != null && this.valueSSO.length() > 0) {
                try {
                    Integer.parseInt(this.valueSSO);
                    device.setSsoSupport(this.valueSSO, this.portSSO);
                }
                catch (NumberFormatException ex) {
                    if (this.valueSSO.equalsIgnoreCase("true")) {
                        device.setSsoSupport("1", this.portSSO);
                        break block14;
                    }
                    if (this.valueSSO.equalsIgnoreCase("false")) {
                        device.setSsoSupport("0", this.portSSO);
                        break block14;
                    }
                    mgmtProcIdentificationDebug.error("Received invalid SSO property [" + this.valueSSO + "] from " + device.getNameString());
                    device.setSsoSupport("0", this.portSSO);
                }
            } else {
                device.setSsoSupport("0", this.portSSO);
            }
        }
        if (this.valueFWRI != null) {
            device.setClientAttribute("compaq.device.firmwareRevision", this.valueFWRI);
        }
        if (this.valueHWRI != null) {
            device.setClientAttribute("compaq.device.hardwareRevision", this.valueHWRI);
        }
        if (this.valueDUrl != null && (durltype = NodeUrlTypeManager.getDefaultManager().getUrlTypeByName("compaq.hmmd.REMOTECONSOLE")) != null) {
            DeviceUrl rmc = new DeviceUrl(device.getDeviceKey(), durltype, this.valueDUrl);
            try {
                NodeUrlManager.getDefaultManager().addDeviceUrl(rmc);
            }
            catch (MxException ex) {
                mgmtProcIdentificationDebug.error("Error adding mgmt proc url " + (Object)((Object)ex));
            }
        }
    }

    public void parseMgmtProcIdentificationDataFromXml(MxNode device) {
        try {
            Element rcTag;
            Element mpTag = this.rootElement.getChild("MP");
            if (mpTag != null) {
                this.productName = mpTag.getChildText("PN");
                this.valueFWRI = mpTag.getChildText("FWRI");
                this.valueHWRI = mpTag.getChildText("HWRI");
                this.valueSSO = mpTag.getChildText("SSO");
                this.valueCIMOM = mpTag.getChildText("CIMOM");
            }
            if ((rcTag = this.rootElement.getChild("RC")) != null) {
                this.valueDUrl = rcTag.getChildText("DU");
            }
        }
        catch (Exception ex) {
            mgmtProcIdentificationDebug.error("ERROR parsing XML " + ex);
            mgmtProcIdentificationDebug.exception((Throwable)ex);
            mgmtProcIdentificationDebug.warning(this.xmlData);
        }
    }

    public void setXmlData(String xmlData) {
        this.xmlData = xmlData;
        Object dataNodeValue = null;
        String temp = null;
        try {
            int pos;
            if (xmlData != null && (temp = (pos = (xmlData = xmlData.trim()).indexOf("<?xml")) != -1 ? xmlData.substring(pos) : xmlData) != null) {
                this.xmlStream = new ByteArrayInputStream(temp.getBytes());
                SAXBuilder saxBuilder = new SAXBuilder();
                this.rootElement = saxBuilder.build((InputStream)this.xmlStream).getRootElement();
            }
        }
        catch (Exception ex) {
            mgmtProcIdentificationDebug.error("ERROR parsing XML " + ex);
            mgmtProcIdentificationDebug.exception((Throwable)ex);
            mgmtProcIdentificationDebug.warning(temp);
        }
    }

    public String getXmlData() {
        return this.xmlData;
    }

    public Element getXmlRootElement() {
        return this.rootElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendTheRequest(String urlName) {
        int response = -1;
        HttpClient client = MxHttpClientManager.getHttpClient();
        GetMethod method = null;
        method = new GetMethod(urlName);
        method.setFollowRedirects(false);
        method.setStrictMode(false);
        Object responseBody = null;
        try {
            Header newHeader = new Header("Compaq-WBEM-Flags", "NoCookie");
            method.addRequestHeader(newHeader);
            newHeader = new Header("accept", "application/xml");
            method.addRequestHeader(newHeader);
            newHeader = new Header("Accept-Charset", "utf-8");
            method.addRequestHeader(newHeader);
            newHeader = new Header("Connection", "close");
            method.addRequestHeader(newHeader);
            client.executeMethod((HttpMethod)method);
            response = method.getStatusCode();
        }
        catch (HttpException e) {
            mgmtProcIdentificationDebug.error("Mgmt Proc HTTP identification HTTP exception on " + urlName + " exception " + (Object)((Object)e));
            method.releaseConnection();
            return null;
        }
        catch (Exception e) {
            mgmtProcIdentificationDebug.error("Mgmt Proc HTTP identification exception on " + urlName + " exception " + e);
            method.releaseConnection();
            return null;
        }
        if (response == 301 || response == 302 || response == 303 || response == 307) {
            Header locationHeader = method.getResponseHeader("location");
            if (locationHeader == null) {
                mgmtProcIdentificationDebug.warning("Redirect failed, no location header found.");
                method.releaseConnection();
                return null;
            }
            String location = locationHeader.getValue();
            method.releaseConnection();
            method = new GetMethod(location);
            Header newHeader = new Header("Compaq-WBEM-Flags", "NoCookie");
            method.addRequestHeader(newHeader);
            newHeader = new Header("accept", "application/xml");
            method.addRequestHeader(newHeader);
            newHeader = new Header("Accept-Charset", "utf-8");
            method.addRequestHeader(newHeader);
            newHeader = new Header("Connection", "close");
            method.addRequestHeader(newHeader);
            try {
                client.executeMethod((HttpMethod)method);
            }
            catch (Exception e) {
                mgmtProcIdentificationDebug.exception("Mgmt Proc HTTP identification exception on " + location + " exception " + e);
                method.releaseConnection();
                return null;
            }
            response = method.getStatusCode();
        }
        if (response != 200 && !iLoSimulationDebug.getEnabled()) {
            mgmtProcIdentificationDebug.finest("Mgmt Proc not responding / HTTP Error " + response);
            method.releaseConnection();
            return null;
        }
        try {
            StringBuffer strBuf = new StringBuffer(method.getResponseBodyAsString());
            String string = strBuf.toString();
            return string;
        }
        catch (Exception ee) {
            mgmtProcIdentificationDebug.fine(" Error getting data from response " + ee);
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }
}

