# HP Insight Manager Agent 7.9.0 Installer
#
#
# *********************************************************************
# ** Global Variables that need to be modified with each release     **
# *********************************************************************
HPASM_PACKAGE="hpasm-7.9.0-116.vmware30.i386.rpm"
HPRSM_PACKAGE="hprsm-7.9.0-108.vmware30.i386.rpm"
HPSMH_PACKAGE="hpsmh-2.1.10-186.vmware.i386.rpm"
CMANIC_PACKAGE="cmanic-7.9.0-5.vmware.linux.rpm"
HP_OPENIPMI_PACKAGE="hp-OpenIPMI-7.9.0-110.vmware30.i386.rpm"

HPASM_PACKAGE_MD5=d8290d5744dcf4958d814c6fc0091ad3
HPRSM_PACKAGE_MD5=b250f1f0d03034d9a24abd3036788a1c
CMANIC_PACKAGE_MD5=456a9004b5f8731d30d9e194cd8cf38c
HPSMH_PACKAGE_MD5=98cb71fc368b3495a5a4d8ea5c832d59
HP_OPENIPMI_PACKAGE_MD5=d68dc46ce3a062501ce1a65eef72dffc

#List of ESX Server versions that this package supports
SUPPORTED_VERSIONS="3.0.0 3.0.1 3.0.2"

#Internal build number for the Agents package
BUILD_NUMBER="17"

# *********************************************************************

LOGFILENAME="hpmgmtlog"

if [ -n "$BUILD_NUMBER" ] 
then
	MINOR_VERSION="-$BUILD_NUMBER"
else
	MINOR_VERSION=""
fi
# Identify the ESX Version where agents are to be installed
INSTALLED_VERSION=`vmware -v | awk '{print $4}'`
if [ -z $INSTALLED_VERSION ]
then
	$SETCOLOR_RED
	echo "ERROR:ESX OS Version:null"
	$SETCOLOR_NORMAL
fi

SMH_PKGLIST="HPSMH_PACKAGE"

#Only include hprsm if iLO/RILOE/RILOE2 is found
cut -f2 /proc/bus/pci/devices | grep -i "0e11b203\|80861960\|0e11005a" > /dev/null 2>&1
if [ $? -eq 0 ]; then
        AGENT_PKGLIST="HPASM_PACKAGE HPRSM_PACKAGE CMANIC_PACKAGE"
else
        AGENT_PKGLIST="HPASM_PACKAGE CMANIC_PACKAGE"
fi

# Check whether the system is having Embedded Health Management Controller
cut -f2 /proc/bus/pci/devices | grep -i "103c3302" > /dev/null 2>&1
if [ $? -eq 0 ]; then
        FOUND_IPMI=1
fi

# On Systems with Embedded Health Management Controller install hp-OpenIPMI rpm
if [ $FOUND_IPMI ] ; then
	AGENT_PKGLIST="HP_OPENIPMI_PACKAGE $AGENT_PKGLIST"
fi

AGENTLIST="cmanic cmastor hprsm hpasm hp-OpenIPMI"
SMHLIST="hpsmh"
#Agent services
AGENTSERVICES="cmanic cmastor hprsm hpasm"

ASMSVC=hpasm
SMHSVC=hpsmhd
SNMPSVC=snmpd
SMHPKG=hpsmh
HPIPMIPKG=hp-OpenIPMI

. /etc/init.d/functions

# Set the positon  to print OK/FAILED
RES_COL=70
MOVE_TO_COL="echo -en \\033[${RES_COL}G"

SETCOLOR_BLUE="echo -en \\033[1;34m"
SETCOLOR_WHITE="echo -en \\033[0;39m"
SETCOLOR_RED="echo -en \\033[0;31m"
SETCOLOR_CYAN="echo -en \\033[0;36m"
SETCOLOR_MAGENTA="echo -en \\033[1;31m"
SETCOLOR_LIGHTRED="echo -en \\033[1;31m"

setsuccess() { 
[[ ! $SILENT ]] && echo `echo_success` || echo "....OK"
echo -e "\t[ OK ]" >> $LOGFILENAME

}
setfailure() {
[[ ! $SILENT ]] && echo `echo_failure` || echo "....FAILED"
echo -e "\t[ FAILED ]" >> $LOGFILENAME
}

splash() {
	echo " "
	if [[ ! $SILENT ]]; then $SETCOLOR_BLUE; fi
	echo "HP Insight Manager Agent 7.9.0${MINOR_VERSION} Installer for VMware ESX Server"
	if [[ ! $SILENT ]]; then $SETCOLOR_NORMAL; fi
	echo -e "HP Insight Manager Agent 7.9.0${MINOR_VERSION} Installer for VMware ESX Server" >> $LOGFILENAME
	echo " "
}

error() {
	$SETCOLOR_LIGHTRED	
	echo $1 | tee -a $LOGFILENAME
	echo -e "Check $LOGFILENAME for additional information"
	$SETCOLOR_NORMAL
}

log() {
	echo $1 >> $LOGFILENAME
}

verify_action() {
	echo "" | tee -a $LOGFILENAME
	echo "This script will now attempt to $1 the HP Insight Manager Agents " | tee -a $LOGFILENAME
	echo -n "Do you wish to continue (y/n) " | tee -a $LOGFILENAME
	read answer
	echo "$answer" >> $LOGFILENAME
	if [ "$answer" != "y" ]; then
		error "Action cancelled by user"
		exit 34
	fi
}

verify_root() {
	if [ $UID != 0 ]; then
		error "You must be logged on as 'root' to continue"
		exit 30
	fi
}
remove_from_list() {
	AGENT_PKGLIST=`echo $AGENT_PKGLIST | sed "s/$1//"`		
	SMH_PKGLIST=`echo $SMH_PKGLIST | sed "s/$1//"`		
}
verify_pkgs() {
	echo "Verifying RPM packages:" | tee -a $LOGFILENAME
	for i in ${AGENT_PKGLIST} ${SMH_PKGLIST}; do
		echo -ne "\tVerifying ${!i}" | tee -a $LOGFILENAME
		if [ ! -f ${!i} ]
		then
			setfailure
			$SETCOLOR_LIGHTRED
			echo -e "Package ${!i} is missing" | tee -a $LOGFILENAME		
			$SETCOLOR_NORMAL
			exit 4 
		else
			PKGMD5=${i}_MD5
			if [ "${!PKGMD5}" = `md5sum ${!i} | awk '{print $1}'` ]; then
				setsuccess
			else
				setfailure
				$SETCOLOR_LIGHTRED
				echo -e "Package ${!i} is corrupted" | tee -a $LOGFILENAME
 				$SETCOLOR_NORMAL
				exit 4
			fi
	 	fi
	done
}

# Function that checks dependency 
check_dependency() {
	echo -en "\tChecking dependencies of $1" | tee -a $LOGFILENAME
	local PACKAGE_NAME=`rpm -qp --queryformat '%{NAME}' $1 2> /dev/null`
	`rpm -Uvh --test $1 > /dev/null 2>&1`
	if [ $? -eq 0 ]
	then
		setsuccess
		return 0
	else
		local installed_version=`rpm -q $PACKAGE_NAME|sed -e '/is not installed/d'`
		if [ -n "$installed_version" ] && ( echo $1 | grep -q $installed_version )
 		then
			setsuccess
			return 0
		else
			setfailure
			if ( rpm -Uvh --test $1 2>&1 | grep -qF "failed dependencies" ) 
			then
				$SETCOLOR_LIGHTRED	
				echo -e "Package has dependencies."
				$SETCOLOR_NORMAL
			fi
			if ( rpm -Uvh --test --nodeps $1 2>&1 | grep -qF "conflicts" ) 
			then
				$SETCOLOR_LIGHTRED	
				echo -e "This package conflicts with an installed package."
				$SETCOLOR_NORMAL
			fi
				
			$SETCOLOR_LIGHTRED	
			echo -e "Check $LOGFILENAME for additional information"
			$SETCOLOR_NORMAL
			rpm -Uv --test $1 > /dev/null 2>> $LOGFILENAME
			rpm -Uv --test --nodeps $1 > /dev/null 2>> $LOGFILENAME
			echo -e "" >> $LOGFILENAME
			return 1
		fi
	fi
}

verify_esx_version() {
	echo -n "Verifying VMware ESX Server version" | tee -a $LOGFILENAME
		
	if [ ! -f /usr/bin/vmware ] 
	then
		setfailure
                error "Installation can be done in VMware ESX Server only!" | tee -a $LOGFILENAME
		echo "Exiting..." >> $LOGFILENAME
                exit 31
	fi
	if [ -n "$INSTALLED_VERSION" ] && ( echo $SUPPORTED_VERSIONS | grep -qF "$INSTALLED_VERSION" ) 
	then
		setsuccess
	else
		setfailure
		error "Installer does not support the VMware ESX Server version" | tee -a $LOGFILENAME
		echo "Exiting..." >> $LOGFILENAME
		exit 31
	fi
}

check_installed() {
	INSTALLEDPKGS=`rpm -q $@ | sed -e '/not installed/d'`
}

stop_agents() {
	local TMP
	echo -n "Stopping HP Insight Manager agents:" | tee -a $LOGFILENAME
	for i in $AGENTSERVICES; do
		rpm -qa | grep ${i} > /dev/null 2>> $LOGFILENAME
		if [ $? -eq 0 ]; then
			if [ -z $TMP ]; then TMP=1;echo "" | tee -a $LOGFILENAME;fi
			svc_control "\tStopping ${i}" stop $i
		fi
	done
	[ -z $TMP ] && setsuccess
}

stop_snmp() {
	local TMP
        echo -ne "Stopping SNMP stack:" | tee -a $LOGFILENAME
	pidof snmpd > /dev/null 2>> $LOGFILENAME
	if [ $? -eq 0 ]; then
		echo "" | tee -a $LOGFILENAME
		svc_control "\tStopping snmpd" stop $SNMPSVC
		TMP=1
	fi
	[ -z $TMP ] && setsuccess
}

stop_smh() {
	check_installed hpsmh
        [[ $INSTALLEDPKGS ]] && svc_control "Stopping System Management Homepage" stop $SMHSVC
	# Make sure SMH is really stopped and all files are cleaned up
	# Wait for up to 30 sec for SMH to stop gracefully
	unset STOPPED
	for i in `seq 1 6`; do 
		echo "Waiting for SMH to stop" >> $LOGFILENAME
		if [ -f /opt/hp/hpsmh/logs/httpd.pid ]; then
			echo "SMH not stopped yet...sleeping for 5" >> $LOGFILENAME
			sleep 5
		else	
			STOPPED=1
			echo "SMH is now stopped" >> $LOGFILENAME
			break
		fi
	done
	# Are we still not stopped?
	if [[ ! $STOPPED ]]; then  
		echo "Forcing shutdown of SMH" >> $LOGFILENAME
		[ -f /opt/hp/hpsmh/logs/httpd.pid ] && rm -f /opt/hp/hpsmh/logs/httpd.pid
		killall -9 hpsmhd >> $LOGFILENAME 2>&1
	fi
	[ -f /var/lock/subsys/hpsmhd ] && rm -f /var/lock/subsys/hpsmhd
}

start_snmp() {
        echo "Starting SNMP stack:" | tee -a $LOGFILENAME
	svc_control "\tStarting snmpd" start $SNMPSVC
}

remove_packages() {
	echo -n "$1:" | tee -a $LOGFILENAME
	shift
	check_installed $@
	if [ -z "$INSTALLEDPKGS" ]; then
		setsuccess
	else
		echo " " | tee -a $LOGFILENAME
		for i in $INSTALLEDPKGS; do
			echo -ne "\tRemoving ${i}: " | tee -a $LOGFILENAME
                	rpm -e --nodeps ${i} >> $LOGFILENAME 2>&1
                	if [ $? -eq 0 ]; then
                	        setsuccess
                	else
                	        setfailure
                	        error "Unable to remove ${i}"
                	fi
                done
        fi
}

#Function that installs packages
install_packages() {
	local PACKAGE_NAME
	echo "$1:" | tee -a $LOGFILENAME
	shift
	for i in $@; do
#		check whether this is a src rpm . If it is then install it.	
		if ( echo ${!i} | grep -q "src.rpm" ) ; then
			echo -ne "\tInstalling ${!i}" | tee -a $LOGFILENAME
                        echo "" >> $LOGFILENAME
                        rpm -ivh ${!i} >> $LOGFILENAME 2>&1
                        if [ $? -eq 0 ]; then
                                setsuccess
                        else
                                setfailure
                        fi
                        echo "" >> $LOGFILENAME
		else
#	 		Find out the Package name 
			PACKAGE_NAME=`rpm -qp --queryformat '%{NAME}' ${!i} 2> /dev/null`
# 			Check whether an old version of the package is already installed
			check_installed $PACKAGE_NAME
			if [ -z "$INSTALLEDPKGS" ]; then
				check_dependency ${!i}
				if [ $? -eq 0 ] 
				then
					echo -ne "\tInstalling ${!i}" | tee -a $LOGFILENAME
					echo "" >> $LOGFILENAME
        				rpm -ivh ${!i} >> $LOGFILENAME 2>&1
					if [ $? -eq 0 ]; then
	        	                	setsuccess
    		        	        else
                	        		setfailure
					fi
					echo "" >> $LOGFILENAME
				elif [ ! $SILENT ]
				then
					echo -en "Do you want to force the installation of the package ${!i} <y/n> ? (Blank is n) " | tee -a $LOGFILENAME
					read choice 
					echo  "$choice" >> $LOGFILENAME
					if [ "$choice" = "y" ]
					then
				     		echo -ne "\tInstalling ${!i}" | tee -a $LOGFILENAME
						echo "" >> $LOGFILENAME
 			                        rpm -ivh --force --nodeps ${!i} >> $LOGFILENAME 2>&1
                    				if [ $? -eq 0 ]; then
		      			               	setsuccess
	                  			else
			        	            	setfailure
						fi
					fi
					echo "" >> $LOGFILENAME
				else
					$SETCOLOR_LIGHTRED
					echo "${!i} can't be installed" | tee -a $LOGFILENAME
					$SETCOLOR_NORMAL
					echo "" >> $LOGFILENAME
				fi
	  	        else
				if ( grep -q $INSTALLEDPKGS ${!i} )
				then	
		              		echo -e "\tPackage ${!i} is already installed" | tee -a $LOGFILENAME
					[[ "$PACKAGE_NAME" = "$SMHPKG" ]] && SMH_RECONF=1	
				else
					local pkg=`rpm -qp ${!i}`
					if ( rpm -Uvh --test --nodeps ${!i} 2>&1 | grep -q "package $INSTALLEDPKGS (which is newer than $pkg) is already installed" )
					then
						echo -e "\tPackage $INSTALLEDPKGS (which is newer than $pkg) is already installed" | tee -a $LOGFILENAME
						[[ "$PACKAGE_NAME" = "$SMHPKG" ]] && SMH_RECONF=1	
					else
						echo -e "\tFound an older package ${INSTALLEDPKGS}" | tee -a $LOGFILENAME
						echo -en "\tUpgrading to `echo ${!i} |sed -e 's/\.rpm$//'` :\n\t" | tee -a $LOGFILENAME 
						[[ "$PACKAGE_NAME" = "$SMHPKG" ]] && SMH_RECONF=1	
						check_dependency ${!i}
						if [ $? -eq 0 ]
						then
							echo -en "\t\tUpgrading to ${!i} " | tee -a $LOGFILENAME
							echo "" >> $LOGFILENAME
							rpm -Uvh ${!i} >> $LOGFILENAME 2>&1
					                if [ $? -eq 0 ]; then
        		        		             setsuccess
  	        		        		else
	                		        	     setfailure
							fi
							echo "" >> $LOGFILENAME
						elif [ ! $SILENT ]
						then
	        	                             	echo -n "Do you want to force the upgrading of $PACKAGE_NAME <y/n> ? (Blank is n) " | tee -a $LOGFILENAME
        	        	                     	read choice
							echo "$choice" >> $LOGFILENAME
                        		             	if [ "$choice" = "y" ]
                                		     	then
                                        			echo -ne "\tUpgrading ${!i}" | tee -a $LOGFILENAME
								echo "" >> $LOGFILENAME
	                	        	                rpm -Uvh --force --nodeps ${!i} >> $LOGFILENAME 2>&1
        	                	                	if [ $? -eq 0 ]; then
                	                	                	setsuccess
	                	                	        else
        	                	                	        setfailure
		                	                        fi
							fi
							echo "" >> $LOGFILENAME
						else
							$SETCOLOR_LIGHTRED
							echo "${PACKAGE_NAME} can't be upgraded" | tee -a $LOGFILENAME
							$SETCOLOR_NORMAL
							echo "" >> $LOGFILENAME
	               		        	fi
                        		fi
				fi
			fi
		fi
	done
}

configure_hpasm() {
	
	echo -n "HP Advanced Server Management configuration:" | tee -a $LOGFILENAME
	if [ ! -f /opt/compaq/hpasm/etc/hpasm ]
	then
		setfailure
		echo "/opt/compaq/hpasm/etc/hpasm: No such file or directory" >> $LOGFILENAME
		error "HP Advanced Server Management configuration failed"
		return 99
	fi
	if [ ! -e /sbin/hpasm ]
	then
        	echo -en "\nDo you want to reconfigure hpasm <y/n> ? (Blank is n) " | tee -a $LOGFILENAME
		read choice
                echo  "$choice" >> $LOGFILENAME
                if [ "$choice" = "y" ]
                then
			/opt/compaq/hpasm/etc/hpasm reconfigure
			if [ $? -eq 0 ]; then
				setsuccess
			else
				setfailure
				error "HP Advanced Server Management configuration failed"
				return 99
			fi
		fi
	else		
		/opt/compaq/hpasm/etc/hpasm activate
		if [ $? -eq 0 ]; then
			setsuccess
		else
			setfailure
			error "HP Advanced Server Management configuration failed"
			return 99
		fi
	fi
}

configure_hpsmh() {

	if [ -e ./smhpd.xml ]; then
		log "Found SMH configuration file...copying"
		echo -n "Copying SMH configuration"
		cp ./smhpd.xml /opt/hp/hpsmh/conf/smhpd.xml
		if [ $? -eq 0 ]; then
			SMHAUTOCONF=1
			setsuccess
		else
			setfailure
			error "HP System Management Homepage configuration failed"
		fi
	else
		echo "SMH Configuration file not found...no action taken" >> $LOGFILENAME
	fi
}

svc_control() {
	echo -ne "$1:" | tee -a $LOGFILENAME
	service $3 $2 > /dev/null 2>> $LOGFILENAME
        if [ $? -eq 0 ]; then
		setsuccess
		return 0
	else
		setfailure
		error "Unable to ${2} ${3}"
	fi

}

post_splash() {
	case "$1" in
	
	install)
	
	if [[ -z $SMHAUTOCONF ]]; then
		echo "**********************************************************" | tee -a $LOGFILENAME 
		echo "* System Management Homepage installed successfully with *" | tee -a $LOGFILENAME
		echo "* default configuration values.   To change the default  *" | tee -a $LOGFILENAME
		echo "* configuration values,  type the following command at   *" | tee -a $LOGFILENAME
		echo "* the root prompt:                                       *" | tee -a $LOGFILENAME
		echo "*                                                        *" | tee -a $LOGFILENAME
		echo "* perl /usr/local/hp/hpSMHSetup.pl                       *" | tee -a $LOGFILENAME
		echo "*                                                        *" | tee -a $LOGFILENAME
		echo "**********************************************************" | tee -a $LOGFILENAME
	fi
	echo "Please read the Licence Agreement for this software at"  | tee -a $LOGFILENAME
	echo "" | tee -a $LOGFILENAME
	echo "/opt/compaq/hpasm/hpasm.license" | tee -a $LOGFILENAME
	echo " " | tee -a $LOGFILENAME
	echo "By not removing this package, you are accepting the terms" | tee -a $LOGFILENAME
	echo -e "of the \"License for HP Value Added Software\"." | tee -a $LOGFILENAME
	;;
	esac

	echo "" | tee -a $LOGFILENAME
	echo "HP Insight Manager agents have been ${1}ed successfully!" | tee -a $LOGFILENAME
	echo "" | tee -a $LOGFILENAME

}

install() {
	splash
	[[ ! $SILENT ]] && verify_action "install"
	echo "" | tee -a $LOGFILENAME
	verify_esx_version
	echo "" | tee -a $LOGFILENAME
	verify_pkgs
	echo "" | tee -a $LOGFILENAME
# Silence the endless "ucd-snmp: Connection from 127.0.0.1" messages
        if ( ! grep -q "^[ ]*snmpd: 127.0.0.1: severity debug" /etc/hosts.allow )
        then
                echo "snmpd: 127.0.0.1: severity debug" >> /etc/hosts.allow
                echo "Added the line \"snmpd: 127.0.0.1: severity debug\" to the file /etc/hosts.allow" >> $LOGFILENAME
		echo "" | tee -a $LOGFILENAME
        fi
	
	#None of the following agents will be started immediately after its installation
	if [ ! $SILENT ] 
	then
# Fix for the issue wherein no traps will be generated immediately after installation of agents
#		export CMANOSTARTINSTALL="hpasmd cmastor cmafdtn cmasvr"
		export CMANOSTARTINSTALL="hpasmd"
	fi

	install_packages "Installing HP System Management Homepage" $SMH_PKGLIST
	if [ ! $SILENT_UPGRADE ]
	then 
		if [ $SILENT ] 
		then 
			configure_hpsmh
		elif [ -n "$SMH_RECONF" ] ; then
			echo ""
			echo -en "Do you want to reconfigure hpSMH <y/n> ? (Blank is n) " | tee -a $LOGFILENAME
			read choice
			echo "$choice" >> $LOGFILENAME
			if [ "$choice" = "y" ] ; then
			perl /usr/local/hp/hpSMHSetup.pl
			fi
		fi
	fi
	echo "" 
# Stop the Agents before installing hp-OpenIPMI package otherwise it will fail to install hp-OpenIPMI package
	check_installed $ASMSVC
	if [ $FOUND_IPMI ] && [ $INSTALLEDPKGS ]
	then
		stop_agents
		echo "" | tee -a $LOGFILENAME
		check_installed $HPIPMIPKG
		if [ $INSTALLEDPKGS ]
                then
                        local pkg=`rpm -qp $HP_OPENIPMI_PACKAGE`
                        if ( ! grep -q $INSTALLEDPKGS $HP_OPENIPMI_PACKAGE ) && ( ! ( rpm -Uvh --test --nodeps $HP_OPENIPMI_PACKAGE 2>&1 | grep -q "package $INSTALLEDPKGS (which is newer than $pkg) is already installed" ) )
                        then
                                remove_packages "Removing hp-OpenIPMI Stack" $HPIPMIPKG
                                echo "" | tee -a $LOGFILENAME
                        fi
                fi
	fi
	install_packages "Installing HP Management Agents" $AGENT_PKGLIST
	echo "" | tee -a $LOGFILENAME

# Configure the ESX Firewall
        if [ ! $SILENT ]
        then
# Prompt the user to enable/disable the port for hpim service in the firewall if it has already been enabled
		if ( ! esxcfg-firewall -q | grep -q hpim )
		then
			echo -en "\nFor accessing the System Managament Homepage, the port for hpim service (2381) \nshould be enabled in the firewall. \nDo you want to enable this port? <y/n> (default is y) " | tee -a $LOGFILENAME
	                read choice
                        echo "$choice" >> $LOGFILENAME
               	        if [ "$choice" != "n" ] ; then
                       	        echo -n "Enabling the port for hpim service (2381) in the firewall" | tee -a $LOGFILENAME
                       		`esxcfg-firewall -o 2381,tcp,in,hpim >> $LOGFILENAME 2>&1`
                       		if [ $? -eq 0 ] ; then
                                       	setsuccess
	                        else
                                        setfailure
               	                fi
                       	else
                               	`esxcfg-firewall -c 2381,tcp,in > /dev/null 2>&1`
                       	fi
		fi
# Prompt the user to enable/disable the snmpd service in the firewall
		if ( ! esxcfg-firewall -q snmpd > /dev/null 2>&1 )
		then
	                echo -en "\nFor the Insight Manager agents to communicate properly with HP Systems Insight \nManager, the snmpd service should be enabled in the firewall. \nDo you want to enable the snmpd service? <y/n> (default is y) " | tee -a $LOGFILENAME
                        read choice
               	        echo "$choice" >> $LOGFILENAME
                       	if [ "$choice" != "n" ] ; then
                             	echo -n "Enabling snmpd service in the firewall" | tee -a $LOGFILENAME
	                        `esxcfg-firewall --enableservice snmpd >> $LOGFILENAME 2>&1`
                                if [ $? -eq 0 ] ; then
               	                        setsuccess
                       	        else
                               	        setfailure
	                        fi
                        else
               	                `esxcfg-firewall --disableservice snmpd > /dev/null 2>&1`
                       	fi
		fi
# Prompt the user to enable/disable the port 280 that is used for adding the SIM certificate in SMH
                if ( ! esxcfg-firewall -q | grep -q sim-cert )
                then
                        echo -en "\nFor adding the HP Systems Insight Manager Certificate in SMH, the port [280] \nshould be enabled in the firewall. \nDo you want to enable this port? <y/n> (default is y) " | tee -a $LOGFILENAME
                        read choice
                        echo "$choice" >> $LOGFILENAME
                        if [ "$choice" != "n" ] ; then
                                echo -n "Enabling the port [280] in the firewall" | tee -a $LOGFILENAME
                                `esxcfg-firewall -o 280,tcp,out,sim-cert >> $LOGFILENAME 2>&1`
                                if [ $? -eq 0 ] ; then
                                        setsuccess
                                else
                                        setfailure
                                fi
                        else
                                `esxcfg-firewall -c 280,tcp,out > /dev/null 2>&1`
                        fi
                fi
        elif [ ! $SILENT_UPGRADE ]
	then
                if [ "$ENABLEHPIMPORT" != "N" ] ; then
                        echo -n "Enabling the port for hpim service (2381) in the firewall" | tee -a $LOGFILENAME
                        `esxcfg-firewall -o 2381,tcp,in,hpim >> $LOGFILENAME 2>&1`
                        if [ $? -eq 0 ] ; then
                                setsuccess
                        else
                                setfailure
                        fi
                else
                        `esxcfg-firewall -c 2381,tcp,in > /dev/null 2>&1`
                fi
                if [ "$ENABLESNMPSERVICE" != "N" ] ; then
                        echo -n "Enabling snmpd service in the firewall" | tee -a $LOGFILENAME
                        `esxcfg-firewall --enableservice snmpd >> $LOGFILENAME 2>&1`
                        if [ $? -eq 0 ] ; then
                                setsuccess
                        else
                                setfailure
                        fi
                else
                        `esxcfg-firewall --disableservice snmpd > /dev/null 2>&1`
                fi
		if [ "$ENABLESIMCERTPORT" != "N" ] ; then
                        echo -n "Enabling the port [280] for adding the HP SIM Certificate in SMH" | tee -a $LOGFILENAME
                        `esxcfg-firewall -o 280,tcp,out,sim-cert >> $LOGFILENAME 2>&1`
                        if [ $? -eq 0 ] ; then
                                setsuccess
                        else
                                setfailure
                        fi
                else
                        `esxcfg-firewall -c 280,tcp,out > /dev/null 2>&1`
                fi
        fi
        echo "" | tee -a $LOGFILENAME
	[[ ! $SILENT ]] && configure_hpasm
	echo "" | tee -a $LOGFILENAME
	stop_agents
        echo "" | tee -a $LOGFILENAME
        stop_smh
        echo "" | tee -a $LOGFILENAME
        stop_snmp
        echo "" | tee -a $LOGFILENAME
# Insert a 3 sec delay before starting the services
	sleep 3
        start_snmp
        echo "" | tee -a $LOGFILENAME
        svc_control "Starting System Management Homepage" start $SMHSVC
        echo "" | tee -a $LOGFILENAME
        svc_control "Starting HP Insight Manager agents" start $ASMSVC
        echo "" | tee -a $LOGFILENAME
        post_splash install
}

uninstall() {
	splash
	verify_action "remove"
	echo "" | tee -a $LOGFILENAME
	verify_esx_version
	echo "" | tee -a $LOGFILENAME
	stop_agents
	echo "" | tee -a $LOGFILENAME
	stop_smh
	echo "" | tee -a $LOGFILENAME
	stop_snmp
	echo "" | tee -a $LOGFILENAME
	remove_packages "Removing HP Insight Manager agents" $AGENTLIST
	echo "" | tee -a $LOGFILENAME
	remove_packages "Removing HP System Management Homepage" $SMHLIST
	echo "" | tee -a $LOGFILENAME
        # Disable the port for hpim in the firewall if it had been enabled
	if ( esxcfg-firewall -q | grep -q hpim )
	then
		echo -n "Disabling the port for hpim service (2381) in the firewall" | tee -a $LOGFILENAME
        	if ( esxcfg-firewall -c 2381,tcp,in > /dev/null 2>&1 )
		then
	               	setsuccess
		else
			setfailure
		fi
	fi
	if ( esxcfg-firewall -q snmpd | grep -q "enabled" )
	then
        	echo -e "\nWarning: snmpd service has been enabled in the firewall. Disable this service \nusing the command \"esxcfg-firewall --disableservice snmpd\" if no other program \nis using it" | tee -a $LOGFILENAME
	fi
	if ( esxcfg-firewall -q | grep -q sim-cert )
        then
        	echo -en "\nDisabling the port [280] in the firewall" | tee -a $LOGFILENAME
                if ( esxcfg-firewall -c 280,tcp,out > /dev/null 2>&1 )
                then
                        setsuccess
                else
                        setfailure
                fi
        fi
	post_splash uninstall
}

usage() {
	splash
	echo "Usage:"
	echo ""
	echo "${0} {--install|--uninstall|--silent} [--inputfile filename]"
	echo ""
	echo -e "--install:"
	echo -e "\tThis will attempt to install version 7.9.0${MINOR_VERSION} of the HP Insight"
	echo -e "\tManager Agents. Uninstall the previous versions of agents"
	echo -e "\tbefore installing version 7.9.0."
	echo ""
	echo -e "--uninstall:"
	echo -e "\tThis will attempt to uninstall the HP Insight Manager Agents"
	echo -e "\tfrom your system. You must be running versions 6.40 or later."

	echo -e "\tVersions prior to 6.40 must be uninstalled manually."
	echo ""
	echo -e "--silent"
        echo -e "\tThis will attempt a silent installation of the HP Insight"
        echo -e "\tManager Agents. Uninstall the previous versions of agents"
	echo -e "\tbefore installing version 7.9.0. This option also requires"
	echo -e "\tthe '--inputfile' option where filename points to the"
	echo -e "\tconfiguration file that contains your settings."
	echo -e "\tPlease see the README and the hpmgmt.conf.example files"
	echo -e "\tfor more details."
        exit 20

}

# START MAIN
verify_root
echo -e "\n**********`date`**********\n" >> $LOGFILENAME
case "$1" in
	--silent)
	SILENT=1
	if [ "$2" != "--inputfile" ] && [ "$2" != "--oldconfig" ]; then
                usage
        elif [ "$2" == "--oldconfig" ]; then
		if [ "$3" != "" ]; then
			usage
		fi
                SILENT_UPGRADE=1
        elif [ ! -e "$3" ]; then
                echo $3
                echo "Input file does not exist!" | tee -a $LOGFILENAME
                exit 20;
	elif [ "$4" != "" ]; then
		usage
        else
		. $3
	fi
	install
	;;
	--install)
	if [ "$2" != "" ]; then
        	usage
	else
		install
	fi
	;;
	--uninstall)
	if [ "$2" != "" ]; then
        	usage
        else
		uninstall
	fi
	;;
	*)
	usage
	;;
esac

exit 0

