<?php
// cimom error response codes allowed in IMETHODRESPONSE and METHODRESPONSE
define("CIM_ERR_FAILED", "1"); // A general error occured that is not covered by a more specific error code 
define("CIM_ERR_ACCESS_DENIED", "2"); // Access to a CIM resource was not available to the client 
define("CIM_ERR_INVALID_NAMESPACE", "3"); // The target namespace does not exist 
define("CIM_ERR_INVALID_PARAMETER", "4"); // One or more parameter values passed to the method were invalid 
define("CIM_ERR_INVALID_CLASS", "5"); // The specified Class does not exist 
define("CIM_ERR_NOT_FOUND", "6"); // The requested object could not be found 
define("CIM_ERR_NOT_SUPPORTED", "7"); // The requested operation is not supported 
define("CIM_ERR_CLASS_HAS_CHILDREN", "8"); // Operation cannot be carried out on this class since it has subclasses 
define("CIM_ERR_CLASS_HAS_INSTANCES", "9"); // Operation cannot be carried out on this class since it has instances 
define("CIM_ERR_INVALID_SUPERCLASS", "10"); // Operation cannot be carried out since the specified superclass does not exist 
define("CIM_ERR_ALREADY_EXISTS", "11"); // Operation cannot be carried out because an object already exists 
define("CIM_ERR_NO_SUCH_PROPERTY", "12"); // The specified Property does not exist 
define("CIM_ERR_TYPE_MISMATCH", "13"); // The value supplied is incompatible with the type 
define("CIM_ERR_QUERY_LANGUAGE_NOT_SUPPORTED", "14"); // The query language is not recognized or supported 
define("CIM_ERR_INVALID_QUERY", "15"); // The query is not valid for the specified query language 
define("CIM_ERR_METHOD_NOT_AVAILABLE", "16"); // The extrinsic Method could not be executed 
define("CIM_ERR_METHOD_NOT_FOUND", "17"); //The specified extrinsic Method does not exist 


define("CONTACT_PERSON_TAG", "cpqSNMPCFGContact");
define("SYS_LOCATION_TAG", "cpqSNMPCFGLocation");
define("DATA_INTERVAL_TAG", "cpqSNMPCFGDataIntv");
define("REMOTE_SET_TAG", "cpqSNMPCFGRemoteSet");
define("REMOTE_REBOOT_TAG", "cpqSNMPCFGRemoteReboot");
define("SNMP_SERVICE_TAG", "cpqSNMPCFGService");
define("RESTART_SERVICES_TAG", "cpqSNMPCFGRestartAgent");
define("SERVER_ROLE_TAG",  "cpqSNMPCFGServerRole");

// security
define("SEND_AUTH_TRAP_TAG", "cpqSNMPCFGAuthTrap");
define("ACCEPTED_HOSTS_TAG", "cpqSNMPCFGAccptHost");
define("VALID_COMMUNITIES_GET_TAG", "cpqSNMPCFGCommStrCFG");

// POST data tags
define("VALID_COMMUNITIES_TAG", "cpqSNMPCFGCommStr");
define("COMMUNITY_RIGHTS_TAG", "cpqSNMPCFGCommStrRight");

// traps
define("TRAP_COMMUNITIES_GET_TAG", "cpqSNMPCFGTrapCFG");

// POST data tags
define("TRAP_COMMUNITIES_TAG", "cpqSNMPCFGTrapComm");
define("TRAP_DESTINATION_TAG", "cpqSNMPCFGTrapDest");

// read/write access
define("ACCESS_TAG", "cpqSNMPCFGAccess");  

// for the Win OS threshold settings.
define("THRESH_CPU_TAG",    "cpqCPUThresh");
define("THRESH_PAGE_TAG",   "cpqPAGEThresh"); // paging 
define("THRESH_CACHE_TAG",  "cpqCACHEThresh"); // cache hits 


define("SVC_PHYSICAL",	  0x0001);
define("SVC_DATALINK",	  0x0002);
define("SVC_INTERNET",	  0x0004);
define("SVC_ENDTOEND",	  0x0008);
define("SVC_APPLICATION",   0x0040);

define("GROUP_CONFIG_DELIM_STR", "%01");

$agentSettings = array(
        "contact" => CONTACT_PERSON_TAG,      
        "location" => SYS_LOCATION_TAG,
        "server_role" => SERVER_ROLE_TAG,
    	"data_interval" => DATA_INTERVAL_TAG,
        "remote_reboot" => REMOTE_REBOOT_TAG,      
        "remote_set" => REMOTE_SET_TAG,
        "restart_services" => RESTART_SERVICES_TAG,
        "send_auth_trap" => SEND_AUTH_TRAP_TAG,
        "accept_specific_hosts" => ACCEPTED_HOSTS_TAG,
        "accepted_hosts" => ACCEPTED_HOSTS_TAG,
        "cpuThresh" => THRESH_CPU_TAG,
        "memThresh" => THRESH_PAGE_TAG,
        "cacheThresh" => THRESH_CACHE_TAG
        );
        
    // global variables
    
	if( isset( $_SERVER["HTTP_HPSMH_SESSIONDIR"]))
	   $snmpoutFile = $_SERVER["HTTP_HPSMH_SESSIONDIR"].'/snmpcfg.out';
	$modInstStr = "snmpRedirectFile=".$snmpoutFile."&CPQSNMPCFG=".GROUP_CONFIG_DELIM_STR."&";

    $traps = array(
         "trapcommstr" => "",
         "trapdest" => ""
         );

?>
