#!/bin/sh

UTILS="/usr/local/ProLiant/Interconnect_Switch/Utilities/p-GbE2/version3.1.0"
MIBDIR=$UTILS"/Mibs"
IMDIR="/opt/mx"
MC="mcompile"
MXA="mxmib -a"
MXD="mxmib -d"
MODULES="hp-switch-pl bladetype2-acl bladetype2-network bladetype2-physical bladetype2-qos bladetype2-switch bladetype2-trap ieee8023-lag"
####################################################################


####################################################################
# Functions
function ok {

  cd $IMDIR
  cd mibs
  echo "Deleting duplicate MIBs.  Ignore any error messages..."
  echo ""

  # Delete already registered mibs
  for name in $MODULES
  do 
    if test -e $name".mib"
    then
      $MXD $name".mib" 1>&2
    fi
  done

  # The SIM compiler requires the filename match the module it defines.
  cp --reply=yes $MIBDIR/bt2acl.mib		bladetype2-acl.mib
  cp --reply=yes $MIBDIR/bt2Network.mib		bladetype2-network.mib
  cp --reply=yes $MIBDIR/bt2Physical.mib	bladetype2-physical.mib
  cp --reply=yes $MIBDIR/bt2qos.mib		bladetype2-qos.mib
  cp --reply=yes $MIBDIR/bt2Switch.mib		bladetype2-switch.mib
  cp --reply=yes $MIBDIR/bt2trap.mib		bladetype2-trap.mib
  cp --reply=yes $MIBDIR/hpswitchpl.mib		hp-switch-pl.mib
  cp --reply=yes $MIBDIR/ieee8023ad.mib		ieee8023-lag.mib

  echo ""
  echo "Compiling MIBs..."
  echo ""

  # Compile mibs
  for name in $MODULES
  do 
    if test -e $name".mib"
    then
      $MC $name".mib" 1>&2
    fi
  done

  echo ""
  echo "Importing MIBs to SIM..."
  echo ""

  # Register mibs
  for name in $MODULES
  do 
    if test -e $name".mib"
    then
      $MXA $name".cfg" 1>&2
    fi
  done

  echo ""
  echo "MIB compilation and SIM import complete."

  errorlevel="0"
  echo ""
  echo "Restarting the Insight Manager service..."
  echo "Press ctrl-c to exit or press any key to continue..."
  read -n 1 wait
  echo ""
  echo "Stopping mx"
  mxstop
  echo "Starting mx"
  mxstart
  echo ""

}
readonly -f ok
declare -t ok
####################################################################


####################################################################
#Body
if test -d $IMDIR
then
  ok		#calls ok function
  exit 0	#exit with no errors
fi

echo ""
echo "=========================================================="
echo "Systems Insight Manager (SIM) installation not found at:"
echo $IMDIR
echo ""
echo "If SIM is installed elsewhere, edit this file to redefine"
echo "the IMDIR variable and then rerun this script."
echo "=========================================================="
echo ""
errorlevel="1"
exit 1		#exit with errors
####################################################################

