/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.session;

import com.hp.mx.core.automation.AutomationEvent;
import com.hp.mx.core.automation.InterconnectEngine;
import com.hp.mx.core.automation.NetAutomationEvent;
import com.hp.mx.core.protocol.dns.InetAddressXe;
import com.hp.mx.core.subjects.usermanager.MxUser;
import com.hp.mx.core.utilities.BusyFlag;
import com.hp.mx.core.utilities.TimerEvent;
import com.hp.mx.core.utilities.TimerListener;
import com.hp.mx.portal.session.SessionList;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.XERand;
import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class UserSession
implements TimerListener {
    private static final Vector empty = new Vector(0);
    MxUser theLoggedInUser = null;
    MxLoginBean myLoginBean = null;
    private byte[] clientRC4Key = null;
    private byte[] serverRC4Key = null;
    String lastToken;
    InetAddressXe userLocation = null;
    private int sessionId;
    long lastTouched;
    long timeLoggedOut = 0L;
    long timePluginRequested = 0L;
    long cookieCreated;
    Date dateLoggedInAt = null;
    Locale lastResortLocale = Locale.getDefault();
    Vector pumpMessages;
    Hashtable data;
    Vector responses = new Vector(1);
    Object netsupporter;
    BusyFlag lock = new BusyFlag();
    boolean loggedOut;
    int logOutState = SESSION_NOT_LOGGED_OUT;
    boolean anonymousSession = false;
    boolean localAppletFilesState = false;
    int editingQuery = 0;
    int editingTask = 0;
    public static int SESSION_NOT_LOGGED_OUT = 0;
    public static int SESSION_LOGGED_OUT = 1;
    public static int SESSION_USER_DELETED_GO2LOGOUT = 2;
    public static int SESSION_USER_DELETED = 3;
    public static int SESSION_USER_ACCESS_LEVEL_CHANGED_GO2LOGOUT = 4;
    public static int SESSION_USER_ACCESS_LEVEL_CHANGED = 5;
    public static int MAX_LOGIN_SCREEN_TIME = 30;
    public static int MAX_SESSION_TIMEOUT = 60;
    private static final DebugSubsystem myDebug = new DebugSubsystem(UserSession.class);

    private int getNextSessionId() {
        int nextSess = -1;
        do {
            nextSess = XERand.getNextRandInt();
            SessionList.getSessionList();
        } while (SessionList.getSession((int)nextSess) != null);
        return nextSess;
    }

    public UserSession(MxUser user, InetAddress userLoc, MxLoginBean loginBean) {
        this.pumpMessages = new Vector(1, 1);
        this.data = new Hashtable(5);
        this.theLoggedInUser = user;
        this.myLoginBean = loginBean;
        this.userLocation = this.getXEUserLoc(userLoc);
        this.lastToken = "";
        this.setSessionId(this.getNextSessionId());
        this.cookieCreated = 0L;
        this.loggedOut = false;
        this.anonymousSession = false;
        this.touched();
        this.attachSessionVariable("colorDepth", new Integer(256));
        this.dateLoggedInAt = new Date();
    }

    private InetAddressXe getXEUserLoc(InetAddress userLoc) {
        InetAddressXe XEAddr = null;
        if (userLoc != null) {
            XEAddr = new InetAddressXe(userLoc.getHostAddress());
        }
        return XEAddr;
    }

    public Date getLoggedInAtDate() {
        return this.dateLoggedInAt;
    }

    public void attachSessionVariable(String key, Object data) {
        this.data.put(key, data);
    }

    public Object retrieveSessionVariable(String key) {
        return this.data.get(key);
    }

    public void removeSessionVariable(String key) {
        this.data.remove(key);
    }

    public void lock() {
        this.lock.getBusyFlag();
    }

    public void unlock() {
        this.lock.freeBusyFlag();
    }

    public synchronized void addResponse(NetAutomationEvent nae) {
        if (this.loggedOut) {
            return;
        }
        this.responses.addElement(nae);
    }

    public synchronized Vector getResponses() {
        if (this.responses.size() == 0) {
            return empty;
        }
        Vector returnVect = this.responses;
        this.responses = new Vector(1);
        return returnVect;
    }

    public Object getNetsupport() {
        return this.netsupporter;
    }

    public void setNetsupport(Object ns1) {
        this.netsupporter = ns1;
    }

    public void setLanguage(String language) {
        Locale locale = Locale.US;
        if (language.startsWith("ja")) {
            locale = Locale.JAPAN;
        }
        if (language.equals("ko")) {
            locale = Locale.KOREAN;
        }
        if (language.equals("zh")) {
            locale = Locale.CHINESE;
        }
        this.setSessionsLocale(locale);
    }

    public String getLanguage() {
        if (this.myLoginBean == null) {
            return this.lastResortLocale.getLanguage();
        }
        return this.myLoginBean.getLocale().getLanguage();
    }

    public void setLocalAppletFilesState(boolean state) {
        this.localAppletFilesState = state;
    }

    public boolean getLocalAppletFilesState() {
        return this.localAppletFilesState;
    }

    private boolean checkToken(String token) {
        return this.lastToken.equals(token);
    }

    private String getToken() {
        return this.lastToken;
    }

    public int getId() {
        return this.getSessionId();
    }

    public InetAddressXe getLocation() {
        return this.userLocation;
    }

    public void setSessionsTimeZone(TimeZone tz) {
        if (this.myLoginBean != null) {
            this.myLoginBean.setTimeZone(tz);
        }
    }

    public TimeZone getSessionsTimeZone() {
        if (this.myLoginBean == null) {
            return TimeZone.getDefault();
        }
        return this.myLoginBean.getTimeZone();
    }

    public void setSessionsLocale(Locale lc) {
        this.lastResortLocale = lc;
    }

    public Locale getSessionsLocale() {
        if (this.myLoginBean == null) {
            return this.lastResortLocale;
        }
        return this.myLoginBean.getLocale();
    }

    public void touched() {
        if (!this.loggedOut) {
            this.lastTouched = System.currentTimeMillis();
        }
        if (myDebug.check(50)) {
            myDebug.finest("Session object was touched - trace is ");
            Thread.dumpStack();
        }
    }

    public long getLastTouched() {
        return this.lastTouched;
    }

    public void setPluginBeingRequested() {
        this.timePluginRequested = System.currentTimeMillis();
    }

    public boolean outOfDate() {
        long test;
        long now = System.currentTimeMillis();
        long diffAllowed = 0L;
        diffAllowed = !this.isAnonymousSession() ? (diffAllowed += (long)(MAX_SESSION_TIMEOUT * 60 * 1000)) : (diffAllowed += (long)(MAX_LOGIN_SCREEN_TIME * 60 * 1000));
        if (this.timePluginRequested != 0L && now - this.timePluginRequested < 360000L) {
            diffAllowed += now - this.timePluginRequested;
        }
        if (now > this.lastTouched + diffAllowed) {
            return true;
        }
        return this.timeLoggedOut != 0L && now > (test = this.timeLoggedOut + 10000L);
    }

    public boolean shouldBeFlushed() {
        if (this.timeLoggedOut != 0L) {
            long test;
            if (this.isAnonymousSession()) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (now > (test = this.timeLoggedOut + 86400000L)) {
                return true;
            }
        }
        return false;
    }

    public MxUser getUser() {
        return this.theLoggedInUser;
    }

    public void setUser(MxUser theUser) {
        this.theLoggedInUser = theUser;
    }

    public int getInterval() {
        return 60;
    }

    public synchronized void timerTriggered(TimerEvent event) {
        Enumeration e = this.pumpMessages.elements();
        while (e.hasMoreElements()) {
            AutomationEvent naer = (AutomationEvent)e.nextElement();
            InterconnectEngine.maEngine.fireEvent(naer);
        }
    }

    public void logOutUser() {
        this.loggedOut = true;
        this.logOutState = SESSION_LOGGED_OUT;
        this.timeLoggedOut = System.currentTimeMillis();
        this.data = null;
    }

    public void setLogOutState(int los) {
        if (los == SESSION_NOT_LOGGED_OUT) {
            this.loggedOut = false;
        } else {
            this.loggedOut = true;
            if (this.timeLoggedOut == 0L) {
                this.timeLoggedOut = System.currentTimeMillis();
            }
        }
        this.logOutState = los;
    }

    public boolean getLogOutState() {
        return this.loggedOut;
    }

    public int getLogOutStateDetails() {
        return this.logOutState;
    }

    public boolean isAnonymousSession() {
        return this.anonymousSession;
    }

    public String toString() {
        return "ID: " + this.getId() + " State " + this.getLogOutStateDetails();
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }
}

