%{!?direct:%define name linux-iscsi-boot}
%{?direct:%define name linux-direct-boot}
%define version 4.1.26
%define release 1

%define _srcdir %(if [ -f /etc/SuSE-release ];then echo "/usr/src/packages/SOURCES"; else echo "/usr/src/redhat/SOURCES"; fi)

%define _mandir /usr/man
%define _sbindir /usr/sbin
%define _sysconfdir /etc
%define _rcroot %(if [ -f /etc/SuSE-release ];then echo "/etc/init.d"; else echo "/etc"; fi)
%define _moddir /lib
%define _optdir /opt

%{?direct:%(cp %{_srcdir}/linux-iscsi-boot-%{version}.tar.gz %{_srcdir}/%{name}-%{version}.tar.gz)}

Summary     : iSCSI daemon and utility programs
Name        : %{name}
Version     : %{version}
Release     : %{release}
License     : GPL
Group       : System Environment/Daemons
Packager    : Cisco Systems, Inc. SRBU
URL	    : http://linux-iscsi.sourceforge.net
Source      : %{name}-%{version}.tar.gz
BuildRoot   : %{_tmppath}/%{name}-buildroot

#some file defines for direct build
%{?direct: %define _files /opt/*}
#some file defines for normal build
%{!?direct: %define _files /usr/man/man*/*}

%description
The iboot package provides the driver and helper scripts to build 
initrd image to facilitate ibooting. The package also provides the 
server daemon for the iSCSI protocol, as well as the utility programs used 
to manage it. 

%prep
rm -rf $RPM_BUILD_ROOT
%setup -c

%build
value=%{?direct}
if [  -z "$value" ];then
	make KVER= BASEDIR="/usr"
else
	make iboot_install_module 
fi

%install
rm -rf $RPM_BUILD_ROOT/*

#We are supposed to create the rc and init directories
#so that the links are also properly created. the iscsi
#install.sh is written so that it checks these directories 
#before creating appropriate links

value=%{?direct}

if [ -z "$value" ];then
	mkdir -p $RPM_BUILD_ROOT/etc/init.d
	for rcdir in 0 1 2 3 4 5 6
	do
	    mkdir -p $RPM_BUILD_ROOT/%{_rcroot}/rc${rcdir}.d
	done
	make KVER= ROOT=$RPM_BUILD_ROOT install
	echo "%defattr(-,root,root)" > file.list.%{name}
	if [ -f /etc/redhat-release ]; then
		rcbase=etc
	fi
	if [ -f /etc/SuSE-release ];then
		rcbase=etc/init.d
	fi
	for rcdir in 0 1 2 3 4 5 6
	do
		find $RPM_BUILD_ROOT/$rcbase/rc${rcdir}.d/* -type l  -print |
			sed "s@^$RPM_BUILD_ROOT@@g" >> file.list.%{name}
	done
	echo "/etc/iscsi.conf" >> file.list.%{name}
	echo "/etc/initiatorname.iscsi" >> file.list.%{name}
	echo "/etc/fstab.iscsi" >> file.list.%{name}
	find $RPM_BUILD_ROOT/etc/init.d/* -type f -print | 
		sed "s@^$RPM_BUILD_ROOT@@g" >> file.list.%{name}
	find $RPM_BUILD_ROOT/usr/sbin/* -type f -print | 
		sed "s@^$RPM_BUILD_ROOT@@g" >> file.list.%{name}
	find $RPM_BUILD_ROOT/lib/* -type f -print | 
		sed "s@^$RPM_BUILD_ROOT@@g" >> file.list.%{name}
	find $RPM_BUILD_ROOT/lib/* -type f -print | 
		sed "s@^$RPM_BUILD_ROOT@@g" >> file.list.%{name}
	find $RPM_BUILD_ROOT/opt/* -type f -print | 
		sed "s@^$RPM_BUILD_ROOT@@g" >> file.list.%{name}
else
	make  ROOT=$RPM_BUILD_ROOT install_direct
	echo "%defattr(-,root,root)" > file.list.%{name}
fi

%clean
rm -rf $RPM_BUILD_ROOT

%pre
KVER=

value=%{?direct}

if [ -z "$value" ];then
	if [ -z $KVER ];then
		lsmod | grep iscsi_sfnet 
		if [ $? -eq 0 ];then
			echo " iscsi_sfnet is loaded. exiting..."
			exit 1;
		fi	
	fi

	if [ -e /etc/iscsi.conf ];then
		mv /etc/iscsi.conf /etc/iscsi.conf.rpm.save
	fi	

	if [ -e /etc/initiatorname.iscsi ];then
		mv /etc/initiatorname.iscsi /etc/initiatorname.iscsi.rpm.save
	fi	
fi

%post
value=%{?direct}

if [ -z "$value" ];then
	if [ -e /etc/iscsi.conf.rpm.save ];then
		mv /etc/iscsi.conf /etc/iscsi.conf.new
		mv /etc/iscsi.conf.rpm.save /etc/iscsi.conf 
		echo "New iscsi configuration file iscsi.conf.new created"
	else
		echo "Please Edit the iscsi configuration file"
	fi	

	INAME=`/usr/sbin/iscsi-iname`
	echo "InitiatorName=$INAME" > /etc/initiatorname.iscsi

	if [ -e /etc/initiatorname.iscsi.rpm.save ];then
		mv /etc/initiatorname.iscsi /etc/initiatorname.iscsi.new
		mv /etc/initiatorname.iscsi.rpm.save /etc/initiatorname.iscsi 
	fi	

	/sbin/depmod -a >/dev/null 2>&1
fi
exit 0

%preun
value=%{?direct}

if [ -z "$value" ];then
	if [ -z $NOCHECK ];then
		lsmod | grep iscsi_sfnet 
		if [ $? -eq 0 ];then
			echo "iscsi_sfnet is loaded. exiting..."
			exit 1;
		fi	
	fi

	if [ -d /opt/hp/iboot/src ];then
		rm -rf /opt/hp/iboot/src > dev/null 2>&1
	fi
fi

%postun
value=%{?direct}

if [ -z "$value" ];then
	/sbin/depmod -a >/dev/null 2>&1
fi

rm -rf /opt/hp/iboot

exit 0

%files -f file.list.%{name} 
# Do not try replacing this with a 'find *' as we do for other
# packages. Red Hat does not like the way man pages are installed
# by 'make install'.
%{_files}
%{!?direct: %doc README COPYING Release.notes}

%changelog
