#!/bin/bash

#### functions #####
function usage()
{
	        cat <<EOF
usage : prep_iscsi_boot.sh [-d </path/to/iboot>] [-h <hostname>]
                                                 [-b <grub|lilo>]
EOF
        exit $1
}

function error_exit()
{
 	if [ $1 -ne 0 ]
	then
		echo -e "\033[31m[Failed]\033[37m"
		echo "ERROR: Post install failed."
		echo "***************************************************"
		tail /root/iSCSI_boot.log
		echo "***************************************************"
		echo
		echo "Please look at /root/iSCSI_boot.log for more information."
		echo -n "Press <ENTER> to Abort"
		read n
		exit 1
	fi
	echo -e "\033[32m[Done]\033[37m"
}

####  main #######

# Default values.
BASE_PATH=.
SYSTEM_NAME="localhost"
BOOT_LOADER="grub"
LOG_FILE=/root/iSCSI_boot.log

# do argument parsing

while [ $# -gt 0 ]; do
	case $1 in
		--hostname|-h)
			if [ -z "$2" ]; then
				usage 1
			else
				SYSTEM_NAME=$2
			fi
			shift 2
			;;
		--directory|-d)
			if [ -z "$2" ]; then
				usage 1
			else
				BASE_PATH=$2
			fi
			shift 2
			;;
		--bootloader|-b)
			if [ -z "$2" ]; then
				usage 1
			else
				BOOT_LOADER=$2
			fi
			shift 2
			;;
		*)
			usage 1
			;;
	esac
done

echo
echo "Preparing target disk for iSCSI Boot." | tee -a $LOG_FILE
echo -n "Gatthering System Configuration... "
$BASE_PATH/scripts/configure.sh $BASE_PATH $SYSTEM_NAME $BOOT_LOADER
error_exit $?
cp $BASE_PATH/iboot.conf /etc/iboot.conf
echo -n "Setting up the kernel tree... "
$BASE_PATH/scripts/setup_kernel_tree.sh $BASE_PATH/iboot.conf >> $LOG_FILE 2>&1
error_exit $?
echo -n "Installing bnx2 driver... "
$BASE_PATH/scripts/install_bnx2.sh $BASE_PATH $BASE_PATH/iboot.conf >> $LOG_FILE 2>&1
error_exit $?
echo -n "Installing iSCSI boot driver... "
$BASE_PATH/scripts/install_iscsi.sh --config $BASE_PATH/iboot.conf --srcrpm $BASE_PATH/SRPMS --force --verbose >> $LOG_FILE 2>&1
error_exit $?
mv /opt/hp/iboot/etc/iboot.conf /opt/hp/iboot/etc/iboot.conf.sample
cp /etc/iboot.conf /opt/hp/iboot/etc/iboot.conf
echo -n "Removing Temporary files... "
rm -rf $BASE_PATH/scripts $BASE_PATH/patches $BASE_PATH/SRPMS
error_exit $?
echo "Successfully prepared target disk for iSCSI Boot" | tee -a $LOG_FILE
exit 0

