:: (C) Compaq Computer Corp. - Sample script for Exchange Server 5.5 Log Verification 

REM *********************************************************************************
REM	Used to verify transaction log signatures and paths to .edb files
REM	The Log Verification tools should be tested and customized for your environment.
REM     The output from these scripts will automate verifcation of log files.	
REM 	Review the KB article "XADM: Making and Restoring Offline Backups" Q237767.
REM *********************************************************************************

REM *** Modify this section with the location (LogLocate) of the database log files.
REM 	Also set directory (CompaqLog) for storing output.

REM *** AnchorLog variable is the last consistent transaction log file. 
REM     Use the LAST CONSISTENT LOG GENERATION: from the output of the CHECKDB utility.
REM     Example:  LAST CONSISTENT LOG GENERATION:EDB00047.log
REM     NOTE: If the AnchorLog variable is equal to edb.log than you must use the next 
REM     older transaction log if it exists.

REM *** The anchor log can also be calculated from the first value in parentheses on
REM     the "Last Consistent" line in the output from eseutil /mh.  Convert from decimal
REM     to hexadecimal. 

REM *********************************************************************************
REM	IMPORTANT: If you cannot locate the anchor log file, do not replay ANY log files
REM	into the database.  If you skip the anchor log file and force replay to begin
REM     using a subsequent log file, you may damage the database. If the anchor log is 
REM	not available a "Point in Time" restoration should be evaluated.
REM *********************************************************************************
 
SET AnchorLog=edb00002.log

SET LogLocate=e:\exchsrvr\mdbdata
REM SET LogLocate=
SET CompaqLog=c:\compaq\log
SET RecoverLog=recout.txt
SET WarningLog=warn.txt

REM *********************************************************************************
REM ***	End Modification section: Save the .cmd file
REM *********************************************************************************

@echo OFF
REM REM SET echo=ON
@if not "%ECHO%"=="" echo %ECHO%

REM *********************************************************************************
REM *** Housekeeping Section
REM *********************************************************************************

REM * Cleanup old cmp compare files
DEL %CompaqLog%\*.cmp

CD /D %LogLocate%
MD c:\compaq\log

REM  ############################################################################
REM  # DUMP EDB SIGNATURE FROM Transaction Anchor Log 
REM  ############################################################################

FOR %%A IN (edb*.log) DO eseutil /ml %%A | FIND /I "SIG" >%CompaqLog%\%%A.cmp
eseutil /ml %AnchorLog% | find /I "SIG" >%CompaqLog%\%RecoverLog% 

echo ############################################################################>>%CompaqLog%\%RecoverLog% 
echo # START SIGNATURE COMPARE VERIFICATION ***** ANCHOR LOG=%AnchorLog% >>%CompaqLog%\%RecoverLog% 
echo # NOTE: ***** %CompaqLog%\\%AnchorLog%.cmp >>%CompaqLog%\%RecoverLog% 
echo # THE ABOVE LINE INDICATES THE SIGNATURES DID NOT MATCH >>%CompaqLog%\%RecoverLog% 
echo # IF THIS IS EDB00001.LOG THAN IGNORE ELSE YOU MUST INVESTIGATE DIFFERENCES. >>%CompaqLog%\%RecoverLog% 
echo ############################################################################>>%CompaqLog%\%RecoverLog% 

FOR %%A IN (%CompaqLog%\*.cmp) DO FC %CompaqLog%\%AnchorLog%.cmp %%A >>%CompaqLog%\%RecoverLog% 

REM ############################################################################
REM # DUMP EDB PATH FROM Transaction Anchor Log 
REM ############################################################################

FOR %%A IN (edb*.log) DO eseutil /ml %%A | FIND /I ".EDB" >%CompaqLog%\%%A.cmp
eseutil /ml %AnchorLog% | FIND /I ".EDB" >>%CompaqLog%\%RecoverLog% 

echo ############################################################################>>%CompaqLog%\%RecoverLog% 
echo # START PATH COMPARE VERIFICATION ***** ANCHOR LOG=%AnchorLog% >>%CompaqLog%\%RecoverLog% 
echo # NOTE: ***** %CompaqLog%\\%AnchorLog%.cmp >>%CompaqLog%\%RecoverLog% 
echo # THE ABOVE LINE INDICATES THE EDB PATH DID NOT MATCH >>%CompaqLog%\%RecoverLog% 
echo # IF THIS IS EDB00001.LOG THAN IGNORE ELSE YOU MUST INVESTIGATE DIFFERENCES. >>%CompaqLog%\%RecoverLog% 
echo ############################################################################>>%CompaqLog%\%RecoverLog% 


FOR %%A IN (%CompaqLog%\*.cmp) DO FC %CompaqLog%\%AnchorLog%.cmp %%A >>%CompaqLog%\%RecoverLog% 

echo ############################################################################>%CompaqLog%\%WarningLog% 
echo # WARNING !!! IF SIGNATURES OR EDB PATHS DO NOT MATCH THE ANCHOR LOG >>%CompaqLog%\%WarningLog% 
echo # YOU MUST INVESTIGATE WHY.  READ Q237767 FOR MORE INFORMATION. >>%CompaqLog%\%WarningLog% 
echo # "<http://support.microsoft.com/support/kb/articles/Q237/7/67.ASP>" >>%CompaqLog%\%WarningLog% 
echo # IF THIS IS EDB00001.LOG THAN IGNORE ELSE YOU MUST INVESTIGATE EACH TRANSACTION LOG BELOW. >>%CompaqLog%\%WarningLog% 
echo ############################################################################>>%CompaqLog%\%WarningLog% 

FIND /I "*****" %CompaqLog%\%RecoverLog% >>%CompaqLog%\%WarningLog%  

start notepad %CompaqLog%\%WarningLog%  
start notepad %CompaqLog%\%RecoverLog%  



