#!/bin/bash

# run_linux_unattended.sh

TOOLKIT=/TOOLKIT
. ${TOOLKIT}/toolkit_functions
echo "### Linux Unattended Install using Kickstart ###"

tpart=/mnt/localpartition

# carve up disk
cd linux_diskcarve/
./linux_diskcarve.sh

# mount disk
mount -t vfat /dev/sssd1  ${tpart}


# copy over remaining boot files
# what is needed is a syslinux.cfg, boot.msg, initrd.img, and vmlinuz
cd ${TOOLKIT}/linux_diskcarve/
cp -a syslinux.cfg ${tpart}/ 
cp -a boot.msg ${tpart}/ 
cp -a initrd.img ${tpart}/ 
cp -a vmlinuz ${tpart}/ 

# unmount disk
umount ${tpart}

read_break

${TOOLKIT}/reboot c:
