#!/bin/bash

# start_toolkit.sh

TOOLKIT=/TOOLKIT
NFS_MAIN=/mnt/nfs_main
HWDISC_FILE=/TOOLKIT/hwdisc.dat
SERVERID=
BOOTDEVNODE=

# source over the toolkit functions...maybe just have the functions embedded in the top here...
cp -a ${NFS_MAIN}/scripts/toolkit_functions /TOOLKIT/
cd /TOOLKIT/
. toolkit_functions

echo "*** MAIN TOOLKIT LAUNCH ***"

# copy over utilities
echo "copying over utilites from NFS share"
cp -a ${NFS_MAIN}/utilities/* /TOOLKIT/


REPLY=
echo "If you want to exit the Toolkit process, type a non-blank character and press enter"
read REPLY

if [ -z ${REPLY} ]; then
	# run hwdisc the first time to get Server ID
	./hwdisc3 -f${HWDISC_FILE}
	clear
	# call function to get ${SERVERID}
	get_serverid ${HWDISC_FILE}
	echo ${SERVERID}
	
	# copy down datafiles based upon system id
	cp -a ${NFS_MAIN}/data_files/${SERVERID}* /TOOLKIT/

	# copy down scripts based upon system id
	cp -a ${NFS_MAIN}/scripts/${SERVERID}.sh /TOOLKIT/

	REPLY=
	echo "If you want to execute server specific "${SERVERID}" script, press <enter>"
	echo "If you want to continue toolkit w/o running server specific script, type a non-blank character and press <enter>"
	read REPLY
	if [ -z ${REPLY} ]; then
		./${SERVERID}.sh
	fi 

	sleep 1s

	# rerun hardware discovery 
	echo ""
	echo "Rerun hardware discovery"
	modprobe cciss
	sleep 1s
	./hwdisc3 -f${HWDISC_FILE}
	
	# get boot dev node from hwdisc-3.dat
	get_bootdevnode ${HWDISC_FILE} 
	echo "BOOTDEVNODE="${BOOTDEVNODE}

	make_sssd ${BOOTDEVNODE}
	clear
	ls -al /dev/sssd*
	
	OS_choice=

#	pwd
	while [ -z ${OS_choice} ]; do
	
	echo "Type [linux] for linux install"
	echo "Type [win] for windows install"
	echo "Type [bash] for bash prompt"
	echo -n "choice: "
	read OS_choice

	case ${OS_choice} in

		linux )	${TOOLKIT}/run_linux_unattended.sh ;;

		win )	${TOOLKIT}/run_windows_unattended.sh ;;
		
		bash )	exec /bin/bash ;;	

		* )	echo "you chose poorly"
			OS_choice= ;;

	esac

	done 

	echo "giving user last chance to break out before rebooting"
	read_break

	./reboot c:
else
	echo "loading cciss module"
	modprobe cciss
	echo "Skipping Server specific script"
fi

exec /bin/bash



