/***************************************************************************
* (c) Copyright 2001-2003 Hewlett-Packard Development Company, L.P.
****************************************************************************/

#ifndef _UNIXPROTO_H
#define _UNIXPROTO_H

#include "hptypes.h"

#define CMHP_INVAL  -1
#define CMHP_NOMEM  -2
#define CMHP_FAULT  -3
#define CMHP_EAGAIN -4
#define CMHP_EIO    -5

/* cmhp_ioctl.c */
ULONG cmhp_ioctl(ULONG cmd, ULONG arg);

/* vendor/cmhp_hw.c */
typedef struct _PCISTRUCTLIST *PPCISTRUCTLIST;
typedef struct _PCISTRUCTLIST
{
   PPCISTRUCTLIST pNext;       // next device
   PVOID sysdata;              // scratch pad pointer
   ULONG ulMemAddr;            // Base Addr
   PVOID pvVirtAddr;           // Virtual Addr of BaseAddr
   ULONG ulSize;               
   UCHAR ucIrq;          
   UCHAR ucBusNumber;
   UCHAR ucDeviceNumber;
   UCHAR ucFunctionNumber;
}PCISTRUCTLIST;
LONG    cmhp_function_init(PPCISTRUCTLIST);
VOID    cmhp_function_exit(VOID);
BOOLEAN cmhp_interrupt(ULONG irq);
VOID    cmhpInterruptProcessingThread(ULONG);
ULONG   cmhp_get_rebuild_rate(void);
VOID    cmhpNotifyOSHotAddMem(ULONG start, ULONG size, PVOID ranges);
VOID    cmhpChangeTopOfMemory(USHORT);
ULONG   cmhpLogEvent(ULONG alert, ULONG ulAction, PVOID *log);

/* unixmiscfuncs.c  */
ULONG   unixMemCpy(PUCHAR dest, PUCHAR src, ULONG size);
PUCHAR  unixStrCpy(PUCHAR s1, PUCHAR s2);
ULONG   unixStrLen (PUCHAR s1);
PUCHAR  unixStrCat (PUCHAR s1, PUCHAR s2);
ULONG   unixStrnCmp (PUCHAR s1, PUCHAR s2, ULONG n);
PVOID   unixMemSet (PUCHAR p, UCHAR v, ULONG n);
PVOID   unixMemZero(PVOID s, ULONG n);


/****************  DEFINES ****************************/
#ifndef max
#define max(a,b)	((a) > (b) ? (a) : (b))
#endif /* max */

#define cmhp_thread_name   "cmhpd"


#endif /* _UNIXPROTO_H */
