/*
 * (C) Copyright 2000-2005 Hewlett-Packard Development Company, L.P.
 */
#include "../CpqCiHlx.h"

//#ifdef loops_per_jiffy
//#undef loops_per_jiffy
//#endif

#if LINUX_VERSION_CODE < 0x020300
void CpqCiUSleep(unsigned long usecs)
{
	udelay(usecs);
}
#else
inline void time_stamp(unsigned long long* result)
{
	unsigned low, high;
	__asm__ volatile ("rdtsc" : "=a" (low) , "=d" (high));
	*result = ((unsigned long long) low) | ((((unsigned long long)high) << 32));
}

void CpqCiUSleep(unsigned long usecs)
{
        unsigned long long end;
        unsigned long long now;
	time_stamp(&end);
	end += (((unsigned long long)usecs * HZ) * current_cpu_data.loops_per_jiffy) >> 20; 

	do {
		time_stamp(&now);
	        schedule();
	} while ( now < end );
}
#endif
