/***************************************************************************
* (c) Copyright 2001-2003 Hewlett-Packard Development Company, L.P. 
****************************************************************************/

#ifndef _HPPROTO_H
#define _HPPROTO_H

#include "hptypes.h"

#define cmhp_modname	"cmhp"

/* cmhp.c */

/* atomic counters */
void cmph_inc_inj_err_count(ULONG mrm);
void cmph_dec_inj_err_count(ULONG mrm);
ULONG cmph_read_inj_err_count(ULONG mrm);

/* Memory Access */
PVOID cmhpMapPhys(ULONG ulPhysAddr, ULONG ulLength);
VOID  cmhpUnMapPhys(PVOID VirtAddr, ULONG size);

VOID  *cmhp_get_free_DMA_page(void);
ULONG cmhp_copy_from_user(PVOID dest, PVOID src, ULONG size);
ULONG cmhp_copy_to_user(PVOID dest, PVOID src, ULONG size);
PVOID cmhpMalloc(ULONG ulSize);
VOID  cmhpFree(PVOID pVAddr, ULONG ulSize);
ULONG cmhpGetPageSize(VOID);

/* locks */
VOID cmhp_var_lock(VOID);
VOID cmhp_var_unlock(VOID);

extern ULONG 	cmhp_rebuild_rate;
extern BOOLEAN 	cmhp_hotadd_enabled;

/*  PCI Access  */
/* Device ID for the Memory Controller */
#if !defined(PCI_VENDOR_ID_COMPAQ)
#define PCI_VENDOR_ID_COMPAQ 0xe11
#endif
#define PCI_DEVICE_ID_COMPAQ_MEMCNTL	0xb200
/* Device ID for the brigdes*/
#define SERVERWORKS_VENDOR_ID 0x1166
#define SERVERWORKS_CIOB30_DEVICE_ID 0x0010


VOID cmhpNotifyHWNewTopOfMemory(ULONG ulVendorID, ULONG ulDeviceID, ULONG addr, WORD val);

/* ISR */
VOID cmhpRegisterIRQ(ULONG irq, PVOID arg);
VOID cmhpUnRegisterIRQ(ULONG irq, PVOID arg);
VOID cmhpWakeupIntrProcessThread(VOID);
ULONG cmhpBlockIntrThread(VOID);
#define UNLOADING 1

/* Delay */
ULONG cmhpUsecWait(ULONG microsecs);

ULONG cmhpGetCurrentTimeInSec(VOID);

/* print */
void cmhpPrint(ULONG ulSev, PCHAR str, ...);
/* Severity levels */
#define CMHP_INFO     1
#define CMHP_WARNING  2
#define CMHP_ERR      3
#define CMHP_DBG      4

// notifiy the OS that the new memory is available
LONG cmhpHotAdd(ULONG start_addr, ULONG size, UCHAR flags);

// Log the event throught the health driver if it is present
//ULONG cmhpEventHandler(ULONG ulAction, ULONG ulMatchcode, ULONG ulEventNumber, PVOID pEvt);

ULONG cmhpAtomicInc(volatile PULONG int_ptr);
ULONG cmhpAtomicDec(volatile PULONG int_ptr);

ULONG cmhpIoctlGetIMLRequest(PVOID arg);
ULONG cmhpIoctlSetEventNumber(PVOID arg);



#endif /* _HPPROTO_H */
