#
# HP Insight Manager Agent 7.4.0 Installer
#
#
# *********************************************************************
# ** Global Variables that need to be modified with each release     **
# *********************************************************************
HPASM_PACKAGE="hpasm-7.4.0b-58.vmware.i386.rpm"
HPRSM_PACKAGE="hprsm-7.4.0-50.vmware.i386.rpm"
HPSMH_PACKAGE="hpsmh-2.1.2-127.vmware.i386.rpm"
UCD_SNMP_PACKAGE="ucd-snmp-cmaX-4.2.5-266.vmware.i386.rpm"
UCD_SNMP_UTILS_PACKAGE="ucd-snmp-cmaX-utils-4.2.5-266.vmware.i386.rpm"
UCD_SNMP_DEVEL_PACKAGE="ucd-snmp-cmaX-devel-4.2.5-266.vmware.i386.rpm"
UCD_SNMP_SRC_PACKAGE="ucd-snmp-cmaX-4.2.5-266.vmware.src.rpm"
CMANIC_PACKAGE="cmanic-7.4.0-7.vmware.linux.rpm"
EXPAT_PACKAGE="expat-1.95.1-7.vmware.i386.rpm"

HPASM_PACKAGE_MD5=11ff31aa031c4aecc4e1983cbc9f7b17
HPRSM_PACKAGE_MD5=7cbd6908c0f41226f2012e1ef3810629
CMANIC_PACKAGE_MD5=8d9b2422adcd8da73862717a12bd631a
UCD_SNMP_PACKAGE_MD5=d897233fadf204f5b26449aa957dbaf1
UCD_SNMP_UTILS_PACKAGE_MD5=53fb340a6b487d4892656e095483272d
UCD_SNMP_DEVEL_PACKAGE_MD5=bc9ec2136732e8a1dd6946a3f8796418
UCD_SNMP_SRC_PACKAGE_MD5=fefee5d91e49d99415e116b143e5ae81
HPSMH_PACKAGE_MD5=cea9b3da3d2ed72f766508ae765d6552
EXPAT_PACKAGE_MD5=b6d05df1bba25f48c317a3daa4d219dd

#List of ESX Server versions that this package supports
SUPPORTED_VERSIONS="2.5 2.5.1 2.5.2"

LOGFILENAME="hpmgmtlog"

SMH_PKGLIST="EXPAT_PACKAGE HPSMH_PACKAGE"
SNMP_PKGLIST="UCD_SNMP_SRC_PACKAGE UCD_SNMP_PACKAGE UCD_SNMP_UTILS_PACKAGE UCD_SNMP_DEVEL_PACKAGE"

#Only include hprsm if iLO/RILOE/RILOE2 is found
cut -f2 /proc/bus/pci/devices | grep -i "0e11b203\|80861960\|0e11005a" > /dev/null 2>&1
if [ $? -eq 0 ]; then
        AGENT_PKGLIST="HPASM_PACKAGE HPRSM_PACKAGE CMANIC_PACKAGE"
else
        AGENT_PKGLIST="HPASM_PACKAGE CMANIC_PACKAGE"
fi
AGENTLIST="cmanic cmastor hprsm hpasm"
SNMPLIST="ucd-snmp-cmaX-devel ucd-snmp-cmaX-utils ucd-snmp-cmaX"
SMHLIST="expat hpsmh"
ESXSNMPLIST="ucd-snmp-utils ucd-snmp-devel ucd-snmp"

ASMSVC=hpasm
SMHSVC=hpsmhd
SNMPSVC=snmpd
VMSNMPSVC=vmware-snmpd
SNMPPKG=ucd-snmp-cmaX
SMHPKG=hpsmh

. /etc/init.d/functions

# Set the positon  to print OK/FAILED
RES_COL=70
MOVE_TO_COL="echo -en \\033[${RES_COL}G"

SETCOLOR_BLUE="echo -en \\033[1;34m"
SETCOLOR_WHITE="echo -en \\033[0;39m"
SETCOLOR_RED="echo -en \\033[0;31m"
SETCOLOR_CYAN="echo -en \\033[0;36m"
SETCOLOR_MAGENTA="echo -en \\033[1;31m"
SETCOLOR_LIGHTRED="echo -en \\033[1;31m"
setsuccess() { 
[[ ! $SILENT ]] && echo `echo_success` || echo "....OK"
echo -e "\t[ OK ]" >> $LOGFILENAME

}
setfailure() {
[[ ! $SILENT ]] && echo `echo_failure` || echo "....FAILED"
echo -e "\t[ FAILED ]" >> $LOGFILENAME
}

splash() {
	echo " "
	if [[ ! $SILENT ]]; then $SETCOLOR_BLUE; fi
	echo "HP Insight Manager Agent 7.4.0 Installer for VMware ESX Server"
	if [[ ! $SILENT ]]; then $SETCOLOR_NORMAL; fi
	echo -e "HP Insight Manager Agent 7.4.0 Installer for VMware ESX Server" >> $LOGFILENAME
	echo " "
}

error() {
	$SETCOLOR_LIGHTRED	
	echo $1 | tee -a $LOGFILENAME
	echo -e "Check $LOGFILENAME for additional information"
	$SETCOLOR_NORMAL
}

log() {
	echo $1 >> $LOGFILENAME
}

verify_action() {
	echo "" | tee -a $LOGFILENAME
	echo "This script will now attempt to $1 the HP Insight Manager Agents" | tee -a $LOGFILENAME
	echo -n "Do you wish to continue (y/n) " | tee -a $LOGFILENAME
	read answer
	echo "$answer" >> $LOGFILENAME
	if [ "$answer" != "y" ]; then
		error "Action cancelled by user"
		exit 34
	fi
}

verify_root() {
	if [ $UID != 0 ]; then
		error "You must be logged on as 'root' to continue"
		exit 30
	fi
}
remove_from_list() {
	AGENT_PKGLIST=`echo $AGENT_PKGLIST | sed "s/$1//"`		
	SNMP_PKGLIST=`echo $SNMP_PKGLIST | sed "s/$1//"`		
	SMH_PKGLIST=`echo $SMH_PKGLIST | sed "s/$1//"`		
}
verify_pkgs() {
	echo "Verifying RPM packages:" | tee -a $LOGFILENAME
	for i in ${AGENT_PKGLIST} ${SNMP_PKGLIST} ${SMH_PKGLIST}; do
		echo -ne "\tVerifying ${!i}" | tee -a $LOGFILENAME
		if [ ! -f ${!i} ]
		then
			setfailure
			$SETCOLOR_LIGHTRED
			echo -e "Package ${!i} is missing" | tee -a $LOGFILENAME		
			$SETCOLOR_NORMAL
			exit 4 
		else
			PKGMD5=${i}_MD5
			if [ "${!PKGMD5}" = `md5sum ${!i} | awk '{print $1}'` ]; then
				setsuccess
			else
				setfailure
				$SETCOLOR_LIGHTRED
				echo -e "Package ${!i} is corrupted" | tee -a $LOGFILENAME
 				$SETCOLOR_NORMAL
				exit 4
			fi
	 	fi
	done
}

# Function that checks dependency 
check_dependency() {
	echo -en "\tChecking dependencies of $1" | tee -a $LOGFILENAME
	local PACKAGE_NAME=`rpm -qp --queryformat '%{NAME}' $1 2> /dev/null`
	`rpm -Uvh --test $1 > /dev/null 2>&1`
	if [ $? -eq 0 ]
	then
		setsuccess
		return 0
	else
		local installed_version=`rpm -q $PACKAGE_NAME|sed -e '/is not installed/d'`
		if [ -n "$installed_version" ] && ( echo $1 | grep -q $installed_version )
 		then
			setsuccess
			return 0
		else
			setfailure
			if ( rpm -Uvh --test $1 2>&1 | grep -qF "failed dependencies" ) 
			then
				$SETCOLOR_LIGHTRED	
				echo -e "Package has dependencies."
				$SETCOLOR_NORMAL
			fi
			if ( rpm -Uvh --test --nodeps $1 2>&1 | grep -qF "conflicts" ) 
			then
				$SETCOLOR_LIGHTRED	
				echo -e "This package conflicts with an installed package."
				$SETCOLOR_NORMAL
			fi
				
			$SETCOLOR_LIGHTRED	
			echo -e "Check $LOGFILENAME for additional information"
			$SETCOLOR_NORMAL
			rpm -Uv --test $1 > /dev/null 2>> $LOGFILENAME
			rpm -Uv --test --nodeps $1 > /dev/null 2>> $LOGFILENAME
			echo -e "" >> $LOGFILENAME
			return 1
		fi
	fi
}

verify_esx_version() {
	local INSTALLED_VERSION
	echo -n "Verifying VMware ESX Server version" | tee -a $LOGFILENAME
		
	if [ ! -f /usr/bin/vmware ] 
	then
		setfailure
                error "Installation can be done in VMware ESX Server only!" | tee -a $LOGFILENAME
		echo "Exiting..." >> $LOGFILENAME
                exit 31
	fi
	INSTALLED_VERSION=`vmware -v | awk '{print $4}'`
	if [ -n "$INSTALLED_VERSION" ] && ( echo $SUPPORTED_VERSIONS | grep -qF "$INSTALLED_VERSION" ) 
	then
		setsuccess
	else
		setfailure
		error "Installer does not support the VMware ESX Server version" | tee -a $LOGFILENAME
		echo "Exiting..." >> $LOGFILENAME
		exit 31
	fi
}

check_installed() {
	INSTALLEDPKGS=`rpm -q $@ | sed -e '/not installed/d'`
}

stop_agents() {
	echo "Stopping HP Insight Manager agents:" | tee -a $LOGFILENAME
	for i in $AGENTLIST; do
		rpm -qa | grep ${i} > /dev/null 2>> $LOGFILENAME
		if [ $? -eq 0 ]; then
			svc_control "\tStopping ${i}" stop $i
		fi
	done
}

stop_snmp() {
        echo -ne "Stopping SNMP stack:" | tee -a $LOGFILENAME
	pidof vmware-snmpd > /dev/null 2>> $LOGFILENAME
	if [ $? -eq 0 ]; then
		TMP=1
		echo "" | tee -a $LOGFILENAME
		svc_control "\tStopping vmware-snmpd" stop $VMSNMPSVC
	fi
	pidof snmpd > /dev/null 2>> $LOGFILENAME
	if [ $? -eq 0 ]; then
		if [ -z $TMP ]; then echo "" | tee -a $LOGFILENAME ; else TMP=1; fi
		svc_control "\tStopping snmpd" stop $SNMPSVC
	fi
	[ -z $TMP ] && setsuccess
}

stop_smh() {
	check_installed hpsmh
	[[ $INSTALLEDPKGS ]] && svc_control "Stopping System Management Homepage" stop $SMHSVC
	# Make sure SMH is really stopped and all files are cleaned up
	# Wait for up to 30 sec for SMH to stop gracefully
	unset STOPPED
	for i in `seq 1 6`; do 
		echo "Waiting for SMH to stop" >> $LOGFILENAME
		if [ -f /opt/hp/hpsmh/logs/httpd.pid ]; then
			echo "SMH not stopped yet...sleeping for 5" >> $LOGFILENAME
			sleep 5
		else	
			STOPPED=1
			echo "SMH is now stopped" >> $LOGFILENAME
			break
		fi
	done
	# Are we still not stopped?
	if [[ ! $STOPPED ]]; then  
		echo "Forcing shutdown of SMH" >> $LOGFILENAME
		[ -f /opt/hp/hpsmh/logs/httpd.pid ] && rm -f /opt/hp/hpsmh/logs/httpd.pid
		killall -9 hpsmhd >> $LOGFILE 2>&1
	fi
	[ -f /var/lock/subsys/hpsmhd ] && rm -f /var/lock/subsys/hpsmhd

}

start_snmp() {
        echo "Starting SNMP stack:" | tee -a $LOGFILENAME
	svc_control "\tStarting snmpd" start $SNMPSVC
	ls /etc/rc3.d/S*vmware-snmpd > /dev/null 2>> $LOGFILENAME
	if [ $? -eq 0 ]; then
		svc_control "\tStarting vmware-snmpd" start $VMSNMPSVC
	fi
}

remove_packages() {
	echo -n "$1:" | tee -a $LOGFILENAME
	shift
	check_installed $@
	if [ -z "$INSTALLEDPKGS" ]; then
		setsuccess
	else
		echo " " | tee -a $LOGFILENAME
		for i in $INSTALLEDPKGS; do
			echo -ne "\tRemoving ${i}: " | tee -a $LOGFILENAME
                	rpm -e --nodeps ${i} >> $LOGFILENAME 2>&1
                	if [ $? -eq 0 ]; then
                	        setsuccess
                	else
                	        setfailure
                	        error "Unable to remove ${i}"
                	fi
                done
        fi
}

#Function that installs packages
install_packages() {
	local PACKAGE_NAME
	echo "$1:" | tee -a $LOGFILENAME
	shift
	for i in $@; do
#		check whether this is a src rpm . If it is then install it.	
		if ( echo ${!i} | grep -q "src.rpm" ) ; then
			echo -ne "\tInstalling ${!i}" | tee -a $LOGFILENAME
                        echo "" >> $LOGFILENAME
                        rpm -ivh ${!i} >> $LOGFILENAME 2>&1
                        if [ $? -eq 0 ]; then
                                setsuccess
                        else
                                setfailure
                        fi
                        echo "" >> $LOGFILENAME
		else
#	 		Find out the Package name 
			PACKAGE_NAME=`rpm -qp --queryformat '%{NAME}' ${!i} 2> /dev/null`
# 			Check whether an old version of the package is already installed
			check_installed $PACKAGE_NAME
			if [ -z "$INSTALLEDPKGS" ]; then
				check_dependency ${!i}
				if [ $? -eq 0 ] 
				then
					echo -ne "\tInstalling ${!i}" | tee -a $LOGFILENAME
					echo "" >> $LOGFILENAME
        				rpm -ivh ${!i} >> $LOGFILENAME 2>&1
					if [ $? -eq 0 ]; then
	        	                	setsuccess
    		        	        else
                	        		setfailure
					fi
					echo "" >> $LOGFILENAME
				elif [ ! $SILENT ]
				then
					echo -en "Do you want to force the installation of the package ${!i} (y/n)? " | tee -a $LOGFILENAME
					read choice 
					echo  "$choice" >> $LOGFILENAME
					if [ "$choice" = "y" ]
					then
				     		echo -ne "\tInstalling ${!i}" | tee -a $LOGFILENAME
						echo "" >> $LOGFILENAME
 			                        rpm -ivh --force --nodeps ${!i} >> $LOGFILENAME 2>&1
                    				if [ $? -eq 0 ]; then
		      			               	setsuccess
	                  			else
			        	            	setfailure
						fi
					fi
					echo "" >> $LOGFILENAME
				else
					$SETCOLOR_LIGHTRED
					echo "${!i} can't be installed" | tee -a $LOGFILENAME
					$SETCOLOR_NORMAL
					echo "" >> $LOGFILENAME
				fi
	  	        else
				if ( grep -q $INSTALLEDPKGS ${!i} )
				then	
		              		echo -e "\tPackage ${!i} is already installed" | tee -a $LOGFILENAME
					[[ "$PACKAGE_NAME" = "$SNMPPKG" ]] && SNMP_RECONF=1	
					[[ "$PACKAGE_NAME" = "$SMHPKG" ]] && SMH_RECONF=1	
				else
					local pkg=`rpm -qp ${!i}`
					if ( rpm -Uvh --test --nodeps ${!i} 2>&1 | grep -q "package $INSTALLEDPKGS (which is newer than $pkg) is already installed" )
					then
						echo -e "\tPackage $INSTALLEDPKGS (which is newer than $pkg) is already installed" | tee -a $LOGFILENAME
						[[ "$PACKAGE_NAME" = "$SNMPPKG" ]] && SNMP_RECONF=1	
						[[ "$PACKAGE_NAME" = "$SMHPKG" ]] && SMH_RECONF=1	
					else
						echo -e "\tFound an older package ${INSTALLEDPKGS}" | tee -a $LOGFILENAME
						echo -en "\tUpgrading to `echo ${!i} |sed -e 's/\.rpm$//'` :\n\t" | tee -a $LOGFILENAME 
						[[ "$PACKAGE_NAME" = "$SNMPPKG" ]] && SNMP_RECONF=1	
						[[ "$PACKAGE_NAME" = "$SMHPKG" ]] && SMH_RECONF=1	
						check_dependency ${!i}
						if [ $? -eq 0 ]
						then
							echo -en "\t\tUpgrading to ${!i} " | tee -a $LOGFILENAME
							echo "" >> $LOGFILENAME
							rpm -Uvh ${!i} >> $LOGFILENAME 2>&1
					                if [ $? -eq 0 ]; then
        		        		             setsuccess
  	        		        		else
	                		        	     setfailure
							fi
							echo "" >> $LOGFILENAME
						elif [ ! $SILENT ]
						then
	        	                             	echo -n "Do you want to force the upgrading of $PACKAGE_NAME (y/n)? " | tee -a $LOGFILENAME
        	        	                     	read choice
							echo "$choice" >> $LOGFILENAME
                        		             	if [ "$choice" = "y" ]
                                		     	then
                                        			echo -ne "\tUpgrading ${!i}" | tee -a $LOGFILENAME
								echo "" >> $LOGFILENAME
	                	        	                rpm -Uvh --force --nodeps ${!i} >> $LOGFILENAME 2>&1
        	                	                	if [ $? -eq 0 ]; then
                	                	                	setsuccess
	                	                	        else
        	                	                	        setfailure
		                	                        fi
							fi
							echo "" >> $LOGFILENAME
						else
							$SETCOLOR_LIGHTRED
							echo "${PACKAGE_NAME} can't be upgraded" | tee -a $LOGFILENAME
							$SETCOLOR_NORMAL
							echo "" >> $LOGFILENAME
	               		        	fi
                        		fi
				fi
			fi
		fi
	done
}

restore_snmp() {
	echo -n "Restoring VMware snmpd configuration:"
	echo "Restoring VMware snmpd configuration:" >> $LOGFILENAME
	/usr/sbin/snmpsetup.sh restore | sed 's/\[[0-9]*;\?[0-9]*[Gm]//g' >> $LOGFILENAME 2>&1
	if [[ $? != 0 ]]; then
        	setfailure
        	error "Unable to restore VMware SNMP configuration"
		return 99
        fi
        # Restore snmpsetup script
        if [ -e /usr/sbin/snmpsetup.prehp ]; then
        	mv -f /usr/sbin/snmpsetup.prehp /usr/sbin/snmpsetup.sh
        	if [[ $? != 0 ]]; then
		       	setfailure
		       	error "Unable to restore snmpsetup.sh script"
			return 99
		fi
	fi
	setsuccess
}

configure_vmwaresnmp() {
	if [[ ! $SILENT ]]; then
		#Check to see if subagent is enabled
		ls /etc/rc3.d/S*vmware-snmpd > /dev/null 2>> $LOGFILENAME 
		if [ $? -eq 0 ]; then
			ENABLEVMSNMP="Y"
		else
			echo "==============================================================================" | tee -a $LOGFILENAME
			echo "The VMware SNMP Sub-agent is currently disabled.  The sub-agent must be" | tee -a $LOGFILENAME
			echo "enable in order to see VMware SNMP information." | tee -a $LOGFILENAME
			echo "==============================================================================" | tee -a $LOGFILENAME
			echo "" | tee -a $LOGFILENAME
			echo -ne "Would you like to enable it now (y/n)? " | tee -a $LOGFILENAME
			read ENABLEVMSNMP
			echo -e "$ENABLEVMSNMP\n" >> $LOGFILENAME
		fi
		echo "" | tee -a $LOGFILENAME
		echo -ne "Do you want to enable SNMP traps for virtual machine events (y/n)? " | tee -a $LOGFILENAME
		read ENABLEVMTRAPS 
		echo -e "$ENABLEVMTRAPS\n" >> $LOGFILENAME
		echo ""
		SNMPCONFLOC=1
	fi
	perl -ni -e 'print unless (/^serverd.snmpdconf/||/^snmp.enable/||/^\n/)' /etc/vmware/config
	if [[ $ENABLEVMSNMP = "Y" || $ENABLEVMSNMP = "y" ]]; then
		chkconfig --level 2345 vmware-snmpd on
		echo "serverd.snmpdconf.subagentenabled = \"TRUE\"" >> /etc/vmware/config
	else
		service vmware-snmpd status | grep running >> $LOGFILENAME 2>&1
		if [ $? -eq 0 ]; then
			service vmware-snmpd stop >> $LOGFILENAME 2>&1
		fi
		chkconfig --level 2345 vmware-snmpd off >> $LOGFILENAME 2>&1
		echo "serverd.snmpdconf.subagentenabled = \"FALSE\"" >> /etc/vmware/config
	fi

	echo -n "Linking vmware-snmpd to the ucd-snmp-cmaX daemon" | tee -a $LOGFILENAME
	# Need to edit snmpsetup.sh script from VMware to account for cmaX in snmp pkg
	cp /usr/sbin/snmpsetup.sh /usr/sbin/snmpsetup.prehp
	if [[ $? != 0 ]]; then
		setfailure
		error "Could not make backup of snmpsetup.sh script" 
		return 99
	fi
/usr/bin/perl -pi -e 's/=\$CONSNMPD/=`echo \$CONSNMPD \| sed -e \"s\/-4\/\\\\(-cmaX\\\\)\\\\?-4\/g\"`/g' /usr/sbin/snmpsetup.sh
        /usr/bin/perl -pi -e 's/grep \$mainsnmpd/grep -E \$mainsnmpd/g' /usr/sbin/snmpsetup.sh
	echo -e ":\nExecuting \`snmpsetup.sh connect\`" >> $LOGFILENAME 
	/usr/sbin/snmpsetup.sh connect <<EOT >> $LOGFILENAME 2>&1
$ENABLEVMTRAPS
$SNMPCONFLOC
EOT
	if [ $? -eq 0 ]; then
		setsuccess
		echo "" >> $LOGFILENAME
	else
		setfailure
		error "There was a problem linking the snmpd daemons"
		return 14
	fi
}

configure_hpasm() {
	
	echo -n "HP Advanced Server Management configuration:" | tee -a $LOGFILENAME
	if [ ! -f /opt/compaq/hpasm/etc/hpasm ]
	then
		setfailure
		echo "/opt/compaq/hpasm/etc/hpasm: No such file or directory" >> $LOGFILENAME
		error "HP Advanced Server Management configuration failed"
		return 99
	fi
	if [ ! -e /sbin/hpasm ]
	then
        	echo -en "\nDo you want to reconfigure hpasm (y/n)? " | tee -a $LOGFILENAME
		read choice
                echo  "$choice" >> $LOGFILENAME
                if [ "$choice" = "y" ]
                then
			/opt/compaq/hpasm/etc/hpasm reconfigure
			if [ $? -eq 0 ]; then
				setsuccess
			else
				setfailure
				error "HP Advanced Server Management configuration failed"
				return 99
			fi
		fi
	else		
		/opt/compaq/hpasm/etc/hpasm activate
		if [ $? -eq 0 ]; then
			setsuccess
		else
			setfailure
			error "HP Advanced Server Management configuration failed"
			return 99
		fi
	fi
}

configure_hpsmh() {

	if [ -e ./smhpd.xml ]; then
		log "Found SMH configuration file...copying"
		echo -n "Copying SMH configuration"
		cp ./smhpd.xml /opt/hp/hpsmh/conf/smhpd.xml
		if [ $? -eq 0 ]; then
			SMHAUTOCONF=1
			setsuccess
		else
			setfailure
			error "HP System Management Homepage configuration failed"
		fi
	else
		echo "SMH Configuration file not found...no action taken" >> $LOGFILENAME
	fi
}

svc_control() {
	echo -ne "$1:" | tee -a $LOGFILENAME
	service $3 $2 > /dev/null 2>> $LOGFILENAME
        if [ $? -eq 0 ]; then
		setsuccess
		return 0
	else
		setfailure
		error "Unable to ${2} ${3}"
	fi

}

post_splash() {
	case "$1" in
	
	install)
	
	if [[ -z $SMHAUTOCONF ]]; then
		echo "**********************************************************" | tee -a $LOGFILENAME 
		echo "* System Management Homepage installed successfully with *" | tee -a $LOGFILENAME
		echo "* default configuration values.   To change the default  *" | tee -a $LOGFILENAME
		echo "* configuration values,  type the following command at   *" | tee -a $LOGFILENAME
		echo "* the root prompt:                                       *" | tee -a $LOGFILENAME
		echo "*                                                        *" | tee -a $LOGFILENAME
		echo "* perl /usr/local/hp/hpSMHSetup.pl                       *" | tee -a $LOGFILENAME
		echo "*                                                        *" | tee -a $LOGFILENAME
		echo "**********************************************************" | tee -a $LOGFILENAME
	fi
	echo "Please read the Licence Agreement for this software at"  | tee -a $LOGFILENAME
	echo "" | tee -a $LOGFILENAME
	echo "/opt/compaq/hpasm/hpasm.license" | tee -a $LOGFILENAME
	echo " " | tee -a $LOGFILENAME
	echo "By not removing this package, you are accepting the terms" | tee -a $LOGFILENAME
	echo -e "of the \"License for HP Value Added Software\"." | tee -a $LOGFILENAME
	;;
	esac

	echo "" | tee -a $LOGFILENAME
	echo "HP Insight Manager agents have been ${1}ed successfully!" | tee -a $LOGFILENAME
	echo "" | tee -a $LOGFILENAME

}

install() {
	splash
	[[ ! $SILENT ]] && verify_action "install"
	echo "" | tee -a $LOGFILENAME
	verify_esx_version
	echo "" | tee -a $LOGFILENAME
	verify_pkgs
	echo "" | tee -a $LOGFILENAME
	stop_snmp
	echo "" | tee -a $LOGFILENAME
#	Remove SNMP packages that comes with ESX as they conflict with HP SNMP packages
	remove_packages "Removing SNMP stack that comes with ESX Server" $ESXSNMPLIST
	echo "" | tee -a $LOGFILENAME
	install_packages "Installing SNMP stack with cmaX extenstions" $SNMP_PKGLIST
	echo "" | tee -a $LOGFILENAME
	install_packages "Installing HP System Management Homepage" $SMH_PKGLIST
	if [ $SILENT ] 
	then 
		configure_hpsmh
	elif [ -n "$SMH_RECONF" ] ; then
		echo ""
		echo -en "Do you want to reconfigure HPSMH (y/n)? " | tee -a $LOGFILENAME
		read choice
		echo "$choice" >> $LOGFILENAME
		if [ "$choice" = "y" ] ; then
		perl /usr/local/hp/hpSMHSetup.pl
		fi
	fi
	echo ""
	install_packages "Installing HP Management Agents" $AGENT_PKGLIST
	if [ -n "$SNMP_RECONF" ] && [ ! $SILENT ] ; then
		echo -en "\nDo you want to reconfigure SNMP (y/n)? " | tee -a $LOGFILENAME
		read choice
		echo "$choice" >> $LOGFILENAME
		if [ "$choice" = "y" ] ; then
			configure_vmwaresnmp
		fi
	else	
		configure_vmwaresnmp
	fi
	echo "" | tee -a $LOGFILENAME
	[[ ! $SILENT ]] && configure_hpasm
	echo "" | tee -a $LOGFILENAME
	stop_agents
	echo "" | tee -a $LOGFILENAME
	stop_smh
	echo "" | tee -a $LOGFILENAME
	stop_snmp
	echo "" | tee -a $LOGFILENAME
	start_snmp
	echo "" | tee -a $LOGFILENAME
	svc_control "Starting System Management Homepage" start $SMHSVC 
	echo "" | tee -a $LOGFILENAME
	svc_control "Starting HP Insight Manager agents" start $ASMSVC
	echo "" | tee -a $LOGFILENAME
	post_splash install
}

uninstall() {
	splash
	verify_action "remove"
	echo "" | tee -a $LOGFILENAME
	verify_esx_version
	echo "" | tee -a $LOGFILENAME
	stop_agents
	echo "" | tee -a $LOGFILENAME
	stop_smh
	echo "" | tee -a $LOGFILENAME
	stop_snmp
	echo "" | tee -a $LOGFILENAME
	remove_packages "Removing HP Insight Manager agents" $AGENTLIST
	echo "" | tee -a $LOGFILENAME
	remove_packages "Removing HP System Management Homepage" $SMHLIST
	echo "" | tee -a $LOGFILENAME
	remove_packages "Removing SNMP stack" $SNMPLIST
	echo "" | tee -a $LOGFILENAME
	restore_snmp
	echo "" | tee -a $LOGFILENAME
	post_splash uninstall
}

usage() {
	splash
	echo "Usage:"
	echo ""
	echo "${0} {--install|--uninstall|--silent} [--inputfile filename]" 
	echo ""
	echo -e "--install:"
	echo -e "\tThis will attempt to install version 7.40 of the HP Insight"
	echo -e "\tManager Agents.  Any previous versions of the agents will"
	echo -e "\tbe upgraded to the latest versions."
	echo ""
	echo -e "--uninstall:"
	echo -e "\tThis will attempt to unistall the HP Insight Manager Agents"
	echo -e "\tfrom your sytem. You must be running versions 6.40 or"
	echo -e "\tlater. Versions prior to 6.40 must be uninstalled"
	echo -e "\tmanually."
	echo ""
	echo -e "--silent"
	echo -e "\tThis will attempt a silent installation of the HP Insight"
	echo -e "\tManager Agents.  Any previous versions of the agents will"
	echo -e "\tbe upgraded to the latest versions. This option"
	echo -e "\talso requires the '--inputfile' option where filename points"
	echo -e "\tto the configuration file that contain your settings."
	echo -e "\tPlease see the readme and the hpmgmt.conf.example file for"
	echo -e "\tmore details" 
	exit 20
}

# START MAIN
verify_root
echo -e "\n**********`date`**********\n" >> $LOGFILENAME
case "$1" in
	--silent)
	SILENT=1
	if [ "$2" != "--inputfile" ]; then
		usage
	fi
	if [ ! -e "$3" ]; then
		echo $3
		echo "Input file does not exist!"
		exit 20;
	else
		. $3
	fi
	install
	;;
	--install)
	install
	;;
	--remove|--uninstall)
	uninstall
	;;
	*)
	usage
	;;
esac

exit 0
