#!/bin/bash
# ##################################################################
# ### copyright 2003 Compaq Information Technologies Group, L.P. ###
# ##################################################################

# ********************************************************
# ** log_msg                                            **
# ********************************************************
# ** This routine will log a message to the screen and  **
# ** to our error log.                                  **
# ********************************************************
function log_msg() {
   echo "$*" >> /opt/compaq/cmhp/cmhp_boot.log 
   echo "$*"
}


# ********************************************************
# ** MAIN                                               **
# ********************************************************
# ** This is the main routine of the shell script       **
# ********************************************************
MY_DATE=`date`
THIS_KERNEL=`uname -r`
DIR=/opt/compaq/cmhp/bin/${THIS_KERNEL}
CMHP=${DIR}/cmhp.o


log_msg "Loading ${CMHP} at ${MY_DATE} . . ."
log_msg "Reloading the hp ProLiant Memory Hot Plug Driver module . . ."
if eval "insmod -p ${CMHP}" >>/opt/compaq/cmhp/cmhp_boot.log 2>&1
then 
	/sbin/insmod ${CMHP} >>/opt/compaq/cmhp/cmhp_boot.log 2>&1
	if [ $? -eq 0 ]; then
		log_msg " "
		log_msg "The hp ProLiant Advanced Server Management module (cmhp.o)"
		log_msg "has loaded successfully."
		log_msg " "
	else
		log_msg " "
		log_msg "The hp ProLiant Advanced Server Management module (cmhp.o) "
		log_msg "failed to load, possibly because no hotplug memory device is present."
		log_msg " "
	fi
	exit 0 
else
	echo -e "\n"
	log_msg "WARNING!  The hpasm RPM is not compatible with this kernel."
	log_msg "          See /opt/compaq/cmhp/cmhp_boot.log for details."
	log_msg "          Hint:  Look for Compiler or Linker issues."
	exit 1 
fi

