#!/usr/bin/perl

# Not available on SLES9
#use LWP::Simple ;

&runConfig ;

sub runConfig {
   my $rc ;

   &InitXMLFile ;
   &Intro ;

GROUPINPUT:
   &GroupInput ;

USERACCESS:
   $rc = &UserAccess ;
   if (($rc eq 'p') || ($rc eq 'P')) {
      goto GROUPINPUT ;
   }

TRUSTMODE:
   $rc = &TrustMode ;
   if (($rc eq 'p') || ($rc eq 'P')) {
      goto USERACCESS ;
   }

IPBINDING:
   $rc = &IPBinding ;
   if (($rc eq 'p') || ($rc eq 'P')) {
      goto  TRUSTMODE ;
   }

   $rc = &IPRestrictedLogins ;
   if (($rc eq 'p') || ($rc eq 'P')) {
      goto IPBINDING ;
   }
}

sub InitXMLFile {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;
   my $INIFile  = "/var/spool/compaq/wbem/homepage/cpqhmmd.ini" ;
   my $INIXFile = "/var/spool/compaq/wbem/homepage/cpqhmmdx.ini" ;
   my $status ;
   my $tempEntry ;

   my $admgroup="" ;
   my $oprgroup="" ;
   my $usrgroup="" ;
   my $admlogin="true" ;
   my $anonacc="false" ;
   my $localacc="false" ;
   my $localtype="Anonymous" ;
   my $trustmode="TrustByCert" ;
   my $certlst="" ;
   my $xenamelst="" ;
   my $ipbind="False" ;
   my $ipbindlst="" ;
   my $iprestrct="False" ;
   my $iprestrctinc="" ;
   my $iprestrctexc="" ;


   $status = open FILE, $XMLSmhpd ;
   close FILE ;

   if (!$status) {

      $status = open FILE, $INIFile ;
      close FILE ;
      if ($status) {
         
         # Copy existing CHP cert files...
         #
         system("cp -f /var/spool/compaq/wbem/file.pem /opt/hp/sslshare");
         system("cp -f /var/spool/compaq/wbem/cert.pem /opt/hp/sslshare");
         system("cp -f /var/spool/compaq/wbem/certs/* /opt/hp/hpsmh/certs");

         $tempEntry = &GetINIData ($INIFile, "AnonymousAccess") ;
         if ($tempEntry ne "") {
             $anonacc = $tempEntry ;
         }
      }

      $status = open FILE, $INIXFile ;
      close FILE ;
      if ($status) {
         $tempEntry = &GetINIData ($INIXFile, "LocalAccessEnabled") ;
         if ($tempEntry ne "") {
            $localacc = $tempEntry ;
         }

         $tempEntry = &GetINIData ($INIXFile, "LocalAccessType") ;
         if ($tempEntry ne "") {
            $localtype = ucfirst $tempEntry ;
         }

         $tempEntry = &GetINIData ($INIXFile, "TrustMode") ;
         if ($tempEntry ne "") {
            $trustmode = $tempEntry ;
         }

         $tempEntry = &GetINIData ($INIXFile, "XENameList") ;
         if ($tempEntry ne "") {
            $xenamelst = $tempEntry ;
         }

         $tempEntry = &GetINIData ($INIXFile, "IPRestriction") ;
         if ($tempEntry ne "") {
            $iprestrct = $tempEntry ;
         }

         $tempEntry = &GetINIData ($INIXFile, "AdministratorIPInclude") ;
         if ($tempEntry ne "") {
            $tempEntry = &GetINIData ($INIXFile, "AdministratorIPInclude") ;
         }

         $tempEntry = &GetINIData ($INIXFile, "AdministratorIPExclude") ;
         if ($tempEntry ne "") {
            $iprestrctexc = &GetINIData ($INIXFile, "AdministratorIPExclude") ;
         }
      }

      print "   Writing a new $XMLSmhpd file\n" ;
      open FILE, ">$XMLSmhpd" ;

      print FILE "<\?xml version=\"1.0\" encoding=\"UTF-8\"\?>\n" ;
      print FILE "<system-management-homepage>\n" ;
      print FILE "  <admin-group>$admgroup</admin-group>\n" ;
      print FILE "  <operator-group>$oprgroup</operator-group>\n" ;
      print FILE "  <user-group>$usrgroup</user-group>\n" ;
      print FILE "  <allow-default-os-admin>$admlogin</allow-default-os-admin>\n" ;
      print FILE "  <anonymous-access>$anonacc</anonymous-access>\n" ;
      print FILE "  <localaccess-enabled>$localacc</localaccess-enabled>\n" ;
      print FILE "  <localaccess-type>$localtype</localaccess-type>\n" ;
      print FILE "  <trustmode>$trustmode</trustmode>\n" ;
      print FILE "  <xenamelist>$xenamelst</xenamelist>\n" ;
      print FILE "  <ip-binding>$ipbind</ip-binding>\n" ;
      print FILE "  <ip-binding-list>$ipbindlst</ip-binding-list>\n" ;
      print FILE "  <ip-restricted-logins>$iprestrct</ip-restricted-logins>\n" ;
      print FILE "  <ip-restricted-include>$iprestrctinc</ip-restricted-include>\n" ;
      print FILE "  <ip-restricted-exclude>$iprestrctexc</ip-restricted-exclude>\n" ;
      print FILE "</system-management-homepage>\n" ;

      close FILE ;
   }

}

sub Intro {
   my $input ;

   print "-------------------------------------------------------------------------------
   Welcome to the Setup Wizard for the HP System Management HomePage 2.0.0

   The Setup Wizard will install the HP System Management HomePage 2.0.0 on
   your computer.

   On the following screens, you will configure security and access parameters
   for the HP System Management HomePage and related HP web-based management
   tools (e.g. Insight Management Agents, Version Control Agents, Diagnostics).

   HP System Management HomePage 2.0.0
   Hewlett-Packard Company
   www.hp.com\n\n" ;

   print "Press ENTER to continue." ;

   $input = <STDIN> ;
}

sub GroupInput {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;
   my @AdminGroup ;
   my @OperatorGroup ;
   my @UserGroup ;

   @AdminGroup    = &GetXMLArrayData ($XMLSmhpd, "admin-group") ;
   @OperatorGroup = &GetXMLArrayData ($XMLSmhpd, "operator-group") ;
   @UserGroup     = &GetXMLArrayData ($XMLSmhpd, "user-group") ;

   do {
   my $Group ;

   print "-------------------------------------------------------------------------------
   Operating System Groups

   Select 'Add' to add an Operating System (OS) Group Name to one of the OS
   Group Lists (up to 5 entries per group) or 'Delete' to delete a name from
   a list. When you have completed your additions and deletions,
   select 'n' below.\n\n" ;

   &PrintGroup ("Administrator", @AdminGroup) ;
   &PrintGroup ("Operator", @OperatorGroup) ;
   &PrintGroup ("User", @UserGroup) ;

   print "
   Modify Group Lists
   ------------------
   1 - Add Groups
   2 - Delete Groups
      
   n - next\n\n" ;

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key ne 'n') && ($key ne 'N')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      (*AdminGroup, *OperatorGroup, *UserGroup) = &AddGroup (\@AdminGroup, \@OperatorGroup, \@UserGroup) ;
   }

   if ($key == '2') {
      (*AdminGroup, *OperatorGroup, *UserGroup) = &DeleteGroup (\@AdminGroup, \@OperatorGroup, \@UserGroup) ;
   }

   } until (($key eq 'n') || ($key eq 'N')) ;

   $key = '0' ;

   &PutXMLArrayData ($XMLSmhpd, "admin-group"   , @AdminGroup) ;
   &PutXMLArrayData ($XMLSmhpd, "operator-group", @OperatorGroup) ;
   &PutXMLArrayData ($XMLSmhpd, "user-group"    , @UserGroup) ;

}

sub AddGroup {
   local (*Admin, *Oper, *User) = @_ ;
   my $key ;
   my $input ;
   my $error ;

   print "\n-------------------------------------------------------------------------------\n" ;
   print "Add Operating System Groups\n\n" ;

   $error = "" ;

   do {

   &PrintGroup ("Administrator", @Admin) ;
   &PrintGroup ("Operator",      @Oper) ;
   &PrintGroup ("User",          @User) ;

   print "
   1 - Administrator
   2 - Operator
   3 - User
   
   n - next\n\n" ;

   if ($error ne "") {
      print "$error" ;
   }

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key != '3') && ($key ne 'n') && ($key ne 'N')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;
   
   if ($key == '1') {
      if (scalar (@Admin) < 5) {
         $error = "" ;

         print "\n   Enter the name of an Operating System (OS) Group that you wish to assign to\n" ;
         print "   the Administrator Group List: " ;
         $input = <STDIN> ;
         chomp ($input) ;

         if (length ($input) > 32) {
            $error = "\n   The Group Name exceeds 32 characters\n\n" ;
         } 

         if (($input eq "") || (!($input=~/[A-Za-z0-9]+/))) {
            $error = "\n   A blank value is not a valid Group Name!\n\n";
         }
         
         if ($input =~ m/([~\`@#\$\%^&\*();+=\":'<>?,|])/) {
            $error = "\n   The Group Name $input contains the illegal character << $1 >>\n\n" ;
         }

         if ($error eq "") {
            (*Admin) = &addArrayElement ($input, \@Admin) ;
            $error = "" ;
         }

      } else {
         $error = "   The limit of 5 Administrator Groups has been reached\n\n" ;
      }
   }

   if ($key == '2') {
      if (scalar (@Oper) < 5) {
         $error = "" ;

         print "\n   Enter the name of an Operating System (OS) Group that you wish to assign to\n" ;
         print "   the Operator Group List: " ;
         $input = <STDIN> ;
         chomp ($input) ;

         if (length ($input) > 32) {
            $error = "\n   The Group Name exceeds 32 characters\n\n" ;
         } 

         if (($input eq "") || (!($input=~/[A-Za-z0-9]+/))) {
            $error = "\n   A blank value is not a valid Group Name!\n\n";
         }
            
         if ($input =~ m/([~\`@#\$\%^&\*();+=\":'<>?,|])/) {
            $error = "\n   The Group Name $input contains the illegal character << $1 >>\n\n" ;
         }

         if ($error eq "") {
            (*Oper) = &addArrayElement ($input, \@Oper) ;
            $error = "" ;
         }

      } else {
         $error = "   The limit of 5 Operator Groups has been reached\n\n" ;
      }
   }

   if ($key == '3') {
      if (scalar (@User) < 5) {
         $error = "" ;

         print "\n   Enter the name of an Operating System (OS) Group that you wish to assign to\n" ;
         print "   the User Group List: " ; 
         $input = <STDIN> ;
         chomp ($input) ;

         if (length ($input) > 32) {
            $error = "\n   The Group Name exceeds 32 characters\n\n" ;
         } 

         if (($input eq "") || (!($input=~/[A-Za-z0-9]+/))) {
            $error = "\n   A blank value is not a valid Group Name!\n\n";
         }
            
         if ($input =~ m/([~\`@#\$\%^&\*();+=\":'<>?,|])/) {
            $error = "\n   The Group Name $input contains the illegal character << $1 >>\n\n" ;
         }

         if ($error eq "") {
            (*User) = &addArrayElement ($input, \@User) ;
            $error = "" ;
         }

      } else {
         $error = "   The limit of 5 User Groups has been reached\n\n" ;
      }
   }

   } until (($key eq 'n') || ($key eq 'N')) ;

   return (\@Admin, \@Oper, \@User) ;

   $key = '0' ;

}

sub DeleteGroup {
   local (*Admin, *Oper, *User) = @_ ;
   my $key ;
   my $input ;

   print "\n-------------------------------------------------------------------------------\n" ;
   print "Delete Operating System Groups\n\n" ;

   do {

   &PrintGroup ("Administrator", @Admin) ;
   &PrintGroup ("Operator",      @Oper) ;
   &PrintGroup ("User",          @User) ;

   print "
   1 - Administrator
   2 - Operator
   3 - User
   
   n - next\n\n" ;

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key != '3') && ($key ne 'n') && ($key ne 'N')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      (*Admin) = &DeleteGroupEntries ("Administrator", \@Admin) ;
   }

   if ($key == '2') {
      (*Oper) = &DeleteGroupEntries ("Operator", \@Oper) ;
   }

   if ($key == '3') {
      (*User) = &DeleteGroupEntries ("User", \@User) ;
   }

   } until (($key eq 'n') || ($key eq 'N')) ;

   $key = '0' ;

   return (\@Admin, \@Oper, \@User) ;

}

sub DeleteGroupEntries {
   local ($name, *group) = @_ ;
   my $input ;
   my $count ;

   do {
   &PrintGroup ($name, @group) ;

   $count = scalar (@group) ;

   print "
   Enter the number of the $name Group to delete,
   or ENTER when you are finished: " ;

   $input = <STDIN> ;

   if (($input > '0') && ($input <= $count)) {
      splice (@group, ($input - 1), 1) ;
   }

   } until $input == '0' ;

   return (\@group) ;

}

sub PrintGroup {
   my ($title, @GroupMembers) = @_ ;
   my $groupCount ;


   print "\n   $title Group List\n   ---------------\n" ;
   $groupCount = 1 ;
   if (scalar (@GroupMembers) > '0') {
      my $Group ;

      foreach $Group (@GroupMembers) {
         print "   $groupCount) $Group\n" ;
         $groupCount++ ;
      }
   } else {
      print "   ***empty list***\n" ;
   }
}

sub UserAccess {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;

   my $anonAccess      ;
   my $localAccess     ;
   my $localAccessType ;

   $anonAccess      = &GetXMLData ($XMLSmhpd, "anonymous-access") ;
   $localAccess     = &GetXMLData ($XMLSmhpd, "localaccess-enabled") ;
   $localAccessType = &GetXMLData ($XMLSmhpd, "localaccess-type") ;

   print "-------------------------------------------------------------------------------\n" ;
   print "User Access\n\n" ;

   print "
   Anonymous Access: Allow Anonymous users access to unsecured pages.
   Please note that this includes local users.\n\n" ;
   print "
   Local Access: Setup the System Management HomePage to automatically
   configure local IP addresses as part of the selected group. This means
   that any user with access to the local console will be granted full
   accesss if Administrator is selected, without being challenged for a
   username and password.\n\n" ;

   do {
   &printUserAccessSettings ($anonAccess, $localAccess, $localAccessType) ;

   print "
   Set Anonymous Access:
   -------------------------
   1 - Anonymous Access True
   2 - Anonymous Access False

   Set Local Access
   ------------------------------
   3 - Disable Local Access
   4 - Local Access Anonymous     - Restricted access to unsecure pages
   5 - Local Access Administrator - Grant full access to secure and
                                        unsecured pages
       
   p - previous
   n - next\n\n" ;

   print "Select an optional access methods to modify the Current Settings. " ;

   $key = '0' ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') &&
           ($key != '2') &&
           ($key != '3') &&
           ($key != '4') &&
           ($key != '5') &&
           ($key ne 'n') &&
           ($key ne 'N') &&
           ($key ne 'p') &&
           ($key ne 'P')
           ) { } ;

   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      $anonAccess = "True" ;
   }

   if ($key == '2') {
      $anonAccess = "False" ;
   }

   if ($key == '3') {
      $localAccess = "False" ;
   }

   if ($key == '4') {
      $localAccess     = "True" ;
      $localAccessType = "Anonymous" ;
   }

   if ($key == '5') {
      $localAccess     = "True" ;
      $localAccessType = "Administrator" ;
   }

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   &PutXMLData ($XMLSmhpd, "anonymous-access"   , $anonAccess) ;
   &PutXMLData ($XMLSmhpd, "localaccess-enabled", $localAccess) ;
   &PutXMLData ($XMLSmhpd, "localaccess-type"   , $localAccessType) ;

   return ($key) ;

}

sub printUserAccessSettings {
   my ($anonAccess, $localAccess, $localAccessType) = @_ ;
   my $tmp ;

   $tmp = ucfirst $localAccess ;

   print "
   User Access Settings
   --------------------" ;
   print "
   Anonymous Access         $anonAccess
   Local Access             $localAccess" ;
   if ($tmp eq "True") {
   print "
   Local Access Type     $localAccessType" ;
   }
   print "\n   --------------------\n\n" ;

}

sub TrustMode {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;

   my $trustMode ;
   my @XENameList ;

   $trustMode  = &GetXMLData      ($XMLSmhpd, "trustmode") ;
   @XENameList = &GetXMLArrayData ($XMLSmhpd, "xenamelist") ;

   print "-------------------------------------------------------------------------------\n" ;
   print "Trust Mode\n\n" ;

   print "
   Select a device trust mode below. This will determine how HTTP requests
   from Insight Manager 7 or Systems Insight Manager hosts are handled.

   NOTE:  HP strongly recommends using Trust by Certificate.

   Trust by Certificate: Setup the System Management HomePage to only accept
   Secure Task Execution requests and Single Login requests that have been
   signed by an Insight Manager 7 or Systems Insight Manager host with a
   Trusted Certificate.

   Trust by Name: Setup the System Management HomePage to accept Secure Task
   Execution requests and Single Login requests from specific Insight Manager 7
   or Systems Insight Manager hosts.

   Trust All: Setup the System Management HomePage to accept Secure Task
   Execution requests and Single Login requests from any server.\n\n" ;

   do {
   &printTrustMode ($trustMode, @XENameList) ;

   print "
   1 - Trust by Certificate
   2 - Trust by Name
   3 - Trust All\n\n" ;

   if (lc ($trustMode) eq "trustbycert") {
      print "   4 - Modify Certificate List\n" ;
   }

   if (lc ($trustMode) eq "trustbyname") {
      print "   4 - Modify Server Name List\n" ;
   }

   print "
   p - previous
   n - next

   Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') &&
           ($key != '2') &&
           ($key != '3') &&
           ($key != '4') &&
           ($key ne 'n') &&
           ($key ne 'N') &&
           ($key ne 'p') &&
           ($key ne 'P')
           ) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      $trustMode = "TrustByCert" ;
   }

   if ($key == '2') {
      $trustMode = "TrustByName" ;
   }

   if ($key == '3') {
      $trustMode = "TrustByAll" ;
   }

   if ($key == '4') {
      if ((lc $trustMode) eq "trustbycert") {
         &TrustCertificates ;
      }

      if ((lc $trustMode) eq "trustbyname") {
         (*XENameList) = &getXENames (\@XENameList) ;
      }
   }

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   &PutXMLData      ($XMLSmhpd, "trustmode" , $trustMode) ;
   &PutXMLArrayData ($XMLSmhpd, "xenamelist", @XENameList) ;

   return ($key) ;

}

sub getXENames {
   local (*XENames) = @_ ;

   my $input ;
   my $key ;
   my $error ;
   my $count ;
   my $name ;

   print "
   Setup the System Management HomePage to accept Secure Task Execution
   and Single Login requests from Insight Manager 7.\n\n" ; 

   do {

   &printXENames (@XENames) ;

   print "
   Modify Insight Manager 7 Server List
   ------------------------------------
   1 - Add    Insight Manager 7 Server
   2 - Delete Insight Manager 7 Server
   
   p - previous
   n - next\n\n" ;

   if ($error ne "") {
      print $error ;
   }

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key ne 'n') && ($key ne 'N') && ($key ne 'p') && ($key ne 'P')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      $error = "" ;

      print "   Please enter the Insight Manager 7 Server to add: " ;
      $input = <STDIN> ;
      chomp ($input) ;

      if (length ($input) > 64) {
         $error = "\n   The XE Name exceeds 64 characters\n\n" ;
      } 

      if (($input eq "") || (!($input=~/[A-Za-z0-9]+/))) {
         $error = "\n   A blank value is not a valid XE Name!\n\n";
      }

      if ($input =~ m/([~\`@#\$\%^&\*()+=\":'<>?,|])/) {
         $error = "\n   The XE Name $input contains the illegal character << $1 >>\n\n" ;
      }

      if ($error eq "") {
         (*XENames) = &addArrayElement ($input, \@XENames) ;
      }
   }

   if ($key == '2') {

      $count = scalar (@XENames) ;

      print "\n   Enter the number of the Insight Manager 7 Server to delete,\n" ;
      print "   or ENTER when you are finished: " ;

      $input = <STDIN> ;
      chomp ($input) ;

      if (($input > '0') && ($input <= $count)) {
         $name = @XENames [$input - '1'] ;
         (*XENames) = &removeArrayElement ($name, \@XENames) ;
      }

   }

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   $key = '0' ;

   return (\@XENames) ;

}

sub printTrustMode {
   my ($mode, @XEList) = @_ ;
   my @certs ;

   print "
   Trust Mode Settings
   -------------------------" ;

   if ((lc $mode) eq "trustbycert") {
   print "
   Trust Mode: Trust By Certificate\n" ;
   }

   if ((lc $mode) eq "trustbyname") {
   print "
   Trust Mode: Trust By Name\n" ;
   }

   if ((lc $mode) eq "trustbyall") {
   print "
   Trust Mode: Trust All\n" ;
   }
   print "   -------------------------\n" ;

   if ((lc $mode) eq "trustbyname") {
      &printXENames (@XEList) ;
   }

   if ((lc $mode) eq "trustbycert") {
      (*certs) = &printCertList (\@certs) ;
   }

}

sub printXENames {
   my (@xeNames) = @_ ;
   my $count ;

   $count = 0 ;

   print "\n   Trusted Server Names\n" ;
   print "   -------------------------\n" ;
   foreach $member (@xeNames) {
      $count++ ;
      print "   $count) $member\n" ;
   }
   print "   -------------------------\n" ;
}

sub printCertList {
   local (*certs) = @_ ;
   my $certsDir = "/opt/hp/hpsmh/certs" ;
   my $files ;
   my $count = 0 ;

   opendir (CERTDIR, "$certsDir") ;

   print "
   Trusted Certificates List
   -------------------------\n" ;
   @files = readdir (CERTDIR) ;
   if (scalar (@files) > '0') {
      for (@files) {
         if ($_ ne "." && $_ ne "..") {
            $count++ ;
            print "   $count) $_\n" ;
            @certs [$count - '1'] = $_ ;
         }
      }
   } else {
   print "   ***empty list***\n" ;
   }
   print "   -------------------------\n" ;

   closedir CERTDIR ;

   return (\@certs) ;

}

sub TrustCertificates {
   my @certs ;

   print "-------------------------------------------------------------------------------\n" ;
   print "Trusted Certificates\n\n" ;

   do {
   $Complete  = '0' ;

   do {
   print "
   Select 'Add File' to add a Certificate File to the Trusted Certificates List,
   'Import' to import a certificate from a particular server, or 'Delete' to
   delete a file from the list. When you have completed your additions and
   deletions, select 'next' below.\n\n" ;

   (*certs) = &printCertList (\@certs) ;

   if (( ! -x '/usr/bin/curl'  ) && ( ! -x '/usr/bin/wget' )) {
   print "
   1 - Add File
   2 - Import (Option disabled)
   3 - Delete

   n - next\n\n" ;
   }
   else {
   print "
   1 - Add File
   2 - Import
   3 - Delete

   n - next\n\n" ;
   }

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key != '3') && ($key ne 'n') && ($key ne 'N')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      &AddCertFile ;
   }

   if ($key == '2') {
      &ImportCertFile ;
   }

   if ($key == '3') {
      &DeleteCertFile ;
   }

   } until (($key eq 'n') || ($key eq 'N')) ;

   $key = '0' ;

   if (scalar (@certs) <= '0') {
   print "
   If you do not specify any trusted certificates, Insight Manager 7 or Systems
   Insight Manager will not be able to access the HP web-based agents on this
   device.
   
   Do you want to proceed without adding any trusted certificates?\n\n" ;

   print "
   1 - Yes
   2 - No\n\n" ;

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '2') {
      $Complete = '1' ;
   }

   }

   } until $Complete eq '0' ;

   $key = '0' ;

   print "\n\n" ;

}

sub AddCertFile {
   my $certsDir = "/opt/hp/hpsmh/certs" ;
   my @certs ;
   my $input ;
   my $target ;
   my $newpath ;
   my $certFile ;
   my $login ;
   my $pass ;
   my $uid ;
   my $gid ;

   do {
   (*certs) = &printCertList (\@certs) ;

   print "
   Enter the file path of the Trusted Certificate to add to the list,
   or press ENTER when you are finished:

   File: " ;

   $input = <STDIN> ;
   chomp ($input) ;
  
   $newpath=$input;
   $newpath=~m/([^\\\/]*)$/;
   $target=$1;

   $certFile = "$certsDir/$target" ;

   $status = system ("cp $input $certsDir/$target 2> /dev/null") ;

   if ($status ne '0' && $input ne "") {
   print "
   The file '$input' does not exist.

   Please try again...\n\n" ;
   } else {
      ($login, $pass, $uid, $gid) = getpwnam ("hpsmh") ;
      chown $uid, $gid, $certFile ;
   }

   } until $input eq "" ;

}

sub ImportCertFile {
   my $certsDir = "/opt/hp/hpsmh/certs" ;
   my $certificate ;
   my $certName ;
   my $certFile ;
   my $input ;
   my $login ;
   my $pass ;
   my $uid ;
   my $gid ;


    if (( ! -x '/usr/bin/curl'  ) && ( ! -x '/usr/bin/wget' )) {
       print "\n\n";
       print "  *** Importing a remote Trusted Certificates is disabled. The 'cURL'\n";
       print "  *** or 'wget' utility is not installed on the system.  To enable\n";
       print "  *** Importing, install the curl-7.8 or wget-1.8.2 RPM package from\n";
       print "  *** the Linux distribution CD/DVD media.\n";
       print "  ***\n";
       print "  *** Trusted Certificates can be imported by administrators from the\n";
       print "  *** System Management HomePage.  Select the 'Settings' tab and choose\n";
       print "  *** the 'Security' option.  Under 'Security' option,  choose 'Trusted\n";
       print "  *** Management Servers' option, and use the 'Add Certificate from\n";
       print "  *** Server' option to import certificates.\n";
       return;
    }

   do {
   print "
   Enter the name of the server whose certificate you would like to import,
   or press ENTER when you are finished:

   Server Name: " ;

   $certName = <STDIN> ;
   chomp ($certName) ;

   if ($certName ne "") {
   print "
   Retrieving certificate.

   Please wait...\n\n" ;

 # $certificate = get("http://$certName:280/GetCertificate") ;
 # Use cURL or wget utility
    if ( -x '/usr/bin/curl' ) {
       $certificate = `/usr/bin/curl http://$certName:280/GetCertificate`;
    }
    else {
       if (-x '/usr/bin/wget' ) {
         $certificate =`/usr/bin/wget http://$certName:280/GetCertificate -O -`;
       }
       else {
         print "Certificate Import not supported. Missing cURL or wget utility programs."
       }
    }

   print "
   Import Server Certificate request has completed.\n\n" ;

   print "
   Review the certificate information below, and select 'Accept' to add the
   certificate to the Trusted Certificates List or select 'Reject' to return
   to the Trusted certificates information without adding the certificate.\n\n" ;

   print "-------------------------------------------------------------------------------\n\n" ;
   $status = system ("echo '$certificate' | /opt/hp/hpsmh/bin/openssl x509 -text -noout") ;
   print "-------------------------------------------------------------------------------\n\n" ;

   print "
   1 - Accept
   2 - Reject

   Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '1') {
      $certFile = "$certsDir/$certName.pem" ;
      print "\n   Saving to certificate file: $certFile\n" ;
      open CERTFILE, ">$certFile" ;
         print CERTFILE $certificate ;
         ($login, $pass, $uid, $gid) = getpwnam ("hpsmh") ;
         chown $uid, $gid, $certFile ;
      close CERTFILE ;
   }

   if ($key == '2') {
      $certificate = "" ;
   }

   }
   } until $certName eq "" ;

   $key = '0' ;

}

sub DeleteCertFile {
   my $certsDir = "/opt/hp/hpsmh/certs" ;
   my $certFile ;
   my $certCount ;
   my @certs ;
   my $cert ;
   my $input ;

   do {
   (*certs) = &printCertList (\@certs) ;

   $certCount = scalar (@certs) ;

   print "
   Enter the number of the Certificate File to delete,
   or ENTER when you are finished: " ;

   $input = <STDIN> ;

   if (($input > '0') && ($input <= $certCount)) {
      $cert = @certs [$input - '1'] ;
      $certFile = "$certsDir/$cert" ;
      unlink $certFile ;
   }

   } until $input == '0' ;

}

sub IPBinding {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;
   my $key ;
   my $IPBinding ;
   my @IPAddresses ;

IPBINDTOP:

   $IPBinding   = &GetXMLData      ($XMLSmhpd, "ip-binding") ;
   @IPAddresses = &GetXMLArrayData ($XMLSmhpd, "ip-binding-list") ;

   print "-------------------------------------------------------------------------------\n" ;
   print "IP Binding\n\n" ;

   print "
   Select IP Binding to ON if you would like to bind to IP Addresses
   that match a specific Subnet and Mask.

   If IP Binding is enabled and no Subnet IP Address/Netmask pairs are
   configured then the System Management HomePage will only be available
   on the localhost.\n\n" ;

   do {
   print "\n   IP Binding: " ;
   if ((lc $IPBinding) eq "true") {
      print " ON\n\n" ;
   } else {
      print " OFF\n\n" ;
   }

   print "
   1 - ON
   2 - OFF

   p - previous
   n - next\n\n" ;

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') &&
           ($key != '2') &&
           ($key ne 'n') &&
           ($key ne 'N') &&
           ($key ne 'p') &&
           ($key ne 'p')
           ) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '1') {
      $IPBinding = "True" ;
   }

   if ($key == '2') {
      $IPBinding = "False" ;
   }

   print "\n" ;

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   if (($key eq 'p') || ($key eq 'P')) {
      return ($key) ;
   }

   if ((lc $IPBinding) eq "true") {
   do {

   print "
   Select up to 5 IP Address and Mask using 'Add' or 'Delete' to add or
   delete a Subnet/Mask pair from the list. When you have completed your
   additions and deletions, select n for next below.\n\n" ;

   &printIPBindingList (@IPAddresses) ;

   print "
   1 - Add
   2 - Delete

   p - previous
   n - next\n\n" ;

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key ne 'n') && ($key ne 'N') && ($key ne 'p') && ($key ne 'P')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      if (scalar (@IPAddresses) < '5') {
          (*IPAddresses) = &AddIPAddress (\@IPAddresses) ;
      } else {
          print "   The maximum allowed number of IP Addresses has been reached\n" ;
      }
   }

   if ($key == '2') {
      (*IPAddresses) = &DeleteIPAddress (\@IPAddresses) ;
   }

   print "\n" ;

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;
   }

   &PutXMLData      ($XMLSmhpd, "ip-binding"     , $IPBinding) ;
   &PutXMLArrayData ($XMLSmhpd, "ip-binding-list", @IPAddresses) ;

   if (($key eq 'p') || ($key eq 'P')) {
      goto IPBINDTOP ;
   }

   return ($key) ;
}

sub printIPBindingList {
   my (@ipadd) = @_ ;
   my $ipCount = '0' ;

   print "
   IP Binding List
   ----------------\n" ;
   if (scalar (@ipadd)) {
      foreach (@ipadd) {
         $ipCount++ ;
         print "   $ipCount) $_\n" ;
      }
   } else {
      print "   ***empty list***\n" ;
   }
   print "   ----------------\n\n" ;

}

sub AddNetMask {
   my $NetMask ;
   my $validEntry = "false" ;
   my $rc ;

   do {

   ($rc, $NetMask) = &enterNetMask ;

   if ($rc eq "") {
      print "\n\n   Netmask: $NetMask\n" ;
      $validEntry = "true" ;
   } else {
      print "\n\n   Invalid Netmask: $NetMask\n" ;
      $validEntry = "false" ;
   }

   } until $validEntry eq "true" ;

   return ($NetMask) ;
}

sub AddIPAddress {
   local (*ipaddress) = @_ ;
   my $IPAddress ;
   my $netmask ;
   my $enrty ;
   my $validEntry = "false" ;
   my $rc ;

   do {

   ($rc, $IPAddress) = &enterIPAddress ;

   if ($rc eq "") {
      if ($IPAddress ne "") {
         ($rc, $netmask) = &enterNetmask ;      
         if ($netmask ne "") {
            (*ipaddress) = &addNetworkElement ($IPAddress, $netmask, \@ipaddress) ;
         }
      }
      $validEntry = "true" ;
   } else {
      print "\n\n   Invalid IP Address: $IPAddress - $rc\n" ;
   }

   } until $validEntry eq "true" ;

   return (\@ipaddress) ;
}

sub enterNetmask {
   my $Netmask ;
   my $validEntry = "false" ;
   my $rc ;

   do {
   print "
   Enter the netmask for the subnet IP Address,
   or ENTER when you are finished.

   Netmask: " ;

   $Netmask = <STDIN> ;
   chomp ($Netmask) ;

   if ($Netmask ne "") {
       $rc = &validNetMask ($Netmask) ;
       if ($rc eq "") {
          $validEntry = "true" ;
       } else {
          print "\n\n   Invalid netmask: $Netmask - $rc\n" ;
       }
   } else {
       $validEntry = "true" ;
   }
   } until $validEntry eq "true" ;

   return ($rc, $Netmask) ;
}

sub enterIPAddress {
   my $IPAddress ;
   my $rc ;

   print "
   Enter the subnet IP Address to add to the IP Binding List,
   or ENTER when you are finished.

   IP Address: " ;

   $IPAddress = <STDIN> ;
   chomp ($IPAddress) ;

   if ($IPAddress ne "") {
       $rc = &validIP ($IPAddress) ;
   }

   return ($rc, $IPAddress) ;
}

sub DeleteIPAddress {
   local (*ipaddress) = @_ ;
   $input ;
   $bindCount ;

   do {
   &printIPBindingList (@ipaddress) ;

   $bindCount = scalar (@ipaddress) ;

   print "
   Enter the number of the subnet to delete,
   or ENTER when you are finished: " ;

   $input = <STDIN> ;

   if (($input > '0') && ($input <= $bindCount)) {
      splice (@ipaddress, ($input - 1), 1) ;
   }

   } until $input == '0' ;

   return (\@ipaddress) ;

}

sub IPRestrictedLogins {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;
   $IPLogins = "false" ;
   @IPInclude ;
   @IPExclude ;

IPRESTRICTTOP:

   $IPLogins  = &GetXMLData      ($XMLSmhpd, "ip-restricted-logins") ;
   @IPInclude = &GetXMLArrayData ($XMLSmhpd, "ip-restricted-include") ;
   @IPExclude = &GetXMLArrayData ($XMLSmhpd, "ip-restricted-exclude") ;

   print "-------------------------------------------------------------------------------\n" ;
   print "IP Restricted Logins\n\n" ;

   print "
   The System Management HomePage can restrict login access based on the
   IP address of the machine from which the login is attempted.

   If an IP address is explicitly excluded, it will be excluded even if it
   is also explicitly included. If there are any IP addresses in the inclusion
   list, then only those IP addresses will be allowed login access. If there
   are no IP addresses in the inclusion list, then login access will be allowed
   to any IP addresses not in the exclusion list.\n\n" ;

   do {
   print "\n   IP Restricted Logins: " ;
   if ((lc $IPLogins) eq "true") {
      print " ON\n" ;
   } else {
      print " OFF\n" ;
   }

   print "
   Please select the number below to include and/or exclude specific IP
   Addresses or IP Address Ranges.\n\n" ;

   print "
   1 - IP Restricted Logins ON
   2 - IP Restricted Logins OFF

   p - previous
   n - next\n\n" ;

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key ne 'n') && ($key ne 'N') && ($key ne 'p') && ($key ne 'P')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '1') {
      $IPLogins = "True"  ;
   }

   if ($key == '2') {
      $IPLogins = "False"  ;
   }

   print "\n" ;

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   if (($key eq 'p') || ($key eq 'P')) {
      return ($key) ;
   }

   if ((lc $IPLogins) eq "true") {
      ($key, *IPInclude, *IPExclude) = &SetIPAddressLogins ($key, \@IPInclude, \@IPExclude) ;
   } 

   &PutXMLData      ($XMLSmhpd, "ip-restricted-logins",  $IPLogins) ;
   &PutXMLArrayData ($XMLSmhpd, "ip-restricted-include", @IPInclude) ;
   &PutXMLArrayData ($XMLSmhpd, "ip-restricted-exclude", @IPExclude) ;

   if (($key eq 'p') || ($key eq 'P')) {
      goto IPRESTRICTTOP ;
   }

   print "\n\n\n" ;
   print "   ===============================================================\n" ;
   print "                    Thank you for choosing hp\n" ;
   print "   You have successfully set up the System Management HomePage\n\n" ;
   print "   ===============================================================\n\n\n" ;
   print "   You can run this script by executing: perl /usr/local/hp/hpSMHSetup.pl\n\n" ;
   system('/etc/init.d/hpsmhd restart');
}

sub SetIPAddressLogins {
   local ($key, *ipinclude, *ipexclude) = @_ ;

   print "-------------------------------------------------------------------------------\n" ;
   print "Set IP Address Restrictions\n\n" ;

   do {

   &printIPRestriction ("Inclusion", @ipinclude) ;
   &printIPRestriction ("Exclusion", @ipexclude) ;

   print "
   1 - Include Login Restriction IP Addresses
   2 - Exclude Login Restriction IP Addresses

   p - previous
   n - next\n\n" ;

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key ne 'n') && ($key ne 'N') && ($key ne 'p') && ($key ne 'P')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '1') {
      (*ipinclude) = &IPAddressInclude (\@ipinclude) ;
   }

   if ($key == '2') {
      (*ipexclude) = &IPAddressExclude (\@ipexclude) ;
   }

   print "\n" ;

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   return ($key, \@ipinclude, \@ipexclude) ;

}

sub IPAddressInclude {
   local (*ipinclude) = @_ ;

   print "-------------------------------------------------------------------------------\n" ;
   print "IP Addresses to Include\n\n" ;

   print "
   IP Addresses can be explicitly included in gaining login access. If there
   are any IP Addresses in the Inclusion List, then only those IP Addresses
   will be allowed login access. If there are no IP Addresses in the Inclusion
   List, then login access will be allowed to any IP Address not in the
   Exclusion List (next screen).

   IP Address Ranges should be listed with the lower end of the range followed
   by a hyphen, followed by the upper end of the range.

   Note:  All defined IP ranges will include the upper and lower address
          entries.

   Select 'Add' to add an IP Address or IP Address Range to the IP Address
   Inclusion List or 'Delete' to delete an IP Address or IP Address Range
   from the list. When you have completed your additions and deletions,
   select 'next' below.\n\n" ;

   do {

   &printIPRestriction ("Inclusion", @ipinclude) ;

   print "
   1 - Add
   2 - Delete

   n - next\n\n" ;

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key != 'n')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '1') {
      (*ipinclude) = &AddLoginIPAddress ("Inclusion", \@ipinclude) ;
   }

   if ($key == '2') {
      (*ipinclude) = &DeleteLoginIPAddress ("Inclusion", \@ipinclude) ;
   }

   print "\n" ;

   } until $key eq 'n' ;

   $key = '0' ;

   return (\@ipinclude) ;

}

sub IPAddressExclude {
   local (*ipexclude) = @_ ;

   print "-------------------------------------------------------------------------------\n" ;
   print "IP Addresses to Exclude\n\n" ;

   print "
   IP Addresses can be explicitly excluded in gaining login access. If an IP
   Address is explicitly excluded it will be excluded even if it is also
   explicitly included (previous screen).

   IP Address Ranges should be listed with the lower end of the range followed
   by a hyphen, followed by the upper end of the range.

   Note:  All defined IP ranges will include the upper and lower address
          entries.

   Select 'Add' to add an IP Address or IP Address Range to the IP Address
   Exclusion List or 'Delete' to delete an IP Address or IP Address Range
   from the list. When you have completed your additions and deletions,
   select 'next' below.

   Ensure that you do not exclude the IP Address of your system, because you
   will not be able to login to the System Management HomePage.\n\n" ;

   do {

   &printIPRestriction ("Exclusion", @ipexclude) ;

   print "
   1 - Add
   2 - Delete

   n - next\n\n" ;

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key != 'n')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n\n" ;

   if ($key == '1') {
      (*ipexclude) = &AddLoginIPAddress ("Exclusion", \@ipexclude) ;
   }

   if ($key == '2') {
      (*ipexclude) = &DeleteLoginIPAddress ("Exclusion", \@ipexclude) ;
   }

   print "\n" ;

   } until $key eq 'n' ;

   $key = '0' ;

   return (\@ipexclude) ;
}

sub printIPRestriction {
   my ($name, @IPEntries) = @_ ;
   my $count = 0 ;

   print "
   IP Address $name List
   -------------------------\n" ;
   if (scalar (@IPEntries) > 0) {
      foreach (@IPEntries) {
         $count++ ;
         print "   $count) $_\n" ;
      }
   } else {
      print "   ***empty list***\n" ;
   }
   print "   -------------------------\n\n" ;

}

sub AddLoginIPAddress {
   local ($name, *ipArray) = @_ ;
   my $rawInput ;
   my @lowerLimit ;
   my @upperLimit ;
   my @ipRanges ;
   my @ipAddresses ;
   my $upperIPAddress ;
   my $lowerIPAddress ;
   my $badRange ;
   my $badInput ;
   my $validLimit ;
   my $result ;
   my $count ;
   my $rc ;

   do {

   &printIPRestriction ($name, @ipArray) ;

   print "
   Valid IP Address Ranges consist of either a single IP Address or an
   IP Address Range with the lower IP Address separated from the upper
   IP Address by a '-'.

   Sample Entry: 122.23.44.1-122.23.44.255;172.84.100.35;127.0.0.0-127.0.0.255
   
   Please enter your IP Address values or ENTER to continue\n\n   " ;

   $rawInput = <STDIN> ;
   chomp ($rawInput) ;

   @ipRanges = split (/;/, $rawInput) ;

   $badRange = "false" ;
   $badInput = "false" ;
   foreach (@ipRanges) {
      push (@ipArray, $_) ;
      @ipAddresses = split (/-/, $_) ;
      $lowerIPAddress = @ipAddresses [0] ;
      $rc = &validNetwork ($lowerIPAddress) ;
      if ($rc ne "") {
         $badInput = "true" ;
         print "\n   Invalid IP Address: $lowerIPAddress - $rc\n\n" ;
         pop (@ipArray) ;
      } else {
         @lowerLimit = split (/\./, $lowerIPAddress) ;
         if (scalar (@ipAddresses) > 1) {
            $upperIPAddress = @ipAddresses [1] ;
            $rc = &validNetwork ($upperIPAddress) ;
            if ($rc ne "") {
               $badInput = "true" ;
               print "\n   Invalid IP Address: $upperIPAddress - $rc\n\n" ;
               pop (@ipArray) ;
            } else {
               @upperLimit = split (/\./, $upperIPAddress) ;
               $validLimit = "false" ;

               $octet4 = @upperLimit [0] - @lowerLimit [0] ;
               $octet3 = @upperLimit [1] - @lowerLimit [1] ;
               $octet2 = @upperLimit [2] - @lowerLimit [2] ;
               $octet1 = @upperLimit [3] - @lowerLimit [3] ;

               if ($octet4 > 0) {
                     $validLimit = "true" ;
               } elsif ($octet4 == 0) {
                  if ($octet3 > 0) {
                     $validLimit = "true" ;
                  } elsif ($octet3 == 0) {
                     if ($octet2 > 0) {
                        $validLimit = "true" ;
                     } elsif ($octet1 > 0) {
                        $validLimit = "true" ;
                     }
                  }
               }

               if ($validLimit eq "false") {
                  $badRange = "true" ;
                  print "\n   Invalid range: $lowerIPAddress - $upperIPAddress\n\n" ;
               }
            }
         }
      }
      if ($badRange eq "true") {
         pop (@ipArray) ;
      }
   }

   } until $rawInput eq "" ;

   return (\@ipArray) ;

}

sub DeleteLoginIPAddress {
   local ($name, *ipArray) = @_ ;
   my $input ;
   my $count ;

   do {
   &printIPRestriction ($name, @ipArray) ;

   $count = scalar (@ipArray) ;

   print "
   Enter the number of the $name to delete,
   or ENTER when you are finished: " ;

   $input = <STDIN> ;

   if (($input > '0') && ($input <= $count)) {
      splice (@ipArray, ($input - 1), 1) ;
   }

   } until $input == '0' ;

   return (\@ipArray) ;

}

# A sub-routine to verify that an IP address is valid
sub validIP {

    my $ip = shift || return;

    # Check for on-digit characters
    if ($ip =~ m/ /) {
        return("INVALID_IP_HASSPACES");
    }
    elsif ($ip =~ m/[^\d\.]/) {
        return("INVALID_IP_HASNONDIGITS");
    }
    elsif (!($ip =~ m/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/) ) {
        return("INVALID_IP");
    }
    elsif ($1 > 255 || $2 > 255 || $3 > 255 || $4 > 255) {
        return("INVALID_IP_OUTOFRANGE");
    }
    elsif ($4 == 255) {
        return ("INVALID_IP_BROADCAST");
    }
    elsif ($1 == 127) {
        return ("INVALID_IP_LOOPBACK");
    }
    elsif ($1 == 255 && $2 == 255 && $3 == 255 && $4 == 255) {
        return ("INVALID_IP_BROADCAST");
    }
    elsif ($1 == 0) {
        return ("INVALID_IP");
    }
    elsif ($1 == 0 && $2 == 0 && $3 == 0 && $4 == 0) {
        return ("INVALID_IP");
    }
    elsif ($4 == 0) {
        return ("INVALID_IP");
    }
    elsif ($1 > 223) {
        return ("INVALID_IP_MULTICAST");
    }
    else {
        return("");
    }
}

# A sub-routine to verify that a Network is valid
sub validNetwork {

    my $network = shift || return;

    # Check for non-digit characters
    if ($network =~ m/ /) {
        return("INVALID_NETWORK_HASSPACES");
    }
    elsif ($network =~ m/[^\d\.]/) {
        return("INVALID_NETWORK_HASNONDIGITS");
    }
    elsif (!($network =~ m/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/) ) {
        return("INVALID_NETWORK");
    }
    elsif ($1 > 255 || $2 > 255 || $3 > 255 || $4 > 255) {
        return("INVALID_NETWORK_OUTOFRANGE");
    }
    elsif ($1 == 0) {
        return("INVALID_NETWORK");
    }
    else {
        return("");
    }
}

# A sub-routine to veify the binary sequence of the octets
sub validOctets {
   local (@octets) = @_ ;
   my $count, $octet, $bitmask, $rc = "" ;
   my @bitmasks = (0, 128, 192, 224, 240, 248, 252, 254, 255) ; 

   $count = 0 ;      
   foreach $octet (@octets) {
      $count++;
      $tmprc = "FAILED" ;
      foreach $bitmask (@bitmasks) {
         if ($bitmask == $octet) {
            $tmprc = "" ;
         }
      }

      if ($tmprc eq "FAILED") {
         $rc = "NETMASK FAILED" ;
      }
   }

   return ($rc) ;
}


# A sub-routine to verify that a Net Mask is valid
sub validNetMask {

    my $netmask = shift || return;
    my $goodform = $netmask =~ m/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})/;
    my @octets ;

    push (@octets, $1, $2, $3, $4) ;

#    print STDERR "Netmask octets = $1 $2 $3 $4\nGoodForm = $goodform\n";

    # Check for non-digit characters
    if ($netmask =~ m/ /) {
        return("INVALID_NETMASK_HASSPACES");
    }
    elsif ($netmask =~ m/[^\d\.]/) {
        return("INVALID_NETMASK_HASNONDIGITS");
    }
    elsif (!$goodform) {
        return("INVALID_NETMASK");
    }
    elsif ($1 > 255 || $2 > 255 || $3 > 255 || $4 > 255) {
        return("INVALID_NETMASK_OUTOFRANGE");
    }
    elsif ($1 == 0) {
        return ("INVALID_NETMASK");
    }
    elsif ($1 < 255 && ($2 != 0 || $3 != 0 || $4 !=0)) {
        return ("INVALID_NETMASK_SECOND_OCTET");
    }
    elsif ($1 == 255 && $2 < 255 && ($3 != 0 || $4 != 0)) {
        return ("INVALID_NETMASK_THIRD_OCTET");
    }
    elsif ($1 == 255 && $2 == 255 && $3 < 255 && $4 !=0) {
        return ("INVALID_NETMASK_FOURTH_OCTET");
    }
    elsif (&validOctets (@octets) ne "") {
        return ("INVALID_NETMASK_OCTET_SEQUENCE");
    }
    else {
        return("");
    }
}

sub GetXMLArrayData {
   my ($file, $parseVariable) = @_ ;
   my @XMLData ;

   open XMLFILE, $file ;

   while (<XMLFILE>) {
      if ($_ =~ m/<$parseVariable>(.*)<\/$parseVariable>/) {
         @XMLData = split (/;/, $1) ;
      }
   }

   close XMLFILE ;

   return (@XMLData) ;

}

sub GetXMLData {
   my ($file, $parseVariable) = @_ ;
   my $XMLData ;

   open XMLFILE, $file ;

   while (<XMLFILE>) {
      if ($_ =~ m/<$parseVariable>(.*)<\/$parseVariable>/) {
         $XMLData = $1 ;
      }
   }

   close XMLFILE ;

   return ($XMLData) ;

}

sub GetINIData {
   my ($file, $parseVariable) = @_ ;
   my $INIData ;
   my $tag ;
   my $entry ;
   my $member ;

   $tag = lc $parseVariable ;

   open INIFILE, $file ;

   $INIData = "" ;
   while (<INIFILE>) {
      $entry = lc $_ ;
      $entry =~ s/
//g ; 
      if ($entry =~ m/$tag=(.*)/) {
         $member = $1 ;
         $member = ~s/
//g ;
         chomp ($member) ;
         $member =~ s/,/;/g ;
         $INIData = $member ;
      }
   }

   close INIFILE ;

   return ($INIData) ;

}

sub PutXMLArrayData {
   my ($file, $parseVariable, @Data) = @_ ;
   my @tempData ;

   my $enrtryData ;

   $entryData = join ';', @Data ;

   chomp $entryData ;

   open XMLFILE, "$file" ;

   while (<XMLFILE>) {
      if (($_ =~ m/<$parseVariable>/) || ($_ =~ m/<$parseVariable\/>/)) {
         push (@tempData, "<$parseVariable>$entryData<\/$parseVariable>\n") ;
      } else {
         push (@tempData, $_) ;
      }
   }

   close XMLFILE ;

   open XMLFILE, ">$file" ;

   foreach $tmp (@tempData) {
      print XMLFILE $tmp ;
   }

   close XMLFILE ;
}

sub PutXMLData {
   my ($file, $parseVariable, $Data) = @_ ;
   my $found ;
   my @tempData ;

   open XMLFILE, "$file" ;

   while (<XMLFILE>) {
      if (($_ =~ m/<$parseVariable>/) || ($_ =~ m/<$parseVariable\/>/)) {
         push (@tempData, "<$parseVariable>$Data<\/$parseVariable>\n") ;
      } else {
         push (@tempData, $_) ;
      }
   }

   close XMLFILE ;

   open XMLFILE, ">$file" ;

   foreach $tmp (@tempData) {
      print XMLFILE $tmp ;
   }

   close XMLFILE ;
}

sub addNetworkElement {
   local ($ipaddress, $netmask, *array) = @_ ;
   my $duplicate ;

   chomp ($element) ;

   $duplicate = "false" ;
   foreach (@array) {
      $_ =~ m/(.*)\/(.*)/ ;
      print "   IPaddress = $1\n" ;
      print "   Netmask   = $2\n" ;
      if ($ipaddress eq $1 && $netmask eq $2) {
         $duplicate = "true" ;
      }
   }

   if ($duplicate eq "false") {
      push (@array, "$ipaddress/$netmask") ;
   }

   return (\@array) ;
}

sub addArrayElement {
   local ($element, *array) = @_ ;
   my $duplicate ;

   chomp ($element) ;

   $duplicate = "false" ;
   foreach (@array) {
      if ($element eq $_) {
         $duplicate = "true" ;
      }
   }

   if ($duplicate eq "false") {
      push (@array, $element) ;
   }

   return (\@array) ;
}

sub removeArrayElement {
   local ($element, *array) = @_ ;
   my $member, $index = 0 ;

   chomp ($element) ;

   foreach $member (@array) {
      if ($member eq $element) {
         splice (@array, $index, 1) ;
      }
      $index++ ;
   }

   return (\@array) ;
}
