# compatibility with legacy rpm
%{!?_lib:%define _lib	lib}

%define	__soversion	3.3
%define	_libdb_a	libdb-%{__soversion}.a
%define	_libcxx_a	libdb_cxx-%{__soversion}.a

Summary: The Berkeley DB database library (version 3) for C.
Name: db3
Version: 3.3.11
Release: 6.vmware
Source: http://www.sleepycat.com/update/%{version}/db-%{version}.tar.gz
Source1: http://www.sleepycat.com/update/1.85/db.1.85.tar.gz
Patch0: http://www.sleepycat.com/update/3.3.11/patch.3.3.11.1
Patch1: http://www.sleepycat.com/update/3.3.11/patch.3.3.11.2
Patch10: http://www.sleepycat.com/update/1.85/patch.1.1
Patch11: http://www.sleepycat.com/update/1.85/patch.1.2
Patch12: http://www.sleepycat.com/update/1.85/patch.1.3
Patch13: http://www.sleepycat.com/update/1.85/patch.1.4
Patch14: db-1.85-errno.patch
URL: http://www.sleepycat.com/
License: Sleepycat (BSD-ish)
Group: System Environment/Libraries

BuildPreReq: perl, tcl

BuildRoot: %{_tmppath}/%{name}-root
Prefix: %{_prefix}

%description
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. The Berkeley DB includes B+tree, Extended
Linear Hashing, Fixed and Variable-length record access methods,
transactions, locking, logging, shared memory caching, and database
recovery. The Berkeley DB supports C, C++, Java, and Perl APIs. It is
used by many applications, including Python and Perl, so this should
be installed on all systems.

%package utils
Summary: Command line tools for managing Berkeley DB (version 3) databases.
Group: Applications/Databases
Requires: db3 = %{version}
Prefix: %{_prefix}

%description utils
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. Berkeley DB includes B+tree, Extended
Linear Hashing, Fixed and Variable-length record access methods,
transactions, locking, logging, shared memory caching, and database
recovery. DB supports C, C++, Java and Perl APIs.

This package contains command line tools for managing Berkeley DB
(version 3) databases.

%package devel
Summary: Development files for the Berkeley DB (version 3) library.
Group: System Environment/Libraries
Requires: db3 = %{version}
Prefix: %{_prefix}

%description devel
The Berkeley Database (Berkeley DB) is a programmatic toolkit that
provides embedded database support for both traditional and
client/server applications. This package contains the header files,
libraries, and documentation for building programs which use the
Berkeley DB.

%prep
%setup -q -n db-%{version} -a 1
%patch0 -p0 -b .patch.3.2.11.1
%patch1 -p0 -b .patch.3.2.11.2
pushd db.1.85/PORT/linux
%patch10 -p0 -b .1
cd ../..
%patch11 -p0 -b .1
%patch12 -p0 -b .2
%patch13 -p0 -b .3
%patch14 -p1 -b .errno
popd
find . -name tags | xargs rm -f
fixup_href() {
    for doc in $@ ; do
        chmod u+w ${doc}
        sed -e 's,="../api_c/,="../../%{name}-devel-%{version}/api_c/,g' \
            -e 's,="api_c/,="../%{name}-devel-%{version}/api_c/,g' \
            -e 's,="../api_cxx/,="../../%{name}-devel-%{version}/api_cxx/,g' \
            -e 's,="api_cxx/,="../%{name}-devel-%{version}/api_cxx/,g' \
            -e 's,="../api_java/,="../../%{name}-devel-%{version}/api_java/,g' \
            -e 's,="api_java/,="../%{name}-devel-%{version}/api_java/,g' \
            -e 's,="../api_tcl/,="../../%{name}-devel-%{version}/api_tcl/,g' \
            -e 's,="api_tcl/,="../%{name}-devel-%{version}/api_tcl/,g' \
            -e 's,="../examples_c/,="../../%{name}-devel-%{version}/examples_c/,g' \
            -e 's,="examples_c/,="../%{name}-devel-%{version}/examples_c/,g' \
            -e 's,="../examples_cxx/,="../../%{name}-devel-%{version}/examples_cxx/,g' \
            -e 's,="examples_cxx/,="../%{name}-devel-%{version}/examples_cxx/,g' \
            -e 's,="../ref/,="../../%{name}-devel-%{version}/ref/,g' \
            -e 's,="ref/,="../%{name}-devel-%{version}/ref/,g' \
            -e 's,="../sleepycat/,="../../%{name}-devel-%{version}/sleepycat/,g' \
            -e 's,="sleepycat/,="../%{name}-devel-%{version}/sleepycat/,g' \
            -e 's,="../images/,="../../%{name}-%{version}/images/,g' \
            -e 's,="images/,="../%{name}-%{version}/images/,g' \
            -e 's,="../utility/,="../../%{name}-%{version}/utility/,g' \
            -e 's,="utility/,="../%{name}-%{version}/utility/,g' ${doc} > ${doc}.new
        touch -r ${doc} ${doc}.new
        cat ${doc}.new > ${doc}
        touch -r ${doc}.new ${doc}
        rm -f ${doc}.new
    done
}
fixup_href `find . -name "*.html"`

%build
CFLAGS="$RPM_OPT_FLAGS"; export CFLAGS

# Build db 1.85 for the library.
make -C db.1.85/PORT/%{_os} OORG="$CFLAGS"
# Build db_dump185 using the old library.
/bin/sh libtool --mode=compile %{__cc} $RPM_OPT_FLAGS -Idb.1.85/PORT/%{_os}/include -D_REENTRANT -c db_dump185/db_dump185.c -o dist/db_dump185.lo
/bin/sh libtool --mode=link    %{__cc} -o dist/db_dump185 dist/db_dump185.lo db.1.85/PORT/%{_os}/libdb.a

pushd dist
# XXX --enable-posixmutexes is useful for threads but useless for interprocess locking.
# XXX --enable-diagnostic should be disabled for production (but is useful).
# XXX --enable-debug_{r,w}op should be disabled for production.
# XXX --enable-java
%configure \
	--prefix=%{_prefix} --enable-compat185 --enable-dump185 \
	--enable-shared --enable-static --enable-rpc \
	--enable-tcl --with-tcl=%{_libdir} \
	--enable-cxx --enable-test \
	# --enable-diagnostic \
	# --enable-debug --enable-debug_rop --enable-debug_wop \
	# --enable-posixmutexes

make libdb=%{_libdb_a} libcxx=%{_libcxx_a}
popd

# Remove dangling tags symlink from examples.
rm -f examples_cxx/tags
rm -f examples_c/tags

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_includedir}
mkdir -p ${RPM_BUILD_ROOT}%{_libdir}
%makeinstall -C dist libdb=%{_libdb_a} libcxx=%{_libcxx_a}
chmod +x $RPM_BUILD_ROOT/%{_libdir}/*.so*

# On Linux systems, move the shared libraries to lib directory, but leave the
# versioned .so symlink to in the usual place to link against.
%ifos linux
if [ "%{_libdir}" != "%{_lib}" ]; then
	mkdir -p $RPM_BUILD_ROOT/%{_lib}
	mv $RPM_BUILD_ROOT/%{_libdir}/libdb[-.]*so* $RPM_BUILD_ROOT/%{_lib}/
	touch $RPM_BUILD_ROOT/rootfile
	root=..
	while [ ! -e $RPM_BUILD_ROOT/%{_libdir}/${root}/rootfile ] ; do
		root=${root}/..
	done
	ln -sf ${root}/%{_lib}/libdb-%{__soversion}.so $RPM_BUILD_ROOT/%{_libdir}/libdb-%{__soversion}.so
	ln -sf ${root}/%{_lib}/libdb-%{__soversion}.so $RPM_BUILD_ROOT/%{_libdir}/libdb.so
	fi
%endif

# Move the header files to a subdirectory, in case we're deploying on a
# system with multiple versions of DB installed.
mkdir -p $RPM_BUILD_ROOT/%{_includedir}/db3
mv $RPM_BUILD_ROOT/%{_includedir}/*.h $RPM_BUILD_ROOT/%{_includedir}/db3/

# Rename the utilities s/db_/dbN_/ (for multiple versions of DB installed)
for p in berkeley_db_svc db_dump185 \
	 db_archive db_checkpoint db_deadlock db_dump db_load \
	 db_printlog db_recover db_stat db_upgrade db_verify; do
	q="`echo $p | sed -e 's,db_,%{name}_,'`"
	mv  ${RPM_BUILD_ROOT}%{_bindir}/$p ${RPM_BUILD_ROOT}%{_bindir}/$q
	ln -s `basename ${RPM_BUILD_ROOT}%{_bindir}/$q` ${RPM_BUILD_ROOT}%{_bindir}/$p
done

# Create symlinks so that "use <db.h> and link with -ldb" works.
ln -sf db3/db.h $RPM_BUILD_ROOT/%{_includedir}/db.h
ln -sf %{_libdb_a} $RPM_BUILD_ROOT/%{_libdir}/libdb.a

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -rf ${RPM_BUILD_ROOT}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc LICENSE README docs/images
%ifos linux
/%{_lib}/libdb-%{__soversion}.so
%else
%{_libdir}/libdb-%{__soversion}.so
%endif
%{_libdir}/libdb_cxx-%{__soversion}.so

%files utils
%defattr(-,root,root)
%doc	docs/utility
%{_libdir}/libdb_tcl.so
%{_libdir}/libdb_tcl-%{__soversion}.la
%{_libdir}/libdb_tcl-%{__soversion}.so
%{_bindir}/berkeley_db*_svc
%{_bindir}/db*_archive
%{_bindir}/db*_checkpoint
%{_bindir}/db*_deadlock
%{_bindir}/db*_dump
%{_bindir}/db*_dump185
%{_bindir}/db*_load
%{_bindir}/db*_printlog
%{_bindir}/db*_recover
%{_bindir}/db*_stat
%{_bindir}/db*_upgrade
%{_bindir}/db*_verify

%files devel
%defattr(-,root,root)
%doc	docs/api_c docs/api_cxx docs/api_java docs/api_tcl docs/index.html
%doc	docs/ref docs/sleepycat
%doc	examples_c examples_cxx
%{_libdir}/libdb-%{__soversion}.la
%{_libdir}/libdb_cxx-%{__soversion}.la
%{_libdir}/libdb.a
%{_libdir}/%{_libdb_a}
%{_libdir}/%{_libcxx_a}
%{_includedir}/db3/db.h
%{_includedir}/db3/db_185.h
%{_includedir}/db3/db_cxx.h
%{_includedir}/db.h
%ifos linux
/%{_lib}/libdb.so
/%{_libdir}/libdb-%{__soversion}.so
%else
%{_libdir}/libdb.so
%endif
%{_libdir}/libdb.so
%{_libdir}/libdb_cxx.so

%changelog
* Tue Apr  9 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3.11-6
- rebuild

* Tue Apr  9 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3.11-5
- include the db_ names as well

* Tue Mar 26 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3.11-4
- rebuild

* Tue Mar 26 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3.11-3
- reintroduce symlink in %%{_libdir} to allow dynamic linking with -ldb again

* Mon Mar 25 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3.11-2
- rebuild

* Mon Mar 25 2002 Nalin Dahyabhai <nalin@redhat.com> 3.3.11-1
- update to 3.3.11 + recommended patches
- build our own db 1.85 to remove build-time requirement on the static library

* Thu Nov  1 2001 Bill Nottingham <notting@redhat.com>
- fix license

* Sun Aug  5 2001 Nalin Dahyabhai <nalin@redhat.com>
- fix dangling docs symlinks
- fix dangling doc HREFs (#33328)
- apply the two patches listed at http://www.sleepycat.com/update/3.2.9/patch.3.2.9.html

* Tue Jun 19 2001 Bill Nottingham <notting@redhat.com>
- turn off --enable-debug

* Thu May 10 2001 Than Ngo <than@redhat.com>
- fixed to build on s390x

* Mon Mar 19 2001 Jeff Johnson <jbj@redhat.com>
- update to 3.2.9.

* Tue Dec 12 2000 Jeff Johnson <jbj@redhat.com>
- rebuild to remove 777 directories.

* Sat Nov 11 2000 Jeff Johnson <jbj@redhat.com>
- don't build with --enable-diagnostic.
- add build prereq on tcl.
- default value for %%_lib macro if not found.

* Tue Oct 17 2000 Jeff Johnson <jbj@redhat.com>
- add /usr/lib/libdb-3.1.so symlink to %%files.
- remove dangling tags symlink from examples.

* Mon Oct  9 2000 Jeff Johnson <jbj@redhat.com>
- rather than hack *.la (see below), create /usr/lib/libdb-3.1.so symlink.
- turn off --enable-diagnostic for performance.

* Fri Sep 29 2000 Jeff Johnson <jbj@redhat.com>
- update to 3.1.17.
- disable posix mutexes Yet Again.

* Tue Sep 26 2000 Jeff Johnson <jbj@redhat.com>
- add c++ and posix mutex support.

* Thu Sep 14 2000 Jakub Jelinek <jakub@redhat.com>
- put nss_db into a separate package

* Wed Aug 30 2000 Matt Wilson <msw@redhat.com>
- rebuild to cope with glibc locale binary incompatibility, again

* Wed Aug 23 2000 Jeff Johnson <jbj@redhat.com>
- remove redundant strip of libnss_db* that is nuking symbols.
- change location in /usr/lib/libdb-3.1.la to point to /lib (#16776).

* Thu Aug 17 2000 Jeff Johnson <jbj@redhat.com>
- summaries from specspo.
- all of libdb_tcl* (including symlinks) in db3-utils, should be db3->tcl?

* Wed Aug 16 2000 Jakub Jelinek <jakub@redhat.com>
- temporarily build nss_db in this package, should be moved
  into separate nss_db package soon

* Wed Jul 19 2000 Jakub Jelinek <jakub@redhat.com>
- rebuild to cope with glibc locale binary incompatibility

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Sun Jun 11 2000 Jeff Johnson <jbj@redhat.com>
- upgrade to 3.1.14.
- create db3-utils sub-package to hide tcl dependency, enable tcl Yet Again.
- FHS packaging.

* Mon Jun  5 2000 Jeff Johnson <jbj@redhat.com>
- disable tcl Yet Again, base packages cannot depend on libtcl.so.

* Sat Jun  3 2000 Jeff Johnson <jbj@redhat.com>
- enable tcl, rebuild against tcltk 8.3.1 (w/o pthreads).

* Tue May 30 2000 Matt Wilson <msw@redhat.com>
- include /lib/libdb.so in the devel package

* Wed May 10 2000 Jeff Johnson <jbj@redhat.com>
- put in "System Environment/Libraries" per msw instructions.

* Tue May  9 2000 Jeff Johnson <jbj@redhat.com>
- install shared library in /lib, not /usr/lib.
- move API docs to db3-devel.

* Mon May  8 2000 Jeff Johnson <jbj@redhat.com>
- don't rename db_* to db3_*.

* Tue May  2 2000 Jeff Johnson <jbj@redhat.com>
- disable --enable-test --enable-debug_rop --enable-debug_wop.
- disable --enable-posixmutexes --enable-tcl as well, to avoid glibc-2.1.3
  problems.

* Mon Apr 24 2000 Jeff Johnson <jbj@redhat.com>
- add 3.0.55.1 alignment patch.
- add --enable-posixmutexes (linux threads has not pthread_*attr_setpshared).
- add --enable-tcl (needed -lpthreads).

* Sat Apr  1 2000 Jeff Johnson <jbj@redhat.com>
- add --enable-debug_{r,w}op for now.
- add variable to set shm perms.

* Sat Mar 25 2000 Jeff Johnson <jbj@redhat.com>
- update to 3.0.55

* Tue Dec 29 1998 Jeff Johnson <jbj@redhat.com>
- Add --enable-cxx to configure.

* Thu Jun 18 1998 Jeff Johnson <jbj@redhat.com>
- Create.
