// $RCSfile: navtable.js,v $ $Revision: 1.2.2.1 $
// (C) Copyright 2004 Hewlett-Packard Development Company, L.P.

headerBgColor = "#006699";

function navigationObject(condition)
{
   if (null == condition)
       condition = 1;
   this.topLevel = new Array;
   this.cond = new cpqCondition(condition);
   this.addTop = navAddTopLevel;
   this.addSecondary = navAddSecondary;
   this.findTopLevel = navFindTopLevel;
   this.extensionFlag = false;
}

function navAddTopLevel(label, condition, img, usefulCondition)
{
   if (-1 == this.findTopLevel(label))
   {
      this.topLevel[ this.topLevel.length ] =
         new topLevelObject(label, condition, img, usefulCondition, this.extensionFlag);
      if (this.extensionFlag && usefulCondition)
         this.cond.update(condition);
   }
}
function navAddSecondary(topLabel, label, link, condition, target, sortby)
{
   var i, j;

   i = this.findTopLevel(topLabel);
   if (-1 == i)
   {
      this.addTop(topLabel, 0, null, false);
      i = this.topLevel.length - 1;
   }
   this.topLevel[i].addSecondary(label, link, condition, this.extensionFlag, target, sortby);
   if (this.extensionFlag && this.topLevel[i].usefulCondition)
   {
      this.cond.update(condition);
      if (!this.topLevel[i].isExtension)
          this.topLevel[i].cond.update(condition);
   }
}
function navFindTopLevel( label )
{
   var i;
   var rc = -1;
   var limit = this.topLevel.length;

   for (i = 0; i < limit; i++)
   {
      if (label == this.topLevel[i].label)
      {
         rc = i;
         break;
      }
   }
   return (rc);
}
function topLevelObject(label, condition, img, usefulCondition, isExtension)
{
   this.nextLevel = new Array;
   this.cond = new cpqCondition(condition);
   this.img = img;
   this.usefulCondition = usefulCondition;
   this.label = label;
   this.isExtension = isExtension;
   this.findSecondary = topFindSecondary;
   this.addSecondary = topAddSecondary;
}
function topFindSecondary(label)
{
   var i;
   var rc = -1;
   var limit = this.nextLevel.length;

   for (i = 0; i < limit; i++)
   {
      if (label == this.nextLevel[i].label)
      {
         rc = i;
         break;
      }
   }
   return (rc);
}
function topAddSecondary(label, link, condition, isExtension, target, sortby)
{
   if (-1 == this.findSecondary(label))
      this.nextLevel[this.nextLevel.length] =
         new secondLevelObject(label, condition, link, isExtension, target, sortby);
}
function secondLevelObject(label, condition, link, isExtension, target, sortby)
{
   this.label = label;
   this.cond = new cpqCondition(condition);
   this.link = link;
   this.target = target;
   this.isExtension = isExtension;
   this.sortby = sortby;
   this.usefulCondition = (null != condition && condition >= 1 && condition <= 4);
}
function writeNavTableRowHeader(label, color, img)
{
   document.write("<tr>");
   document.write("<td width=185 align=left>");
   document.write("<table border=0 cellspacing=0 cellpadding=0 width=185 bgcolor=\"#FFFFFF\">");
   document.write("<tr>");
   if (img && "" != img)
   {
      document.write("<td background=\"images/backgrnd.gif\" colspan=3><img border=0 src=\"", img, "\" alt=\"", label, "\"></td>");
   }
   else
   {
      document.write("  <td width=100% valign=middle align=left bgcolor=" + headerBgColor + " colspan=3>");
      document.write("    <font face=Arial size=2 color=#FFFFFF>" + label + "</font>");
      document.write("  </td>");
   }
   document.write("</tr>");
}
highlightedNow = new Array(0);
highlightCount = 0;
highlightedImageRight = "images/slctrt.gif";
highlightedImageLeft = "images/slctlft.gif";
notHighlightedImage = "images/notslctd.gif";

function highlightLink(imgname)
{
   var i;
   var leftname = imgname + "left";
   var rightname = imgname + "right";

   for (i = 0; i < highlightCount; i++)
   {
      document.images[ highlightedNow[i] ].src = notHighlightedImage;
   }
   highlightCount = 0;

   for (i = 0; i < document.images.length; i++)
   {
      if (document.images[i].name == leftname)
      {
         document.images[i].src = highlightedImageLeft;
         highlightedNow[highlightCount++] = i;
      }
      if (document.images[i].name == rightname)
      {
         document.images[i].src = highlightedImageRight;
         highlightedNow[highlightCount++] = i;
      }
   }
}
function writeNavTableRow(label, link, condpic, target, sortby)
{
   var text;

   if (null == label || "" == label)
      text = "&#160";
   else
      text = "<font size=1 face=\"Arial\">" + label + "</font>";

   if (link != null)
   {
      text = makeLink(link, text, target, sortby);
      if (condpic != null)
         condpic = makeLink(link, condpic, target, sortby);
   }

   if (condpic == null)
      condpic = "&#160";

   document.write("<tr><td valign=top background=\"images/backgrnd.gif\" width=10>");
   document.write("<img name=\"", link, "left\" src=\"", notHighlightedImage, "\" align=left>");
   document.write("</td><td valign=top background=\"images/backgrnd.gif\" width=140>");
   writeStatusNameTable( condpic, text );
   document.write("</td><td valign=top background=\"images/backgrnd.gif\" width=10>");
   document.write("<img name=\"", link, "right\" src=\"", notHighlightedImage, "\" align=left>");
   document.write("</td></tr>");
   document.write("<tr><td height=5 colspan=3 background=images/backgrnd.gif></td></tr>");
}
function writeNavTableRowTail()
{
   document.write("</table>");
   document.write("</td>");
   document.write("</tr>");
}



