#
# HP Insight Manager Agent 7.2.0 Installer
#
# 2/3/05
#
# *********************************************************************
# ** Global Variables that need to be modified with each release     **
# *********************************************************************
HPASM_PACKAGE="hpasm-7.2.0-198.vmware.i386.rpm"
HPRSM_PACKAGE="hprsm-7.2.0-198.vmware.i386.rpm"
HPSMH_PACKAGE="hpsmh-2.0.0-103.vmware.i386.rpm"
UCD_SNMP_PACKAGE="ucd-snmp-cmaX-4.2.5-259.vmware.i386.rpm"
UCD_SNMP_UTILS_PACKAGE="ucd-snmp-cmaX-utils-4.2.5-259.vmware.i386.rpm"
CMANIC_PACKAGE="cmanic-7.2.0-8.linux.i686.rpm"
DB3_PACKAGE="db3-3.3.11-6.vmware.i386.rpm"
EXPAT_PACKAGE="expat-1.95.1-7.vmware.i386.rpm"

HPASM_PACKAGE_MD5=990657d38f4057b1d4e9798319cdb249
HPRSM_PACKAGE_MD5=a94c32a7af90a069c4504f5e1509de75
CMANIC_PACKAGE_MD5=5f08aff3009e7c92cfaba0167d8151e0
UCD_SNMP_PACKAGE_MD5=e93089ba1484e46d8c4b5792b51d2b91
UCD_SNMP_UTILS_PACKAGE_MD5=02b0ba4b2c7cda093948709756d505b7
HPSMH_PACKAGE_MD5=d81c987d286fb03382e6fd311668fd39
DB3_PACKAGE_MD5=51620d9421c28087b30453f3d8bbea5a
EXPAT_PACKAGE_MD5=b6d05df1bba25f48c317a3daa4d219dd

LOGFILENAME="hpmgmtlog"

SMH_PKGLIST="DB3_PACKAGE EXPAT_PACKAGE HPSMH_PACKAGE"
SNMP_PKGLIST="UCD_SNMP_PACKAGE UCD_SNMP_UTILS_PACKAGE"

#Only include hprsm if iLO/RILOE/RILOE2 is found
cut -f2 /proc/bus/pci/devices | grep -i "0e11b203\|80861960\|0e11005a" > /dev/null 2>&1
if [ $? -eq 0 ]; then
        AGENT_PKGLIST="HPASM_PACKAGE HPRSM_PACKAGE CMANIC_PACKAGE"
else
        AGENT_PKGLIST="HPASM_PACKAGE CMANIC_PACKAGE"
fi
AGENTLIST="cmanic cmastor hprsm hpasm"
SNMPLIST="ucd-snmp-cmaX-utils ucd-snmp-cmaX ucd-snmp-utils ucd-snmp"
SMHLIST="db3-3.3.11 expat-1.95.1-7 hpsmh"

ASMSVC=hpasm
SMHSVC=hpsmhd
SNMPSVC=snmpd
VMSNMPSVC=vmware-snmpd

. /etc/init.d/functions

SETCOLOR_BLUE="echo -en \\033[1;34m"

setsuccess() { 
[[ ! $SILENT ]] && echo `echo_success` || echo "....OK"
}
setfailure() {
[[ ! $SILENT ]] && echo `echo_failure` || echo "....FAILED"
}

splash() {
	echo " "
	if [[ ! $SILENT ]]; then $SETCOLOR_BLUE; fi
	echo "HP Insight Manager Agent 7.2.0 Installer for VMware ESX Server"
	if [[ ! $SILENT ]]; then $SETCOLOR_NORMAL; fi
	echo " "
}

error() {
	echo $2
	log $2
	echo "Check $LOGFILENAME for additional information"
	exit $1
}

log() {
	echo $1 >> $LOGFILENAME
}

verify_action() {
	echo ""
	echo "This script will now attempt to $1 the HP Insight Manager Agents"
	echo -n "Do you wish to continue (y/n) "
	read answer
	if [ "$answer" != "y" ]; then
		error 34 "Action cancelled by user"
	fi
}

verify_root() {
	if [ $UID != 0 ]; then
		error 30 "You must be logged on as 'root' to continue"
	fi
}

verify_pkgs() {
	echo "Verifying RPM packages:"
	for i in ${AGENT_PKGLIST} ${SNMP_PKGLIST} ${SMH_PKGLIST}; do
		echo -ne "\tVerifying ${!i}"
		PKGMD5=${i}_MD5
		if [ "${!PKGMD5}" = `md5sum ${!i} | awk '{print $1}'` ]; then
			setsuccess
		else
			setfailure
			error 4 "Package ${i} is either missing or corrupt"
		fi
	done
}

verify_esx_version() {
	echo -n "Verifying VMware ESX Server version is 2.5.x"
	vmware -v | awk '{print $4}' | grep "2.5" >> $LOGFILENAME 2>&1
	if [ $? -eq 0 ]; then
		setsuccess
	else
		setfailure
		error 31 "VMware ESX must be version 2.5.x"
	fi
}

check_installed() {
	INSTALLEDPKGS=`rpm -q $@ | sed -e '/not installed/d'`
}

remove_installed() {
	check_installed $AGENTLIST $SMHLIST
	echo -n "Checking for previously installed agents"
	if [ -z "$INSTALLEDPKGS" ]; then
		setsuccess
	else
		setfailure
		echo "The following packages have already been installed"
		for i in $INSTALLEDPKGS; do echo $i; done
		if [[ ! $SILENT ]]; then
			echo "These packages must be removed before installation can continue"
			echo -n "Would you like to remove existing packages (y/n)? "
			read REMOVE
			
			if [[ $REMOVE = "Y" || $REMOVE = "y" ]]; then
				remove_packages "Removing previously installed packages" $INSTALLEDPKGS
			else
				error 32 "Please remove the previous installation"
			fi
		else
			error 32 "Please remove the previous installation."
		fi
	fi
}

stop_agents() {
	echo "Stopping HP Insight Manager agents:"
	for i in $AGENTLIST; do
		rpm -qa | grep ${i} >> $LOGFILENAME 2>&1
		if [ $? -eq 0 ]; then
			svc_control "\tStopping ${i}" stop $i
		fi
	done
}

stop_snmp() {
        echo -ne "Stopping SNMP stack:"
	pidof vmware-snmpd >> $LOGFILENAME 2>&1
	if [ $? -eq 0 ]; then
		TMP=1
		echo ""
		svc_control "\tStopping vmware-snmpd" stop $VMSNMPSVC
	fi
	pidof snmpd >> $LOGFILENAME 2>&1
	if [ $? -eq 0 ]; then
		if [ -z $TMP ]; then echo ""; else TMP=1; fi
		svc_control "\tStopping snmpd" stop $SNMPSVC
	fi
	[ -z $TMP ] && setsuccess
}

stop_smh() {
	check_installed hpsmh
	[[ $INSTALLEDPKGS ]] && svc_control "Stopping System Management Homepage" stop $SMHSVC
	# Make sure SMH is really stopped and all files are cleaned up
	# Wait for up to 30 sec for SMH to stop gracefully
	unset STOPPED
	for i in `seq 1 6`; do 
		log "Waiting for SMH to stop"
		if [ -f /opt/hp/hpsmh/logs/httpd.pid ]; then
			log "SMH not stopped yet...sleeping for 5"
			sleep 5
		else	
			STOPPED=1
			log "SMH is now stopped"
			break
		fi
	done
	# Are we still not stopped?
	if [[ ! $STOPPED ]]; then  
		log "Forcing shutdown of SMH"
		[ -f /opt/hp/hpsmh/logs/httpd.pid ] && rm -f /opt/hp/hpsmh/logs/httpd.pid
		killall -9 hpsmhd >> $LOGFILE 2>&1
	fi
	[ -f /var/lock/subsys/hpsmhd ] && rm -f /var/lock/subsys/hpsmhd

}

start_snmp() {
        echo "Starting SNMP stack:"
	svc_control "\tStarting snmpd" start $SNMPSVC
	ls /etc/rc3.d/S*vmware-snmpd >> $LOGFILENAME 2>&1
	if [ $? -eq 0 ]; then
		svc_control "\tStarting vmware-snmpd" start $VMSNMPSVC
	fi
}

remove_packages() {
	echo -n "$1:"
	shift
	check_installed $@
	if [ -z "$INSTALLEDPKGS" ]; then
		setsuccess
	else
		echo " "
		for i in $INSTALLEDPKGS; do
			echo -ne "\tRemoving ${i}"
                	rpm -e --nodeps ${i} >> $LOGFILENAME 2>&1
                	if [ $? -eq 0 ]; then
                	        setsuccess
                	else
                	        setfailure
                	        error 99 "Unable to remove ${i}"
                	fi
                done
        fi
}

install_packages() {
	echo "$1:"
	shift
	for i in $@; do
		echo -ne "\t${!i}"
		rpm -ivh ${!i} >> $LOGFILENAME 2>&1
		if [ $? -eq 0 ]; then
			setsuccess
		else
			setfailure
			error 10 "Unable to install package ${!i}"
		fi
	done
}

restore_snmp() {
	echo -n "Restoring VMware snmpd configuration:"
	log "Restoring VMware snmpd configuration"
	/usr/sbin/snmpsetup.sh restore >> $LOGFILENAME 2>&1
	if [[ $? != 0 ]]; then
        	setfailure
        	error 99 "Unable to restore VMware SNMP configuration"
        fi
        # Restore snmpsetup script
        if [ -e /usr/sbin/snmpsetup.prehp ]; then
        	mv -f /usr/sbin/snmpsetup.prehp /usr/sbin/snmpsetup.sh
        	if [[ $? != 0 ]]; then
		       	setfailure
		       	error 99 "Unable to restore snmpsetup.sh script"
		fi
	fi
	setsuccess
}

configure_vmwaresnmp() {
	if [[ ! $SILENT ]]; then
		#Check to see if subagent is enabled
		ls /etc/rc3.d/S*vmware-snmpd >> $LOGFILENAME 2>&1
		if [ $? -eq 0 ]; then
			ENABLEVMSNMP="Y"
		else
			echo "=============================================================================="
			echo "The VMware SNMP Sub-agent is currently disabled.  The sub-agent must be"
			echo "enable in order to see VMware SNMP information."
			echo "=============================================================================="
			echo ""
			echo -ne "Would you like to enable it now (y/n)? "
			read ENABLEVMSNMP
		fi
		echo ""
		echo -ne "Do you want to enable SNMP traps for virtual machine events (y/n)? "
		read ENABLEVMTRAPS
		echo ""
		SNMPCONFLOC=1
	fi
	perl -ni -e 'print unless (/^serverd.snmpdconf/||/^snmp.enable/||/^\n/)' /etc/vmware/config
	if [[ $ENABLEVMSNMP = "Y" || $ENABLEVMSNMP = "y" ]]; then
		chkconfig --level 2345 vmware-snmpd on
		echo "serverd.snmpdconf.subagentenabled = \"TRUE\"" >> /etc/vmware/config
	else
		service vmware-snmpd status | grep running >> $LOGFILENAME 2>&1
		if [ $? -eq 0 ]; then
			service vmware-snmpd stop >> $LOGFILENAME 2>&1
		fi
		chkconfig --level 2345 vmware-snmpd off >> $LOGFILENAME 2>&1
		echo "serverd.snmpdconf.subagentenabled = \"FALSE\"" >> /etc/vmware/config
	fi

	echo -n "Linking vmware-snmpd to the ucd-snmp-cmaX daemon"
	# Need to edit snmpsetup.sh script from VMware to account for cmaX in snmp pkg
	cp /usr/sbin/snmpsetup.sh /usr/sbin/snmpsetup.prehp
	if [[ $? != 0 ]]; then
		setfailure
		error 99 "Could not make backup of snmpsetup.sh script"
	fi
	/usr/bin/perl -pi -e 's/=\$CONSNMPD/=`echo \$CONSNMPD \| sed -e \"s\/-4\/\\\\(-cmaX\\\\)\\\\?-4\/g\"`/g' /usr/sbin/snmpsetup.sh
	/usr/bin/perl -pi -e 's/grep \$mainsnmpd/grep -E \$mainsnmpd/g' /usr/sbin/snmpsetup.sh

	/usr/sbin/snmpsetup.sh connect <<EOT >> $LOGFILENAME 2>&1
$ENABLEVMTRAPS
$SNMPCONFLOC
EOT
	if [ $? -eq 0 ]; then
		setsuccess
	else
		setfailure
		error 14 "There was a problem linking the snmpd daemons"
	fi
}

configure_hpasm() {

	/opt/compaq/hpasm/etc/hpasm activate
	echo -n "HP Advanced Server Management configuration"
	if [ $? -eq 0 ]; then
		setsuccess
	else
		setfailure
		error 99 "HP Advanced Server Management configuration failed"
	fi
}

configure_hpsmh() {

	if [ -e ./smhpd.xml ]; then
		log "Found SMH configuration file...copying"
		echo -n "Copying SMH configuration"
		cp ./smhpd.xml /opt/hp/hpsmh/conf/smhpd.xml
		if [ $? -eq 0 ]; then
			SMHAUTOCONF=1
			setsuccess
		else
			setfailure
			error 99 "HP System Management Homepage configuration failed"
		fi
	else
		log "SMH Configuration file not found...no action taken"
	fi
}

svc_control() {
	echo -ne "$1:"
	service $3 $2 >> $LOGFILENAME 2>&1
        if [ $? -eq 0 ]; then
		setsuccess
		return 0
	else
		setfailure
		error 33 "Unable to ${2} ${3}"
	fi

}

post_splash() {
	case "$1" in
	
	install)
	
	if [[ -z $SMHAUTOCONF ]]; then
		echo "**********************************************************"
		echo "* System Management Homepage installed successfully with *"
		echo "* default configuration values.   To change the default  *"
		echo "* configuration values,  type the following command at   *"
		echo "* the root prompt:                                       *"
		echo "*                                                        *"
		echo "* perl /usr/local/hp/hpSMHSetup.pl                       *"
		echo "*                                                        *"
		echo "**********************************************************"
	fi
	echo "Please read the Licence Agreement for this software at"
	echo ""
	echo "/opt/compaq/hpasm/hpasm.license"
	echo " "
	echo "By not removing this package, you are accepting the terms"
	echo -e "of the \"License for HP Value Added Software\"."
	;;
	esac

	echo ""
	echo "HP Insight Manager agents have been ${1}ed successfully!"
	echo ""

}

install() {
	splash
	[[ ! $SILENT ]] && verify_action "install"
	verify_esx_version
	verify_pkgs
	remove_installed
	stop_snmp
	remove_packages "Removing existing SNMP stack" $SNMPLIST
	install_packages "Installing SNMP stack with cmaX extenstions" $SNMP_PKGLIST
	install_packages "Installing HP System Management Homepage" $SMH_PKGLIST
	[[ $SILENT ]] && configure_hpsmh
	install_packages "Installing HP Management Agents" $AGENT_PKGLIST
	configure_vmwaresnmp
	[[ ! $SILENT ]] && configure_hpasm
	stop_agents
	stop_smh
	stop_snmp
	start_snmp
	svc_control "Starting System Management Homepage" start $SMHSVC 
	svc_control "Starting HP Insight Manager agents" start $ASMSVC
	post_splash install
}

uninstall() {
	splash
	verify_action "remove"
	verify_esx_version
	stop_agents
	stop_smh
	stop_snmp
	remove_packages "Removing HP Insight Manager agents" $AGENTLIST
	remove_packages "Removing HP System Management Homepage" $SMHLIST
	remove_packages "Removing SNMP stack" $SNMPLIST
	restore_snmp
	post_splash uninstall
}

usage() {
	splash
	echo "Usage:"
	echo ""
	echo "${0} {--install|--uninstall|--silent} [--inputfile filename]" 
	echo ""
	echo -e "--install:"
	echo -e "\tThis will attempt to install version 7.2.0 of the HP Insight"
	echo -e "\tManager Agents.  Any previous versions of the agents must"
	echo -e "\tbe removed before using the 'install' option."
	echo ""
	echo -e "--uninstall:"
	echo -e "\tThis will attempt to unistall the HP Insight Manager Agents"
	echo -e "\tfrom your sytem. You must be running versions 6.40 or"
	echo -e "\tlater. Versions prior to 6.40 must be uninstalled"
	echo -e "\tmanually."
	echo ""
	echo -e "--silent"
	echo -e "\tThis will attempt a silent installation of the HP Insight"
	echo -e "\tManager Agents.  Any previous versions of the agents must"
	echo -e "\tbe removed before using the '--silent' option. This option"
	echo -e "\talso requires the '--inputfile' option where filename points"
	echo -e "\tto the configuration file that contain your settings."
	echo -e "\tPlease see the readme and the hpmgmt.conf.example file for"
	echo -e "\tmore details" 
	exit 20
}

# START MAIN
verify_root
echo **********`date`********** >> $LOGFILENAME
case "$1" in
	--silent)
	SILENT=1
	if [ "$2" != "--inputfile" ]; then
		usage
	fi
	if [ ! -e "$3" ]; then
		echo $3
		echo "Input file does not exist!"
		exit 20;
	else
		. $3
	fi
	install
	;;
	--install)
	install
	;;
	--remove|--uninstall)
	uninstall
	;;
	*)
	usage
	;;
esac

exit 0
