#include "../CpqCiHlx.h"
#include "../CpqCiWrp.h"
#include "../CpqCiTyp.h"
#include "../CpqCiKlx.h"

#define	BUF_ORDER 3

//forware decl
static int print_adapter(char* buffer, int bufsize);
CPQCISIZE CpqCiSNPrintf(CPQCICHAR* buf, CPQCISIZE size, const CPQCICHAR* fmt, ...);

//externs
extern CPQCIADAPTEREXTENSION *CpqCi;
extern struct semaphore connection_list_lock;

//new entry
struct proc_dir_entry* cpqci_entry_print_cpqci;

void mk_buffer_print_cpqci(int* len, char** buf) {
	if (*buf == NULL) {
		*buf = (char*) __get_free_pages(GFP_KERNEL, BUF_ORDER);
		if(*buf) {
			memset(*buf, 0, (1<<BUF_ORDER));
			*len = print_adapter(*buf, (1<<BUF_ORDER) * PAGE_SIZE);
		}
	}
}

void del_buffer_print_cpqci(int* len, char** buf) {
	  if (*buf != NULL) {
			free_pages((unsigned long) *buf, BUF_ORDER);
			*buf = NULL;
			*len = 0;
	  }
}
//Generating function for proc entry "cpqci"
int cpqci_read_print_cpqci(char *Buf, char **start, off_t off, int count, int *eof, void *data)
{
	static int scratch_len = 0;
	static char* scratch = NULL;
	int len;
	DBG("print_cpqci off %x count %d\n", off, count);
	if (!scratch) {
		mk_buffer_print_cpqci(&scratch_len, &scratch);
	}
	if (scratch == NULL) return -EINVAL;
	len = scratch_len;
	if (len <= off+count) *eof = 1;
	len -= off;
	if (len>count) len = count;
	if (len<0) len = 0;
	if (off < scratch_len) memcpy(Buf+(off%PAGE_SIZE), scratch+off, len);
	*start = Buf + (off%PAGE_SIZE);
	if (*eof) {
		del_buffer_print_cpqci(&scratch_len, &scratch);
	}
	return len;
}

//Now, these are the print helpers.
int print_mem_handle(char* buffer, int bufsize, CPQCIDRVOSMEMHANDLE handle)
{
	int buflen = 0;
	if (handle == NULL) {
		PRINTF("(null)");
	} else {
		PRINTF("(p:%p, v:%p, s:%x)", handle->PhysicalAddress, handle->VirtualAddress, handle->MemorySize);
	}
	return buflen;
}


static int print_connection_extension(char* buffer, int bufsize, CPQCICONNECTIONEXTENSION* obj, struct _CPQCIADAPTEROBJECT* pao)
{
	int buflen = 0;

	PRINTF("(add:%p ", obj); 
	if (obj != NULL) {
		PRINTF("con:%d ", obj->Connection);
		PRINTF("obj: ");
		buflen+=print_connection_object(buffer+buflen, bufsize-buflen, get_connection_object(pao, obj->Connection));
	}
	PRINTF(")");
	return buflen;
}

static int print_adapter(char* buffer, int bufsize)
{
	int i;
	int buflen = 0;
	int used_channels = 0;
	CPQCICONNECTIONEXTENSION** pc;
    	struct _CPQCIADAPTEROBJECT* pao;

	if (!CpqCi) return 0;
	pao = CpqCi->Adapter;
	if (!pao) return 0;
	PRINTF("os conn use:\n");
	down(&connection_list_lock);
	pc = &CpqCi->ConnectionList;
	while (*pc) {
		int channel = (*pc)->Channel;
		used_channels |= (1<<channel);
		buflen+=print_connection_extension(buffer+buflen, bufsize-buflen, *pc, pao);
		PRINTF("\n");		
		pc = &((*pc)->Next);
	}
	up(&connection_list_lock);
	PRINTF("os channel use:\n");
	for (i=0; i<32; i++) {
		if ((used_channels & (1<<i)) == 0) continue;
		buflen+=print_channel_object(buffer+buflen, bufsize-buflen, i, get_channel_object(pao, i));
#if LINUX_VERSION_CODE >= 0x020300
		if (waitqueue_active(&CpqCi->RecvSignal[i])) {
			PRINTF("[*]");
		}
#else
		if (CpqCi->RecvSignal[i] != NULL) {
			PRINTF("[*]");
		}
#endif
		PRINTF("\n");		
	}

	return buflen;
}
/*
int print_adapter(char* buffer, int bufsize, CPQCIDRVOSMEMHANDLE handle)
{
	int buflen = 0;
    	CPQCIADAPTEROBJECT *pao = CpqCi->Adapter;
	return buflen;
}
*/
