#
# HP Insight Manager Agent 7.1.2 Installer
#
# 10/18/04

# *********************************************************************
# ** Global Variables that need to be modified with each SmartStart  **
# *********************************************************************
HPASM_PACKAGE="hpasm-7.1.2-21.vmware.i386.rpm"
HPRSM_PACKAGE="hprsm-7.1.2-19.vmware.i386.rpm"
UCD_SNMP_PACKAGE="ucd-snmp-cmaX-4.2.5-143.rh73.i386.rpm"
UCD_SNMP_UTILS_PACKAGE="ucd-snmp-cmaX-utils-4.2.5-143.rh73.i386.rpm"
CMANIC_PACKAGE="cmanic-7.1.2-3.linux.i686.rpm"

HPASM_PACKAGE_MD5=90647aaa36996afb8af45652275459fd
HPRSM_PACKAGE_MD5=275e3dd33cb3632a45358ef430c982d6
CMANIC_PACKAGE_MD5=7dd4800d0e9ae5f0dfc2400f4e03e848
UCD_SNMP_PACKAGE_MD5=38070178b9c196ffaab820d56932fe4b
UCD_SNMP_UTILS_PACKAGE_MD5=95c5825dd64a937427ceb7bb25a0666e

LOGFILE="hpmgmtlog"

SNMP_PKGLIST="UCD_SNMP_PACKAGE UCD_SNMP_UTILS_PACKAGE"
#Only include hprsm if iLO is found
cat /proc/bus/pci/devices | grep -i 0e11b203 > /dev/null 2>&1
if [ $? -eq 0 ]; then
        AGENT_PKGLIST="HPASM_PACKAGE HPRSM_PACKAGE CMANIC_PACKAGE"
else
        AGENT_PKGLIST="HPASM_PACKAGE CMANIC_PACKAGE"
fi
PKGLIST="${AGENT_PKGLIST} ${SNMP_PKGLIST}"
AGENTLIST="cmanic cmastor hprsm hpasm"
SNMPLIST="ucd-snmp-cmaX-utils ucd-snmp-cmaX ucd-snmp-utils ucd-snmp"
unset TMP

. /etc/init.d/functions

SETCOLOR_BLUE="echo -en \\033[1;34m"

splash() {
	$SETCOLOR_BLUE
	echo "HP Insight Manager Agent 7.1.2 Installer for VMware ESX Server"
	$SETCOLOR_NORMAL
	echo " "
}
error() {
	echo $1
	echo "Check $LOGFILE for additional information"
	exit 1
}

log() {
	echo $1 >> $LOGFILE
}

verify_action() {
	echo ""
	echo "This script will now attempt to $1 the HP Insight Manager Agents"
	echo -n "Do you wish to continue (y/n) "
	read answer
	if [ "$answer" != "y" ]; then
		error "Action cancelled by user"
	fi
}

verify_root() {
	if [ $UID != 0 ]; then
		error "You must be logged on as 'root' to continue"
	fi
}

verify_pkgs() {
	echo " Verifying RPM packages:"
	for i in $PKGLIST; do
		echo -ne "\tVerifying ${!i}"
		PKGMD5=${i}_MD5
		if [ "${!PKGMD5}" = `md5sum ${!i} | awk '{print $1}'` ]; then
			echo_success; echo " "
		else
			echo_failure; echo " "
			error "Package ${i} is either missing or corrupt"
		fi
	done
}

verify_esx_version() {
	echo -n " Verifying VMware ESX Server version is 2.1.x"
	vmware -v | awk '{print $4}' | grep "2.1\|2.5" >> $LOGFILE 2>&1
	if [ $? -eq 0 ]; then
		echo_success; echo " "
	else
		echo_failure; echo " "
		error "VMware ESX must be version 2.1.x"
	fi
}
verify_agent_version() {
	INSTALLEDAGENTS=`rpm -qa | grep "cmanic\|cmastor\|hprsm\|hpasm"`
	echo -n " Verifying installed HP agents are version 6.4 or later"
	if [ -z "$INSTALLEDAGENTS" ]; then
		echo_failure; echo " "
		error "No HP agents have been installed. Please run again with 'install' option."
	else
		AGENTSVER=`rpm -qa | grep "cmanic\|cmastor\|hprsm\|hpasm" | grep "6.4\|7.0\|7.1"`
		if [ "$AGENTSVER" != "$INSTALLEDAGENTS" ]; then
			echo_failure; echo " "
			error "Agents must be version 6.4 or later.  Upgrade cannot continue"
		fi
	fi
	echo_success; echo " "
}

check_installed() {
	INSTALLEDAGENTS=`rpm -qa | grep "cmanic\|cmastor\|hprsm\|hpasm"`
	echo -n " Checking for previously installed agents"
	if [ -z "$INSTALLEDAGENTS" ]; then
		echo_success; echo " "
	else
		echo_failure; echo " "
		error "Some agents have already been installed.  Please remove the previous installation\
			or run again with the 'upgrade' option."
	fi
}

verify_vmwaresnmp() {
	echo -n " Checking vmware-snmpd configuration"
	ls /etc/rc3.d/S*vmware-snmpd >> $LOGFILE 2>&1
	if [ $? -eq 0 ]; then
		SUBAGENT="Y"
		echo_success; echo  ""
	else
		SUBAGENT="N"
		echo_passed; echo " "
		echo WARNING: vmware-snmpd has not been configured.  You will not be able to\
			to see any VMware SNMP information
	fi
}
stop_agents() {
	echo " Stopping all HP agents:"
	for i in $AGENTLIST; do
		rpm -qa | grep ${i} >> $LOGFILE 2>&1
		if [ $? -eq 0 ]; then
			TMP=1
       			echo -ne "\tStopping ${i}"
                	service ${i} stop >> $LOGFILE 2>&1
                	if [ $? -eq 0 ]; then
				echo_success; echo " "
			else
				echo_failure; echo " "
				error "Unable to stop ${i} agent"
			fi
		fi
	done
	if [ -z "$TMP" ]; then
		echo_success; echo " "
	fi
	unset TMP
}
start_agents() {
	echo " Starting all HP agents:"
	for i in $AGENTLIST; do
		REVLIST="$i $REVLIST"
	done
	for i in $REVLIST; do
		rpm -qa | grep ${i} >> $LOGFILE 2>&1
		if [ $? -eq 0 ]; then
			TMP=1
       			echo -ne "\tStarting ${i}"
                	service ${i} start >> $LOGFILE 2>&1
                	if [ $? -eq 0 ]; then
				echo_success; echo " "
			else
				echo_failure; echo " "
				error "Unable to start ${i} agent"
			fi
		fi
	done
	if [ -z "$TMP" ]; then
		echo_success; echo " "
	fi
	unset TMP
}
remove_agents() {
        echo " Removing all HP agents:"
        for i in $AGENTLIST; do
                rpm -qa | grep ${i} >> $LOGFILE 2>&1
                if [ $? -eq 0 ]; then
			TMP=1
                        echo -ne "\tRemoving ${i}"
                        rpm -e --nodeps ${i} >> $LOGFILE 2>&1
                        if [ $? -eq 0 ]; then
				echo_success; echo " "
			else
                                echo_failure; echo " "
                                error "Unable to remove ${i}"
                        fi
                fi
        done
	if [ -z "$TMP" ]; then
                echo_success; echo " "
        fi
        unset TMP
}
stop_snmp() {
        echo " Stopping SNMP stack:"
	pidof vmware-snmpd >> $LOGFILE 2>&1
	if [ $? -eq 0 ]; then
		TMP=1
		echo -ne "\tStopping vmware-snmpd"
		service vmware-snmpd stop >> $LOGFILE 2>&1
		if [ $? -ne 0 ]; then
			echo_failure; echo " "
			error "Unable to stop vmware-snmpd"
		else
			echo_success; echo " "
		fi
	fi
	pidof snmpd >> $LOGFILE 2>&1
	if [ $? -eq 0 ]; then
		TMP=1
		echo -ne "\tStopping snmpd"
		service snmpd stop >> $LOGFILE 2>&1
		if [ $? -ne 0 ]; then
			echo_failure; echo " "
			error "Unable to stop snmpd"
		else
			echo_success; echo " "
		fi
	fi
	if [ -z "$TMP" ]; then
                echo_success; echo " "
        fi
        unset TMP
}

start_snmp() {
        echo " Starting SNMP stack:"
	echo -ne "\tStarting snmpd"
	service snmpd start >> $LOGFILE 2>&1
	if [ $? -ne 0 ]; then
		echo_failure; echo ""
		error "Unable to start snmpd"
	else
		echo_success; echo ""
	fi
	
	ls /etc/rc3.d/S*vmware-snmpd >> $LOGFILE 2>&1
	if [ $? -eq 0 ]; then
		echo -ne "\tStarting vmware-snmpd"
		service vmware-snmpd start >> $LOGFILE 2>&1
		if [ $? -ne 0 ]; then
			echo_failure; echo " "
			error "Unable to start vmware-snmpd"
		else
			echo_success; echo " "
		fi
	fi
}
remove_snmp() {
        echo " Removing SNMP stack:"
        for i in $SNMPLIST; do
                rpm -q ${i} >> $LOGFILE 2>&1
                if [ $? -eq 0 ]; then
                        echo -ne "\tRemoving ${i}"
                        rpm -e --nodeps ${i} >> $LOGFILE 2>&1
                        if [ $? -eq 0 ]; then
                                echo_success; echo " "
                        else
                                echo_failure; echo " "
                                error "Unable to remove ${i}"
                        fi
                fi
        done
}
cleanup() {
	echo -n " Cleaning up init scripts:"
	for i in $AGENTLIST; do
	        for j in `seq 0 6`; do
        	        rm -rf /etc/rc${j}.d/*${i} >> $LOGFILE 2>&1
        	done
        rm -rf /etc/init.d/*${i} >> $LOGFILE 2>&1
	rm -rf /etc/rc3.d/S99zvwsnmpd_restart >> $LOGFILE 2>&1
	done
	if [ $? -eq 0 ]; then
		echo_success; echo " "
	fi
}
restore_snmp() {
	echo -n " Restoring VMware snmpd configuration:"
	/usr/sbin/snmpsetup.sh restore >> $LOGFILE 2>&1
	 if [ $? -eq 0 ]; then
                echo_success; echo " "
        fi
}

upgrade_snmp() {
	# New SNMP stack has cmaX nomenclature, thus we need to remove old packages first
	remove_snmp	

	echo  " Upgrading SNMP stack:"
	for i in $SNMP_PKGLIST; do
		echo -ne "\t${!i}"
		rpm -ivh ${!i} >> $LOGFILE 2>&1
		if [ $? -eq 0 ]; then
			echo_success; echo " "
		else
			echo_failure; echo " "
			error "Unable to upgrade package ${!i}"
		fi
	done
}

install_agents() {
	echo " Installing HP Management Agents:"
	for i in $AGENT_PKGLIST; do
		echo -ne "\t${!i}"
		rpm -ivh ${!i} >> $LOGFILE 2>&1
		if [ $? -eq 0 ]; then
			echo_success; echo " "
		else
			echo_failure; echo " "
			error "Unable to install package ${!i}"
		fi
	done
}

upgrade_agents() {
	# New RPM won't allow us to use upgrade switch, we must uninstall first
	# Need to backup some config files
	echo -ne " Backing up Configuration Files:"
	unset FAIL
	if [ -e /etc/hpasmrc ]; then
		cp -f /etc/hpasmrc /tmp/hpasmrc.sav
		if [ $? -ne 0 ]; then
			FAIL=1
		fi
	fi
	if [ -e /etc/snmp/snmpd.conf ]; then
		cp -f /etc/snmp/snmpd.conf /tmp/snmpd.conf.sav
		if [ $? -ne 0 ]; then
			FAIL=1
		fi
	fi
	if [ -e /opt/compaq/cma.conf ]; then
		cp -f /opt/compaq/cma.conf /tmp/cma.conf.sav
		if [ $? -ne 0 ]; then
			FAIL=1
		fi
	fi
	if [ -z "$FAIL" ]; then
		echo_success; echo " "
	else
		echo_failure; echo " "
		error "Unable to save configuration files"
	fi
	
	remove_agents
	# Restore hpasmrc and snmpd
	echo -ne " Restoring Configuration Files:"
	if [ -e /tmp/hpasmrc.sav ]; then
		cp -f /tmp/hpasmrc.sav /etc/hpasmrc
		if [ $? -ne 0 ]; then
			FAIL=1
		else
			rm -f /tmp/hpasmrc.sav
		fi
	fi
	if [ -e /tmp/snmpd.conf.sav ]; then
		cp -f /tmp/snmpd.conf.sav /etc/snmp/snmpd.conf
		if [ $? -ne 0 ]; then
			FAIL=1
		else
			rm -f /tmp/snmpd.conf.sav
		fi
	fi
	if [ -z "$FAIL" ]; then
		echo_success; echo " "
	else
		echo_failure; echo " "
		error "Unable to save configuration files"
	fi
	
	echo " Upgrading HP Management Agents:"
	for i in $AGENT_PKGLIST; do
		echo -ne "\t${!i}"
		rpm -ivh ${!i} >> $LOGFILE 2>&1
		if [ $? -eq 0 ]; then
			echo_success; echo " "
		else
			echo_failure; echo " "
			error "Unable to upgrade package ${!i}"
		fi
	done
	# Finally restore cma.conf
	if [ -e /tmp/cma.conf.sav ]; then
		cp -f /tmp/cma.conf.sav /opt/compaq/cma.conf
		if [ $? -ne 0 ]; then
			FAIL=1
		else
			rm -f /tmp/cma.conf.sav
		fi
	fi
	if [ ! -z "$FAIL" ]; then
		echo_failure; echo " "
		error "Unable to save configuration files"
	fi
	unset FAIL
}

upgrade_cleanup() {
	echo -n " Post-upgrade cleanup"
	# Update init script links
	/usr/bin/perl -pi -e 's/S90/S91/g;s/K10/K09/g' /opt/compaq/hpasm/etc/hpasm
	if [ $? -ne 0 ]; then
		echo_failure; echo ""
		error "There was an error updating the hpasm package."
	fi
	# Fix init script priority for hpasm
	for i in `seq 0 6`; do
		if [ -e /etc/rc${i}.d/S90hpasm ]; then
			mv /etc/rc${i}.d/S90hpasm /etc/rc${i}.d/S91hpasm
			if [ $? -ne 0 ]; then
				echo_failure; echo ""
				error "There was an error updating the hpasm package."
			fi
		fi
		if [ -e /etc/rc${i}.d/K10hpasm ]; then
			mv /etc/rc${i}.d/K10hpasm /etc/rc${i}.d/K09hpasm
			if [ $? -ne 0 ]; then
				echo_failure; echo ""
				error "There was an error updating the hpasm package."
			fi
		fi
	done
	echo_success; echo ""
}
configure_vmwaresnmp() {
	echo "";echo ""

	# Need to edit snmpsetup.sh script from VMware to account for cmaX in snmp pkg
	/usr/bin/perl -pi -e 's/=\$CONSNMPD/=`echo \$CONSNMPD \| sed -e \"s\/-4\/\\\\(-cmaX\\\\)\\\\?-4\/g\"`/g' /usr/sbin/snmpsetup.sh
	/usr/bin/perl -pi -e 's/grep \$mainsnmpd/grep -E \$mainsnmpd/g' /usr/sbin/snmpsetup.sh

	echo "Linking vmware-snmpd to the ucd-snmp-cmaX daemon"
	if [ -e ./hpmgmt.conf ]; then
		. ./hpmgmt.conf
	else
		if [ $SUBAGENT = "N" ]; then
			echo "=============================================================================="
			echo "The VMware SNMP Sub-agent is currently disabled.  The sub-agent must be"
			echo "enable in order to see VMware SNMP information.  Would you like to enable"
			echo "it now? (y/n)"
			echo "=============================================================================="
			read ENABLEVMSNMP
		fi
		echo "=============================================================================="
		echo "Do you want to enable SNMP traps for virtual machine events? (y/n) "
		echo "=============================================================================="
		read ENABLEVMTRAPS
		SNMPCONFLOC=1
	fi
	mv /etc/vmware/config /etc/vmware/config.sav
	sed -e '/serverd.snmpdconf.subagentenabled/d' /etc/vmware/config.sav > /etc/vmware/config
	if [[ $ENABLEVMSNMP = "Y" || $ENABLEVMSNMP = "y" ]]; then
		chkconfig --level 2345 vmware-snmpd on
		echo "serverd.snmpdconf.subagentenabled = \"TRUE\"" >> /etc/vmware/config
	else
		service vmware-snmpd status | grep running >> $LOGFILE 2>&1
		if [ $? -eq 0 ]; then
			service vmware-snmpd stop >> $LOGFILE 2>&1
		fi
		chkconfig --level 2345 vmware-snmpd off >> $LOGFILE 2>&1
		echo "serverd.snmpdconf.subagentenabled = \"FALSE\"" >> /etc/vmware/config
	fi
	echo "Linking..."
	/usr/sbin/snmpsetup.sh connect <<EOT >> $LOGFILE 2>&1
$ENABLEVMTRAPS
$SNMPCONFLOC
EOT
	if [ $? -eq 0 ]; then
		echo -n " Linking vmware-snmpd"
		echo_success; echo " "
	else
		echo -n " Linking vmware-snmpd"
		echo_failure; echo " "
		error "There was a problem linking the snmpd daemons"
	fi
}

configure_hpasm() {
	# FIX priority of hpasm startup script to load after vmware
	/usr/bin/perl -pi -e 's/S90/S91/g;s/K10/K09/g' /opt/compaq/hpasm/etc/hpasm
	echo "";echo""
	
	if [ -e ./hpmgmt.conf ]; then
		. ./hpmgmt.conf
	else

	echo "Configuring the Advanced Server Management Package"
	echo "=============================================================================="
	echo "Configuring the Advanced Server Management Package.  You will need to"
	echo "provide some basic parameters and setup your passwords for the Web"
	echo "enabled agents.  For the SNMP community strings, you can use \"public\""
	echo "the default for now.  This is, however, very common and not very secure."
	echo "=============================================================================="
	echo -n "Press enter to continue: "
	read junk
	echo " "
	fi
	
	/opt/compaq/hpasm/etc/hpasm activate
	echo -n " HP Advanced Server Management configuration"
	if [ $? -eq 0 ]; then
		echo_success; echo " "
	else
		echo_failure; echo " "
		error " HP Advanced Server Management configuration failed"
	fi
}
install() {
	verify_esx_version
	verify_pkgs
	verify_vmwaresnmp
	check_installed
	stop_snmp
	upgrade_snmp
	install_agents
	configure_vmwaresnmp
	configure_hpasm
	stop_agents
	stop_snmp
	start_snmp
	start_agents
}
uninstall() {
	verify_esx_version
	stop_agents
	remove_agents
	stop_snmp
	remove_snmp
	cleanup
	restore_snmp
}
upgrade() {
	verify_esx_version
	verify_agent_version
	verify_pkgs
	verify_vmwaresnmp
	stop_agents
	stop_snmp
	upgrade_snmp
	upgrade_agents
	stop_agents
	stop_snmp
	upgrade_cleanup
	start_snmp
	start_agents
}

# START MAIN
verify_root
echo **********`date`********** >> $LOGFILE
splash
case "$1" in
	install)
	if [ "$2" != "now" ]; then
	verify_action "install"
	fi
	install
	;;
	remove|uninstall)
	if [ "$2" != "now" ]; then
	verify_action "remove"
	fi
	uninstall
	;;
	reinstall)
	if [ "$2" != "now" ]; then
	verify_action "reinstall"
	fi
	uninstall
	install
	;;	
#	upgrade)
#	if [ "$2" != "now" ]; then
#	verify_action "upgrade"
#	fi
#	upgrade
#	;;
	do)
	$2
	;;
	*)
	echo "Usage:"
	echo ""
#	echo "${0} {install|uninstall|reinstall|upgrade}" 
	echo "${0} {install|uninstall|reinstall}" 
	echo ""
	echo -e "install:"
	echo -e "\tThis will attempt to install version 7.1.2 of the HP Insight"
	echo -e "\tManager Agents.  Any previous versions of the agents must"
	echo -e "\tbe removed before using the 'install' option.  If you"
	echo -e "\tcurrently have version 6.40 or later of the agents installed,"
	echo -e "\ttry the 'upgrade' or 'reinstall' option."
	echo ""
	echo -e "uninstall:"
	echo -e "\tThis will attempt to unistall the HP Insight Manager Agents"
	echo -e "\tfrom your sytem. You must be running versions 6.40 or"
	echo -e "\tlater. Versions prior to 6.40 must be uninstalled"
	echo -e "\tmanually."
	echo ""
	echo -e "reinstall:"
	echo -e "\tThis will attempt to install version 7.1.2 of the HP Insight"
	echo -e "\tManager Agents. Previously installed agents will be"
	echo -e "\tremoved first and configuration information will be lost."
	echo -e "\tIf you are running agents prior to version 6.40, please"
	echo -e "\tuninstall them manually; then run this script with the"
	echo -e "\t'install' option."
	echo ""
#	echo -e "upgrade:"
#	echo -e "\tThis will attempt to upgrade your previously installed"
#	echo -e "\tHP Insight Manager Agents from 6.40 or later to"
#	echo -e "\tversion 7.1.2.  Current SNMP configuration information will"
#	echo -e "\tbe retained."
#	echo ""
	exit 1;
	;; 
esac
echo ""
echo "$1 completed successfully!!"
echo ""
exit 0
