// $Id: NC-CMMN.JS,v 1.14 2004/02/26 19:22:31 tonycu Exp $
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->


var logicalSpeed;  // this is where i'm declaring the global variable
var ifVlanId;
var ifVlanName;

function physName( physIndex )
{
   var i, j;
   var pname = "Single NIC";

   for(i=0; i<cpqNicIfPhysAdapterEntry.length; i++)
   {
      if( physIndex == cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterIndex )
      {
         break;
      }
   }

   if(i < cpqNicIfPhysAdapterEntry.length)
   {

      // create an object that mimics an entry in the nicinfotable to fake out the
      // function getModelName from the older NIC stuff
      nic = new Object;
      nic.ioaddr = cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterIoAddr;
			nic.memaddr = cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterMemAddr;
      nic.memtype = 2;

      if(nic.ioaddr == 0)    //=0 -> memory mapped i/o  (jo012500)
      {
        nic.ioaddr = cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterMemAddr;
        nic.memtype = 3;
      }

      
      nic.slot = cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterSlot;

      for(j=0;j<cpqNicIfPhysAdapterEntry.length; j++)
      {
         if( physIndex!=cpqNicIfPhysAdapterEntry[j].cpqNicIfPhysAdapterIndex &&
             nic.slot == cpqNicIfPhysAdapterEntry[j].cpqNicIfPhysAdapterSlot )
             {
               nic.needport = true;
               nic.port = cpqNicIfPhysAdapterEntry[i].cpqNicIfPhysAdapterPort;
             }
      }

      if( -1==nic.slot || 4294967295==nic.slot){  // old way was 0 for both embedded and unknown
		  nic.real_slot = nic.slot;
         nic.slot = 0;     // new way has 0 for embedded and 255 for unknown
		}
      pname = buildString( nic );
   }

   return pname;
}



function nicName( logNicIndex )
{
   var i,j;
   var logName = "unknown NIC";
   var ifnum;

   for(i=0; i<cpqNicIfLogMapEntry.length; i++)
   {
      if( cpqNicIfLogMapEntry[i].cpqNicIfLogMapIndex == logNicIndex )
      {
         break;
      }
   }

   if( i < cpqNicIfLogMapEntry.length )
   {
      ifnum=0;
      for(j=0; j<4 && j<cpqNicIfLogMapIfNumber[i].length; j++)
      {
         ifnum += cpqNicIfLogMapIfNumber[i][j] << 8*j;
      }
var ifnumDisplay = ifnum.toString(16);

      if( cpqNicIfLogMapEntry[i].cpqNicIfLogMapGroupType > 2 )
      {
         logName = cpqNicIfLogMapEntry[i].cpqNicIfLogMapDescription;
         if(""==logName)
         {
            logName = dispBase("cpqNicIfLogMapGroupType", cpqNicIfLogMapEntry[i].cpqNicIfLogMapGroupType);
         }

         logName = logName + " (" + ifnumDisplay + ")";
      }
      else if( 0 == cpqNicIfLogMapEntry[i].cpqNicIfLogMapAdapterCount )
      {
         logName = "Virtual interface " + ifnumDisplay;
      }
      else
      {
         logName = physName( cpqNicIfLogMapPhysicalAdapters[i][0] );
      }

   }

   return logName;
}



function writeControllerInfo( physindex )
{
   with( cpqNicIfPhysAdapterEntry[physindex] )
   {
      var model;
      var nic = new Object;
      var label;
      var nicType;
      var ifindex;
      var i;
      var slot;

      // fake out old getModelName function by creating a nic object and
      // putting in the necessary members to have that function work
      nic.ioaddr = cpqNicIfPhysAdapterIoAddr;
			nic.memaddr = cpqNicIfPhysAdapterMemAddr;
      nic.memtype = 2;
      if(nic.ioaddr == 0)    //=0 -> memory mapped i/o  (jo012500)
      {
    nic.ioaddr = cpqNicIfPhysAdapterMemAddr;
    nic.memtype = 3;
      }
      nic.slot = -1==cpqNicIfPhysAdapterSlot || 4294967295==cpqNicIfPhysAdapterSlot ? 0 : cpqNicIfPhysAdapterSlot;  // new way is 0->embedded, -1->unknown old was 0 for both
		nic.real_slot = cpqNicIfPhysAdapterSlot;
      model = getModelName( nic );
      if(""==model)  model = "Unknown";

      label = "Controller Information";
      nicType = 1;
      if( 3 < window.cpqNicIfPhysAdapterIfNumber[physindex].length )
      {
         ifindex=0;
         for(i=0;i<4;i++)
         {
            ifindex += window.cpqNicIfPhysAdapterIfNumber[physindex][i] << (4*i);
         }
         for(i=0;i<ifEntry.length;i++)
         {
            if( ifindex == ifEntry[i].ifIndex )
            {
               nicType = ifEntry[i].ifType;
               break;
            }
         }
      }

      if(1<nicType)
      {
         label = displayItem("ifType", nicType) + " " + label;
      }

      writeTableLabel( label );
      writeTableHead();
      writeSingleTableRowInDoubleTable(
         "Model:",   model
         );
      writeDoubleTableRow(
         "Status:",  displayItem( "cpqNicIfPhysAdapterStatus", cpqNicIfPhysAdapterStatus),
         "Role:",    displayItem( "cpqNicIfPhysAdapterRole",   cpqNicIfPhysAdapterRole)
         );

      slot = displayItem( "cpqNicIfPhysAdapterSlot",   cpqNicIfPhysAdapterSlot);
      if(-1==slot || 4294967295==slot)
         slot = "Unknown";
      else if(0==slot)
         slot = "Embedded";

      writeDoubleTableRow(
         "Slot:", slot,
         "Port:", displayItem( "cpqNicIfPhysAdapterPort",   cpqNicIfPhysAdapterPort)
         );

//code block below must be exactly like this to work in both Netscape and IE browsers
      if(0>cpqNicIfPhysAdapterMemAddr)
      {
            cpqNicIfPhysAdapterMemAddr = - cpqNicIfPhysAdapterMemAddr;
            cpqNicIfPhysAdapterMemAddr = (0xFFFFFFFF+1) - cpqNicIfPhysAdapterMemAddr ;
      }
      upperMemAddr = (cpqNicIfPhysAdapterMemAddr >> 4) & 0xfffffff;
      lowerMemAddr = cpqNicIfPhysAdapterMemAddr & 0xf;
      hexMemAddr = upperMemAddr.toString(16).toUpperCase() + lowerMemAddr.toString(16).toUpperCase() + "h";
//end block

      writeDoubleTableRow(
         "Duplex:",        displayItem( "cpqNicIfPhysAdapterDuplexState",  cpqNicIfPhysAdapterDuplexState),
         "Base Mem Addr:",  0==cpqNicIfPhysAdapterMemAddr ? "N/A" : hexMemAddr
         );
      writeDoubleTableRow(
         "Base I/O Addr:", 0==cpqNicIfPhysAdapterIoAddr ? "N/A" : (cpqNicIfPhysAdapterIoAddr-0).toString(16) + "h",
         "DMA Channel:",   displayItem( "cpqNicIfPhysAdapterDma",  cpqNicIfPhysAdapterDma)
         );
      writeDoubleTableRow(
         "IRQ:",              0==cpqNicIfPhysAdapterIrq ? "N/A" : cpqNicIfPhysAdapterIrq,
         "Physical Address:", rawToHex( window.cpqNicIfPhysAdapterMACAddress[physindex], " ")
         );

      if(1 == cpqNicIfPhysAdapterStatsValid)
      {
         writeSingleTableRowInDoubleTable( "&#160", "&#160" );
         writeDoubleTableRow( "<u>Receive Statistics</u>",  "&#160", "<u>Transmit Statistics</u>",  "&#160");
         writeDoubleTableRow(
            "Good Frames:",   displayItem("cpqNicIfPhysAdapterGoodReceives", cpqNicIfPhysAdapterGoodReceives),
            "Good Frames:",   displayItem("cpqNicIfPhysAdapterGoodTransmits", cpqNicIfPhysAdapterGoodTransmits)
            );
         writeDoubleTableRow(
            "Bad Frames:",   displayItem("cpqNicIfPhysAdapterBadReceives", cpqNicIfPhysAdapterBadReceives),
            "Bad Frames:",   displayItem("cpqNicIfPhysAdapterBadTransmits", cpqNicIfPhysAdapterBadTransmits)
            );
         writeDoubleTableRow(
            "Alignment Errors:",   displayItem("cpqNicIfPhysAdapterAlignmentErrors", cpqNicIfPhysAdapterAlignmentErrors),
            "Carrier Sense Err:",   displayItem("cpqNicIfPhysAdapterCarrierSenseErrors", cpqNicIfPhysAdapterCarrierSenseErrors)
            );
         writeDoubleTableRow(
            "Frame Too Long:",   displayItem("cpqNicIfPhysAdapterFrameTooLongs", cpqNicIfPhysAdapterFrameTooLongs),
            "Mult. Coll. Frames:",   displayItem("cpqNicIfPhysAdapterMultipleCollisionFrames", cpqNicIfPhysAdapterMultipleCollisionFrames)
            );
         writeDoubleTableRow(
            "FCS Errors:",   displayItem("cpqNicIfPhysAdapterFCSErrors", cpqNicIfPhysAdapterFCSErrors),
            "Late Collisions:",   displayItem("cpqNicIfPhysAdapterLateCollisions", cpqNicIfPhysAdapterLateCollisions)
            );
         writeDoubleTableRow(
            "MAC Recv Errs:",   displayItem("cpqNicIfPhysAdapterInternalMacReceiveErrors", cpqNicIfPhysAdapterInternalMacReceiveErrors),
            "Single Coll. Frames:",   displayItem("cpqNicIfPhysAdapterSingleCollisionFrames", cpqNicIfPhysAdapterSingleCollisionFrames)
            );
         writeDoubleTableRow(
            "&#160", "&#160",
            "Excessive Coll.:",   displayItem("cpqNicIfPhysAdapterExcessiveCollisions", cpqNicIfPhysAdapterExcessiveCollisions)
            );
         writeDoubleTableRow(
            "&#160", "&#160",
            "Deferred Xmits:",   displayItem("cpqNicIfPhysAdapterDeferredTransmissions", cpqNicIfPhysAdapterDeferredTransmissions)
            );
         writeDoubleTableRow(
            "&#160", "&#160",
            "MAC Xmit Errs:",   displayItem("cpqNicIfPhysAdapterInternalMacTransmitErrors", cpqNicIfPhysAdapterInternalMacTransmitErrors)
            );
      }
      writeTableTail();
   }
}


function writeIfInfo( ifindex, vlanId, vlanName,sysUpTime, logindex )
{
   var i;
   var tableindex;
   var buffer1;
   var x, i;
   var physAddress;
   var lastChange;
   var diffTimeValue, diffDays, diffHours, diffMinutes;
   var statindex, protocolindex;
   var interfaceStatus;
   var speed =  cpqNicIfLogMapEntry[logindex].cpqNicIfLogMapSpeed;
   var ifLastChange =  cpqNicIfLogMapEntry[logindex].cpqNicIfLogMapLastChange;

   for(tableindex=0;tableindex<ifEntry.length;tableindex++)
   {
      if(ifEntry[tableindex].ifIndex == ifindex )
      {

    //hack so that the interface description does not include the string "&#000" - problem unique to Win2000
    if((ifDescPosition =ifEntry[tableindex].ifDescr.lastIndexOf("&#000")) != -1)
    {
        ifEntry[tableindex].ifDescr = ifEntry[tableindex].ifDescr.substring(0,ifDescPosition);
    }
    //end of hack

         writeTableLabel("Interface Information - " + displayItem("ifDescr", ifEntry[tableindex].ifDescr));

         writeTableHead();

         for(i=0; i<ipAddrEntry.length; i++)
         {
            if( ipAddrEntry[i].ipAdEntIfIndex == ifindex )
            {
               writeSingleTableRowInDoubleTable("IP Address:", ipAdEntAddr[i][0] + "." + ipAdEntAddr[i][2] + "." +
                  ipAdEntAddr[i][4] + "." + ipAdEntAddr[i][6]);
               break;
            }
         }

        if ( vlanId > 0 )
        {
            //writeDoubleTableRow( "VLAN Id:", displayItem( "cpqNicIfVlanMapVlanId", vlanId,
            //    "VLAN Name:", displayItem( "cpqNicIfVlanMapVlanName", vlanName );

            writeDoubleTableRow( "VLAN Id:", displayItem( "cpqNicIfVlanMapVlanId", vlanId), "VLAN Name:", vlanName );
        }

        if ( tableindex > 0 )
        {
            if (speed >= 1000000)
                speed = (speed/1000000) + " Mbit/Sec";
        }
        else if(cpqHoInfo.cpqHoOsType == 2)
        {
           if (speed >= 1000000)
               speed = (speed/1000000) + " Mbit/Sec";
        }
        else
            speed = "N/A";
	if(cpqNicIfLogMapEntry[logindex].cpqNicIfLogMapCondition == 4)
	  speed = "Unknown";

         writeDoubleTableRow("Type:",  displayItem("ifType", ifEntry[tableindex].ifType),
            "Speed:", displayItem("ifSpeed", speed));


         buffer1 = "";
         for (x=0; x<=5; x++)
         {
            if (ifPhysAddress[tableindex][x] == null)
               buffer1 = buffer1 + "00 ";
            else
               buffer1 = buffer1 +
            hexfromdec(ifPhysAddress[tableindex][x]).substring(2, 4) + " ";
         }
         if (buffer1 == "00 00 00 00 00 00 ")
            physAddress = "N/A";
         else
            physAddress = buffer1;


	// Determine the interface status from cpqNicIfPhysAdapterStatus. A "OK" in cpqNicIfPhysAdapterStatus
	 // is treated as "Up" and everything else is treated as "Down". Assuming that the 'tableindex' used to
	 // determine index into ifEntry table can be used to get the index into cpqNicPhysAdapterEntry table.
	 // This change affects all the Operating Systems (Windows, Netware and Linux). The issue is with the
	 // Netware and Linux not updating the ifOperStatus, when link is lost on a NIC.


         writeDoubleTableRow(
              "Interface Status:", displayItem("cpqNicIfLogMapCondition",
		 cpqNicIfLogMapEntry[logindex].cpqNicIfLogMapCondition),
                        "Physical Addr:",    displayItem("ifPhysAddress", physAddress)
            );

         //if (ifEntry[tableindex].ifLastChange < 0 || sysUpTime < 0)
         if (ifLastChange < 0 || sysUpTime < 0)
            lastChange = "N/A";
         else
         {
            diffTimeValue = (sysUpTime - ifLastChange) / 6000;
            diffDays = parseNicInt( diffTimeValue / 1440 ); 
            diffHours = parseNicInt( (diffTimeValue % 1440) / 60);
            diffMinutes = parseNicInt( diffTimeValue % 60);
            if (diffDays > 0)
            {
               lastChange = diffDays + " Days, " +
                  diffHours + " Hours, " +
                  diffMinutes + " Minutes ago";
            }
            else
            if (diffHours > 0)
            {
               lastChange = diffHours + " Hours, " +
                  diffMinutes + " Minutes ago";
            }
            else
               lastChange = diffMinutes + " Minutes ago";
         }
         writeDoubleTableRow(
            "Max Packet Size:",     displayItem("ifMtu", ifEntry[tableindex].ifMtu + " bytes"),
            "Last Status Change:",  displayItem("ifLastChange", lastChange)
            );

         writeDoubleTableRow("<br><u>Receive Statistics</u>", "&#160", "<br><u>Transmit Statistics</u>", "&#160");
         writeDoubleTableRow(
            "Bytes:", displayStatItem(ifEntry[tableindex].ifInOctets),
            "Bytes:", displayStatItem(ifEntry[tableindex].ifOutOctets)
            );
         writeDoubleTableRow(
            "Total Packets:", displayStatItem((parseNicInt(ifEntry[tableindex].ifInUcastPkts) +
               parseNicInt(ifEntry[tableindex].ifInNUcastPkts) +
               parseNicInt(ifEntry[tableindex].ifInDiscards) +
               parseNicInt(ifEntry[tableindex].ifInErrors) +
               parseNicInt(ifEntry[tableindex].ifInUnknownProtos))),
            "Total Packets:", displayStatItem((parseNicInt(ifEntry[tableindex].ifOutUcastPkts) +
               parseNicInt(ifEntry[tableindex].ifOutNUcastPkts) +
               parseNicInt(ifEntry[tableindex].ifOutDiscards) +
               parseNicInt(ifEntry[tableindex].ifOutErrors)))
               );
         writeDoubleTableRow(
            "Unicast Packets:", displayStatItem(ifEntry[tableindex].ifInUcastPkts),
            "Unicast Packets:",  displayStatItem(ifEntry[tableindex].ifOutUcastPkts)
            );
         writeDoubleTableRow(
            "Non-Unicast Packets:", displayStatItem(ifEntry[tableindex].ifInNUcastPkts),
            "Non-Unicast Packets:", displayStatItem(ifEntry[tableindex].ifOutNUcastPkts)
            );
         writeDoubleTableRow(
            "Discarded Packets:", displayStatItem(ifEntry[tableindex].ifInDiscards),
            "Discarded Packets:", displayStatItem(ifEntry[tableindex].ifOutDiscards)
            );
         writeDoubleTableRow(
            "Error Packets:", displayStatItem(ifEntry[tableindex].ifInErrors),
            "Error Packets:", displayStatItem(ifEntry[tableindex].ifOutErrors)
            );
         writeDoubleTableRow(
            "Unknown Protocols:", displayStatItem(ifEntry[tableindex].ifInUnknownProtos),
            "Queue Length:", displayStatItem(ifEntry[tableindex].ifOutQLen)
            );

         writeTableTail();

         if( 6 == ifEntry[tableindex].ifType || 7 == ifEntry[tableindex].ifType )
         {
            for(statindex=0; statindex < dot3StatsEntry.length; statindex++)
            {

               if( dot3StatsEntry[statindex].dot3StatsIndex == ifindex )
               {
                  document.write("<br>");
                  writeEthernetStats( statindex );
                  break;
               }
            }
         }
         else if( 9 == ifEntry[tableindex].ifType )
         {

            for(protocolindex=0; protocolindex<dot5Entry.length; protocolindex++)
            {
               
               if( dot5Entry[protocolindex].dot5IfIndex == ifindex )
               {

                  document.write("<br>");
                  
                  writeTokenRingInfo( protocolindex );
               }
            }

            for(statindex=0; statindex < dot5StatsEntry.length; statindex++)
            {
               
               if( dot5StatsEntry[statindex].dot5StatsIfIndex == ifindex )
               {

                  document.write("<br>");

                  writeTokenRingStats( statindex );
                  break;
               }
            }
         }
      }
   }
}


function writeEthernetStats( dot3pageindex )
{
   var   receiveTotalErrors,
         frameTooLongs,
         alignmentErrors,
         macReceiveErrors,
         fcsErrors,
         transmitTotalErrors,
         macTransmitErrors,
         carrierSenseErrors,
         multipleCollisionFrames,
         lateCollisions,
         singleCollisionFrames,
         excessiveCollisions,
         deferredTransmissions
         ;
   frameTooLongs = dot3StatsEntry[dot3pageindex].dot3StatsFrameTooLongs;
   alignmentErrors = dot3StatsEntry[dot3pageindex].dot3StatsAlignmentErrors;
   macReceiveErrors = dot3StatsEntry[dot3pageindex].dot3StatsInternalMacReceiveErrors;
   fcsErrors = dot3StatsEntry[dot3pageindex].dot3StatsFCSErrors;

   if(-1 == fcsErrors || 4294967295 == fcsErrors)
     fcsErrors = 0;

   receiveTotalErrors = displayStatItem(
      parseNicInt(alignmentErrors) +
      parseNicInt(fcsErrors) +
      parseNicInt(frameTooLongs) +
      parseNicInt(macReceiveErrors)
      );
   frameTooLongs = displayStatItem(frameTooLongs);
   alignmentErrors = displayStatItem(alignmentErrors);
   macReceiveErrors = displayStatItem(macReceiveErrors);
   fcsErrors = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsFCSErrors);
   transmitTotalErrors = displayStatItem(
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsCarrierSenseErrors) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsLateCollisions) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsExcessiveCollisions) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsInternalMacTransmitErrors) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsMultipleCollisionFrames) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsSingleCollisionFrames) +
      parseNicInt(dot3StatsEntry[dot3pageindex].dot3StatsDeferredTransmissions)
      );
   macTransmitErrors = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsInternalMacTransmitErrors);
   carrierSenseErrors = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsCarrierSenseErrors);
   multipleCollisionFrames = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsMultipleCollisionFrames);
   lateCollisions = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsLateCollisions);
   singleCollisionFrames = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsSingleCollisionFrames);
   excessiveCollisions = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsExcessiveCollisions);
   deferredTransmissions = displayStatItem(dot3StatsEntry[dot3pageindex].dot3StatsDeferredTransmissions);

   writeTableLabel("Interface Ethernet Statistics");
   writeTableHead();
   writeDoubleTableRow("<u>Receive Errors</u>", "", "", "");
   writeDoubleTableRow(
    "Total Errors:",     receiveTotalErrors,
    "Frame Too Long:",   frameTooLongs
    );
   writeDoubleTableRow(
      "Alignment Errors:", alignmentErrors,
      "MAC Recv Errs:",    macReceiveErrors
      );
   writeDoubleTableRow(
      "FCS Errors:", fcsErrors,
      "",            ""
      );

   writeDoubleTableRow("&#160<br><u>Transmit Errors</u>", "", "", "");
   writeDoubleTableRow(
     "Total Errors:",  transmitTotalErrors,
     "MAC Xmit Errs:", macTransmitErrors
     );
   writeDoubleTableRow(
     "Carrier Sense Err:",   carrierSenseErrors,
     "Mult. Coll. Frames:",  multipleCollisionFrames
     );
   writeDoubleTableRow(
     "Late Collisions:",     lateCollisions,
     "Single Coll. Frames:", singleCollisionFrames
     );
   writeDoubleTableRow(
     "Excessive Coll:",   excessiveCollisions,
     "Deferred Xmits:",   deferredTransmissions
     );
   writeTableTail();
}


function writeTokenRingInfo( dot5pageindex )
{
   var   ringSpeed,
         upstreamAddr,
         ringState,
         actMonParticipate,
         ringStatus,
         functionalAddr,
         ringOpenStatus
         ;

   ringSpeed = displayNicItem("dot5RingSpeed", dot5Entry[dot5pageindex].dot5RingSpeed);
   if ( "0,0,0,0,0,0" == dot5UpStream[dot5pageindex] )
        upstreamAddr = "N/A";
   else
        upstreamAddr = rawToHex( dot5UpStream[dot5pageindex], " ");
   ringState = displayNicItem("dot5RingState", dot5Entry[dot5pageindex].dot5RingState);
   actMonParticipate = displayNicItem("dot5ActMonParticipate", dot5Entry[dot5pageindex].dot5ActMonParticipate);
   //ringStatus = rawToHex( dot5RingStatus[dot5pageindex], " ");
   ringStatus = (dot5Entry[dot5pageindex].dot5RingStatus - 0).toString(16) + "h"; 
   functionalAddr = rawToHex(dot5Functional[dot5pageindex], " ");
   ringOpenStatus = displayNicItem("dot5RingOpenStatus", dot5Entry[dot5pageindex].dot5RingOpenStatus);

   writeTableLabel("Interface Token Ring Information");
   writeTableHead();
   writeDoubleTableRow(
    "Ring Speed:",    ringSpeed,
    "Upstream Addr:", upstreamAddr
    );
   writeDoubleTableRow(
    "Ring State:",       ringState,
    "Active Monitor:",   actMonParticipate
    );
   writeDoubleTableRow(
    "Ring Status:",      ringStatus,
    "Functional Addr:",  functionalAddr
    );
   writeDoubleTableRow(
    "Ring Open Status:", ringOpenStatus,
    "",                  ""
    );
   writeTableTail();

}


function writeTokenRingStats( dot5statsindex )
{
   var   lostFrameErrors,
         internalErrors,
         receiveCongestions,
         tokenErrors,
         frameCopiedErrors,
         transmitBeacons,
         abortTransErrors,
         removes,
         softErrors,
         recoverys,
         hardErrors,
         lobeWires,
         lineErrors,
         signalLoss,
         burstErrors,
         freqErrors,
         acErrors,
         singles
         ;

   lostFrameErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsLostFrameErrors);
   internalErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsInternalErrors);
   receiveCongestions = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsReceiveCongestions);
   tokenErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsTokenErrors);
   frameCopiedErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsFrameCopiedErrors);
   transmitBeacons = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsTransmitBeacons);
   abortTransErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsAbortTransErrors);
   removes = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsRemoves);
   softErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsSoftErrors);
   recoverys = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsRecoverys);
   hardErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsHardErrors);
   lobeWires = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsLobeWires);
   lineErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsLineErrors);
   signalLoss = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsSignalLoss);
   burstErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsBurstErrors);
   freqErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsFreqErrors);
   acErrors = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsACErrors);
   singles = displayStatItem(dot5StatsEntry[dot5statsindex].dot5StatsSingles);

   writeTableLabel("Interface Token Ring Statistics");
   writeTableHead();
   writeDoubleTableRow(
       "Lost Frame Errors:",   lostFrameErrors,
       "Internal Errors:",     internalErrors
       );
   writeDoubleTableRow(
       "Receive Congest:",  receiveCongestions,
       "Token Errors:",     tokenErrors
       );
   writeDoubleTableRow(
       "Frame Copy Errors:",   frameCopiedErrors,
       "Xmit Beacons:",        transmitBeacons
       );
   writeDoubleTableRow(
       "Abort Xmit Errors:",   abortTransErrors,
       "Removes:",             removes
       );
   writeDoubleTableRow(
       "Soft Errors:",   softErrors,
       "Recoveries:",    recoverys
       );
   writeDoubleTableRow(
       "Hard Errors:",   hardErrors,
       "Lobe Faults:",   lobeWires
       );
   writeDoubleTableRow(
       "Line Errors:",   lineErrors,
       "Signal Loss:",   signalLoss
       );
   writeDoubleTableRow(
       "Burst Errors:",     burstErrors,
       "Frequency Errs:",   freqErrors
       );
   writeDoubleTableRow(
       "AC Errors:",        acErrors,
       "Single Station:",   singles
       );
   writeTableTail();
}
