<?php

# determine the current directory and modify it to determine the directory to look for
# INI files in
#echo "\n// ginkgoprop included here\n";

$OIDtoProperty = array();
$RequestProperties = array();

$default_read_level = 1;    //  anonymous
$default_write_level = 0;   // unwriteable

function ReadProperties()
{

    $scriptfile = $_SERVER['SCRIPT_FILENAME'];
    if( $lastslash = strrpos( $scriptfile, '/' ) )  // intentional assign in conditional
    {
        $scriptfile = substr( $scriptfile, 0, $lastslash );
    }
    $inifiledir = str_replace( 'htdocs', 'webapp-data', $scriptfile);

    # strip of an ending /common in case we are using this from the <agent>/common dir
    if ('common' == substr( $inifiledir, -6))
    {
        $inifiledir = substr( $inifiledir, 0, strlen($inifiledir)-7);
    }

    #echo "//looking for ini files in $inifiledir\n";

    if(is_dir( $inifiledir ))
    {
        $dh = opendir( $inifiledir );

        while($onefile = readdir( $dh ))     // intentional assignment in conditional
        {
            $onefile = "$inifiledir/$onefile";  // make it fully qualified
            // check for .INI files
            if( is_file( $onefile ) && !strcmp( ".ini", substr( $onefile, -4 )))
            {
                ProcessINIFile( $onefile );
            }
        }

        closedir($dh);
    }
}

function ProcessINIFile( $fname )
{
    global $OIDtoProperty;

    #echo "\n\n// processing inifile $fname\n";

    $currentProperty = "";

    $fp = fopen( $fname, 'r' );

    while ($line = fgets($fp, 100))
    {
        $line = trim($line);

        if (strlen($line))
        {

            if( '[' == $line[0] )
            {
                # this is a group definition (property)
                if( $close = strpos( $line, ']' ))  // intentional assignment in conditional
                {
                    $currentProperty = substr( $line, 1, $close-1 );
                }
            }
            else if (strlen($currentProperty))
            {
                # this is an OID definition that needs to
                # be related to the current group/property definition
                if( $firstspace = strpos( $line, ' ' ) )    // intentional assignment in conditional
                {
                    $line = substr( $line, 0, $firstspace );
                }

                $OIDtoProperty[ $line ] = $currentProperty;

                #echo "\n\n// added $line = $currentProperty\n";
            }
        }
    }

    fclose($fp);
}


function ParseHeader()
{
    global $RequestProperties;

    $requesturi = $_SERVER["REQUEST_URI"];
    $webappname = substr( $requesturi, 1, strpos( $requesturi, '/', 1 ) - 1 );

    $header = "HTTP_" . strtoupper( $webappname ) . "_PROP";

    if( array_key_exists( $header, $_SERVER ))
    {
        $proplist = split( ';', $_SERVER[ $header ] );

        foreach( $proplist as $oneprop )
        {
            if( strpos( $oneprop, ':' ))
            {
                $propvalpair = split( ':', $oneprop );

                $RequestProperties[ $propvalpair[0] ] = $propvalpair[1];

                #echo "\n\n//---added value $propvalpair[1] for property $propvalpair[0]\n";
            }
        }
    }
}

function GetAccess( $varname, $oid )
{
    global $OIDtoProperty;
    global $RequestProperties;

    $rc = 1;    // read, no write

    if( array_key_exists( $oid, $OIDtoProperty ))
    {
        $property = $OIDtoProperty[ $oid ];

        // check settings for property from header
        if( array_key_exists( $property, $RequestProperties ))
        {
            $value = $RequestProperties[ $property ];

            if( '11' == $value )    $rc = 3;
            elseif ('10' == $value )$rc = 1;
            elseif ('01' == $value )$rc = 2;
            elseif ('00' == $value )$rc = 0;
        }
    }

    echo "\n$varname = $rc;\n";
}


function OIDWriteAccess( $oid )
{
    global $OIDtoProperty;
    global $RequestProperties;

    $rc = FALSE;    // read, no write

    #echo "<br>OIDWriteAccess check on $oid\n";

    if( array_key_exists( $oid, $OIDtoProperty ))
    {
        $property = $OIDtoProperty[ $oid ];

        #echo "property found\n";

        // check settings for property from header
        if( array_key_exists( $property, $RequestProperties ))
        {
            $value = $RequestProperties[ $property ];

            if( '11' == $value )    $rc = TRUE;
            elseif ('10' == $value )$rc = FALSE;
            elseif ('01' == $value )$rc = TRUE;
            elseif ('00' == $value )$rc = FALSE;
        }
    }

    return $rc;
}


ReadProperties();   // kick it off
ParseHeader();
?>
