// $RCSfile: ms-scsic.js,v $ $Revision: 1.2 $

function jpnSlot(str)
{
   var slot = "Xbg ";
   var offset = -1;

   if (str.length > 5)
      offset = str.indexOf("Slot ");
   if (offset >= 0)
     slot += str.substring(offset + 5);
   else slot += "T|[g";
   return slot;
}
function scsiCntlrName(idx)
{
   var rc = "SCSI Rg[ ";
   if (cpqScsiCntlrEntry[idx].cpqScsiCntlrHwLocation != "")
   {
      if (cpqScsiCntlrEntry[idx].cpqScsiCntlrHwLocation == "Slot 0")
         rc = "VXe{[h - " + rc;
      else
         rc = jpnSlot(cpqScsiCntlrEntry[idx].cpqScsiCntlrHwLocation) + " - " + rc;
   }
   else if (cpqScsiCntlrEntry[idx].cpqDaCntlrSlot == 0)
      rc = "VXe{[h - " + rc;
   else
      rc = "Xbg" + cpqScsiCntlrEntry[idx].cpqScsiCntlrSlot + " - " + rc;

   rc += " - |[g " + cpqScsiCntlrEntry[idx].cpqScsiCntlrBusIndex;
   return rc;
}
function scsiCntlrCondition(idx, imageSize)
{
   var cond = new cpqCondition(cpqScsiCntlrEntry[idx].cpqScsiCntlrStatus);
   if (cpqScsiCntlrEntry[idx].cpqScsiCntlrStatus == 3)
   {
      cond.set(4);  // failed
   }
   if (imageSize == "LARGE")
      return cond.image();

   return cond.imageSmall();
}
function compileScsiCondition()
{
   this.state = 1;  // reset to unknown
   this.update(cpqScsiCntlrEntry[this.index].cpqScsiCntlrCondition);
}
function targetType(idx)
{
   var scsiType = displayItem("cpqScsiTargetType",         cpqScsiTargetEntry[idx].cpqScsiTargetType);
   var extType  = displayItem("cpqScsiTargetTypeExtended", cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended);

   if (cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended == 2)
   {
      scsiType =  extType + " " + scsiType;
   }
   else if (cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended == 4 ||  // tape library
            cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended == 5 ||  // cd library
            cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended == 6 ||  // CR3500 controller
            cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended == 7)    // tape autoloader
   {
      scsiType = extType;
   }
   return scsiType;
}
function targetName(idx)
{
   rc = targetType(idx) + " - SCSI ID " + cpqScsiTargetEntry[idx].cpqScsiTargetScsiIdIndex;
   return rc;
}
function targetStatusGraphic(idx, alignment)
{
   var thisStatus  = new cpqCondition(1);
   var targType    = cpqScsiTargetEntry[idx].cpqScsiTargetType;
   var targTypeExt = cpqScsiTargetEntry[idx].cpqScsiTargetTypeExtended;
   var localCntlr  = cpqScsiTargetEntry[idx].cpqScsiTargetCntlrIndex;
   var localBus    = cpqScsiTargetEntry[idx].cpqScsiTargetBusIndex;
   var localId     = cpqScsiTargetEntry[idx].cpqScsiTargetScsiIdIndex;
   var i;

   if (targType == 2)  // drive, use phy drive status
   {
      for (i = 0; i < cpqScsiPhyDrvEntry.length; i++)
      {
         if (cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvCntlrIndex == localCntlr &&
             cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvBusIndex == localBus &&
             cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvScsiID == localId)
         {
            thisStatus.update(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvCondition);
         }
      }
   }
   else if (targType == 3)  // tape drive
   {
      for (i = 0; i < cpqTapePhyDrvEntry.length; i++)
      {
         if (cpqTapePhyDrvEntry[i].cpqTapePhyDrvCntlrIndex == localCntlr &&
             cpqTapePhyDrvEntry[i].cpqTapePhyDrvBusIndex == localBus &&
             cpqTapePhyDrvEntry[i].cpqTapePhyDrvScsiIdIndex == localId)
         {
            thisStatus.update(cpqTapePhyDrvEntry[i].cpqTapePhyDrvCondition);
         }
      }
   }
   else if (targTypeExt == 4)  // tape library
   {
      for (i = 0; i < cpqTapeLibraryEntry.length; i++)
      {
         if (cpqTapeLibraryEntry[i].cpqTapeLibraryCntlrIndex == localCntlr &&
             cpqTapeLibraryEntry[i].cpqTapeLibraryBusIndex == localBus &&
             cpqTapeLibraryEntry[i].cpqTapeLibraryScsiIdIndex == localId)
         {
            thisStatus.update(cpqTapeLibraryEntry[i].cpqTapeLibraryCondition);
         }
      }
   }
   else if (targTypeExt == 5)  // CD library
   {
      for (i = 0; i < cpqCdLibraryEntry.length; i++)
      {
         if (cpqCdLibraryEntry[i].cpqCdLibraryCntlrIndex == localCntlr &&
             cpqCdLibraryEntry[i].cpqCdLibraryBusIndex == localBus &&
             cpqCdLibraryEntry[i].cpqCdLibraryScsiIdIndex == localId)
         {
            thisStatus.update(cpqCdLibraryEntry[i].cpqCdLibraryCondition);
         }
      }
   }
   if (alignment == "LARGE")
      return thisStatus.image();

   return thisStatus.imageSmall(alignment);
}
function driveCapacity(item, size)
{
   var rc = parseInt(size, 10);

   if (isNaN(rc) || rc <= 0)
   {
      rc = "N/A";
   } else {
      rc = displayItem(item, size);
   }
   return rc;
}
function logDrvName(idx)
{
   var drive = cpqScsiLogDrvEntry[idx];
   var name = "_hCu " + drive.cpqScsiLogDrvIndex;

   if (drive.cpqScsiLogDrvFaultTol == 2)
   {
      name += " - tH[ggXȂ";
   }
   else if (drive.cpqScsiLogDrvFaultTol > 2)
   {
      name += " - " + displayItem("cpqScsiLogDrvFaultTol", drive.cpqScsiLogDrvFaultTol);
   }
   return name;
}
function phyDriveName(idx)
{
   var i;
   var name = "s";
   var ctl = cpqScsiPhyDrvEntry[idx].cpqScsiPhyDrvCntlrIndex;
   var bus = cpqScsiPhyDrvEntry[idx].cpqScsiPhyDrvBusIndex;
   var tid = cpqScsiPhyDrvEntry[idx].cpqScsiPhyDrvScsiID;

   for (i = 0; i < cpqScsiTargetEntry.length; i++)
   {
      if (cpqScsiTargetEntry[i].cpqScsiTargetCntlrIndex  == ctl &&
          cpqScsiTargetEntry[i].cpqScsiTargetBusIndex    == bus &&
          cpqScsiTargetEntry[i].cpqScsiTargetScsiIdIndex == tid)
         name = targetName(i);
   }
   return name;
}
