<html>
<!-- RCSfile: MS-FCES.TPL Revision: 1.6  -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Fibre Channel External Storage System Information</title>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqSsChassisEntry>
<!cpqSsBackplaneEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#SSENUMS.JS>
<!#FCAENUMS.JS>
<!#MS-FCCMN.JS>
</script>
</head>
<script language="JavaScript">

writeBodyHead();

idx = findArg("index");
chassisIdx = findArg("chassis");

if (idx == -1 || chassisIdx == -1)
{
   parseArgs(tryPrevPage());
   idx = findArg("index");
   chassisIdx = findArg("chassis");
}
if (idx == -1 || idx >= cpqSsBackplaneEntry.length ||
    chassisIdx == -1 || chassisIdx >= cpqSsChassisEntry.length)
{
   reportMissingArgs();
}
else
{
   writePageHead(fcChassisName(chassisIdx), "/WEBAGENT/IMAGES/MASSHDR.GIF", "External Storage System Information");
   cond = new cpqCondition(cpqSsBackplaneEntry[idx].cpqSsBackplaneCondition);
   writeTableLabel(cond.imageSmall()+fcBackplaneName(idx),"Backplane Information");
   writeTableHead();
   writeDoubleTableRow(
      "Vendor:", displayItem("cpqSsBackplaneVendor", cpqSsBackplaneEntry[idx].cpqSsBackplaneVendor),
      "Temperature Status:", displayItem("cpqSsBackplaneTempStatus", cpqSsBackplaneEntry[idx].cpqSsBackplaneTempStatus));
   writeDoubleTableRow(
      "Model:", displayItem("cpqSsBackplaneModel", cpqSsBackplaneEntry[idx].cpqSsBackplaneModel),
      "Fan Status:", displayItem("cpqSsBackplaneFanStatus", cpqSsBackplaneEntry[idx].cpqSsBackplaneFanStatus));
   writeDoubleTableRow(
      "Serial Number:", displayItem("cpqSsBackplaneSerialNumber", cpqSsBackplaneEntry[idx].cpqSsBackplaneSerialNumber),
      "Power Supply Status:", displayItem("cpqSsBackplaneFtpsStatus", cpqSsBackplaneEntry[idx].cpqSsBackplaneFtpsStatus));
   writeDoubleTableRow(
      "Firmware Revision:", displayItem("cpqSsBackplaneFWRev", cpqSsBackplaneEntry[idx].cpqSsBackplaneFWRev),
      "Speed:", displayItem("cpqSsBackplaneSpeed", cpqSsBackplaneEntry[idx].cpqSsBackplaneSpeed));
   writeDoubleTableRow(
      "Board Revision:", displayItem("cpqSsBackplaneBoardRevision", cpqSsBackplaneEntry[idx].cpqSsBackplaneBoardRevision),
      "Drive Bays:", displayItem("cpqSsBackplaneDriveBays", cpqSsBackplaneEntry[idx].cpqSsBackplaneDriveBays));
   writeDoubleTableRow(
      "Version:", displayItem("cpqSsBackplaneVersion", cpqSsBackplaneEntry[idx].cpqSsBackplaneVersion),
      "Duplex Option:", displayItem("cpqSsBackplaneDuplexOption", cpqSsBackplaneEntry[idx].cpqSsBackplaneDuplexOption));
   writeSingleTableRowInDoubleTable(
      "Placement:", displayItem("cpqSsBackplanePlacement", cpqSsBackplaneEntry[idx].cpqSsBackplanePlacement));
   writeTableTail();
   document.write("<br>");
}
writeBodyTail();
</script>
</html>

