<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->

function nicinfo(pindex)
{       /*
        index
        slot
        port
        mibport
        ioaddr
        cond
        iffor
        redundant
        needport
        */
        this.index = cpqHoIfPhysMapEntry[pindex].cpqHoIfPhysMapIndex;
        this.slot = cpqHoIfPhysMapEntry[pindex].cpqHoIfPhysMapSlot;
        if (cpqHoIfPhysMapEntry[pindex].cpqHoIfPhysMapPort == null ||
                cpqHoIfPhysMapEntry[pindex].cpqHoIfPhysMapPort == 4294967295)
                this.mibport = 1;
        else
                this.mibport = cpqHoIfPhysMapEntry[pindex].cpqHoIfPhysMapPort;
        if (cpqHoIfPhysMapEntry[pindex].cpqHoIfPhysMapIoBaseAddr == null ||
                cpqHoIfPhysMapEntry[pindex].cpqHoIfPhysMapIoBaseAddr == 4294967295)
                this.ioaddr = 0;
        else
                this.ioaddr = cpqHoIfPhysMapEntry[pindex].cpqHoIfPhysMapIoBaseAddr;
        if (cpqHoIfPhysMapEntry[pindex].cpqHoIfPhysMapIoBaseAddr == 34816)
                this.mibport = 1;
        if (cpqHoIfPhysMapEntry[pindex].cpqHoIfPhysMapCondition == null)
                this.cond = 1;  // Other
        else
                this.cond = cpqHoIfPhysMapEntry[pindex].cpqHoIfPhysMapCondition;        // Other
        this.port = this.mibport;
}
nicinfotable = new Array();

function ifinfo()
{       /*
        index
        desc
        type
        physaddr
        */
}
ifinfotable = new Array();

function getModelName(nic)
{       // Get the Model Name
        nicString = "";
        if (cpqSePciMemoryEntry.length > 0)
        {
                if (cpqSePciMemoryEntry[0].cpqSePciMemoryType &&
                        cpqSePciMemoryEntry[0].cpqSePciMemoryBaseAddr)  // Is PCI
                {
                        for (y=0;y<=cpqSePciMemoryEntry.length-1;y++)
                        {
//							alert (" " + cpqSePciMemoryEntry[y].cpqSePciMemoryType + " " + cpqSePciMemoryEntry[y].cpqSePciMemoryBaseAddr + " " + nic.ioaddr + " " + nic.memaddr);
                            if ((cpqSePciMemoryEntry[y].cpqSePciMemoryType == 2 && cpqSePciMemoryEntry[y].cpqSePciMemoryBaseAddr == nic.ioaddr) || (cpqSePciMemoryEntry[y].cpqSePciMemoryType == 3 && cpqSePciMemoryEntry[y].cpqSePciMemoryBaseAddr == nic.memaddr))
                            {
								for (z=0; z<=cpqSePciSlotEntry.length-1;z++)
								{
									if (cpqSePciSlotEntry[z].cpqSePciSlotBusNumberIndex == cpqSePciMemoryEntry[y].cpqSePciMemoryBusNumberIndex &&
											cpqSePciSlotEntry[z].cpqSePciSlotDeviceNumberIndex == cpqSePciMemoryEntry[y].cpqSePciMemoryDeviceNumberIndex)
									{
										nicString = nicString + cpqSePciSlotEntry[z].cpqSePciSlotBoardName;
										break;
									}
                                   }
                            }

							if (nicString != "")
                            {
                               break;
                            }
                        }
                }
        }


        if (nicString == "")
        {
			if (nic.slot > 0)
            {       // EISA
				if (cpqSeEisaSlotBoardName[nic.slot] != null)
                {
					nicString = nicString + cpqSeEisaSlotBoardName[nic.slot];
                }
            }
            else
            {       // Slot = 0 is Virtual NIC
                        // Add Kludge for Special x8800 NIC
				if( 0==nic.ioaddr )
					nicString = nicString + "z NIC";
				else 
					if( 0==nic.ioaddr.length )
                        nicString = nicString + "z NIC";
				if(-1 != nic.real_slot && 4294967295 != nic.real_slot)                        
                nic.needport = false;
           }
        }

		if(nicString == "(Empty)")
			nicString = "s"
		// add translated. message CKK
        nicString = nicString.replace("Embedded", "");

        return nicString;
}

function buildString(nic)
{

	nicString = getModelName(nic);
    if (nic.slot == 0)
    {
		// Need to convert to Hex first!
        if (nic.ioaddr == "0x880")
		{
			nicString = nicString + " (VXe{[h)";
		}
        else
		{ 

			if ( nic.memtype == 3 )
			{

				//code block below must be exactly like this to work in both Netscape and IE browsers
				if( 0 > nic.ioaddr ) 
				{

					nic.ioaddr = - nic.ioaddr;
					nic.ioaddr = (0xFFFFFFFF+1) - nic.ioaddr;

				}

				upperMemAddr = ( nic.ioaddr >> 4) & 0xfffffff;
				lowerMemAddr = nic.ioaddr & 0xf;
				hexMemAddr = upperMemAddr.toString(16).toUpperCase() + lowerMemAddr.toString(16).toUpperCase();
				//end block
				
				if(-1 != nic.real_slot && 4294967295 != nic.real_slot)
					nicString = nicString + " Mem " + hexMemAddr;

			}

			else
			{

				nicString = nicString + " I/O " + hexfromdec(nic.ioaddr);

			}
            
		}
    }
    else
		nicString = nicString + " Xbg " + nic.slot;

    if (nic.needport)
		nicString = nicString + " |[g " + nic.port;

    return nicString;
}



function displayNicItem(itemName, itemValue)
{
        rc = parseInt(itemValue);
        if (itemValue == null)
                rc = "N/A";
        else
        if (rc < 0)
                rc = "N/A";
        else
        if (rc == 4294967295)
                rc = "N/A";
        else
        if (isNaN(rc))
                rc = "N/A";
        else
                rc = displayItem(itemName, itemValue);
        return rc;
}

function displayStatItem(itemValue)
{
        rc = parseInt(itemValue);
        if (itemValue == null)
                rc = "N/A";
        else
        if (rc < 0)
                rc = "N/A";
        else
        if (rc == 4294967295)
                rc = "N/A";
        else
        if (isNaN(rc))
                rc = "N/A";
        else
                rc = itemValue;
        return rc;
}

// added for compatibility between java 1.0 and 1.1 parseInt;
// if value is Not-A-Number, return 0; this is what was done
// in java 1.0 when parseInt could not parse a number. -tonycu 
function parseNicInt(itemValue)
{
        rc = parseInt(itemValue);
        if (isNaN(rc))
                rc = 0;
        return rc;
} 
