
ticklength = 10;     // seconds
toticksleft=0;
tointerval = 20;   // seconds
arfenabled = true;
arfticksleft=0;
arfinterval = 5;   // minutes
idleState = 0;
autorefreshState = 1;
pageLoadState = 2;
stateNames = new Array( "idle", "autorefresh", "pageload", "exit");
state = idleState;
intervalID = null;
function timerFunction()
{
   //debugOut("timerFunction: state="+stateNames[state]+", arfenabled="+arfenabled);
   if( state == idleState )
   {
      // do nothing
   }
   else if (state == pageLoadState)
   {
      if (0==toticksleft)
      {
         debugOut("TimerFunction: timed out on file load, calling PageDone");
         PageDone();
      }
      else
         toticksleft--;
   }
   else if( state == autorefreshState )
   {
      if (arfenabled)
      {
         if(0==arfticksleft)
         {
            debugOut("TimerFunction:  time to autorefresh page");
            state = idleState;
            autorefreshPages();
         }
         else
            arfticksleft--;
      }
      else
      {
         //--- reset the state to idle since we are disabled
         state = idleState;
      }
   }
}
function startupTimer( toIntervalIn, arfEnabledIn, arfIntervalIn )
{
   debugOut("startTimer:  toIntervalIn"+toIntervalIn+", arfEnabledIn "+arfEnabledIn+", arfIntervalIn "+arfIntervalIn);
   tointerval = toIntervalIn;
   arfenabled = arfEnabledIn;
   arfinterval = arfIntervalIn;
   if(null!=intervalID)
   {
      clearInterval( intervalID );
      intervalID = null;
   }
   state = idleState;
   intervalID = setInterval( "timerFunction();", ticklength * 1000 );
}
function shutdownTimer()
{
   clearInterval( intervalID );
   intervalID = null;
   debugOut("stopped Timer");
}
function resetWaitTimer()
{
   toicksleft = tointerval / ticklength;
}
function waitOnLoad()
{
   toticksleft = tointerval / ticklength;
   state = pageLoadState;
}
function arfMode()
{
   arfticksleft = (arfinterval*60)/ticklength;
   state = autorefreshState;
}
function idleMode()
{
   state = idleState;
}
function enableAutorefresh()
{
   arfticksleft = (60*arfinterval)/ticklength;
   arfenabled = true;
}
function disableAutorefresh()
{
   arfenabled = false;
}
function setarfInterval( newInterval )
{
   arfinterval = newInterval;
   arfticksleft = (arfinterval*60)/ticklength;
}
