function chpNavItem( hmmo, entryName, entryStatus, entryURL, treeItem )
{
   this.hmmo = hmmo;
   this.name = entryName;
   this.status = entryStatus;
   this.url = entryURL;
   this.treeItem = treeItem;
   this.loaded = false;
   this.displayName = navDisplayName;
   this.aggregateStatus = itemAggregateStatus;
}
function chpDataItem( hmmo, entryPath, entryName, entryStatus, entryURL, entryTarget )
{
   this.hmmo = hmmo;
   this.path = entryPath;
   this.name = entryName;
   this.status = entryStatus;
   this.url = entryURL;
   if("0"==entryTarget)
   {
      this.target = "";
   }
   else
   {
      this.target = entryTarget;
   }
   this.duplicate = false;
   this.displayName = dataDisplayName;
   this.aggregateStatus = itemAggregateStatus;
}
function itemAggregateStatus( statusIn )
{
   if(1 <= statusIn && 4 >= statusIn && statusIn > this.status )
   {
      this.status = statusIn;
   }
}
function dataDisplayName()
{
   rc = this.name;
   if(this.duplicate)
   {
      rc = this.name + " (" + this.hmmo + ")";
   }
   return rc;
}
function navDisplayName()
{
   return this.name;
}
function treeAddNav( hmmo, name, status, url, findBad, expandList )
{
   var         rc = false;
   var         path = String(name).split("::");
   var         i;
   var         addPoint = this;
   var         lcaddname = String( path[path.length-1] ).toLowerCase();
   var         newNavItem;
   if(1<path.length)
   {
      //--- this is an absolute add
      while(null!=addPoint.parent)     //--- back up to the root of the tree
      {
         addPoint = addPoint.parent;
      }
   }
   //--- now find the absolute add point
   for(i=0; i<path.length && null!=addPoint; i++)
   {
      addPoint = addPoint.findOrAddNode( path[i], status );
   }
   if(null!=addPoint)
   {
      newNavItem = new chpNavItem( hmmo, path[path.length-1], status, url);
      addPoint.navList[ addPoint.navList.length ] = newNavItem;
      rc = true;
      if( findBad && (3==status || 4==status))
      {
         expandList[ expandList.length ] = addPoint;
      }
      //--- handle bubble up if absolute add
      if(1<path.length)
      {
         while (addPoint!=null)
         {
            addPoint.aggregateStatus( status );
            addPoint = addPoint.parent;
         }
      }
   }
   return rc;
}
function treeAddData( hmmo, name, status, url, target, findBad, badList )
{
   var         rc = false;
   var         path = String(name).split("::");
   var         i;
   var         addPoint = this;
   var         lcaddname = String( path[path.length-1] ).toLowerCase();
   var         newDataItem;
   var         fullPath = "";
   var         iterator;
   var         alreadyexists;
   if(1<path.length)
   {
      //--- this is an absolute add
      while(null!=addPoint.parent)     //--- back up to the root of the tree
      {
         addPoint = addPoint.parent;
      }
      //--- now find the absolute add point
      for(i=0; i<(path.length-1) && null!=addPoint; i++)
      {
         addPoint = addPoint.findOrAddNode( path[i], status );
      }
   }
   if(null!=addPoint)
   {
      if( null!=addPoint.parent )   //--- can't add data items to the root!
      {
         for(iterator = addPoint; iterator.parent!=null; iterator = iterator.parent)
         {
            fullPath = iterator.name + (0==fullPath.length ? "" : "::") + fullPath;
         }
         newDataItem = new chpDataItem( hmmo, fullPath, path[path.length-1], status, url, target);
         //--- mark duplicates ---
         alreadyexists = false;
         for(i=0; i<addPoint.dataList.length; i++)
         {
            if( lcaddname == addPoint.dataList[i].name.toLowerCase() )
            {
               if( addPoint.dataList[i].hmmo == newDataItem.hmmo )
               {
                  //--- this is a complete duplicate!
                  alreadyexists = true;
               }
               else
               {
                  newDataItem.duplicate = true;
                  addPoint.dataList[i].duplicate = true;
               }
            }
         }
         if(!alreadyexists)
         {
            addPoint.dataList[ addPoint.dataList.length ] = newDataItem;
            rc = true;
            if( findBad && (3==status || 4==status))
            {
               badList[ badList.length ] = newDataItem;
            }
            //--- bubble up the status for absolute adds
            if(1<path.length)
            {
               while (addPoint!=null)
               {
                  addPoint.aggregateStatus( status );
                  addPoint = addPoint.parent;
               }
            }
         }
      }
   }
   return rc;
}
function treeAddNode( name, status )
{
   var   rc = false;
   var   lcname = String(name).toLowerCase();
   var   nodeAllowed = true;
   if(null==this.parent)
   {
      //--- do restrictions based on the fact that this is the root of the tree
      if( lcname != "home" &&
          lcname != "settings" &&
          lcname != "tasks" &&
          lcname != "tools" &&
          lcname != "logs"
          )
          nodeAllowed = false;
   }
   if(nodeAllowed)
   {
      //--- double check to avoid adding over an existing node of the same name ---
      if(null==this.navList[ lcname ])
      {
         this.children[ lcname ] = new chpTreeNode( name, this, status );
      }
   }
   return rc;
}
function treeFindNode(name)
{
   var lcname = String(name).toLowerCase();
   return this.children[lcname];
}
function treeFindOrAddNode(name, status)
{
   var rc = null;
   var lcname = String(name).toLowerCase();
   var nodeAllowed = true;
   if(null==this.children[ lcname ])
   {
      this.addNode( name, status );
   }
   else
   {
      this.children[ lcname ].aggregateStatus( status );
   }
   rc = this.children[ lcname ];
   return rc;
}
function treeAggregateStatus( status )
{
   if( 1<=status && 4>=status )
   {
      if( status > this.status )
      {
         this.status = status;
      }
   }
}
function chpTreeNode( name, parent, status )
{
   this.name = name;
   this.parent = parent;
   this.status = status;
   this.navList = new Array();
   this.dataList = new Array();
   this.children = new Array();
   this.addNav = treeAddNav;
   this.addData = treeAddData;
   this.addNode = treeAddNode;
   this.findNode = treeFindNode;
   this.findOrAddNode = treeFindOrAddNode;
   this.aggregateStatus = treeAggregateStatus;
}
function dumpTree( treeNode )
{
   var i;
   var oneChild;
   debugOut("----------------------------------------------------------");
   debugOut("node name:  "+treeNode.name);
   debugOut("node status:  "+treeNode.status);
   for(oneChild in treeNode.children)
   {
      debugOut("----> "+oneChild);
   }
   debugOut("nav items: "+treeNode.navList.length);
   for(i=0; i<treeNode.navList.length; i++)
   {
      debugOut("----> "+treeNode.navList[i].name+"  url: "+treeNode.navList[i].url);
   }
   debugOut("data items: "+treeNode.dataList.length);
   for(i=0; i<treeNode.dataList.length; i++)
   {
      debugOut("----> "+treeNode.dataList[i].name);
   }
   for(oneChild in treeNode.children)
   {
      dumpTree( treeNode.children[ oneChild] );
   }
}
