############################################################################
#        copyright 2002 Compaq Information Technologies Group, L.P.       
############################################################################
#
#  cpqimlview.tcl
#
##############################################################################


#set GUI_PATH [exec dirname $argv0]
set GUI_PATH "/sbin"
set Rate 0
set Time 0

array set ARGV $argv
set TCLX [array get ARGV -tclx]
set TIX [array get ARGV -tix]


if {[llength $TCLX] > 1} {
	if {[catch {package require Tclx}]} {
		if {[catch {load [lindex $TCLX 1] Tclx}]} {
			puts "Could not find the TclX module."
			exit 1
		}
	}
}

if {[llength $TIX] > 1} {
	if {[catch {package require Tix}]} {
		if {[catch {load [lindex $TIX 1] Tix}]} {
			puts "Could not find the Tix module."
			exit 1
		}
	}
}

# Uncomment the following line for debugging.
#  cmdtrace on [open "/tmp/IMLError.log" a+]

# source $GUI_PATH/iml.msg.tcl
set EXE_FILE "$GUI_PATH/imlbe"
set PIXMAPS "/usr/share/pixmaps"

# Check to see if kde2 is installed.
#if [file exists /opt/kde2/bin/kfmclient] {
#	set BROWSE 1
#} else {
#	set BROWSE 0
#}
# Determine if we can call the webbrowser
set URL http://www.hp.com/linux
if [file exists /opt/kde2/bin/kfmclient] {
	set BRFile /opt/kde2/bin/kfmclient
	set BROWSE 1
} else {
	if [file exists /usr/bin/kfmclient] {
		set BRFile /usr/bin/kfmclient
		set BROWSE 1
	} else {
		if [file exists /usr/bin/netscape] {
			set BRFILE /usr/bin/netscape
			set BROWSE 1
		} else {
			set BROWSE 0
		}
	}
}


set Options(LOG) 1
set Options(REPAIR) 2
set Options(CONNECT) 3
set Options(CLEAR) 4
set Options(APPEND) 5
set Options(START) 6

set SEVER(Repaired)	6
set SEVER(Information)	2
set SEVER(Caution)	9
set SEVER(Critical)	15

set OldIml 0
set ClearLogRequired 0
set Class ""
set Severity ""
set InitTime "" 
set UpdateTime ""
set GridRows 0
set Sort 6
set IMLList [list]
set FullIMLList [list]
set FileName ""


# Define all text messages used in this appl.
set IML_HLP_MSGS() { }
set IML_GUI_MSGS(@catalog@) {IMLGUI.cat@sa 1}
set IML_GUI_MSGS(MSG_ROOT_USER) {You MUST be 'root' to run this utility!}
set IML_GUI_MSGS(MSG_APP_TITLE) {hp ProLiant Integrated Management Log Viewer}
set IML_GUI_MSGS(MSG_SAVELOG_LABEL) {Save the entries to a .IML file. The file can be read into
the viewer at a later time}
set IML_GUI_MSGS(MSG_PRINTLOG_LABEL) {Print the displayed log entries.}
set IML_GUI_MSGS(MSG_SAVEBTN_LABEL) {Save...}
set IML_GUI_MSGS(MSG_PRINTBTN_LABEL) {Print}
set IML_GUI_MSGS(MSG_CLEARLOG_WARN) {WARNING!: You have chosen to clear the Integrated Management Log on the currently selected machine. This will permanently remove all entries from the log. You can save the entries to an .IML file, if desired.}
set IML_GUI_MSGS(MSG_INVAL_DATE_WARN) {WARNING!: Your system currently is set to an invalid date.  The year must be between 1970 and 2037.  If you clear the log now, it will contain an invalid date, and will be corrupted.}
set IML_GUI_MSGS(MSG_SAVEAS_LABEL) {Save As...}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_SAVEAS_LABEL)) {Save IML Log Entries As File}
set IML_GUI_MSGS(MSG_SELECTION_LABEL) {Type the full path for the .IML file to be saved:}
set IML_GUI_MSGS(MSG_OPEN_LABEL) {Open...}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_OPEN_LABEL)) {Open a Previously Saved File}
set IML_GUI_MSGS(MSG_CLOSE_LABEL) {Close...}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_CLOSE_LABEL)) {Close the Currently Open File}
set IML_GUI_MSGS(MSG_ENTER_FILENAME) {Nothing Saved! You must enter a file name in the space
provided.}
set IML_GUI_MSGS(MSG_ENTER_OPENNAME) {Nothing To Open! You must enter a file name in the space
provided.}
set IML_GUI_MSGS(MSG_MAIN_TITLE) {IML Viewer Utility}
set IML_GUI_MSGS(MSG_FILE_NOT_FOUND) {The .IML file you are trying to open does not exist.
Please make sure you are typing the correct path and file name.}
set IML_GUI_MSGS(MSG_VIEW_LABEL) {View}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_VIEW_LABEL)) {Customize View}
set IML_GUI_MSGS(MSG_REFRESH_NOW) {Refresh Now}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_REFRESH_NOW)) {Retrieve New IML Entries.
Reverts to "Sort by ID" View.}
set IML_GUI_MSGS(MSG_REFRESH_RATE) {Set Refresh Rate...}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_REFRESH_RATE)) {Setting the auto-refresh rate.
Reverts to "Sort by ID" View.}
set IML_GUI_MSGS(MSG_FILTER_LABEL) {Filter}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_FILTER_LABEL)) {Filter Out Unwanted Events}
set IML_GUI_MSGS(MSG_SORT_LABEL) {Sort Events}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_SORT_LABEL)) {Sort Events According to Date, Severity, etc.}
set IML_GUI_MSGS(MSG_MACHINE_LABEL) {Machine:}
set IML_GUI_MSGS(MSG_LOG_LABEL) {Log}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_LOG_LABEL)) {All Log Related Operations}
set IML_GUI_MSGS(MSG_FILE_LABEL) {File}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_FILE_LABEL)) {All File Related Operations}
set IML_GUI_MSGS(MSG_EXIT_LABEL) {Exit}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_EXIT_LABEL)) {Exits this Application}
set IML_GUI_MSGS(MSG_CLEAR_LABEL) {Clear All Entries}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_CLEAR_LABEL)) {Clear All IML Log Entries.
CAUTION: This is DESTRUCTIVE, you should first save the current log to a file.}
set IML_GUI_MSGS(MSG_REPAIR_LABEL) {Mark As Repaired}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_REPAIR_LABEL)) {Mark the selected IML Entry as "Repaired".}
set IML_GUI_MSGS(MSG_FILTER_TITLE) {Set Filter Options}
set IML_GUI_MSGS(MSG_UPDATE_LABEL) {Update Time:}
set IML_GUI_MSGS(MSG_INIT_LABEL) {Initial Time:}
set IML_GUI_MSGS(MSG_CLASS_LABEL) {Class:}
set IML_GUI_MSGS(MSG_SEVERITY_LABEL) {Severity:}
set IML_GUI_MSGS(MSG_MAINT_NOTE_LABEL) {Add Maintenance Note}
set IML_HLP_MSGS($IML_GUI_MSGS(MSG_MAINT_NOTE_LABEL))  {Enter the text for a maintenance note.
The text must be between 1 and 226 characters in length.}
set IML_GUI_MSGS(MSG_MAINT_NOTE_TITLE) {Add Maintenance Note to IML Log}
set IML_GUI_MSGS(MSG_MAINT_NOTE_HEADING) {Maintenance Note}
set IML_GUI_MSGS(MSG_MAINT_NOTE_EMPTY) {The text must be between 1 and 226 characters in length}
set IML_GUI_MSGS(MSG_NOT_REAL_IML_FILE) {The IML file in view is an older saved version of the IML.\nIf you want to view the actual IML file, use the Refresh Now option under the View menu.}
set IML_GUI_MSGS(MSG_NOTE_TOO_LONG) {The length of the maintenance note cannot be greater than 226 characters in length.} 
set IML_GUI_MSGS(MSG_REMOTE_IML_EMPTY) {The IML log on this remote server is empty.}
set IML_GUI_MSGS(MSG_OPTION_LABEL) {Options}
set IML_GUI_MSGS(MSG_DETAIL_EVENT_TITLE) {IML Event Description}
set IML_GUI_MSGS(MSG_CHARM_HEADINGS) {Description   Class   Severity   Count   Update Time   Initial Time}
set IML_GUI_MSGS(MSG_SH_FILE_OPEN) {Open a Saved IML Log File.}
set IML_GUI_MSGS(MSG_SH_FILE_SAVE) {Save the current IML Log to a File.}
set IML_GUI_MSGS(MSG_SH_FILE_EXIT) {Exit the IML Viewer Utility.}
set IML_GUI_MSGS(MSG_SH_LOG_CLEAR) {Clear the IML Log on the currently selected machine.}
set IML_GUI_MSGS(MSG_SH_MARK_REPAIRED) {Mark an IML entry as Repaired.}
set IML_GUI_MSGS(MSG_SH_MAINT_NOTE) {Add a maintenance note to the IML Log.}
set IML_GUI_MSGS(MSG_SH_FILTER_DLG) {Activate the Filter Dialog.}
set IML_GUI_MSGS(MSG_SH_REFRESH_NOW) {Refresh the IML list box now.}
set IML_GUI_MSGS(MSG_SH_REMOTE_SERVER) {Pick a remote server to view. GUI defaults to the localhost.}
set IML_GUI_MSGS(MSG_IML_LISTBOX) {list}
set IML_GUI_MSGS($IML_GUI_MSGS(MSG_IML_LISTBOX)) {IML Log entries:
Double click to see a full description of the event.}
set IML_GUI_MSGS(MSG_SH_IML_LISTBOX) {IML Log entries: Double click to see a full description of the event.}
set IML_GUI_MSGS(MSG_OPEN_FILE_TITLE) {Select a previously saved IML file to view.}
set IML_GUI_MSGS(MSG_WHO_CLEARED_LOG) {IML Log file cleared by %s.}
set IML_GUI_MSGS(MSG_SH_ALREADY_REPAIRED) {The requested IML entry is already repaired.}
set IML_GUI_MSGS(MSG_BROKEN_PIPE) {Pipe Broken....Communication Lost!}
set IML_GUI_MSGS(MSG_FORK_FAILED) {Fork operation failed while creating pipes!}
set IML_GUI_MSGS(MSG_HTTP_URL) {http://www.hp.com/linux}
set IML_GUI_MSGS(MSG_LGD_CRIT) {Legend:
RED icon: An Event, or Failure of a Critical nature has occurred.  Corrective Action may be required.}
set IML_GUI_MSGS(MSG_LGD_CAUT) {Legend:
YELLOW icon: An Event of potentially dangerous nature has occurred.  Should be investigated.}
set IML_GUI_MSGS(MSG_LGD_INFO) {Legend:
BLUE icon: Informational message only.}
set IML_GUI_MSGS(MSG_LGD_REPR) {Legend:
GREEN icon: Condition/Failure has been Repaired.}


#######################
#####  PROCEDURES  ####
#######################

# Procedure for verifying that the 'root' user is running the app.
proc CheckRoot {parent} {
    global IML_GUI_MSGS
    
    set uid ""
    set user [exec id]
    set uid [lindex $user 0]
    set suser [string last "root" "$uid"]
    if { $suser == -1 } {
        wm withdraw $parent 
        set EXTDLG [tk_messageBox \
            -icon error \
            -type ok \
            -title "Error!" \
            -message $IML_GUI_MSGS(MSG_ROOT_USER)]
        exit
    }
}


proc TerminateChild {} {
	global InputPipe

	puts $InputPipe "exit* * "
	flush $InputPipe
}

# This function cleanly exits the IML app when
# the 'x' icon is pressed in the upper right
# hand corner of the window to close the app.
proc QuitCBx {} {

	destroy
	exit 0
}

proc Quit { msg } {

        if { [string compare $msg " "] != 0 } {
		puts $msg
	}
	destroy
	exit 0
}

# This command is called whenever the background of the grid needs to
# be reformatted. The x1, y1, x2, y2 specifies the four corners of the area
# that needs to be reformatted.
#
# area:
#  x-margin:	the horizontal margin
#  y-margin:	the vertical margin
#  s-margin:	the overlap area of the x- and y-margins
#  main:	The rest
#
proc SimpleFormat {w area x1 y1 x2 y2} {

	global margin
	set bg(s-margin) gray25
	set bg(x-margin) gray65
	set bg(y-margin) gray65
	set bg(main)     gray20

	case $area {
	main {
	    # The "grid" format is consecutive boxes without 3d borders
	    #
	    $w format grid $x1 $y1 $x2 $y2 \
		-relief raised -bd 1 -bordercolor $bg($area) -filled 0 \
		-bg white -xon 1 -yon 1 -xoff 0 -yoff 0 -anchor se
	}
	{x-margin y-margin s-margin} {
	    # border specifies consecutive 3d borders
	    #
	    $w format border $x1 $y1 $x2 $y2 \
		-fill 1 -relief raised -bd 1 -bg $bg($area) \
		-selectbackground gray80
	}
	}
}

# This procedure is used to setup the communication paths between the GUI and
# the 'backend' process.
proc OpenCmdPipes {} {

	global InputPipe OutputPipe EXE_FILE IML_GUI_MSGS

	pipe a InputPipe
	pipe OutputPipe b
	set childPid [ fork ]
	case $childPid {
		-1 {
		DoErrorDie $IML_GUI_MSGS(MSG_FORK_FAILED)
			}
		0 {
		close $InputPipe
		close $OutputPipe
	
			dup $a stdin
		close $a
	
		dup $b stdout
		close $b

		signal ignore {SIGINT}

		execl "$EXE_FILE"
			}
		close $a
		close $b
	}

}

# This procedure reads the response from the 'backend' process, parses it, and
# constructs a list object containing all the IML entries.  
proc ParseIMLList {} {

	global FullIMLList IMLList EXE_FILE Options OldIml bSTART InputPipe OutputPipe
	if { $bSTART == 0 } {
	set op $Options(LOG)
	} else {
	set op $Options(START)
	}
	
	set bSTART 0 
	puts $InputPipe "$op* *-1"
	flush $InputPipe
	if { [gets $OutputPipe retval] == -1} {
	Quit $IML_GUI_MSGS(MSG_BROKEN_PIPE)
	} 
	# If the wellness driver isn't loaded or installed on the remote server
	if {[lindex $retval 0] == "WARNING:"} { 
		DisplayErrorMessage [lrange $retval 1 9999]
	  set retval ""
	}

	# If failure occurs on the localhost
	if { [lindex $retval 0] == "FAILURE" } {
		Quit [lrange $retval 1 9999]
	}

	set IMLList [list]
	set FullIMLList [list]
	set OldIml 0

	set line ""
	foreach str $retval {
		if { ![ cequal $str "." ] } {
	  		set line "$line $str"
		} else {
			set list2 [split $line [list "*"]]
			set list3 [list]
			set line ""
			foreach elem2 $list2 {
				set elem2 [string trimleft $elem2]
				set elem2 [string trimright $elem2 [list " " "."]]
				set list3Length [llength $list3]
				if {$list3Length == 4} {
					set rc 0
					catch {set rc [clock scan $elem2]} 
					lappend list3 $rc
					#lappend list3 [clock scan $elem2]
				} elseif {$list3Length == 5} {
					set rc 0
					catch {set rc [clock scan $elem2]} 
					lappend list3 $rc
				} else {
					lappend list3 $elem2
				}
			}
			set isValid [isValidEntry $list3]
			lappend FullIMLList $list3

			if {$isValid > 0} {lappend IMLList $list3}
		}
	}
}

proc CallBrowser {} {

	global BRFile BROWSE URL

	if {[string match kfmclient $BRFile] != -1} {
		catch {exec $BRFile openProfile webbrowsing $URL} return
	} else {
		catch {exec $BRFile $URL} return
	}
	return
}


# Procedure provides a means of 'filtering' the IML listings, so the user can
# concentrate on specific entries.
proc FilterIMLList {} {

	global IMLList FullIMLList

	set IMLList [list]

	foreach elem1 $FullIMLList {
	set isValid [isValidEntry $elem1]
	if {$isValid > 0} {lappend IMLList $elem1}
	}
}

proc UpdateRow {index row} {

	global IMLListWidget icon

	set styleL [tixDisplayStyle imagetext -anchor w]
	set styleT [tixDisplayStyle text -wrap 450]
	set x 0
	foreach rowElem $row {
	if {$x == 0 && $index > 0} {
		$IMLListWidget set $x $index \
			-itemtype imagetext \
			-image $icon($rowElem) \
			-showtext 0 \
			-style $styleL
	} elseif {$x == 5 && $index > 0} {
		if { $rowElem > 0 } {
			$IMLListWidget set $x $index \
				-itemtype text \
				-text [clock format $rowElem -format "%m/%d/%y %H:%M"]
		} else {
			$IMLListWidget set $x $index \
				-itemtype text \
				-text "Invalid Date" 
		}
	} elseif {$x == 6 && $index > 0} {
		if { $rowElem > 0 } {
			$IMLListWidget set $x $index \
				-itemtype text \
				-text [clock format $rowElem -format "%m/%d/%y %H:%M"]
		} else {
			$IMLListWidget set $x $index \
				-itemtype text \
				-text "Invalid Date" 
		}
	} else {
		$IMLListWidget set $x $index \
			-itemtype text \
			-text $rowElem \
			-style $styleT
	}
	incr x
	}
}

# The following Procedure selects the appropriate icon for a given row, then 
# concatenates it as the first element on the row.
proc CombineIconRow {List} {

	global IMLList icon RowList
	
	set itype [GetIconType $List]
	set RowList $itype

	foreach rowElem $List {
		lappend RowList $rowElem
	}
}


proc UpdateList {full} {

	global IMLList IMLListWidget GridRows RowList

	if {$full == 1} {
		$IMLListWidget delete row 0 $GridRows
	set GridRows 0
	  set header [list "" Description Class Severity Count {Update Time} {Initial Time} {Event ID}]
	  UpdateRow 0 $header
	} 
	set IMLListLength [llength $IMLList]
	for {set index $GridRows} {$index < $IMLListLength} {incr index} {
	  set rowIndex [expr $index + 1]
	CombineIconRow [lindex $IMLList $index]
	UpdateRow $rowIndex $RowList
	}
	set GridRows $IMLListLength
}

proc ParseAndUpdateList {full} {
	ParseIMLList
	UpdateList $full
}

proc FilterAndUpdateList {full} {
	FilterIMLList
	UpdateList $full
}

proc RefreshNow {} {

        global Time

	ParseAndUpdateList 1
	UpdateMenuOptions

        if { $Time > 0 } {
           after $Time RefreshNow
        }

}

proc DisableRefreshCB {w} {

        global Rate Time

        set Rate 0
	set Time 0

        destroy $w
}

proc RefreshRateCB {} {

        global Rate

        set w .hscale
        catch {destroy $w}
        toplevel $w
        wm title $w "Setting the Automatic Refresh Rate (in seconds)"
        wm iconname $w "hscale"
        #positionWindow $w

        label $w.msg -wraplength 3.5i -justify left -text "Using the left mouse button, click and drag the scale to your desired Refresh Rate.\nThe default refresh rate value is 30 seconds.\nPress the DISABLE button to turn off the Auto-Refresh Rate feature."
        pack $w.msg -side top -padx .5c

        frame $w.buttons
        pack $w.buttons -side bottom -fill x -pady 2m
        button $w.buttons.dismiss -text OK -command "SetRateandDestroyCB $w"
        button $w.buttons.disable -text Disable -command "DisableRefreshCB $w"
        pack $w.buttons.dismiss  -side left -expand 1
        pack $w.buttons.disable  -side right -expand 1

        frame $w.frame -borderwidth 10
        pack $w.frame -side top -fill x

        canvas $w.frame.canvas -width 50 -height 50 -bd 0 -highlightthickness 0
        $w.frame.canvas create polygon 0 0 1 1 2 2 -fill DeepSkyBlue3 -tags poly
        $w.frame.canvas create line 0 0 1 1 2 2 0 0 -fill black -tags line
        scale $w.frame.scale -orient horizontal -length 300 -from 30 -to 300 \
                -command "setWidth $w.frame.canvas" -tickinterval 50
        pack $w.frame.canvas -side top -expand yes -anchor s -fill x  -padx 15
        pack $w.frame.scale -side bottom -expand yes -anchor n
        $w.frame.scale set $Rate
}

proc setWidth {w width} {

    global Rate Time

    set Time 0

    set Rate [expr $width]
    set Time [expr $Rate * 1000]
    
}
                                                                                                                     
proc SetRateandDestroyCB {w} {

    global Time

    # RefreshNow will do the actual setting up of the event handler
    # and call itself after Time milliseconds.
    if { $Time > 0 } {
       RefreshNow
    }

    destroy $w

}

proc TimeFilter { timeVal filter } {

	set rawTime [clock seconds]

	set difference 0

	if { $filter == "Since Yesterday" } {
		set difference 86400
	} elseif { $filter == "Since A Week Ago" } {
		set difference [expr 7 * 86400 ]
	} elseif { $filter == "During Past 30 Days" } {
		set difference [expr 31 * 86400 ]
	} elseif { $filter == "During Last Six Months" } {
		set difference [expr 6 * 30 * 86400 ]
	}
	set evtdate [clock format $timeVal -format "%Y%m%d"]
	set rawdate [clock format [expr $rawTime - $difference] -format "%Y%m%d"]
	if { $evtdate > $rawdate } {
		return 1
	} else {
		return 0
	}
}

proc isValidEntry { row } {

	global Class Severity UpdateTime InitTime
	
	set retval 0 

	set descr [lindex $row 0]
	set class [lindex $row 1]
	set severity [lindex $row 2]
	set count [lindex $row 3]
	set update [lindex $row 4]
	set init [lindex $row 5]
	set evtID [lindex $row 6]

	if {$Class != "All"} {
		if {$Class != $class} {return 0}
	}
	if {$Severity != "All"} {
		if {$Severity != $severity} {return 0}
	}
	if {$UpdateTime != "All"} {
	  set validTime [TimeFilter $update $UpdateTime]
		if {$validTime == 0} {return 0}
	}
	if {$InitTime != "All"} {
	  set validTime [TimeFilter $init $InitTime]
		if {$validTime == 0} {return 0}
	}

	return 1
}

proc DisplayErrorMessage {msg} {
	tk_messageBox -default ok -message $msg -title "Error" -type ok 
}

proc DefineIcons {} {

	global icon logo PIXMAPS

	set icon(0) [image create photo -file $PIXMAPS/m_green.gif]
	set icon(1) [image create photo -file $PIXMAPS/m_red.gif]
	set icon(2) [image create photo -file $PIXMAPS/m_yellow.gif -gamma 1.1]
	set icon(3) [image create photo -file $PIXMAPS/m_blue.gif]
	set icon(4) [image create photo -file $PIXMAPS/m_red.gif]
	
	set logo [image create bitmap -file $PIXMAPS/hplogo.xbm -foreground #003366]

}

proc GetIconType {List} {
	set rep [string last Repaired $List]
	set crit [string last Critical $List]
	set caut [string last Caution $List]
	set info [string last Information $List]
	set fail [string last Failed $List]

	for {set i [string length $List]} {$i >= 0} {incr i -1} {
		if {$i == $rep} {
			return 0
			break
		}
		if {$i == $crit} {
			return 1
			break
		}
		if {$i == $caut} {
			return 2
			break
		}
		if {$i == $info} {
			return 3
			break
		}
		if {$i == $fail} {
			return 4
			break
		}
	}

# Should never get to this point, but if we do return a default.

return 3

# The original method was not robust enough.  What happens when one
# of these strings is present in the Description?  We then do not 
# accurately gauge the severity.

#	if { [string first Repaired $List] != -1 } {
#	return 0
#	} elseif { [string first Critical $List] != -1 } {
#	return 1
#	} elseif { [string first Caution $List] != -1 } {
#	return 2
#	} elseif { [string first Failed $List] != -1 } {
#	return 4
#	} else {
#	return 3
#	}

}


proc DisplayDetails {} {

	global IMLListWidget IMLList

	set selection [lindex [$IMLListWidget anchor get] 1]
	incr selection -1
	if {$selection < 0} {return}
	if {$selection >= [llength $IMLList]} {return}
	
	set scanStr [lindex $IMLList $selection]

	set eventno [lindex $scanStr 6]

	set frm .detail
	catch {destroy $frm}
	toplevel $frm
	wm title $frm "Details for Event #$eventno"
	wm geometry $frm +350+350
	focus $frm
	set ftop [frame $frm.msg -bg white]
	pack $ftop -side top -fill x -pady 2
	set i 0
	foreach item {Description: Class: Severity: Count: "Update Time:" "Initial Time:"} {
		label $ftop.l$item -text $item -bg white
		if { $i == 4 || $i == 5 } {
			label $ftop.l$i \
				-text [clock format [lindex $scanStr $i] \
				-format "%m/%d/%y %H:%M"] \
				-bg white
		} else {
			label $ftop.l$i \
				-text [lindex $scanStr $i] \
				-wrap 450 \
				-justify left \
				-bg white 
		}
		grid $ftop.l$item $ftop.l$i
		grid $ftop.l$item -sticky w -padx 2
		grid $ftop.l$i -sticky w -padx 6
		incr i
	}
	set fb [frame $frm.buttons -relief raised]
	pack $fb -side bottom -fill x -pady 2
	set btn [button $fb.ok -text OK -command "destroy $frm"]
	pack $btn -side bottom -anchor center
	set selection [lindex [$IMLListWidget anchor clear] 0]
}

proc RepairEntry {entry widget} {

	global IMLListWidget IMLList Options EXE_FILE InputPipe OutputPipe
	global IML_GUI_MSGS

        set selection -1
        if { $entry == -1 } {
	   set selection [lindex [$IMLListWidget anchor get] 1]
        } else {
           set selection $entry
        }

	incr selection -1
	if {$selection < 0} {return}
	if {$selection >= [llength $IMLList]} {return}
	
	set row [lindex $IMLList $selection]
	set elem [lindex $row 2]

	if { $elem == "Repaired"} {
	DisplayErrorMessage $IML_GUI_MSGS(MSG_SH_ALREADY_REPAIRED)
	} else {
	set EvtNum [lindex $row 6]
	puts $InputPipe "$Options(REPAIR)*$EvtNum* "
	flush $InputPipe
	if { [gets $OutputPipe retval] == -1} {
	Quit $IML_GUI_MSGS(MSG_BROKEN_PIPE)
	}
	   if { [lindex retval 0] == "FAILURE" } {
	    DisplayErrorMessage [lrange $retval 1 9999]
	   } else {
	    ParseAndUpdateList 1 
	   }
	}
	set selection [lindex [$IMLListWidget anchor clear] 0]
        if { $widget != 0 } {
           destroy $widget
        }
}


proc RightClkRepair {} {

	global IMLListWidget IMLList

	set selection [lindex [$IMLListWidget anchor get] 1]
        set w .warning
        catch {destroy $w}
        toplevel $w
        wm iconname $w "mmode"
        wm geometry $w 300x75+300+300
        wm title $w "Repair an Entry"

        label $w.msg  \
                -wraplength 3.5i \
                -justify left \
                -text "Mark Repaired?"
        pack $w.msg -side top -padx .5c
        set f [frame $w.buttons]
        pack $f -side bottom -fill x -pady 2m
        set c [button $f.ok -text OK -command "RepairEntry $selection $w"]
        set q [button $f.cancel -text Cancel -command "destroy $w"]
        pack $c $q -side left -expand 1
}


proc ClearLog {w} {

	global form Options HostName OldIml EXE_FILE IML_GUI_MSGS InputPipe OutputPipe

	set TYPE 4

	if { $OldIml == 1 } {
	DisplayErrorMessage $IML_GUI_MSGS(MSG_NOT_REAL_IML_FILE)
	} else {
		puts $InputPipe "$Options(CLEAR)* * "
		flush $InputPipe
	if { [gets $OutputPipe retval] == -1} {
	   Quit $IML_GUI_MSGS(MSG_BROKEN_PIPE)
	}
	if { [lindex retval 0] != "FAILURE" } {
		puts $InputPipe "$Options(APPEND)*Message Log Cleared by root*$TYPE"
		flush $InputPipe
	if { [gets $OutputPipe retval] == -1} {
	   Quit $IML_GUI_MSGS(MSG_BROKEN_PIPE)
	}
	 if { [lindex retval 0] == "FAILURE" } {
	   DisplayErrorMessage [lrange $retval 1 9999]
	}
	} else {
	 DisplayErrorMessage [lrange $retval 1 9999]
	}
	ParseAndUpdateList 1
	UpdateMenuOptions
        destroy $w
	}
	
}

# This proc is required to validate that the system clock is OK.  In Linux
# the system clock cannot exceed the year 2037, since the data type for time
# value is signed long, it can only store a value < (epoch + 67 years).
proc ChkValidDate {} {

	set tday [exec date +%Y]
	if { $tday > 1970 && $tday < 2038 } {
		return 1
	}
	return 0
}

proc WarningCB {} {

	global IML_GUI_MSGS ClearLogRequired

        set w .warning
        catch {destroy $w}
        toplevel $w
        wm title $w $IML_GUI_MSGS(MSG_CLEAR_LABEL)
        wm iconname $w "mmode"
        wm geometry $w +300+300
        wm title $w "Clear the IML"
        label $w.msg  \
                -wraplength 3.5i \
                -justify left \
                -text $IML_GUI_MSGS(MSG_CLEARLOG_WARN)
        pack $w.msg -side top -padx .5c
        set f [frame $w.buttons]
        pack $f -side bottom -fill x -pady 2m
        set c [button $f.ok -text Clear -command "ClearLog $w" -underline 1]
        set s [button $f.save -text Save -command "GetNameAndSave 1" -underline 0]
        set q [button $f.cancel -text Cancel -command "destroy $w" -underline 0]
        pack $c $s $q -side left -expand 1

        # Here we map out our Hot Keys...
        bind [winfo toplevel $w] <Alt-l> \
                "after 0 ButtonInvoke $f.ok"
        bind [winfo toplevel $w] <Alt-s> \
                "after 0 ButtonInvoke $f.save"
        bind [winfo toplevel $w] <Alt-c> \
                "after 0 ButtonInvoke $f.cancel"



        tixPushGrab $w
        focus $w


	# Check to see if system clock is set to a valid date.  If not, and
	# allowed to continue, the timestamp on the resulting entry would 
	# be invalid and would cause this utility to fail.
	set vdate [ChkValidDate]
	if { ! $vdate } {
		
		DisplayErrorMessage $IML_GUI_MSGS(MSG_INVAL_DATE_WARN)
		return
	}
}

	

proc UpdateMenuOptions { }  {

	global OldIml

	.app.menu.logmenu entryconfigure 0 -state normal 
	.app.menu.logmenu entryconfigure 1 -state normal 
	.app.menu.logmenu entryconfigure 2 -state normal 
	.app.menu.viewmenu entryconfigure 1 -state normal
	.app.menu.file entryconfigure 2 -state disabled
	
	if { $OldIml == 1 } {
		.app.menu.logmenu entryconfigure 0 -state disabled 
		.app.menu.logmenu entryconfigure 1 -state disabled 
		.app.menu.logmenu entryconfigure 2 -state disabled 
	  .app.menu.viewmenu entryconfigure 1 -state disabled
	  .app.menu.file entryconfigure 2 -state normal
	}

}


proc GetNameAndSave {bClear} \
{

        global ClearLogRequired

        set ClearLogRequired $bClear 
	set dialog [tix filedialog tixFileSelectDialog]
	set dialog_fsbox [$dialog subwidget fsbox]
	set dialog_btns [$dialog subwidget btns]
	set dialog_fsbox_selection [$dialog_fsbox subwidget selection]
	set dialog_fsbox_filter [$dialog_fsbox subwidget filter]
	set dialog_btns_help [$dialog_btns subwidget help]
	set dialog_btns_apply [$dialog_btns subwidget apply]
	
	bind [winfo toplevel $dialog] <Alt-Key-s> "" 
	bind [winfo toplevel $dialog] <Alt-Key-f> \
	"focus [$dialog_fsbox subwidget selection]"

	$dialog_fsbox_filter appendhistory "*.iml"
	$dialog_fsbox_filter appendhistory "*.*"

	$dialog config -title "Save To A File" 

	$dialog_fsbox config -disablecallback true
	$dialog_fsbox_selection config -label "File Name" 
	$dialog_fsbox_selection config -selectmode immediate 

	$dialog_btns config -cancelcmd "GetNameAndExitCancel $dialog"
	$dialog_btns config -okcmd "GetNameAndSaveExit $dialog"
	$dialog_btns_help config -state disabled 
	$dialog_btns_apply config -state disabled
	
	bind [winfo toplevel $dialog] <Alt-o> \
	"after 0 ButtonInvoke [$dialog_btns subwidget ok]"
	bind [winfo toplevel $dialog] <Alt-c> \
	"after 0 ButtonInvoke [$dialog_btns subwidget cancel]"

	tixPushGrab $dialog
	focus $dialog
	$dialog popup
}

proc GetNameAndExitCancel { dialog } {
        tixPushGrab $dialog
	tixPopGrab
	destroy $dialog
}

proc GetNameAndSaveExit { dialog} {
	global IMLList IML_GUI_MSGS ClearLogRequired

	set dialog_fsbox [$dialog subwidget fsbox]
	set dialog_fsbox_selection [$dialog_fsbox subwidget selection]

	set filename [$dialog_fsbox_selection cget -value]
	if { $filename == "" } {
		DisplayErrorMessage $IML_GUI_MSGS(MSG_ENTER_FILENAME)
		return
	} else {
                if {[string match *.iml* $filename] == 0} {
        	   append filename ".iml"
                }
        	set fd [open $filename w+]
        	seek $fd 0 end
        	set IMLListLength [llength $IMLList]
        	for {set x 0} {$x < $IMLListLength} {incr x} {
        		set row [lindex $IMLList $x]
        		for {set y 0} {$y < 7} {incr y} {
        	 		set elem [lindex $row $y]
        			puts $fd $elem
        		}
        	}
        	close $fd
	}
        tixPushGrab $dialog
	tixPopGrab 
	destroy $dialog
	if { $ClearLogRequired == 1 } {
		ClearLog
		set ClearLogRequired 0
	}
}


proc GetNameAndOpen {} {

	set dialog [tix filedialog tixFileSelectDialog]
	set dialog_fsbox [$dialog subwidget fsbox]
	set dialog_btns [$dialog subwidget btns]
	set dialog_fsbox_selection [$dialog_fsbox subwidget selection]
	set dialog_fsbox_filter [$dialog_fsbox subwidget filter]
	set dialog_btns_help [$dialog_btns subwidget help]
	set dialog_btns_apply [$dialog_btns subwidget apply]

	bind [winfo toplevel $dialog] <Alt-Key-s> "" 
	bind [winfo toplevel $dialog] <Alt-Key-f> \
	"focus [$dialog_fsbox subwidget selection]"	

	$dialog_fsbox_filter appendhistory "*.iml"
	$dialog_fsbox_filter appendhistory "*.*"

	$dialog config -title "Open A File" 
	$dialog_fsbox config -disablecallback true
	$dialog_fsbox_selection config -label "File Name" 
	$dialog_fsbox_selection config -selectmode immediate 

	$dialog_btns config -cancelcmd "GetNameAndExitCancel $dialog" 
	$dialog_btns config -okcmd "GetNameAndOpenExit $dialog" 
	$dialog_btns_help config -state disabled 
	$dialog_btns_apply config -state disabled 

	bind [winfo toplevel $dialog] <Alt-o> \
	"after 0 ButtonInvoke [$dialog_btns subwidget ok]"
	bind [winfo toplevel $dialog] <Alt-c> \
	"after 0 ButtonInvoke [$dialog_btns subwidget cancel]"

	tixPushGrab $dialog
	focus $dialog
	$dialog popup
}

proc GetNameAndOpenExit { dialog } \
{
	global IMLList FullIMLList OldIml IML_GUI_MSGS FileName

	set dialog_fsbox [$dialog subwidget fsbox]
	set dialog_fsbox_selection [$dialog_fsbox subwidget selection]

	set filename [$dialog_fsbox_selection cget -value]

	if { $filename == "" } {
		DisplayErrorMessage $IML_GUI_MSGS(MSG_ENTER_OPENNAME)
		return
	} else {
		if { ![file exists $filename] } {
			DisplayErrorMessage $IML_GUI_MSGS(MSG_FILE_NOT_FOUND)
		} else {
			set FileName "$filename"
			set OldIml 1
			set IMLList [list]
			set FullIMLList [list]
			set fd [open $filename]
			set cont [gets $fd line]
			while {$cont >= 0} {
	 			set row [list]
	   			for {set i 0} {$i < 7} {incr i} {
					lappend row $line
					set cont [gets $fd line]
	 			}
		 		lappend IMLList $row
		 		lappend FullIMLList $row
			}
			close $fd
		}
	}
        tixPushGrab $dialog
	tixPopGrab 
	destroy $dialog
	UpdateTitle
	FilterAndUpdateList 1
	UpdateMenuOptions
}

proc FilterCBExit { w } {

	FilterAndUpdateList 1	
        tixPushGrab $w
	tixPopGrab 
	destroy $w
}

proc FilterCB { } {

	global Class Severity InitTime UpdateTime

	set w .filter
	catch {destroy $w}
	toplevel $w
	wm title $w "Filter Events"
	wm iconname $w "fevent"
	wm geometry $w +300+300
	
	tixPushGrab $w
	focus $w

	set f [frame $w.options1]
	pack $f -side top -fill x 
	set m [label $f.label1 -text "Class:" -underline 0]
	pack $m -side left
	tk_optionMenu $f.menu1 Class All {Internal Test} \
		{Machine Environment} {Main Memory} {Cache Memory} \
		{CPU} {Host Bus} {EISA Bus} {PCI Bus} {Expansion Slot} \
		{POST Messages} {POST Error} {Power Subsystem} {UPS} {ASR} \
		{Operating System} {Diagnostics} {Network} {SCSI Subsuystem} \
		{Drive Array Subsystem} {System Revision} {Maintenance Note} \
		{Maintenance Clear Log} {Infrastructure Environment} \
		{OS Class}

	$f.menu1 configure -width 30
	pack $f.menu1 -side right -fill none 
	bind [winfo toplevel $w] <Alt-c> \
		"focus $f.menu1"

	set f [frame $w.options2]
	pack $f -side top -fill x 
	set m [label $f.label2 -text "Severity:" -underline 0]
	pack $m -side left
	tk_optionMenu $f.menu2 \
		Severity  \
		All \
		Information \
		Repaired \
		Caution \
		Critical \
		Unknown
	$f.menu2 configure -width 30
	pack $f.menu2 -side right -fill none 
	bind [winfo toplevel $w] <Alt-s> \
		"focus $f.menu2"	

	set f [frame $w.options3]
	pack $f -side top -fill x 
	set m [label $f.label3 -text "Update Time:" -underline 0]
	pack $m -side left
	tk_optionMenu $f.menu3 \
		UpdateTime \
		All \
		{Since Yesterday} \
		{Since A Week Ago} \
		{During Past 30 Days} \
		{Last Six Months}
	$f.menu3 configure -width 30
	pack $f.menu3 -side right -fill none 
	bind [winfo toplevel $w] <Alt-u> \
		"focus $f.menu3"	

	set f [frame $w.options4]
	pack $f -side top -fill x 
	set m [label $f.label4 -text "Initial Time:" -underline 0]
	pack $m -side left
	tk_optionMenu $f.menu4 \
		InitTime \
		All \
		{Since Yesterday} \
		{Since A Week Ago} \
		{During Past 30 Days} \
		{Last Six Months}

	$f.menu4 configure -width 30
	pack $f.menu4 -side right -fill none 
	bind [winfo toplevel $w] <Alt-i> \
		"focus $f.menu4"

	set f [frame $w.buttons]
	pack $f -side bottom -fill x -pady 2m
	set m [button $f.ok -text OK -command "FilterCBExit $w" -underline 0]
	pack $m -side left -expand 1 
	  bind [winfo toplevel $w] <Alt-o> \
		"after 0 ButtonInvoke $f.ok"
}

proc SetToAll { } {
	
	global Class Severity InitTime UpdateTime

	set Class "All"
	set Severity "All"
	set InitTime "All"
	set UpdateTime "All"
}

#
# This function will check the number of characters entered
# in the Maintenance Note widget. It prevents the user from
# entering > 228 characters. 
#
proc CheckInputCB {newstr length} {

        return [expr {[string length $newstr] <= $length}]

}

proc MaintNoteCB { } {

	global IML_GUI_MSGS SEVER varname

	set w .mainNote
	catch {destroy $w}
	toplevel $w
	wm title $w $IML_GUI_MSGS(MSG_MAINT_NOTE_HEADING)
	wm iconname $w "mmode"
	wm geometry $w +300+300

	tixPushGrab $w
	focus $w

	set varname $SEVER(Information)
        # The entry widget has a -validate command associated with it that 
        # prevents the user from adding too many characters in the widget
        # with a limit.
        set t [entry $w.msg -width 60 -validate all -invalidcommand bell -validatecommand {CheckInputCB %P 228}]
	pack $t -side top -padx 5 -pady 5
        focus $t
# The following code lines are commented out until we decide whether we want
# to allow the user to set a severity level associated with the Maintenance
# Notes.  If we ever do, just uncomment these lines and it should function ok.
#	set r [frame $w.radios]
#	pack $r -anchor nw  -fill x -pady 5 -padx 2
#	set x 0
#	foreach item {Repaired Information Caution Critical} {
#		radiobutton $r.$x \
#			-variable varname \
#			-text $item \
#			-value $SEVER($item)
#		if { $x == 1 } {
#			$r.$x select
#		}
#		pack $r.$x -side left
#		incr x
#	}
	
#	pack $r -anchor nw 
	set f [frame $w.buttons]
	pack $f -side bottom -fill x -pady 2
	set m [button $f.ok -text OK -command "LogNote $w"]
	set c [button $f.cancel -text Cancel -command "destroy $w"]
	pack $m $c -side left -expand 1 

        bind [winfo toplevel $w] <Alt-o> \
        "after 0 ButtonInvoke $m"
        bind [winfo toplevel $w] <Alt-c> \
        "after 0 ButtonInvoke $c"

}

proc LogNote { w } {

	global EXE_FILE IML_GUI_MSGS Options InputPipe OutputPipe varname

	set TYPE 3
	set str [$w.msg get]
	set str [string trimleft $str]
	set str [string trimright $str]
	set strlen [string length $str]

        # We need to look for any occurrence of an asterisk
        # and prompt the user to remove that character from
	# the maintenance note. We use the '*' character as
	# a delimiter when parsing thru the IML strings
	# which are built on the back-end.
        for {set x 0} {$x < $strlen} {incr x} {
           if { [cindex $str $x] == "*" } {
		DisplayErrorMessage "Please avoid using the '*' character in your maintenance notes." 
                return
           }
        } 
	if { $str == "" } {
		DisplayErrorMessage $IML_GUI_MSGS(MSG_MAINT_NOTE_EMPTY)
		return
	} elseif { $strlen > 226 } {
		DisplayErrorMessage $IML_GUI_MSGS(MSG_NOTE_TOO_LONG)
		return
	} else {
		set ret "\n"
		set rep " "
		regsub -all $ret $str $rep str2
		puts $InputPipe "$Options(APPEND)*$str2*$TYPE"
		flush $InputPipe
		if { [gets $OutputPipe retval] == -1} {
	   		Quit $IML_GUI_MSGS(MSG_BROKEN_PIPE)
		}
		set retval1 [lindex retval 0]
		if { $retval1  == "FAILURE" } {
			DisplayErrorMessage [lrange $retval 1 9999]
		} else {
			ParseAndUpdateList 0
		}
                tixPushGrab $w
		tixPopGrab 
		destroy $w
	}
} 


proc DetailsCB {row} {

	global IMLList IML_GUI_MSGS

# display the entire entry in the text field since there is sooooo much data
# to show in the listbox.  In Tcl there is just no easy way to let the user
# see everything on the screen. Also, there is no such widget like a CListCtrl
# in Visual C++.

	set str  "$str Description:    [lindex $IMLList 0] \n"
	set str  "$str Class:          [lindex $IMLList 1] \n"
	set str  "$str Status:       [lindex $IMLList 2] \n"
	set str  "$str Count:          [lindex $IMLList 3] \n"
	set str  "$str Update Time:    [lindex $IMLList 4] \n"
	set str  "$str Initial Time:   [lindex $IMLList 5]"

	tk_messageBox \
		-default ok \
		-message $str \
		-title $IML_GUI_MSGS(MSG_DETAIL_EVENT_TITLE) \
		-type ok 
}

# The following Procedure is called upon encountering an error....It displays
# a message box with the error, then kills the application.
proc DoErrorDie { msg } {

	tk_messageBox -default ok -message $msg -title "Error" -type ok 
}

proc SortOptionsExit { w } {

	global Sort FullIMLList

	if {$Sort < 3} {
		set FullIMLList [lsort -index $Sort $FullIMLList]
	} else {
		set FullIMLList [lsort -dictionary -index $Sort $FullIMLList]
	}
	FilterAndUpdateList 1
        tixPushGrab $w
	tixPopGrab 
	destroy $w
}

proc SortOptionsCB { } \
{
	global Sort 

	set w .sort
	catch {destroy $w}
	toplevel $w
	wm title $w "Sort Options"
	wm iconname $w "hscale"
	wm geometry $w +300+300

	tixPushGrab $w
	  focus $w

	label $w.msg  \
		-wraplength 3.5i \
		-justify left \
		-text "Choose a Sort Option"

	pack $w.msg -side top -padx .5c

	set f [frame $w.f -relief groove -bd 3]
	pack $f -fill both -padx 2 -pady 2

	set m [radiobutton $w.f.radio1 \
		-text "Sort by Description" \
		-variable Sort -value 0]
	pack $m -side top -anchor w 

	set m [radiobutton $w.f.radio2 \
		-text "Sort by Class" \
		-variable Sort \
		-value 1]
	pack $m -side top -anchor w

	set m [radiobutton $w.f.radio3 \
		-text "Sort by Severity" \
		-variable Sort \
		-value 2]
	pack $m -side top -anchor w

	set m [radiobutton $w.f.radio4 \
		-text "Sort by Count" \
		-variable Sort \
		-value 3]
	pack $m -side top -anchor w

	set m [radiobutton $w.f.radio5 \
		-text "Sort by Initial Time" \
		-variable Sort \
		-value 4]
	pack $m -side top -anchor w

	set m [radiobutton $w.f.radio6 \
		-text "Sort by Update Time" \
		-variable Sort \
		-value 5]
	pack $m -side top -anchor w
	
	set m [radiobutton $w.f.radio7 \
		-text "Sort by ID" \
		-variable Sort \
		-value 6]
	pack $m -side top -anchor w

	set f [frame $w.buttons]
	pack $f -side bottom -fill x -pady 2m
	set m [button $f.ok \
		-text OK \
		-command "SortOptionsExit $w" \
                -underline 0]
	pack $m -side left -expand 1 

        # Here we map out our Hot Key...
        bind [winfo toplevel $w] <Alt-o> \
                "after 0 ButtonInvoke $m"
 
}

# Configure Tooltip for hp Logo and Icon Legend
proc LogoToolTip {button} {

	global menustatus IML_GUI_MSGS
	switch -glob $button {
		"*tg0"	{ set menustatus $IML_GUI_MSGS(MSG_LGD_REPR) }
		"*lg0"	{ set menustatus $IML_GUI_MSGS(MSG_LGD_REPR) }
		"*tg1"	{ set menustatus $IML_GUI_MSGS(MSG_LGD_CRIT) }
		"*lg1"	{ set menustatus $IML_GUI_MSGS(MSG_LGD_CRIT) }
		"*tg2"	{ set menustatus $IML_GUI_MSGS(MSG_LGD_CAUT) }
		"*lg2"	{ set menustatus $IML_GUI_MSGS(MSG_LGD_CAUT) }
		"*tg3"	{ set menustatus $IML_GUI_MSGS(MSG_LGD_INFO) }
		"*lg3"	{ set menustatus $IML_GUI_MSGS(MSG_LGD_INFO) }
		default	{ set menustatus $IML_GUI_MSGS(MSG_HTTP_URL) }
	}
	update idletasks
}

# Configure tooltips for the main display area (grid).
proc GridToolTip {grid} {

	global menustatus IMLListWidget IML_GUI_MSGS

	if {[catch {$IMLListWidget entrycget active} label]} {
		set label "list"
	}
	set menustatus $IML_GUI_MSGS($label)
	update idletasks
}

# Configure tooltips for the menu operations.
proc MenuToolTip {menu} {

	global menustatus IML_HLP_MSGS

	if {[catch {$menu entrycget active -label} label]} {
		set label ""
	}
	set menustatus $IML_HLP_MSGS($label)
	update idletasks
}

# Close a file and update the window title.
proc CloseFile {} {

	global FileName

	set FileName ""
	UpdateTitle
	RefreshNow
}

# Rebuild the window title when viewing a file instead of the log.
proc UpdateTitle {} {

	global FileName form IML_GUI_MSGS HostName
	
	if { $FileName != "" } {
		set newTitle "- "
	}
	append newTitle "$FileName"
        if {[string match *debian* $HostName] != 0} {
                set DriverInfo [exec dpkg -l hpasm | grep hpasm]
                set DriverName [lindex $DriverInfo 1]
                set Version [lindex $DriverInfo 2]
                set DriverInfo "$DriverName-$Version"
        } else {
                set DriverInfo [exec rpm -q hpasm]
        }

	wm title $form "$IML_GUI_MSGS(MSG_APP_TITLE) $DriverInfo $newTitle"
}

# This is an exact copy of the function tkButtonInvoke
# that ships with the Tcl libraries. We are using this
# copy because UnitedLinux's Tcl libraries fall a bit
# short in some of the widget code. Instead of going 
# through the painful updating of rpms and libraries, we
# decided to make our own tkButtonInvoke procedure to 
# work across all the Linux flavors. We renamed it to
# make sure there was no conflict later on.
proc ButtonInvoke {w} {
     if {[string compare [$w cget -state] "disabled"]} {
         set oldRelief [$w cget -relief]
         set oldState [$w cget -state]
         $w configure -state active -relief sunken
         update idletasks
         after 100
         $w configure -state $oldState -relief $oldRelief
         uplevel #0 [list $w invoke]
     }
}


################### Build Screen Layout #######################

# Initialize the start flag.
set bSTART 1

# Get the systems hostname.
set HostName [exec hostname]

# Build the toplevel window.
wm withdraw .
set form .app
catch {destroy $form}
toplevel $form
bind .app  <Destroy> exit 

if {[string match *debian* $HostName] != 0} {
   set DriverInfo [exec dpkg -l hpasm | grep hpasm ]
   set DriverName [lindex $DriverInfo 1]
   set Version [lindex $DriverInfo 2]
   set DriverInfo "$DriverName-$Version"
} else {
   set DriverInfo [exec rpm -q hpasm]
}

wm title $form "$IML_GUI_MSGS(MSG_APP_TITLE) - $DriverInfo"
wm iconname $form "menu"
wm geometry $form 800x500+100+100

# This is the way to override the WM_DELETE_WINDOW
# command. We need to do this because under
# United Linux, an error occurs when the 'x' icon
# in the upper right hand corner of the window
# is pressed to close the app.
wm protocol $form WM_DELETE_WINDOW QuitCBx 

# Check to see if user is logged in as 'root'
CheckRoot .

# Build the main menus.
menu $form.menu -tearoff 0

set m $form.menu.file
menu $m -tearoff 0
$form.menu add cascade -label $IML_GUI_MSGS(MSG_FILE_LABEL) -menu $m -underline 0
$m add command -label $IML_GUI_MSGS(MSG_OPEN_LABEL) -command {GetNameAndOpen} -underline 0
$m add command -label $IML_GUI_MSGS(MSG_SAVEAS_LABEL) -command {GetNameAndSave "0"} -underline 0
$m add command -label $IML_GUI_MSGS(MSG_CLOSE_LABEL) -command {CloseFile} -underline 0 -state disabled
$m add separator
$m add command -label $IML_GUI_MSGS(MSG_EXIT_LABEL) -command {Quit " "} -underline 1

set m $form.menu.logmenu
menu $m -tearoff 0
$form.menu add cascade -label $IML_GUI_MSGS(MSG_LOG_LABEL) -menu $m -underline 0 
$m add command -label $IML_GUI_MSGS(MSG_CLEAR_LABEL) -command {WarningCB} -underline 0  -state disabled 
$m add command -label $IML_GUI_MSGS(MSG_REPAIR_LABEL) -command {RepairEntry "-1" "0"} -underline 0 -state disabled 
$m add command -label $IML_GUI_MSGS(MSG_MAINT_NOTE_LABEL) -command {MaintNoteCB} -underline 0 -state disabled

set m $form.menu.viewmenu
menu $m -tearoff 0
$form.menu add cascade -label $IML_GUI_MSGS(MSG_VIEW_LABEL) -menu $m -underline 0
$m add command -label $IML_GUI_MSGS(MSG_FILTER_LABEL) -command {FilterCB} -underline 0
$m add command -label $IML_GUI_MSGS(MSG_REFRESH_NOW) -command {RefreshNow} -underline 0 -state disabled

# TVMTODO: It appears that there are memory issues when the IML viewer
# is left running for extended periods of time WITH the refresh rate 
# activated. Ultimately, the system becomes bogged down. It only seems
# to NOT be a problem under RH8.0. We will just remove this feature
# for now until the problem is better understood. This feature seems
# to benefit QA more than our customers so we can activate it for them
# only.
#$m add command -label $IML_GUI_MSGS(MSG_REFRESH_RATE) -command {RefreshRateCB} -underline 1

$m add command -label $IML_GUI_MSGS(MSG_SORT_LABEL) -command {SortOptionsCB} -underline 0


# Define and configure the main display window, in grid format.
set w [tixScrolledGrid $form.listctrl -bd 0]
pack $w -expand yes -fill both -padx 3 -pady 3

set IMLListWidget [$form.listctrl subwidget grid]
$IMLListWidget size row default -size auto -pad0 3

for {set x 0} {$x < 7} {incr x} {
	$IMLListWidget size col $x -size auto
}
# Draw the grids and set bg colors.
$IMLListWidget config -formatcmd "SimpleFormat $IMLListWidget"

# Bind the mouse event "double click" to display the Details window.
bind $IMLListWidget <Double-ButtonPress-1> {DisplayDetails}
# Bind the mouse event "ButtonPress-3, right mouse button"
bind $IMLListWidget <ButtonPress-3> {RightClkRepair}
# Bind the enter event to the grid, to display the IML Entry tooltip.
bind $IMLListWidget <Enter> {GridToolTip %W}

DefineIcons

# Build the status bar at bottom of window.
set f [frame $form.frame2]
pack $f -side bottom -fill x -pady 2
set w [label $f.menustatus -textvariable menustatus -relief sunken -bd 1 -font "Helvetica 12" -anchor w -width 40 -justify left -wraplength 300]
set fl [frame $f.fleg -relief groove]
set flu [frame $fl.flupper]
set fll [frame $fl.flower]
pack $flu -side top -expand yes
pack $fll -side bottom -expand yes

set leg0 [button $flu.lg0 \
	-image $icon(0) \
	-relief flat \
	-width 80 \
	-justify center \
	-takefocus 0]
set leg1 [button $flu.lg1 \
	-image $icon(1) \
	-relief flat \
	-width 80 \
	-justify center \
	-takefocus 0]
set leg2 [button $flu.lg2 \
	-image $icon(2) \
	-relief flat \
	-width 80 \
	-justify center \
	-takefocus 0]
set leg3 [button $flu.lg3 \
	-image $icon(3) \
	-relief flat \
	-width 80 \
	-justify center \
	-takefocus 0]
set teg0 [button $fll.tg0 \
	-text "   Repaired    " \
	-font "Helvetica 10" \
	-relief flat \
	-justify center \
	-takefocus 0]
set teg1 [button $fll.tg1 \
	-text "Critical/Failed" \
	-font "Helvetica 10" \
	-relief flat \
	-justify center \
	-takefocus 0]
set teg2 [button $fll.tg2 \
	-text "    Caution    " \
	-font "Helvetica 10" \
	-relief flat \
	-justify center \
	-takefocus 0]
set teg3 [button $fll.tg3 \
	-text "  Information  " \
	-font "Helvetica 10" \
	-relief flat \
	-justify center \
	-takefocus 0]
# Setup logo based on whether browser is available or not.
if { $BROWSE } {
set l [button $f.logo \
	-image $logo \
	-relief flat \
	-command {CallBrowser} \
	-takefocus 0]
} else {
set l [button $f.logo \
	-image $logo \
	-relief flat \
	-takefocus 0]
}
pack $leg0 $leg3 $leg2 $leg1 -side right -fill y -expand yes
pack $teg0 $teg3 $teg2 $teg1 -side right -fill y -expand yes
pack $w -side left -padx 2 -expand yes -fill both
pack $l $fl -side right -padx 2 -expand yes -fill both

$form configure -menu $form.menu

OpenCmdPipes
SetToAll
ParseAndUpdateList 1
UpdateMenuOptions

# Bindings for the menu tooltips.
bind .app.menu <<MenuSelect>> {
	MenuToolTip %W
}
bind .app.menu.file <<MenuSelect>> {
	MenuToolTip %W
}
bind .app.menu.logmenu <<MenuSelect>> {
	MenuToolTip %W
}
bind .app.menu.viewmenu <<MenuSelect>> {
	MenuToolTip %W
}
bind $l <Enter> {
	LogoToolTip %W
}
bind $leg0 <Enter> {
	LogoToolTip %W
}
bind $teg0 <Enter> {
	LogoToolTip %W
}
bind $leg1 <Enter> {
	LogoToolTip %W
}
bind $teg1 <Enter> {
	LogoToolTip %W
}
bind $leg2 <Enter> {
	LogoToolTip %W
}
bind $teg2 <Enter> {
	LogoToolTip %W
}
bind $leg3 <Enter> {
	LogoToolTip %W
}
bind $teg3 <Enter> {
	LogoToolTip %W
}

proc tixScrolledGrid:B1-Leave {w} {
	tixGrid:B1-Leave $w
}

proc tixScrolledGrid:B1-Enter {w x y} {
	tixGrid:B1-Enter $w $x $y
}
