#!/bin/bash
# ##################################################################
# ### copyright 2003 Compaq Information Technologies Group, L.P. ###
# ##################################################################

# ********************************************************
# ** log_msg                                            **
# ********************************************************
# ** This routine will log a message to the screen and  **
# ** to our error log.                                  **
# ********************************************************
function log_msg() {
   echo "$*" >> /opt/compaq/cpqhealth/cpqhealth_boot.log 
   echo "$*"
}


# ********************************************************
# ** MAIN                                               **
# ********************************************************
# ** This is the main routine of the shell script       **
# ********************************************************
MY_DATE=`date`
THIS_KERNEL=`uname -r`
DIR=/opt/compaq/cpqhealth/cmhp/${THIS_KERNEL}
CMHP=${DIR}/cmhp.o


if [ ! -d ${DIR} ]
then
   log_msg "Creating directory \"${DIR}\" "
   mkdir -p ${DIR} 
fi

log_msg "Replacing ${CMHP} at ${MY_DATE} . . ."

cp cmhp_custom.o ${CMHP}
log_msg "Custom Memory Hot Plug Driver installed  . . ."

log_msg "Reloading the hp ProLiant Memory Hot Plug Driver module . . ."
if eval "insmod -p ${CMHP}" >>/opt/compaq/cpqhealth/cpqhealth_boot.log 2>&1

then 
	/sbin/insmod ${CMHP} >>/opt/compaq/cpqhealth/cpqhealth_boot.log 2>&1
	log_msg " "
	log_msg "The hp ProLiant Advanced Server Management module (cmhp.o) has rebuilt"
	log_msg "and has loaded successfully."
	log_msg " "
	exit 0 
else
	echo -e "\n"
	log_msg "WARNING!  The hpasm RPM is not compatible with this kernel."
	log_msg "          See /opt/compaq/cpqhealth/cpqhealth_boot.log for details."
	log_msg "          Hint:  Look for Compiler or Linker issues."
	exit 1 
fi

