################################################################
## copyright 2003 Compaq Information Technologies Group, L.P. ##
################################################################
#Redhat AS 2.1 
 
PWD=`pwd`
CC=gcc
LD=ld
LEVEL=.

EFS_VER=$(shell if [ -f PKG_VERSION ]; then cat PKG_VERSION; else echo Dangerous; fi)

IFLAGS=-I$(LEVEL) -I/lib/modules/`uname -r`/build/include

DFLAGS=-D__KERNEL__ -DMODULE -DEFS_VER=\"$(EFS_VER)\"

COMPILEROPTS=-Wall -Wstrict-prototypes -O2 -fomit-frame-pointer

CFLAGS=$(COMPILEROPTS) $(DFLAGS) $(IFLAGS)

DFLAGS_UP = -D__BOOT_KERNEL_H_ -D__MODULE_KERNEL_i686=1 -D__BOOT_KERNEL_ENTERPRISE=0 -D__BOOT_KERNEL_SMP=0 -D__BOOT_KERNEL_UP=1
DFLAGS_MP = -D__BOOT_KERNEL_H_ -D__MODULE_KERNEL_i686=1 -D__BOOT_KERNEL_ENTERPRISE=0 -D__BOOT_KERNEL_SMP=1 -D__BOOT_KERNEL_UP=0
DFLAGS_EP = -D__BOOT_KERNEL_H_ -D__MODULE_KERNEL_i686=1 -D__BOOT_KERNEL_ENTERPRISE=1 -D__BOOT_KERNEL_SMP=0 -D__BOOT_KERNEL_UP=0


cmhp.o: cmhp.c 
	$(CC) $(CFLAGS) -D__KERNEL__ -DMODULE -I$(LEVEL) -c cmhp.c

all: clean cmhp.c cmhp_up.o cmhp_smp.o cmhp_ent.o

rebuild: clean
	$(CC) $(CFLAGS) -c cmhp.c
	ld -r -o cmhp_custom.o cmhp.o cmhp_lib.o

cmhp_up.o:
	$(CC) $(CFLAGS) $(DFLAGS_UP) -c cmhp.c
	ld -r -o cmhp_up.o cmhp.o cmhp_lib.o

cmhp_smp.o:
	$(CC) $(CFLAGS) $(DFLAGS_MP) -c cmhp.c
	ld -r -o cmhp_smp.o cmhp.o cmhp_lib.o

cmhp_ent.o:
	$(CC) $(CFLAGS)  $(DFLAGS_EP) -c cmhp.c
	ld -r -o cmhp_ent.o cmhp.o cmhp_lib.o

clean:
	rm -f cmhp_up.o cmhp_smp.o cmhp_ent.o cmhp_custom.o cmhp.o

	

