<html>
<!-- $RCSfile: MS-FTAPE.TPL $ $Revision: 1.17 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Fibre Channel Tape Drive Information</title>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqFcTapeCntlrEntry>
<!cpqSsChassisEntry>
<!cpqFcTapeLibraryEntry>
<!cpqFcTapeDriveEntry>
<!cpqFcTapeCountersEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#FCAENUMS.JS>
<!#MS-FCCMN.JS>
</script>
</head>
<script language="JavaScript">

writeBodyHead();

drive = findArg("index");
locIndex = findArg("loc");

if (drive == -1 || locIndex == -1)
{
   parseArgs(tryPrevPage());
   drive = findArg("index");
   locIndex = findArg("loc");
}
if (drive >= cpqFcTapeDriveEntry.length)
{
   reportMissingArgs();
}
else
{
   if (fcTapeStorageSystem(drive) != "")
      title = fcChassisName(locIndex);
   else
      title = fcTapeCntlrName(locIndex);

   writePageHead(title, "/WEBAGENT/IMAGES/MASSHDR.GIF", "Tape Drive Information");
   tapeCondition = new cpqCondition(cpqFcTapeDriveEntry[drive].cpqFcTapeDriveCondition);
   writeTableLabel(tapeCondition.image() + fcTapeName(drive));
   writeTableHead();
   writeDoubleTableRow(
      "Status:", displayItem("cpqFcTapeDriveStatus", cpqFcTapeDriveEntry[drive].cpqFcTapeDriveStatus),
      "Model:",  displayItem("cpqFcTapeDriveModel",  cpqFcTapeDriveEntry[drive].cpqFcTapeDriveModel));
   writeDoubleTableRow(
      "Firmware Revision:", displayItem("cpqFcTapeDriveFWRev", cpqFcTapeDriveEntry[drive].cpqFcTapeDriveFWRev),
      "Serial Number:",     displayItem("cpqFcTapeDriveSerialNumber", cpqFcTapeDriveEntry[drive].cpqFcTapeDriveSerialNumber));
   writeDoubleTableRow(
      "Current Width:", displayItem("cpqFcTapeDriveCurrentWidth", cpqFcTapeDriveEntry[drive].cpqFcTapeDriveCurrentWidth),
      "Current Speed:", displayItem("cpqFcTapeDriveCurrentSpeed", cpqFcTapeDriveEntry[drive].cpqFcTapeDriveCurrentSpeed));
   writeDoubleTableRow(
      "Library Drive:", displayItem("cpqFcTapeDriveLibraryDrive", cpqFcTapeDriveEntry[drive].cpqFcTapeDriveLibraryDrive),
      "Hot Plug:",      displayItem("cpqFcTapeDriveHotPlug", cpqFcTapeDriveEntry[drive].cpqFcTapeDriveHotPlug));
   writeDoubleTableRow(
      "Drive Bay:", displayItem("cpqFcTapeDriveBay", cpqFcTapeDriveEntry[drive].cpqFcTapeDriveBay),
      "", "");
   writeTableTail();

   document.write("<br>");
   writeTableLabel("Tape Drive Error Counts");
   writeTableHead();
   writeDoubleTableRow(
      "Tape Errors:", displayItem("cpqFcTapeCountersTotalErrors", cpqFcTapeCountersEntry[drive].cpqFcTapeCountersTotalErrors),
      "Re-Reads:",    displayItem("cpqFcTapeCountersReReads", cpqFcTapeCountersEntry[drive].cpqFcTapeCountersReReads));
   writeDoubleTableRow(
      "Uncorrectable:", displayItem("cpqFcTapeCountersTotalUncorrectable", cpqFcTapeCountersEntry[drive].cpqFcTapeCountersTotalUncorrectable),
      "Re-Writes:",     displayItem("cpqFcTapeCountersReWrites", cpqFcTapeCountersEntry[drive].cpqFcTapeCountersReWrites));
   writeTableTail();

   document.write("<br>");
   writeTableLabel("Tape Drive Maintenance");
   writeTableHead();
   writeSingleTableRow(
      "Tape Drive Heads Need Cleaning:", displayItem("cpqFcTapeDriveCleanReq", cpqFcTapeDriveEntry[drive].cpqFcTapeDriveCleanReq));
   writeSingleTableRow(
      "Cleaning Tape Needs Replacement:", displayItem("cpqFcTapeDriveCleanTapeRepl", cpqFcTapeDriveEntry[drive].cpqFcTapeDriveCleanTapeRepl));
   writeTableTail();
}
writeBodyTail();
</script>
</html>

