<html>
<!-- $RCSfile: MS-FCPHY.TPL $ $Revision: 1.33 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Fibre Channel Physical Drive Informaiton</title>

<script language="JavaScript">
   writeAccess = (2 & <!cpqFcaPhyDrvBlinkTime.access>) != 0;
   if (writeAccess) noAutoRefresh = 1;
</script>

<!#/COMMON/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqSsChassisEntry>
<!cpqFcaCntlrEntry>
<!cpqFcaPhyDrvEntry>
<!cpqFcaPhyDrvThrEntry>
<!cpqFcaLogDrvEntry>
<!cpqFcaLogDrvPhyDrvIDs.raw>
<!cpqFcaLogDrvAvailSpares.raw>
<!cpqFcaLogDrvSpareReplaceMap.raw>
<!cpqFcaSpareEntry>

<!#/COMMON/COND.JS>
<!#/COMMON/STDITEMS.JS>
<!#/COMMON/TABLES.JS>
<!#/COMMON/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#SSENUMS.JS>
<!#FCAENUMS.JS>
<!#MS-FCCMN.JS>

postfix["cpqFcaPhyDrvSize"] = "MB";

function determineDriveAction(drv)
{
   if (drv.cpqFcaPhyDrvStatus == 4 || drv.cpqFcaPhyDrvStatus == 6 ||
       drv.cpqFcaPhyDrvStatus == 5)
   {
      return "Replace Drive";
   }
   return "No Action Required";
}
function checkThreshold(val, thr, viol)
{
   var rc = "N/A";

   if (val != null && thr != null && viol != null)
   {
      if (val != "" && thr != "" && viol != "" &&
          val != -1 && thr != -1 && viol != -1)
      {
          if (viol == 2) rc = "Replace Drive";
          else if (viol == 1) rc = "OK";
      }
   }
   return rc;
}
function getIndex(form, boxIndex, drvIndex)
{
   form.INDEX.value = parseInt(boxIndex) + "." + parseInt(drvIndex);
   return true;
}
function hotPlugGraphic()
{
   return ("<img src='/WEBAGENT/CQMGSTOR/ENG/HOTPLUG.JPG' align='middle' width='11' height='15' hspace='3' border='0'> ");
}
function getReplacedDrive(idx, boxIndex, list, count)
{
   var i, j, drive = "";
   for (i = 0; i < cpqFcaPhyDrvEntry.length; i++)
   {
      if (cpqFcaPhyDrvEntry[i].cpqFcaPhyDrvBoxIndex == boxIndex &&
          cpqFcaPhyDrvEntry[i].cpqFcaPhyDrvIndex == idx)
      {
         for (j = 0; j < count; j++)
         {
            if (list[j] == idx) return ""; // Duplicate
         }
         drive += makeLink("CQMGSTOR/MS-FCPHY.TPL?index=" + i, fcPhyDrvName(i), "_self");
         break;
      }
   }
   return drive;
}
</script>
</head>
<script language="JavaScript">

writeBodyHead();

idx = findArg("index");

if (idx == -1)
{
   parseArgs(tryPrevPage());
   idx = findArg("index");
}
if (idx == -1 || idx >= cpqFcaPhyDrvEntry.length)
{
   reportMissingArgs();
}
else
{
   thisDrv  = cpqFcaPhyDrvEntry[idx];
   driveIdx = cpqFcaPhyDrvEntry[idx].cpqFcaPhyDrvIndex;
   thisBox  = thisDrv.cpqFcaPhyDrvBoxIndex;

   for (boxIdx = 0; boxIdx < cpqSsChassisEntry.length; boxIdx++)
   {
      if (thisDrv.cpqFcaPhyDrvBoxIndex == cpqSsChassisEntry[boxIdx].cpqSsChassisIndex)
         break;
   }
   for (i = 0; i < cpqFcaPhyDrvThrEntry.length; i++)
   {
      if (cpqFcaPhyDrvThrEntry[i].cpqFcaPhyDrvThrBoxIndex == thisDrv.cpqFcaPhyDrvBoxIndex &&
          cpqFcaPhyDrvThrEntry[i].cpqFcaPhyDrvThrIndex == thisDrv.cpqFcaPhyDrvIndex)
      {
         thisThr = cpqFcaPhyDrvThrEntry[i];
         break;
      }
   }
   thisSpare = null;

   for (i = 0; i < cpqFcaSpareEntry.length; i++)
   {
      if (cpqFcaSpareEntry[i].cpqFcaSpareBoxIndex == thisDrv.cpqFcaPhyDrvBoxIndex &&
          cpqFcaSpareEntry[i].cpqFcaSparePhyDrvIndex == thisDrv.cpqFcaPhyDrvIndex)
      {
         thisSpare = cpqFcaSpareEntry[i];
         break;
      }
   }
   driveCondition = new cpqCondition(thisDrv.cpqFcaPhyDrvCondition);
   writePageHead(fcChassisName(boxIdx), "/WEBAGENT/IMAGES/MASSHDR.GIF", "Physical Drive Information");
   writeTableLabel(driveCondition.image() + "Physical Drive - " + fcPhyDrvName(idx));
   writeTableHead();
   writeDoubleTableRow("Status:", displayItem("cpqFcaPhyDrvStatus", thisDrv.cpqFcaPhyDrvStatus),
                       "Action:", determineDriveAction(thisDrv));
   writeDoubleTableRow("Capacity:", fcDriveCapacity("cpqFcaPhyDrvSize", thisDrv.cpqFcaPhyDrvSize),
                       "Model:",    displayItem("cpqFcaPhyDrvModel", thisDrv.cpqFcaPhyDrvModel));
   writeDoubleTableRow("Firmware Version:", displayItem("cpqFcaPhyDrvFWRev", thisDrv.cpqFcaPhyDrvFWRev),
                       "Serial Number:",    displayItem("cpqFcaPhyDrvSerialNum", thisDrv.cpqFcaPhyDrvSerialNum));
   writeDoubleTableRow("Service Hours:", displayItem("cpqFcaPhyDrvRefHours", thisDrv.cpqFcaPhyDrvRefHours),
                       "S.M.A.R.T. Support:",    displayItem("cpqFcaPhyDrvPreFailMonitoring", thisDrv.cpqFcaPhyDrvPreFailMonitoring));
   writeDoubleTableRow("Current Width:", displayItem("cpqFcaPhyDrvCurrentWidth", thisDrv.cpqFcaPhyDrvCurrentWidth),
                       "Current Speed:", displayItem("cpqFcaPhyDrvCurrentSpeed", thisDrv.cpqFcaPhyDrvCurrentSpeed));
   if (thisDrv.cpqFcaPhyDrvHotPlug == 2)
   {
      writeDoubleTableRow("Placement:",  displayItem("cpqFcaPhyDrvPlacement", thisDrv.cpqFcaPhyDrvPlacement) + hotPlugGraphic(),
                          "", "");
   }
   else writeDoubleTableRow("Placement:",  displayItem("cpqFcaPhyDrvPlacement", thisDrv.cpqFcaPhyDrvPlacement),
                            "", "");
   writeTableTail();
   document.write("<br>");

   if (thisDrv.cpqFcaPhyDrvBlinkTime != "" && thisDrv.cpqFcaPhyDrvBlinkTime < 4294967295)
   {
      writeTableLabel("Identify Drive");
      writeTableHead();
      if (writeAccess)
      {
         if (thisDrv.cpqFcaPhyDrvBlinkTime > 1)
            document.write("<tr><form action='MS-FCPHY.TPL' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisDrv.cpqFcaPhyDrvBoxIndex, thisDrv.cpqFcaPhyDrvIndex);'>",
              "<input type='hidden' name='TABLESET' value='1'><input type='hidden' name='INDEX' value=''>",
              "<input type='hidden' name='cpqFcaPhyDrvBlinkTime' value='1'><td align='center' width='50%'>",
              "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'></td>",
              "<td align='center'><input type='submit' value='Stop'></td></form></tr>");
         else  // Not blinking
            document.write("<tr><form action='MS-FCPHY.TPL' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisDrv.cpqFcaPhyDrvBoxIndex, thisDrv.cpqFcaPhyDrvIndex);'>",
              "<td align='center' width='50%'><input type='hidden' name='TABLESET' value='1'>",
              "<input type='hidden' name='INDEX' value=''><small><font face='Arial'>Blink Drive Lights </font></small>",
              "<select name='cpqFcaPhyDrvBlinkTime'>",
              "<option value='600'>1 minute<option value='1200'>2 minutes<option value='1800'>3 minutes",
              "<option value='2400'>4 minutes<option value='3000' selected>5 minutes<option value='6000'>10 minutes",
              "<option value='12000'>20 minutes<option value='18000'>30 minutes<option value='24000'>40 minutes",
              "<option value='30000'>50 minutes<option value='36000'>1 hour</select></td>",
              "<td align='center'><input type='submit' value='Start'></td>",
              "</form></tr>");
      }
      else  // Read only
      {
         if (thisDrv.cpqFcaPhyDrvBlinkTime > 1)
            imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'>";
         else
            imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRIVE.GIF' width='72' height='42' border='0'>";

         document.write("<tr><td align='center' width='30%'>" + imgStr + "</td>",
            "<td><small><font face='Arial'>Only an administrator or an operator can blink the drive lights ",
            "to identify the drive. Select <I>Help</I> for further information.</font></small></td></tr>");
      }
      writeTableTail();
      document.write("<br>");
   }

   writeTableLabel("Logical Drives");
   writeTableHead();
   logDrvCondition = new cpqCondition(1);
   driveCount = 0;

   for (i = 0; i < cpqFcaLogDrvEntry.length; i++)
   {
      if (thisDrv.cpqFcaPhyDrvBoxIndex == cpqFcaLogDrvEntry[i].cpqFcaLogDrvBoxIndex)
      {
         rawData = cpqFcaLogDrvPhyDrvIDs[i];
         for (j = 0; j < rawData.length; j++)
            if (rawData[j] == thisDrv.cpqFcaPhyDrvIndex)
            {
               driveCount++;
               logDrvCondition.set(cpqFcaLogDrvEntry[i].cpqFcaLogDrvCondition);
               logLink = "CQMGSTOR/MS-FCLOG.TPL?index=" + i;
               document.write("<tr><td>");
               writeStatusNameTable(makeLink(logLink, logDrvCondition.imageSmall(), "_self"),
                                    makeLink(logLink, fcLogDrvName(i), "_self"));
               document.write("</td></tr>");
            }
         if (thisSpare != null &&
             thisSpare.cpqFcaSpareBoxIndex == cpqFcaLogDrvEntry[i].cpqFcaLogDrvBoxIndex)
         {
            rawData = cpqFcaLogDrvAvailSpares[i];
            for (j = 0; j < rawData.length; j++)
               if (rawData[j] == thisSpare.cpqFcaSparePhyDrvIndex)
               {
                  driveCount++;
                  logDrvCondition.set(cpqFcaLogDrvEntry[i].cpqFcaLogDrvCondition);
                  logLink = "CQMGSTOR/MS-FCLOG.TPL?index=" + i;
                  document.write("<tr><td>");
                  writeStatusNameTable(makeLink(logLink, logDrvCondition.imageSmall(), "_self"),
                                       makeLink(logLink, fcLogDrvName(i), "_self"));
                  document.write("</td></tr>");
               }
         }
      }
   }
   if (driveCount == 0) writeOneItemTableRow("None - Unconfigured");
   writeTableTail();

   if (thisSpare != null)
   {
      document.write("<br>");
      spareCondition = new cpqCondition(thisSpare.cpqFcaSpareCondition);
      writeTableLabel(spareCondition.imageSmall() + "Spare Information");
      writeTableHead();
      writeSingleTableRow("Status:", displayItem("cpqFcaSpareStatus", thisSpare.cpqFcaSpareStatus));
      rebuildCaption = "Percent Rebuild Complete:";
      rebuildData = percentGraph(thisSpare.cpqFcaSparePercentRebuild);
      writeSingleTableRow(rebuildCaption, rebuildData);

      // Get replaced drives
      driveCount = 0;
      driveList = new Array();
      for (i = 0; i < cpqFcaLogDrvEntry.length; i++)
      {
         if (cpqFcaLogDrvEntry[i].cpqFcaLogDrvBoxIndex == thisBox)
         {
            rawData = cpqFcaLogDrvSpareReplaceMap[i];
            for (j = 0; j < rawData.length; j += 2)
            {
               if (rawData[j] == driveIdx)
               {
                  drive = getReplacedDrive(rawData[j+1], thisBox, driveList, driveCount);
                  if (drive != "")
                  {
                     driveList[driveCount] = rawData[j+1];
                     driveCount++;
                     if (driveCount == 1)
                        writeSingleTableRow("Replaced Drives:", drive);
                     else
                        writeSingleTableRow("", drive);
                  }
                  break;
               }
            }
         }
      }
      if (driveCount == 0) writeSingleTableRow("Replaced Drives:", "None");
      writeTableTail();
   }
   if (thisDrv.cpqFcaPhyDrvHasMonInfo == 2)
   {
      document.write("<br>");
      writeTableLabel("Predictive Indicators");
      writeTableHead();
      funcTest1 = checkThreshold(thisDrv.cpqFcaPhyDrvFunctTest1, thisThr.cpqFcaPhyDrvThrFunctTest1, thisThr.cpqFcaPhyDrvThrViFunctTest1);
      funcTest2 = checkThreshold(thisDrv.cpqFcaPhyDrvFunctTest2, thisThr.cpqFcaPhyDrvThrFunctTest2, thisThr.cpqFcaPhyDrvThrViFunctTest2);
      funcTest3 = checkThreshold(thisDrv.cpqFcaPhyDrvFunctTest3, thisThr.cpqFcaPhyDrvThrFunctTest3, thisThr.cpqFcaPhyDrvThrViFunctTest3);
      spinupTime = checkThreshold(thisDrv.cpqFcaPhyDrvSpinupTime, thisThr.cpqFcaPhyDrvThrSpinupTime, thisThr.cpqFcaPhyDrvThrViSpinupTime);
      usedRealloc = checkThreshold(thisDrv.cpqFcaPhyDrvUsedReallocs, thisThr.cpqFcaPhyDrvThrUsedReallocs, thisThr.cpqFcaPhyDrvThrViUsedReallocs);

      if (thisDrv.cpqFcaPhyDrvPreFailMonitoring == 3 && funcTest1 == "N/A" && funcTest2 == "N/A" &&
          funcTest3 == "N/A" && spinupTime == "N/A" && usedRealloc == "N/A")
      {
         writeColumnTableDataRow("<b>S.M.A.R.T. Status: </b>" + displayItem("cpqFcaPhyDrvSmartStatus", thisDrv.cpqFcaPhyDrvSmartStatus));
         writeColumnTableDataRow("");
         writeColumnTableDataRow("This physical drive supports S.M.A.R.T. prefailure so the functional " +
                                 "tests, used reallocs, and spinup time values are no longer used.");
      }
      else
      {
         if (thisDrv.cpqFcaPhyDrvPreFailMonitoring == 3)
         {
            writeColumnTableDataRow("","<b>S.M.A.R.T. Status: </b>" + displayItem("cpqFcaPhyDrvSmartStatus", thisDrv.cpqFcaPhyDrvSmartStatus),"");
            writeColumnTableDataRow("","","");
         }
         writeColumnTableDataRow(
             "<b>Func Test 1: </b>" + funcTest1, "<b>Func Test 2: </b>" + funcTest2, "<b>Func Test 3: </b>" + funcTest3);
         writeColumnTableDataRow("","","");
         writeColumnTableHeaderRow("Indicator", "Value", "Status");
         writeColumnTableDataRow(
             "Used Realloc:", displayItem("cpqFcaPhyDrvUsedReallocs", thisDrv.cpqFcaPhyDrvUsedReallocs), usedRealloc);
         writeColumnTableDataRow(
             "Spinup Time:", displayItem("cpqFcaPhyDrvSpinupTime", thisDrv.cpqFcaPhyDrvSpinupTime), spinupTime);
      }
      writeTableTail();
      document.write("<br>");

      writeTableLabel("Problem Indicators");
      writeTableHead();
      writeDoubleTableRow(
         "Failed Recovery Reads:", displayItem("cpqFcaPhyDrvBadRecvReads", thisDrv.cpqFcaPhyDrvBadRecvReads),
         "SCSI Bus Faults:",       displayItem("cpqFcaPhyDrvBusFaults", thisDrv.cpqFcaPhyDrvBusFaults));
      writeDoubleTableRow(
         "Other Timeouts:", displayItem("cpqFcaPhyDrvOtherTimeouts", thisDrv.cpqFcaPhyDrvOtherTimeouts),
         "", "");
      writeTableTail();
      document.write("<br>");

      writeTableLabel("Failure Indicators");
      writeTableHead();
      writeDoubleTableRow(
         "Spinup Errors:",    displayItem("cpqFcaPhyDrvSpinUpErrs", thisDrv.cpqFcaPhyDrvSpinUpErrs),
         "Aborted Commands:", displayItem("cpqFcaPhyDrvAbortedCmds", thisDrv.cpqFcaPhyDrvAbortedCmds));
      writeDoubleTableRow(
         "Format Errors:",   displayItem("cpqFcaPhyDrvFormatErrs", thisDrv.cpqFcaPhyDrvFormatErrs),
         "Hardware Errors:", displayItem("cpqFcaPhyDrvHardwareErrs", thisDrv.cpqFcaPhyDrvHardwareErrs));
      writeDoubleTableRow(
         "Not Ready Errors:",  displayItem("cpqFcaPhyDrvNotReadyErrs", thisDrv.cpqFcaPhyDrvNotReadyErrs),
         "Bad Target Errors:", displayItem("cpqFcaPhyDrvBadTargetErrs", thisDrv.cpqFcaPhyDrvBadTargetErrs));
      writeDoubleTableRow(
         "Fail Recov Writes:", displayItem("cpqFcaPhyDrvBadRecvWrites", thisDrv.cpqFcaPhyDrvBadRecvWrites),
         "Media Failures:",    displayItem("cpqFcaPhyDrvMediaErrs", thisDrv.cpqFcaPhyDrvMediaErrs));
      writeTableTail();
      document.write("<br>");

      writeTableLabel("Statistics");
      writeTableHead();
      writeDoubleTableRow(
         "Sectors Read:",    displayQuadNumber(thisDrv.cpqFcaPhyDrvHReads, thisDrv.cpqFcaPhyDrvReads),
         "Sectors Written:", displayQuadNumber(thisDrv.cpqFcaPhyDrvHWrites, thisDrv.cpqFcaPhyDrvWrites));
      writeDoubleTableRow(
         "Hard Read Errors:",  displayItem("cpqFcaPhyDrvHardReadErrs", thisDrv.cpqFcaPhyDrvHardReadErrs),
         "Hard Write Errors:", displayItem("cpqFcaPhyDrvHardWriteErrs", thisDrv.cpqFcaPhyDrvHardWriteErrs));
      writeDoubleTableRow(
         "Recov Read Errors:",  displayItem("cpqFcaPhyDrvRecvReadErrs", thisDrv.cpqFcaPhyDrvRecvReadErrs),
         "Recov Write Errors:", displayItem("cpqFcaPhyDrvRecvWriteErrs", thisDrv.cpqFcaPhyDrvRecvWriteErrs));
      writeDoubleTableRow(
         "Total Seeks:",    displayItem("cpqFcaPhyDrvSeeks", thisDrv.cpqFcaPhyDrvSeeks),
         "Hot Plug Count:", displayItem("cpqFcaPhyDrvHotPlugs", thisDrv.cpqFcaPhyDrvHotPlugs));
      writeDoubleTableRow(
         "Seek Errors:", displayItem("cpqFcaPhyDrvSeekErrs", thisDrv.cpqFcaPhyDrvSeekErrs),
         "", "");
      writeTableTail();
   }
}
writeBodyTail();
</script>
</html>

