#! /bin/bash
###########################################################################
#  Copyright (c) 2003, Hewlett Packard Technologies Group, L. P.           #
############################################################################
#   PROGRAM: install.sh                                                    #
#   PURPOSE: Shell script for initiating the HP Linux Deployment Utility.  #
############################################################################
# $Id: install.sh,v 1.7.2.9.2.79 2003/11/25 15:26:00 GarnerMi Exp $
############################################################################

#DEBUG DEBUG DEBUG
# set -x

#################
##    LOCALE   ##
#################

LANG=ENG

#################
##   GLOBALS   ##
#################
# Change the pass number on this variable for each pass.
TARBALL=hppldu-1.0.2-4.tar.gz
LCKDIR=/var/lock/hppldu
LCKFILE=${LCKDIR}/hppldu.lock
WORKDIR="/tmp/hppldu"
HPDir="/var/hp"

# Required GDK Library.
GDK_LIB="/usr/lib/libgdk_pixbuf.so.2"
GDK_RPM="gdk-pixbuf-0.18.0-8.1.i386.rpm"
# Required GTK Library.
GTK_LIB="/usr/lib/libgtk-1.2.so.0"
# Process table command to use.
PSE="ps -e"
# Flag for indicating the user has interrupted our execution.
RFLAG=0
# Color definitions.
GREEN="[1;32m"
RED="[1;31m"
HILITE="[1;39m"
NORMAL="[0;39m"
# Default copy and remove commands to use.
CPCMD="/bin/cp -f"
MVCMD="/bin/mv -f"
RMCMD="/bin/rm -f"
# Some temporary scratch files to use.
TEMP1=/tmp/templsp1.$$
TEMP2=/tmp/templsp2.$$
# Option Preset from commandline.
CMDLINE=false
ItIsRHEL3=false
# Boolean flags for setting states.
BLDRPMDIR=false
STOPPED=false
NOHPASM=false
INTR=false
HelpOnly=false
DELAY=false

# Filenames for snmpd.conf files per distribution
RHConfFile="/etc/snmp/snmpd.conf"
SLES7ConfFile="/usr/share/snmp/snmpd.conf"
UL10ConfFile="/usr/share/snmp/snmpd.conf"
tmpConfFile="/var/hp/snmpd.conf.orig"
rpmMacroFile=".rpmmacros"

# Base kernel versions for each supported Linux Distro.
RHAS21="2.4.9-e.24"
RHEL21="2.4.9-e.24"
RHEL30="2.4.21-4"
RH73="2.4.18-3"
RH80="2.4.18-14"
RH90="2.4.20-2.21"
SLES7SMP="2.4.7-19"
SLES7="2.4.7-20"
UL10SMP="2.4.19-113"
UL10="2.4.19-120"

#################
##  FUNCTIONS  ##
#################

#Determine which OS this is, and setup the required directories accordingly.
SetupForOS()
{
    if [ -f /etc/redhat-release ]
    then
        GTKLanded "RH"
        RELFILE="/etc/redhat-release"
        if [ ! -d /usr/src/redhat ]
        then
            BldDirs "/usr/src/redhat"
            BLDRPMDIR=true
        fi
        export RPMDIR=/usr/src/redhat
            KERNELSRC=`uname -r | sed -e 's/enterprise//' -e 's/debug//' -e 's/[sS][mM][pP]//' -e 's/workstation//' -e 's/bigmem//' -e 's/summit//'`
        export KERNELSRC=/usr/src/linux-`echo $KERNELSRC | tr -d '[A-Da-d][f-mF-Mo-sO-Su-wU-WyYzZ]'`
        Version=`grep "[89]\.[0-9]" </etc/redhat-release`
        if [ ${#Version} -gt 0 ]
        then
            PSE="ps -em"
        fi
        rmdir $KERNELSRC 1>/dev/null 2>&1
        GetDistrVer
        export SNMPDCFGFILE=${RHConfFile}
        if [ -f ${RHConfFile} ]
        then
            ${CPCMD} ${RHConfFile} ${tmpConfFile} >/dev/null 2>&1
        fi
    fi
    if [ -f /etc/SuSE-release ]
    then
        GTKLanded "SU"
        RELFILE="/etc/S?SE-release"
        if [ ! -d /usr/src/packages ]
        then
            BldDirs "/usr/src/packages"
            BLDRPMDIR=true
        fi
        export RPMDIR=/usr/src/packages
        export KERNELSRC=/usr/src/linux-`uname -r | sed -e 's/-[-0-9A-Za-z]*$//' -e 's/$/\.SuSE/'`
        rmdir $KERNELSRC 1>/dev/null 2>&1
        GetDistrVer
        export SNMPDCFGFILE=${SLES7ConfFile}
        if [ -f ${SLES7ConfFile} ]
        then
            ${CPCMD} ${SLES7ConfFile} ${tmpConfFile}
        fi
    fi
    if [ -f /etc/UnitedLinux-release ]
    then
        GTKLanded "UL"
        RELFILE="/etc/UnitedLinux-release"
        if [ ! -d /usr/src/packages ]
        then
            BldDirs "/usr/src/packages"
            BLDRPMDIR=true
        fi
        export RPMDIR=/usr/src/packages
        tKrnl=`uname -r`
        sp3bld=$tKrnl
        tKrnl=${tKrnl#*\.} # Strip the major
        tKrnl=${tKrnl#*\.} # strip the minor
        tKrnl=${tKrnl%%-*} # strip the pass & trailing info
        if [ $tKrnl -ge 21 ]
        then
            export KERNELSRC=/usr/src/linux-`uname -r | sed -e 's/[-A-Za-z]*$//'`
        else
            export KERNELSRC=/usr/src/linux-`uname -r | sed -e 's/-[-0-9A-Za-z]*$//' -e 's/$/\.SuSE/'`
        fi
        # Are we running one of the SP3 kernels?
        sp3bld=${sp3bld#*-}
        sp3bld=`echo $sp3bld | sed 's/[-A-Za-z.]*$//'`
        if [ -n $sp3bld -a $sp3bld -ge 85  ]
        then
            export SP3=YES
            export KRNLCFG="/boot/config-`uname -r`"
        else
            export SP3=NO
            export KRNLCFG="/boot/vmlinuz*.config"
        fi
        # Lets see if we have an empty kernel-source directory.
        if [ -d $KERNELSRC ]
        then
            [ -z "`ls $KERNELSRC`" ] && rmdir $KERNELSRC 1>/dev/null 2>&1
        fi
        GetDistrVer
        export SNMPDCFGFILE=${UL10ConfFile}
        if [ -f ${UL10ConfFile} ]
        then
            ${CPCMD} ${UL10ConfFile} ${tmpConfFile}
        fi
    fi
    # Now lets protect the rpmmacro file if present.
    if [ -f ${HOME}/${rpmMacroFile} ]
    then
        ${CPCMD} ${HOME}/${rpmMacroFile} ${HPDir}/${rpmMacroFile}
    fi
    return
}


# Function for establishing the RPM Build dirtree if not present.
BldDirs()
{
    RootDir=$1
    rc=999
    while [ $rc -ne 0 ]
    do
        rc=0
        mkdir -p ${RootDir}/BUILD >/dev/null 2>&1
        rc=`expr $rc + $?`
        mkdir -p ${RootDir}/RPMS/athlon >/dev/null 2>&1
        rc=`expr $rc + $?`
        mkdir -p ${RootDir}/RPMS/i386 >/dev/null 2>&1
        rc=`expr $rc + $?`
        mkdir -p ${RootDir}/RPMS/i486 >/dev/null 2>&1
        rc=`expr $rc + $?`
        mkdir -p ${RootDir}/RPMS/i586 >/dev/null 2>&1
        rc=`expr $rc + $?`
        mkdir -p ${RootDir}/RPMS/i686 >/dev/null 2>&1
        rc=`expr $rc + $?`
        mkdir -p ${RootDir}/RPMS/noarch >/dev/null 2>&1
        rc=`expr $rc + $?`
        mkdir -p ${RootDir}/SOURCES >/dev/null 2>&1
        rc=`expr $rc + $?`
        mkdir -p ${RootDir}/SPECS >/dev/null 2>&1
        rc=`expr $rc + $?`
        mkdir -p ${RootDir}/SRPMS >/dev/null 2>&1
        rc=`expr $rc + $?`
        if [ $rc -ne 0 ]
        then
            putmsg "\nA directory tree at ${RPMDIR} does not appear to be present\non this system.\nIf this dirtree is not present, some of the components will not install properly.\nDo you wish to continue? (Default = No)  \c"
            if [ -z "$ans" ]
            then
                ans="NO"
            fi
            if [ "$ans" = "Y" -o "$ans" = "y" -o "$ans" = "Yes" -o "$ans" = "YES" -o "$ans" = "yes" ]
            then
                return
            else
                cleanup "\nThe user aborted installation of the HP ProLiant Linux Deployment Utility.\n\n"
                exit 23
            fi
        fi
        return
    done
}


# Function for locating required GTK libraries.
GTKLanded()
{
    case "$1" in
        "RH")  GTK_RPM="gtk+-1.2.10"
               ;;
           *)  GTK_RPM="gtk-1.2.10"
               ;;
    esac
    if [ ! -e ${GTK_LIB} ]
    then
        cleanup "\nA necessary graphics library, (${HILITE}${GTK_LIB}${NORMAL}) required by the\nHP ProLiant Linux Deployment Utility GUI is not installed on this server.\n\nPlease install the ${HILITE}${GTK_RPM}${NORMAL} rpm package and re-run this utility.\n"
        exit 2
    fi
    return
}


# Function for verifying the presence of required gdk library on RHEL3.
CheckGDKLib()
{
    [ "$TERM" = "linux" ] && return
    if [ "$GUI" = "false" ]
    then
       return
    else
       GUI=true
    fi
    PROMPT=false
    if [ ! -s "$GDK_LIB" ]
    then
        ans=""
        putmsg "\nA necessary graphics library, (${HILITE}${GDK_LIB}${NORMAL},\nprovided by the ${HILITE}${GDK_RPM}${NORMAL}) required by the\nHP ProLiant Linux Deployment Utility GUI is not installed on this server.\nDo you want the LDU to install the RPM providing this library\nand continue the installation [default=Y]? \c"
        if [ -z "$ans" ]
        then
            ans="Y"
        fi
        if [ "$ans" = "Y" -o "$ans" = "y" -o "$ans" = "Yes" -o "$ans" = "YES" -o "$ans" = "yes" ]
        then
            if [ -s "$GDK_RPM" ]
            then
                /bin/rpm -iv $GDK_RPM >/dev/null
                [ $? -eq 0 ] && return
                putmsg "\nERROR: The installation of ${HILITE}$GDK_RPM${NORMAL} was not successful.\nDo you wish to continue the Linux ProLiant Support Pack installation\nwithout the GUI [default=Y]? \c"
                if [ -z "$ans" ]
                then
                    ans="Y"
                fi
                if [ "$ans" = "Y" -o "$ans" = "y" -o "$ans" = "Yes" -o "$ans" = "YES" -o "$ans" = "yes" ]
                then
                    GUI=false
                else
                    cleanup "\nThe user aborted installation of the HP ProLiant Linux Deployment Utility.\n\n"
                    exit 23
                fi
            else
                putmsg "\nThe RPM, ${HILITE}$GDK_RPM${NORMAL}, is missing or corrupt\nand cannot be installed at this time."
                PROMPT=true
            fi
        else
            PROMPT=true
        fi
    fi
    if [ "$PROMPT" = "true" ]
    then
        putmsg"\nDo you wish to continue the Linux ProLiant Support Pack\ninstallation without the GUI [default=Y]? \c"
        if [ -z "$ans" ]
        then
            ans="Y"
        fi
        if [ "$ans" = "Y" -o "$ans" = "y" -o "$ans" = "Yes" -o "$ans" = "YES" -o "$ans" = "yes" ]
        then
            GUI=false
        else
            cleanup "\nThe user aborted installation of the HP ProLiant Linux Deployment Utility.\n\n"
            exit 23
        fi
    fi
    return
}


# Function for determining if ELM has passwords configured.
IsELMCfg()
{
    export CMAFDTNECHO=yes
    export LSPELMCONFIGURED=NO
    if [ -x /opt/compaq/foundation/etc/hpwebsetup ]
    then
        /opt/compaq/foundation/etc/hpwebsetup -q: >/dev/null 2>&1
        if [ $? = 4 ]; then
            export LSPELMCONFIGURED=YES
        fi
    fi
    return
}

# Function for determining which Bundle File we need to use.
GetBundle()
{
    if [ ! $Identified ]
    then
        cleanup "\n\nThe Linux O/S on this system cannot be identified\nby the HP Proliant Linux Deployment Utility.\nPlease check $RELFILE for correctness.\nCannot continue.  Exiting.\n"
        exit 999
    fi
    for i in `ls $ODIR/BP*`
    do
        if [ `grep -ic "$os $version" $i` -gt 0 ]
        then
            BUNDLE=$i
            break;
        fi
    done
    if [ -z "$BUNDLE" ]
    then
        cleanup "A required XML file appears to be missing...\nCannot continue!!!\n"
        exit 3
    fi
    grep -n "<package install=\"yes\">" $BUNDLE | awk -F\> '{print $2}'| awk -F\< '{print $1}' > $TEMP1
    while read LOOP1 LOOP2
    do 
    #    echo $LOOP1
        ${CPCMD} $ODIR/$LOOP1 ${WORKDIR} >/dev/null  2>&1
    done < $TEMP1
    sed 's/.rpm/.xml/g' $TEMP1 > $TEMP2
    while read LOOP1 LOOP2
    do
    #    echo $LOOP1
        ${CPCMD} $ODIR/$LOOP1 ${WORKDIR} >/dev/null  2>&1
    done < $TEMP2
    ${RMCMD} /tmp/templsp*.$$
    ${CPCMD} $ODIR/install???.sh ${WORKDIR} >/dev/null  2>&1
    ${CPCMD} $ODIR/hppldu-*.tar.gz ${WORKDIR} >/dev/null  2>&1
    ${CPCMD} $ODIR/*.txt ${WORKDIR} >/dev/null 2>&1
    return
}

GetOpts()
{
    GUI=true
    SILENT=false
	for i in $1
	do
        opt=`echo $i|tr [:upper:] [:lower:]`
		if [ "$opt" = "-s" -o "$opt" = "--silent" -o "$opt" = "-silent" -o "$opt" = "-c" ]
		then
			GUI=false
            CMDLINE=true
            SILENT=true
        elif [ "$opt" = "-c" ]
        then
            DELAY=true
		elif [ "$opt" = "--nui" -o "$opt" = "-nui" ]
        then
            CMDLINE=true
        elif [ "$opt" = "-h" -o "$opt" = "-help" -o "$opt" = "--help" -o "$opt" = "-?" -o "$opt" = "-v" -o "$opt" = "--view" -o "$opt" = "-view" ]
        then
            HelpOnly=true
        fi
	done
    return
}


# Function for ID'ing the OS, Version and Base Kernel version.
GetDistrVer()
{
    BASEKRNL=""
    Identified=false
    krnl=`uname -r`
    ktype=`echo $krnl|grep -i smp`
    for File in /etc/redhat-release /etc/SuSE-release /etc/UnitedLinux-release
    do
        if [ -f ${File} ]
        then
            if [ `grep -c "Red Hat" $File` -gt 0 ]
            then
                if [ `grep -c "Red Hat Enterprise" $File` -gt 0 ]
                then
                # we found a RedHat Enterprise Linux
                    version=`cat $File | awk '{print $6}'`
                    if [ "$version" = "release" ]
                    then
                        # Must be RHEL21
                        version=`cat $File | awk '{print $7}'`
                        if [ "$version" != "3" ]
		                then
                            BASEKRNL=$RHEL21
                        else
                            BASEKRNL=$RHEL30
                            IsItRHEL3=true
                            export LD_ASSUME_KERNEL=2.4.1
                            export KERNELSRC=/usr/src/linux-`uname -r|tr -d "[a-z]"`
                        fi
                    fi
                    os="Red Hat Enterprise Linux"
                    [ ${#version} -gt 0 -a ${#os} -gt 0 ] && Identified=true
                elif [ `grep -c Advanced $File` -gt 0 -o `grep -c AS $File` -gt 0 ]
                then
                    # we found a RedHat Advanced Server Linux
                    version=`cat $File | awk '{print $7}'`
                    if [ "$version" = "2.1AS" ]
                    then
                        os="Red Hat Enterprise Linux"
                        version=`echo $version|sed 's/AS//'`
                        BASEKRNL=$RHAS21
                    else
                        os="Red Hat Advanced Server"
                        BASEKRNL=$RHAS21
                    fi
                    [ ${#version} -gt 0 -a ${#os} -gt 0 ] && Identified=true
                elif [ `grep -c "Red Hat Linux" $File` -gt 0 ]
                then
                    # we found a RedHat Linux Professional system.
                    version=`cat $File | awk '{print $5}'`
                    os="Red Hat Linux"
                    case "$version" in
                        "7.3") BASEKRNL=$RH73 ;;
                        "8.0") BASEKRNL=$RH80
                               CheckRPM ;;
                            *) ;;
                    esac
                    [ ${#version} -gt 0 -a ${#os} -gt 0 ] && Identified=true
                fi
            elif [ `grep -c "UnitedLinux" $File` -gt 0 ]
            then
                version=`cat $File | awk '{if(NR == 1) {print $2}}'`
                os="UnitedLinux"
                if [ -n "$ktype" ]
                then
                    BASEKRNL=$UL10SMP
                else
                    BASEKRNL=$UL10
                fi
                [ ${#version} -gt 0 -a ${#os} -gt 0 ] && Identified=true
            elif [ `grep -ic "SuSE SLES-7" $File` -gt 0 ]
            then
                if [ -n "$ktype" ]
                then
                    BASEKRNL=$SLES7SMP
                else
                    BASEKRNL=$SLES7
                fi
                version=`cat $File | awk '{if(NR == 2) {print $3}}'`
                version=${version:0:1}
                os="SuSE Linux Enterprise Server"
                [ ${#version} -gt 0 -a ${#os} -gt 0 ] && Identified=true
            fi
        fi
    done
    # Now we have identified the Base Kernel, lets move it to the environment.
    export BASEKRNL
    return
}


#Function for displaying messages to user.
putmsg()
{
    # Make sure we have the display program available.
    if [ ! -s $HPDir/displayit.sh ]
    then
cat >$HPDir/displayit.sh <<-END
echo -e \$1
read ans
echo \$ans >/tmp/tmpans
END
    chmod 700 $HPDir/displayit.sh
    fi

    # Display the message either on a popup or console.
    old_resume=${auto_resume}
    unset auto_resume
    answered=0
    if [ ${#AUTO} -gt 0 ]
    then
        xterm -bg white -fg black -T "NOTICE!!!" -hold -e $HPDir/displayit.sh "$1" >/dev/null 2>&1 &
    else
        echo -e "$1"
        read -t 10 ans
        return
    fi
    pid=$!
    timer=10
    while [ $timer -gt 0 ]
    do
        if [ -s /tmp/tmpans ]
        then
            answered=1
            read ans </tmp/tmpans
            rm /tmp/tmpans
            break
        fi
        sleep 1
        timer=`expr $timer - 1`
    done
    kill $pid >/dev/null 2>&1
    [ $answered -eq 0 ] && ans="Y"
    set auto_resume=$old_resume
    return
}


# Function for validating the RPM package on RH80 systems.
CheckRPM()
{
    if [ "$GUI" = "false" -o "$SILENT" = "true" -o "$HelpOnly" = "true" ]
    then
        return
    fi
    RPMQ=`$PSE  | grep rpm`
    if [ ${#RPMQ} -gt 0 ]
    then
#    WhichRPM=`rpm -q rpm`
#    if [ "$WhichRPM" = "rpm-4.1-1.06" ]
#    then
        REPLY=""
        putmsg "\nThe RPM database on this system appears to be open, or locked.\nAccordingly, the HP Proliant Linux Deployment Utility cannot continue.\nPlease refer to Bugzilla Issue #73097 for instructions on how to resolve\nthis condition.\n\nPlease resolve the issue and re-start the HP Proliant Linux Deployment Utility.\n\nExiting...\n"
#        putmsg "\nThe RPM package version, \"$WhichRPM\", currently installed on this system, is known to have issues which may cause the RPM command to hang,(Bugzilla\nissue #73097).  You may continue, but if RPM does hang, SIGKILL (-9) must be\nused to stop it and the HP Proliant Linux Deployment Utility must be restarted.\nOr, you may stop now, update the RPM package to version 4.1.1-1 or later, and\nthen execute the HP Proliant Linux Deployment Utility.\n\nDo you wish to continue [Y/N]? \c"
#        if [ "$ans" = "Y" -o "$ans" = "y" -o "$ans" = "Yes" -o "$ans" = "YES" -o "$ans" = "yes" ]
#        then
#            return
#        else
#            putmsg "\nPlease update the RPM package to version rpm-4.1.1-1.i386.rpm, or later.\n"
#        fi
         exit 22
   fi
#   return
}


# Function for cleaning up the work area.
cleanup()
{
    # Flush all buffers to disk
    sync;sync;sync
    # Remove the lock.
    if [ -d $LCKDIR -a ${RFLAG} -eq 1 ]
    then
       rm -rf $LCKDIR >/dev/null 2>&1
    fi
    if [ -s /opt/compaq/hpasm/etc/hpasm -o "$STOPPED" = "true" -o "$NOHPASM" = "true" ]
    then
        RESTARTEM=true
    fi
    if [ "$HelpOnly" = "false" ]
    then
        if [ "$RESTARTEM" = "true" -a \( "$INTR" = "false" -a -f /tmp/didit.tmp \) ]
        then
           [ "$SILENT" = "false" ] && echo -e "\nRestarting hpasm management daemons...\c"
           /etc/init.d/hpasm start agentstart >/dev/null 2>&1
           [ "$SILENT" = "false" ] && echo -e "${GREEN}Done${NORMAL}\n"
        elif [ "$RESTARTEM" = "true" -a \( "$INTR" = "true"  -o ! -f /tmp/didit.tmp \) ]
        then
           [ "$SILENT" = "false" ] && echo -e "\nRestarting hpasm management daemons...\c"
           /etc/init.d/hpasm start agentstart >/dev/null 2>&1
           [ "$SILENT" = "false" ] && echo -e "${GREEN}Done${NORMAL}\n"
        fi
    fi
    # See if we need to cleanup any Remote Access mounts/directories.
    MTD=`mount | grep $KERNELSRC 2>/dev/null`
    if [ -n "$MTD" ]
    then
      umount $KERNELSRC 1>/dev/null 2>&1
        if [ -d $KERNELSRC ]
        then
            rmdir $KERNELSRC 1>/dev/null 2>&1
        fi
    fi
    # Lets restore the .rpmmacros file if we copied it.
    if [ -f ${HPDir}/${rpmMacroFile} ]
    then
        ${MVCMD} ${HPDir}/${rpmMacroFile} ${HOME}/${rpmMacroFile}
    fi
    # Did we have to build the RPM directory tree?
    if [ "$BLDRPMDIR" = "true" ]
    then
       rm -rf ${RPMDIR} >/dev/null 2>&1
    fi
    # Did we have to copy the files to a /tmp directory?
    # If so, we need to clean it up, or just cleanup here.
    unset HPLSPINSTALL KERNELSRC RPMDIR BASEKRNL LSPELMCONFIGURED SNMPDCFGFILE
    if [ -d $WORKDIR -a $RFLAG -eq 1 ]
    then
       cd $ODIR 
       rm -rf ${WORKDIR} >/dev/null 2>&1
    elif [ $RFLAG -eq 1 ]
    then
        ${RMCMD} hppldu >/dev/null 2>&1
        ${RMCMD} hpplduparserss >/dev/null 2>&1
        ${RMCMD} hppldupctss >/dev/null 2>&1
        ${RMCMD} hppldusecurityss >/dev/null 2>&1
        ${RMCMD} hpplduioss >/dev/null 2>&1
        ${RMCMD} hppldudepchkss >/dev/null 2>&1
        ${RMCMD} hpplduinstallerss >/dev/null 2>&1
        ${RMCMD} hppldurpminstallerss >/dev/null 2>&1
        ${RMCMD} hpplduverchkdbss >/dev/null 2>&1
        ${RMCMD} hppldu.conf >/dev/null 2>&1
        ${RMCMD} ncmcon.cfg >/dev/null 2>&1
        ${RMCMD} libcpqlsp* >/dev/null 2>&1
        ${RMCMD} install\?\?\?.sh >/dev/null 2>&1
        ${RMCMD} ${HPDir}/displayit.sh >/dev/null 2>&1
        ${RMCMD} ${GDK_RPM} >/dev/null 2>&1
        ${RMCMD} /usr/lib/libcpqlsptransport.* >/dev/null 2>&1
        ${RMCMD} /tmp/didit.tmp >/dev/null 2>&1
    fi

    # Move to the original working directory and get ready to exit.
    cd $ODIR
    # Echo message, if any, to user.
    if [ -n "$1" ]
    then
        putmsg "$1"
    fi
    # Clear the traps.
    trap '' 2 3 15
    # Then return.
    return
}


# Function for killing all hppldu processes.
killer()
{
    # Identify all our appl processes.
    PIDs=`${PSE}|grep hppldu|awk '{print $1}'|sort -r`
    # Now kill them one at a time. (use SIGKILL to make sure)
    for k in $PIDs
    do
        kill -9 $k >/dev/null 2>&1
    done
    return
}

# Function for catching a user interrupt, then
# terminate our HPPLDU.
interrupt()
{
    # Set a flag to indicate interrupt has occurred.
    INTR=true
    # Call killer to terminate all hppldu processes.
    killer
    # Set the remove flag.
    RFLAG=1
    # Call the cleanup crew.
    cleanup "$1"
    # Make sure we have killed all the processes.
    killer
    # Restore the user's terminal.
    stty echo >/dev/null 2>&1
    tput cnorm >/dev/null 2>&1
    # and, get out!
    exit $RC
}


###################################
##                               ##
##          M A I N              ##
##                               ##
###################################
# Lets make verify that 'superuser' is running this appl.
if [ `id -u` -eq 0 ]
then
    AUTO=${SS_CD_MOUNTPOINT}
    # Set some traps.
    trap 'interrupt "\nTerminated!\n"' 2
    trap 'cleanup ""' 1 3 15

    # Now setup a lock, so that we only allow one instance of
    # the HPPLDU to run at a time.
    if [ ! -d ${LCKDIR} ]
    then
        mkdir -p $LCKDIR >/dev/null 2>&1
        echo $$ >$LCKFILE
    else
        CHKLCK=`cat $LCKFILE 2>/dev/null`
#        ISITCURR=`$PSE | awk -v PID=$CHKLCK 'BEGIN {x=0} {if($1 == PID) ++x} END {print x}'`
        ISITCURR=`$PSE | grep $CHKLCK`
#        echo "ISITCURR = $ISITCURR"
        if [ ${#ISITCURR} -gt 0 ]
        then
            RFLAG=0
            cleanup "\nOnly one instance of the HP Proliant Linux Deployment Utility\nmay run at a time.\n"
            exit 21   # Exit Code = LSP_APPLICATION_ALREADY_RUNNING
        else
            echo $$ >$LCKFILE
        fi
    fi

    # Setup our HP directory if needed.
    if [ ! -d $HPDir ]
    then
        mkdir -p $HPDir
        [ $? -ne 0 ] && cleanup "Unable to create $HPDir..this directory is required for\nstoring certain files used with the HP Proliant Linux Deployment Utility."
    fi

    # Lets make the command line options local.
    OPTS="$@"
    GetOpts "$OPTS"

    # Which Distr. of Linux are we on.
    SetupForOS

    # Determine the path to our executables, and move there.
    ODIR=`dirname $0`
    if [ "$ODIR" = "." ]
    then
       ODIR=$PWD
    fi
    touch ${ODIR}/install???.sh >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        SPACE_AVAIL=`df /tmp | grep -v Available | awk '{print $4}'`
        if [ $SPACE_AVAIL -gt 70000 ]
        then
            putmsg "\n\nBecause of Read-Only media, the HP Proliant Linux Deployment Utility\nis copying the files to a temporary work location.\n\nThis may take several seconds..." 
            mkdir -p $WORKDIR >/dev/null 2>&1
            if [ $? -ne 0 ]
            then
                cleanup "\n\nUnable to create a temporary working directory in '/tmp'.\nPlease verify, or set '/tmp' for proper permissions, and re-run\nthe HP Proliant Linux Deployment Utility."
            exit 1
            fi
            GetBundle
            ${CPCMD} ${BUNDLE} ${WORKDIR} >/dev/null 2>&1
            cd ${WORKDIR}
        else
            cleanup "\n\nThere is inadequate disk space available in '/tmp' to execute\nthe HP Proliant Linux Deployment Utility.\n Exiting...\n"
            exit 1
        fi
    fi

    # Well we finally got thru all the preliminaries, so now
    # we can get down to business.
    # Setup the execution environment. 
    tar zxf ${TARBALL} >/dev/null

    # See if we are on RH EL3, if so verify libgdk_pixbuf.so.2 is present.
    [ "$IsItRHEL3" = "true" ] && CheckGDKLib

    # Is HPASM installed, and are the agents running, if so, stop them.
    if [ "$HelpOnly" = "false" ]
    then
        # Is the hpasm running?
        ASM=`ps -e | grep cmapeerd`
        if [ ${#ASM} -ne 0 ]
        then
           [ "$SILENT" = "false" ] && echo -e "\nStopping hpasm management daemons.....\c"
           /etc/init.d/hpasm stop cmafdtn >/dev/null 2>&1
           STOPPED=true
           [ "$SILENT" = "false" ] && echo -e "${GREEN}Done${NORMAL}\n"
        else
           ASM=`/bin/rpm -q hpasm 2>&1|grep "not installed"`
           if [ ${#ASM} -ne 0 ]
           then
               NOHPASM=true
           fi
        fi
    fi

    # Is ELM configured with passwords?
    IsELMCfg
    ln -sf libcpqlsptransport.so.0.0 libcpqlsptransport.so.0 >/dev/null 2>&1
    ln -sf libcpqlsptransport.so.0 libcpqlsptransport.so >/dev/null 2>&1
    ${CPCMD} libcpqlsptransport.so.0.0 /usr/lib/ >/dev/null 2>&1
    /sbin/ldconfig >/dev/null 2>&1
    HPLSPINSTALL=TRUE
    export HPLSPINSTALL

    # Then kick off the Application.
    RFLAG=1
    if [ "$GUI" = "false" -a "$CMDLINE" = "false" ]
    then
        ./hppldu ${OPTS} --nui
    else
        ./hppldu "$@" 
    fi
    # Capture the return code from the HPPLDU.
    RC=$?
    #  echo "RC is "$RC

    # Delay for a few seconds if we are running a VCA install.
    if [ "$DELAY" = "true" ]
    then
        sleep 15
    fi
 
    # We are finished, so call the cleanup crew.
    cleanup ""
else
    RFLAG=1
    cleanup "\n'root' access is required to run the HP Deployment Utility for Linux.\n"
    RC=1
fi
# echo $RC >rc.out
exit $RC
