// $RCSfile: MS-SCSIC.JS $ $Revision: 1.2 $

function scsiCntlrName(cntlrIdx)
{
   var rc;
   rc = (cpqScsiCntlrEntry[cntlrIdx].cpqScsiCntlrSlot == 0 ? "VXe{[h" :
         "Xbg"+ cpqScsiCntlrEntry[cntlrIdx].cpqScsiCntlrSlot);
   rc += " - SCSI Rg[";
   rc += " - |[g" + cpqScsiCntlrEntry[cntlrIdx].cpqScsiCntlrBusIndex;
   return rc;
}
function scsiCntlrCondition(cntlrIdx, imageSize)
{
   var cond = new cpqCondition(cpqScsiCntlrEntry[cntlrIdx].cpqScsiCntlrStatus);
   if (cpqScsiCntlrEntry[cntlrIdx].cpqScsiCntlrStatus == 3)
   {
      cond.set(4);  // failed
   }
   if (imageSize == "LARGE")
      return cond.image();

   return cond.imageSmall();
}
function compileScsiCondition()
{
   this.state = 1;  // reset to unknown
   this.update(cpqScsiCntlrEntry[this.index].cpqScsiCntlrCondition);
}
function targetType(targetIndex)
{
   var scsiType = displayItem("cpqScsiTargetType",         cpqScsiTargetEntry[targetIndex].cpqScsiTargetType);
   var extType  = displayItem("cpqScsiTargetTypeExtended", cpqScsiTargetEntry[targetIndex].cpqScsiTargetTypeExtended);

   if (cpqScsiTargetEntry[targetIndex].cpqScsiTargetTypeExtended == 2)
   {
      scsiType =  extType + " " + scsiType;
   }
   else if (cpqScsiTargetEntry[targetIndex].cpqScsiTargetTypeExtended == 4 ||  // tape library
            cpqScsiTargetEntry[targetIndex].cpqScsiTargetTypeExtended == 5 ||  // cd library
            cpqScsiTargetEntry[targetIndex].cpqScsiTargetTypeExtended == 6 ||  // CR3500 controller
            cpqScsiTargetEntry[targetIndex].cpqScsiTargetTypeExtended == 7)    // tape autoloader
   {
      scsiType = extType;
   }
   return scsiType;
}
function targetName(targetIndex)
{
   rc = targetType(targetIndex) + " - SCSI ID " + cpqScsiTargetEntry[targetIndex].cpqScsiTargetScsiIdIndex;
   return rc;
}
function targetStatusGraphic(targetIndex, alignment)
{
   var thisStatus  = new cpqCondition(1);
   var targType    = cpqScsiTargetEntry[targetIndex].cpqScsiTargetType;
   var targTypeExt = cpqScsiTargetEntry[targetIndex].cpqScsiTargetTypeExtended;
   var localCntlr  = cpqScsiTargetEntry[targetIndex].cpqScsiTargetCntlrIndex;
   var localBus    = cpqScsiTargetEntry[targetIndex].cpqScsiTargetBusIndex;
   var localId     = cpqScsiTargetEntry[targetIndex].cpqScsiTargetScsiIdIndex;
   var i;

   if (targType == 2)  // drive, use phy drive status
   {
      for (i = 0; i < cpqScsiPhyDrvEntry.length; i++)
      {
         if (cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvCntlrIndex == localCntlr &&
             cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvBusIndex == localBus &&
             cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvScsiID == localId)
         {
            thisStatus.update(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvCondition);
         }
      }
   }
   else if (targType == 3)  // tape drive
   {
      for (i = 0; i < cpqTapePhyDrvEntry.length; i++)
      {
         if (cpqTapePhyDrvEntry[i].cpqTapePhyDrvCntlrIndex == localCntlr &&
             cpqTapePhyDrvEntry[i].cpqTapePhyDrvBusIndex == localBus &&
             cpqTapePhyDrvEntry[i].cpqTapePhyDrvScsiIdIndex == localId)
         {
            thisStatus.update(cpqTapePhyDrvEntry[i].cpqTapePhyDrvCondition);
         }
      }
   }
   else if (targTypeExt == 4)  // tape library
   {
      for (i = 0; i < cpqTapeLibraryEntry.length; i++)
      {
         if (cpqTapeLibraryEntry[i].cpqTapeLibraryCntlrIndex == localCntlr &&
             cpqTapeLibraryEntry[i].cpqTapeLibraryBusIndex == localBus &&
             cpqTapeLibraryEntry[i].cpqTapeLibraryScsiIdIndex == localId)
         {
            thisStatus.update(cpqTapeLibraryEntry[i].cpqTapeLibraryCondition);
         }
      }
   }
   else if (targTypeExt == 5)  // CD library
   {
      for (i = 0; i < cpqCdLibraryEntry.length; i++)
      {
         if (cpqCdLibraryEntry[i].cpqCdLibraryCntlrIndex == localCntlr &&
             cpqCdLibraryEntry[i].cpqCdLibraryBusIndex == localBus &&
             cpqCdLibraryEntry[i].cpqCdLibraryScsiIdIndex == localId)
         {
            thisStatus.update(cpqCdLibraryEntry[i].cpqCdLibraryCondition);
         }
      }
   }
   if (alignment == "LARGE")
      return thisStatus.image();

   return thisStatus.imageSmall(alignment);
}
function driveCapacity(item, size)
{
   var rc = parseInt(size, 10);

   if (isNaN(rc) || rc <= 0)
   {
      rc = "N/A";
   } else {
      rc = displayItem(item, size);
   }
   return rc;
}
