<html>
<!-- $RCSfile: MS-FCSS.TPL $ $Revision: 1.2 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Fibre Channel Storage System Informaiton</title>

<!#/COMMON/JPN/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqSsChassisEntry>
<!cpqSsIoSlotEntry>
<!cpqSsBackplaneEntry>
<!cpqSsPowerSupplyEntry>
<!cpqSsTempSensorEntry>
<!cpqSsFanModuleEntry>

<!#/COMMON/JPN/COND.JS>
<!#/COMMON/JPN/STDITEMS.JS>
<!#/COMMON/JPN/TABLES.JS>
<!#/COMMON/JPN/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#SSENUMS.JS>
<!#FCAENUMS.JS>
<!#MS-FCCMN.JS>

postfix["cpqSsTempSensorCurrentValue"] = "C";
postfix["cpqSsTempSensorLimitValue"] = "C";
</script>
</head>
<script language="JavaScript">

writeBodyHead();

idx = findArg("index");

if (idx == -1)
{
   parseArgs(tryPrevPage());
   idx = findArg("index");
}
if (idx == -1 || idx >= cpqSsChassisEntry.length)
{
   reportMissingArgs();
}
else
{
   thisChassis = cpqSsChassisEntry[idx];
   thisChassisIndex = thisChassis.cpqSsChassisIndex;
   slotControllers = new Array;

   for (i = 0; i < cpqSsIoSlotEntry.length; i++)
   {
      if (cpqSsIoSlotEntry[i].cpqSsIoSlotChassisIndex == thisChassisIndex)
         slotControllers[cpqSsIoSlotEntry[i].cpqSsIoSlotIndex] = displayItem(
            "cpqSsIoSlotControllerType", cpqSsIoSlotEntry[i].cpqSsIoSlotControllerType);
   }
   powerCondition = new cpqCondition(thisChassis.cpqSsChassisPowerSupplyCondition);
   tempCondition = new cpqCondition(thisChassis.cpqSsChassisTemperatureCondition);
   fanCondition = new cpqCondition(thisChassis.cpqSsChassisFanCondition);
   chassisCond = storageSysCondition(idx);
   writePageHead("Xg[W VXe", "/WEBAGENT/IMAGES/MASSHDR.GIF", "Xg[W VXe");
   writeTableLabel(chassisCond.image() + fcChassisName(idx));
   writeTableHead();
   writeSingleTableRowInDoubleTable(
      "f:", displayItem("cpqSsChassisModel", thisChassis.cpqSsChassisModel));
   writeSingleTableRowInDoubleTable(
      "O:", displayItem("cpqSsChassisName", thisChassis.cpqSsChassisName));
   writeDoubleTableRow(
      "ڑ:", displayItem("cpqSsChassisConnectionType", thisChassis.cpqSsChassisConnectionType),
      "IO Xbg 1:", (null!=slotControllers[1] ? slotControllers[1]: "CXg[Ȃ"));
   writeDoubleTableRow(
      "VAԍ:", displayItem("cpqSsChassisSerialNumber", thisChassis.cpqSsChassisSerialNumber),
      "IO Xbg 2:", (null!=slotControllers[2] ? slotControllers[2]: "CXg[Ȃ"));
   if (thisChassis.cpqSsChassisModel > 2)
      writeSingleTableRowInDoubleTable(
         "IO W[^Cv:", displayItem("cpqSsChassisScsiIoModuleType", thisChassis.cpqSsChassisScsiIoModuleType));
   if (thisChassis.cpqSsChassisModel == 4)
      writeSingleTableRowInDoubleTable(
         "RSO Xe[^X:", displayItem("cpqSsChassisRsoStatus", thisChassis.cpqSsChassisRsoStatus));
   writeTableTail();
   document.write("<br>");

   if (thisChassis.cpqSsChassisModel > 2)
   {
      backCond = new cpqCondition(1);
      for (i = 0; i < cpqSsBackplaneEntry.length; i++)
      {
         if (cpqSsBackplaneEntry[i].cpqSsBackplaneChassisIndex == thisChassisIndex)
         {
            ssName = displayItem("cpqSsBackplanePlacement", cpqSsBackplaneEntry[i].cpqSsBackplanePlacement);
            ssName += " Xg[WVXeoX " + cpqSsBackplaneEntry[i].cpqSsBackplaneIndex;
            backCond.set(cpqSsBackplaneEntry[i].cpqSsBackplaneCondition);
            writeTableLabel(backCond.imageSmall()+fcBackplaneName(i),"obNv[");
            writeTableHead();
            // Don't display Temp, Fan, & Power status if not provided
            if (cpqSsBackplaneEntry[i].cpqSsBackplaneTempStatus == 6)
            {
               writeDoubleTableRow(
                  "x_:", displayItem("cpqSsBackplaneVendor", cpqSsBackplaneEntry[i].cpqSsBackplaneVendor),
                  "{[h rW:", displayItem("cpqSsBackplaneBoardRevision", cpqSsBackplaneEntry[i].cpqSsBackplaneBoardRevision));
               writeDoubleTableRow(
                  "f:", displayItem("cpqSsBackplaneModel", cpqSsBackplaneEntry[i].cpqSsBackplaneModel),
                  "o[W:", displayItem("cpqSsBackplaneVersion", cpqSsBackplaneEntry[i].cpqSsBackplaneVersion));
               writeDoubleTableRow(
                  "VAԍ:", displayItem("cpqSsBackplaneSerialNumber", cpqSsBackplaneEntry[i].cpqSsBackplaneSerialNumber),
                  "x:", displayItem("cpqSsBackplaneSpeed", cpqSsBackplaneEntry[i].cpqSsBackplaneSpeed));
               writeDoubleTableRow(
                  "t@[EFA rW:", displayItem("cpqSsBackplaneFWRev", cpqSsBackplaneEntry[i].cpqSsBackplaneFWRev),
                  "hCuxC:", displayItem("cpqSsBackplaneDriveBays", cpqSsBackplaneEntry[i].cpqSsBackplaneDriveBays));
               writeDoubleTableRow(
                  "zu:", displayItem("cpqSsBackplanePlacement", cpqSsBackplaneEntry[i].cpqSsBackplanePlacement),
                  "fvbNX IvV:", displayItem("cpqSsBackplaneDuplexOption", cpqSsBackplaneEntry[i].cpqSsBackplaneDuplexOption));
            } else {
               writeDoubleTableRow(
                  "x_:", displayItem("cpqSsBackplaneVendor", cpqSsBackplaneEntry[i].cpqSsBackplaneVendor),
                  "xXe[^X:", displayItem("cpqSsBackplaneTempStatus", cpqSsBackplaneEntry[i].cpqSsBackplaneTempStatus));
               writeDoubleTableRow(
                  "f:", displayItem("cpqSsBackplaneModel", cpqSsBackplaneEntry[i].cpqSsBackplaneModel),
                  "t@ Xe[^X:", displayItem("cpqSsBackplaneFanStatus", cpqSsBackplaneEntry[i].cpqSsBackplaneFanStatus));
               writeDoubleTableRow(
                  "VAԍ:", displayItem("cpqSsBackplaneSerialNumber", cpqSsBackplaneEntry[i].cpqSsBackplaneSerialNumber),
                  "p[TvC Xe[^X:", displayItem("cpqSsBackplaneFtpsStatus", cpqSsBackplaneEntry[i].cpqSsBackplaneFtpsStatus));
               writeDoubleTableRow(
                  "t@[EFA rW:", displayItem("cpqSsBackplaneFWRev", cpqSsBackplaneEntry[i].cpqSsBackplaneFWRev),
                  "x:", displayItem("cpqSsBackplaneSpeed", cpqSsBackplaneEntry[i].cpqSsBackplaneSpeed));
               writeDoubleTableRow(
                  "{[h rW:", displayItem("cpqSsBackplaneBoardRevision", cpqSsBackplaneEntry[i].cpqSsBackplaneBoardRevision),
                  "hCuxC:", displayItem("cpqSsBackplaneDriveBays", cpqSsBackplaneEntry[i].cpqSsBackplaneDriveBays));
               writeDoubleTableRow(
                  "o[W:", displayItem("cpqSsBackplaneVersion", cpqSsBackplaneEntry[i].cpqSsBackplaneVersion),
                  "fvbNX IvV:", displayItem("cpqSsBackplaneDuplexOption", cpqSsBackplaneEntry[i].cpqSsBackplaneDuplexOption));
               writeSingleTableRowInDoubleTable(
                  "zu:", displayItem("cpqSsBackplanePlacement", cpqSsBackplaneEntry[i].cpqSsBackplanePlacement));
            }
            writeTableTail();
            document.write("<br>");
         }
      }
   }
   else // RA4xxx
   {
      writeTableLabel("obNv[");
      writeTableHead();
      writeColumnTableHeaderRow("t@[EFA rW", "hCu xC", "fvbNX");

      for (i = 0; i < cpqSsBackplaneEntry.length; i++)
      {
         if (cpqSsBackplaneEntry[i].cpqSsBackplaneChassisIndex == thisChassisIndex)
         {
            writeColumnTableDataRow(
               displayItem("cpqSsBackplaneFWRev",        cpqSsBackplaneEntry[i].cpqSsBackplaneFWRev),
               displayItem("cpqSsBackplaneDriveBays",    cpqSsBackplaneEntry[i].cpqSsBackplaneDriveBays),
               displayItem("cpqSsBackplaneDuplexOption", cpqSsBackplaneEntry[i].cpqSsBackplaneDuplexOption));
         }
      }
      writeTableTail();
      document.write("<br>");

      writeTableLabel("Y");
      writeTableHead();
      writeColumnTableHeaderRow("{[h", "VAԍ", "{[h rW");
      writeColumnTableDataRow("VXe {[h",
         displayItem("cpqSsChassisSystemBoardSerNum", thisChassis.cpqSsChassisSystemBoardSerNum),
         displayItem("cpqSsChassisSystemBoardRev",    thisChassis.cpqSsChassisSystemBoardRev));
      writeColumnTableDataRow("d{[h",
         displayItem("cpqSsChassisPowerBoardSerNum", thisChassis.cpqSsChassisPowerBoardSerNum),
         displayItem("cpqSsChassisPowerBoardRev",    thisChassis.cpqSsChassisPowerBoardRev));
      writeColumnTableDataRow("SCSI {[h",
         displayItem("cpqSsChassisScsiBoardSerNum", thisChassis.cpqSsChassisScsiBoardSerNum),
         displayItem("cpqSsChassisScsiBoardRev",    thisChassis.cpqSsChassisScsiBoardRev));
      writeTableTail();
      document.write("<br>");

      writeTableLabel(powerCondition.imageSmall()+"p[TvC", "p[TvC");
      writeTableHead();
      writeColumnTableHeaderRow("ʒu", "Xe[^X", "UPS","VAԍ", "{[h rW", "t@[EFA rW");

      for (i = 0; i < cpqSsPowerSupplyEntry.length; i++)
      {
         if (cpqSsPowerSupplyEntry[i].cpqSsPowerSupplyChassisIndex == thisChassisIndex)
         {
            thisPS = cpqSsPowerSupplyEntry[i];
            powerCondition.state = 1;
            powerCondition.update(thisPS.cpqSsPowerSupplyCondition);
            writeColumnTableDataRow(
               powerCondition.imageSmall() + "dxC " + (thisPS.cpqSsPowerSupplyBay-1) ,
               displayItem("cpqSsPowerSupplyStatus",           thisPS.cpqSsPowerSupplyStatus ),
               displayItem("cpqSsPowerSupplyUpsStatus",        thisPS.cpqSsPowerSupplyUpsStatus),
               displayItem("cpqSsPowerSupplySerialNumber",     thisPS.cpqSsPowerSupplySerialNumber),
               displayItem("cpqSsPowerSupplyBoardRevision",    thisPS.cpqSsPowerSupplyBoardRevision),
               displayItem("cpqSsPowerSupplyFirmwareRevision", thisPS.cpqSsPowerSupplyFirmwareRevision));
         }
      }
      writeTableTail();
      document.write("<br>");

      writeTableLabel(tempCondition.imageSmall() + "x", "x");
      writeTableHead();
      writeColumnTableHeaderRow("ʒu", "Xe[^X", "ݒl", "l");

      for (i = 0; i < cpqSsTempSensorEntry.length; i++)
      {
         if (cpqSsTempSensorEntry[i].cpqSsTempSensorChassisIndex == thisChassisIndex)
         {
            thisTemp = cpqSsTempSensorEntry[i];
            tempCondition.state = 1;
            tempCondition.update(thisTemp.cpqSsTempSensorCondition);
            writeColumnTableDataRow(
               tempCondition.imageSmall() + displayItem("cpqSsTempSensorLocation", thisTemp.cpqSsTempSensorLocation),
               displayItem("cpqSsTempSensorStatus", thisTemp.cpqSsTempSensorStatus),
               displayItem("cpqSsTempSensorCurrentValue", thisTemp.cpqSsTempSensorCurrentValue),
               displayItem("cpqSsTempSensorLimitValue", thisTemp.cpqSsTempSensorLimitValue));
         }
      }
      writeTableTail();
      document.write("<br>");

      writeTableLabel(fanCondition.imageSmall() + "t@", "t@");
      writeTableHead();
      writeColumnTableHeaderRow("ʒu", "Xe[^X", "VAԍ", "{[h rW");

      for (i = 0; i < cpqSsFanModuleEntry.length; i++)
      {
         if (cpqSsFanModuleEntry[i].cpqSsFanModuleChassisIndex == thisChassisIndex)
         {
            thisFan = cpqSsFanModuleEntry[i];
            fanCondition.state = 1;
            fanCondition.update(thisFan.cpqSsFanModuleCondition);
            writeColumnTableDataRow(
               fanCondition.imageSmall() + displayItem("cpqSsFanModuleLocation", thisFan.cpqSsFanModuleLocation),
               displayItem("cpqSsFanModuleStatus",        thisFan.cpqSsFanModuleStatus),
               displayItem("cpqSsFanModuleSerialNumber",  thisFan.cpqSsFanModuleSerialNumber),
               displayItem("cpqSsFanModuleBoardRevision", thisFan.cpqSsFanModuleBoardRevision));
         }
      }
      writeTableTail();
   }
}
writeBodyTail();
</script>
</html>

